/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generic {
    public static final int CHM_INITIAL_CAPACITY = 16;
    public static final float CHM_LOAD_FACTOR = 0.75f;
    public static final int CHM_CONCURRENCY_LEVEL = 2;

    public static <T> List<T> list() {
        return new ArrayList();
    }

    public static <T, U extends T> List<T> list(U ... UArray) {
        ArrayList<U> arrayList = new ArrayList<U>(UArray.length);
        for (U u : UArray) {
            arrayList.add(u);
        }
        return arrayList;
    }

    public static <K, V> Map<K, V> map() {
        return new HashMap();
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap() {
        return new ConcurrentHashMap(16, 0.75f, 2);
    }

    public static <E> Set<E> set() {
        return new HashSet();
    }

    public static <T, U extends T> Set<T> set(U ... UArray) {
        HashSet<U> hashSet = new HashSet<U>(UArray.length);
        for (U u : UArray) {
            hashSet.add(u);
        }
        return hashSet;
    }

    public static <E> Set<E> concurrentSet() {
        return Generic.newSetFromMap(Generic.concurrentMap());
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new SetFromMap<E>(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Serializable {
        private final Map<E, Boolean> map;
        private transient Set<E> keySet;

        public SetFromMap(Map<E, Boolean> map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("Map is non-empty");
            }
            this.map = map;
            this.keySet = map.keySet();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.keySet.containsAll(collection);
        }

        @Override
        public Iterator<E> iterator() {
            return this.keySet.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.keySet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.keySet.toArray(TArray);
        }

        @Override
        public boolean add(E e) {
            return this.map.put(e, Boolean.TRUE) == null;
        }

        @Override
        public boolean remove(Object object) {
            return this.map.remove(object) != null;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.keySet.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.keySet.retainAll(collection);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || ((Object)this.keySet).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.keySet).hashCode();
        }

        @Override
        public String toString() {
            return this.keySet.toString();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.keySet = this.map.keySet();
        }
    }
}

