/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GlobMatchingTask
extends MatchingTask {
    private Path src;
    protected File destDir;
    private Set<File> toExpose = Generic.set();

    public void setSrcdir(Path path) {
        if (this.src == null) {
            this.src = path;
        } else {
            this.src.append(path);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.toExpose.clear();
        for (String string : this.src.list()) {
            File file = this.getProject().resolveFile(string);
            if (!file.exists()) {
                throw new BuildException("srcdir '" + file.getPath() + "' does not exist!", this.getLocation());
            }
            String[] stringArray = this.getDirectoryScanner(file).getIncludedFiles();
            this.scanDir(file, this.destDir != null ? this.destDir : file, stringArray);
        }
        this.process(this.toExpose);
    }

    protected abstract void process(Set<File> var1);

    protected abstract String getFrom();

    protected abstract String getTo();

    protected void scanDir(File file, File file2, String[] stringArray) {
        GlobPatternMapper globPatternMapper = new GlobPatternMapper();
        globPatternMapper.setFrom(this.getFrom());
        globPatternMapper.setTo(this.getTo());
        SourceFileScanner sourceFileScanner = new SourceFileScanner((Task)this);
        for (File file3 : sourceFileScanner.restrictAsFiles(stringArray, file, file2, (FileNameMapper)globPatternMapper)) {
            this.toExpose.add(file3);
        }
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null || this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory '" + this.destDir + "' does not exist " + "or is not a directory", this.getLocation());
        }
    }
}

