/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;
import jline.ConsoleReader;
import jline.Terminal;
import jline.WindowsTerminal;
import org.python.constantine.platform.Errno;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.InteractiveConsole;

public class JLineConsole
extends InteractiveConsole {
    protected ConsoleReader reader;
    protected PyObject startup_hook;
    protected PyObject pre_input_hook;
    private boolean windows;
    protected static final String CTRL_Z = "\u001a";
    private static final List<String> SUSPENDED_STRERRORS = Arrays.asList(Errno.EINTR.description(), Errno.EIO.description());

    public JLineConsole() {
        this(null);
    }

    public JLineConsole(PyObject pyObject) {
        this(pyObject, "<stdin>");
        try {
            File file = new File(System.getProperty("user.home"), ".jline-jython.history");
            this.reader.getHistory().setHistoryFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JLineConsole(PyObject pyObject, String string) {
        super(pyObject, string, true);
        System.setProperty("jline.UnixTerminal.input.encoding", "ISO-8859-1");
        System.setProperty("jline.WindowsTerminal.input.encoding", "ISO-8859-1");
        Terminal.setupTerminal();
        try {
            FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), "ISO-8859-1");
            this.reader = new ConsoleReader(fileInputStream, outputStreamWriter, this.getBindings());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.windows = this.reader.getTerminal() instanceof WindowsTerminal;
    }

    protected InputStream getBindings() {
        String string = new File(System.getProperty("user.home"), ".jlinebindings.properties").getAbsolutePath();
        File file = new File(System.getProperty("jline.keybindings", string));
        try {
            if (file.isFile()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return this.getClass().getResourceAsStream("jline-keybindings.properties");
    }

    public String raw_input(PyObject pyObject) {
        String string = null;
        String string2 = pyObject.toString();
        while (true) {
            try {
                if (this.startup_hook != null) {
                    try {
                        this.startup_hook.__call__();
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                }
                string = this.reader.readLine(string2);
            }
            catch (IOException iOException) {
                if (!this.fromSuspend(iOException)) {
                    throw Py.IOError(iOException);
                }
                try {
                    this.reader.getTerminal().initializeTerminal();
                }
                catch (Exception exception) {
                    throw Py.IOError(exception.getMessage());
                }
                string2 = "";
                continue;
            }
            break;
        }
        if (this.isEOF(string)) {
            throw Py.EOFError("");
        }
        return string;
    }

    private boolean fromSuspend(IOException iOException) {
        return !this.windows && SUSPENDED_STRERRORS.contains(iOException.getMessage());
    }

    private boolean isEOF(String string) {
        return string == null || this.windows && CTRL_Z.equals(string);
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public PyObject getStartupHook() {
        return this.startup_hook;
    }

    public void setStartupHook(PyObject pyObject) {
        this.startup_hook = pyObject;
    }
}

