/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.python.core.PyException;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.modules._py_compile;
import org.python.util.GlobMatchingTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JycompileAntTask
extends GlobMatchingTask {
    @Override
    public void process(Set<File> set) throws BuildException {
        if (set.size() == 0) {
            return;
        }
        if (set.size() > 1) {
            this.log("Compiling " + set.size() + " files");
        } else if (set.size() == 1) {
            this.log("Compiling 1 file");
        }
        Properties properties = new Properties();
        properties.setProperty("python.cachedir.skip", "true");
        PySystemState.initialize(System.getProperties(), properties);
        for (File file : set) {
            String string = _py_compile.getModuleName(file);
            String string2 = string.replace('.', '/');
            if (file.getName().endsWith("__init__.py")) {
                string2 = string2 + "/__init__";
            }
            File file2 = new File(this.destDir, string2 + "$py.class");
            this.compile(file, file2, string);
        }
    }

    protected void compile(File file, File file2, String string) {
        byte[] byArray;
        try {
            byArray = imp.compileSource(string, file);
        }
        catch (PyException pyException) {
            pyException.printStackTrace();
            throw new BuildException("Compile failed; see the compiler error output for details.");
        }
        File file3 = file2.getParentFile();
        if (!file3.exists() && !file2.getParentFile().mkdirs()) {
            throw new BuildException("Unable to make directory for compiled file: " + file2);
        }
        imp.cacheCompiledSource(file.getAbsolutePath(), file2.getAbsolutePath(), byArray);
    }

    @Override
    protected String getFrom() {
        return "*.py";
    }

    @Override
    protected String getTo() {
        return "*$py.class";
    }
}

