/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.Generic;
import org.python.util.PythonInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyServlet
extends HttpServlet {
    public static final String SKIP_INIT_NAME = "skip_jython_initialization";
    protected static final String INIT_ATTR = "__jython_initialized__";
    private static final Pattern FIND_NAME = Pattern.compile("([^/]+)\\.py$");
    private PythonInterpreter interp;
    private Map<String, CacheEntry> cache = Generic.map();

    public void init() {
        boolean bl;
        Properties properties = new Properties();
        Enumeration enumeration = this.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, this.getInitParameter(string));
        }
        boolean bl2 = bl = this.getServletConfig().getInitParameter(SKIP_INIT_NAME) != null;
        if (this.getServletContext().getAttribute(INIT_ATTR) != null) {
            if (bl) {
                System.err.println("Jython has already been initialized in this context, not initializing for " + this.getServletName() + ".  Add " + SKIP_INIT_NAME + " to as an init param to this servlet's configuration to indicate this " + "is expected.");
            }
        } else if (bl) {
            PyServlet.init(properties, this.getServletContext());
        }
        this.reset();
    }

    protected static void init(Properties properties, ServletContext servletContext) {
        String string = PyServlet.getRootPath(servletContext);
        servletContext.setAttribute(INIT_ATTR, (Object)true);
        Properties properties2 = PySystemState.getBaseProperties();
        Enumeration enumeration = servletContext.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            properties.put(string2, servletContext.getInitParameter(string2));
        }
        if (properties.getProperty("python.home") == null && properties2.getProperty("python.home") == null) {
            properties.put("python.home", string + "WEB-INF" + File.separator + "lib");
        }
        PySystemState.initialize(properties2, properties, new String[0]);
        PySystemState.add_package("javax.servlet");
        PySystemState.add_package("javax.servlet.http");
        PySystemState.add_package("javax.servlet.jsp");
        PySystemState.add_package("javax.servlet.jsp.tagext");
        PySystemState.add_classdir(string + "WEB-INF" + File.separator + "classes");
        PySystemState.add_extdir(string + "WEB-INF" + File.separator + "lib", true);
    }

    protected static PythonInterpreter createInterpreter(ServletContext servletContext) {
        String string = PyServlet.getRootPath(servletContext);
        PySystemState pySystemState = new PySystemState();
        PythonInterpreter pythonInterpreter = new PythonInterpreter(Py.newStringMap(), pySystemState);
        pySystemState.path.append(new PyString(string));
        String string2 = string + "WEB-INF" + File.separator + "jython";
        pySystemState.path.append(new PyString(string2));
        return pythonInterpreter;
    }

    protected static String getRootPath(ServletContext servletContext) {
        String string = servletContext.getRealPath("/");
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        servletRequest.setAttribute("pyservlet", (Object)this);
        String string = (String)servletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (string == null && ((string = ((HttpServletRequest)servletRequest).getServletPath()) == null || string.length() == 0)) {
            string = ((HttpServletRequest)servletRequest).getPathInfo();
        }
        String string2 = this.getServletContext().getRealPath(string);
        this.getServlet(string2).service(servletRequest, servletResponse);
    }

    public void destroy() {
        super.destroy();
        this.destroyCache();
    }

    public void reset() {
        this.destroyCache();
        this.interp = PyServlet.createInterpreter(this.getServletContext());
    }

    private synchronized HttpServlet getServlet(String string) throws ServletException, IOException {
        CacheEntry cacheEntry = this.cache.get(string);
        if (cacheEntry == null || new File(string).lastModified() > cacheEntry.date) {
            return this.loadServlet(string);
        }
        return cacheEntry.servlet;
    }

    private HttpServlet loadServlet(String string) throws ServletException, IOException {
        File file = new File(string);
        HttpServlet httpServlet = PyServlet.createInstance(this.interp, file, HttpServlet.class);
        try {
            httpServlet.init(this.getServletConfig());
        }
        catch (PyException pyException) {
            throw new ServletException((Throwable)pyException);
        }
        this.cache.put(string, new CacheEntry(httpServlet, file.lastModified()));
        return httpServlet;
    }

    protected static <T> T createInstance(PythonInterpreter pythonInterpreter, File file, Class<T> clazz) throws ServletException {
        Matcher matcher = FIND_NAME.matcher(file.getName());
        if (!matcher.find()) {
            throw new ServletException("I can't guess the name of the class from " + file.getAbsolutePath());
        }
        String string = matcher.group(1);
        try {
            pythonInterpreter.set("__file__", file.getAbsolutePath());
            pythonInterpreter.execfile(file.getAbsolutePath());
            PyObject pyObject = pythonInterpreter.get(string);
            if (pyObject == null) {
                throw new ServletException("No callable (class or function) named " + string + " in " + file.getAbsolutePath());
            }
            PyObject pyObject2 = pyObject.__call__();
            Object object = pyObject2.__tojava__(clazz);
            if (object == Py.NoConversion) {
                throw new ServletException("The value from " + string + " must extend " + clazz.getSimpleName());
            }
            Object object2 = object;
            return (T)object2;
        }
        catch (PyException pyException) {
            throw new ServletException((Throwable)pyException);
        }
    }

    private void destroyCache() {
        for (CacheEntry cacheEntry : this.cache.values()) {
            cacheEntry.servlet.destroy();
        }
        this.cache.clear();
    }

    private static class CacheEntry {
        public long date;
        public HttpServlet servlet;

        CacheEntry(HttpServlet httpServlet, long l) {
            this.servlet = httpServlet;
            this.date = l;
        }
    }
}

