/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Properties;
import org.python.antlr.base.mod;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.ParserFacade;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFileReader;
import org.python.core.PyFileWriter;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.__builtin__;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonInterpreter {
    protected PySystemState systemState;
    PyObject globals;
    protected ThreadLocal<PyObject> threadLocals;
    protected CompilerFlags cflags = new CompilerFlags();

    public static void initialize(Properties properties, Properties properties2, String[] stringArray) {
        PySystemState.initialize(properties, properties2, stringArray);
    }

    public PythonInterpreter() {
        this(null, null);
    }

    public static PythonInterpreter threadLocalStateInterpreter(PyObject pyObject) {
        return new PythonInterpreter(pyObject, null, true);
    }

    public PythonInterpreter(PyObject pyObject) {
        this(pyObject, null);
    }

    public PythonInterpreter(PyObject pyObject, PySystemState pySystemState) {
        this(pyObject, pySystemState, false);
    }

    protected PythonInterpreter(PyObject pyObject, PySystemState pySystemState, boolean bl) {
        if (pyObject == null) {
            pyObject = Py.newStringMap();
        }
        this.globals = pyObject;
        if (pySystemState == null) {
            pySystemState = Py.getSystemState();
        }
        this.systemState = pySystemState;
        this.setSystemState();
        if (bl) {
            this.threadLocals = new ThreadLocal();
        } else {
            PyModule pyModule = new PyModule("__main__", pyObject);
            pySystemState.modules.__setitem__("__main__", (PyObject)pyModule);
        }
    }

    public PySystemState getSystemState() {
        return this.systemState;
    }

    protected void setSystemState() {
        Py.setSystemState(this.getSystemState());
    }

    public void setIn(PyObject pyObject) {
        this.getSystemState().stdin = pyObject;
    }

    public void setIn(Reader reader) {
        this.setIn(new PyFileReader(reader));
    }

    public void setIn(InputStream inputStream) {
        this.setIn(new PyFile(inputStream));
    }

    public void setOut(PyObject pyObject) {
        this.getSystemState().stdout = pyObject;
    }

    public void setOut(Writer writer) {
        this.setOut(new PyFileWriter(writer));
    }

    public void setOut(OutputStream outputStream) {
        this.setOut(new PyFile(outputStream));
    }

    public void setErr(PyObject pyObject) {
        this.getSystemState().stderr = pyObject;
    }

    public void setErr(Writer writer) {
        this.setErr(new PyFileWriter(writer));
    }

    public void setErr(OutputStream outputStream) {
        this.setErr(new PyFile(outputStream));
    }

    public PyObject eval(String string) {
        this.setSystemState();
        return __builtin__.eval(new PyString(string), this.getLocals());
    }

    public PyObject eval(PyObject pyObject) {
        this.setSystemState();
        return __builtin__.eval(pyObject, this.getLocals());
    }

    public void exec(String string) {
        this.setSystemState();
        Py.exec(Py.compile_flags(string, "<string>", CompileMode.exec, this.cflags), this.getLocals(), null);
        Py.flushLine();
    }

    public void exec(PyObject pyObject) {
        this.setSystemState();
        Py.exec(pyObject, this.getLocals(), null);
        Py.flushLine();
    }

    public void execfile(String string) {
        PyObject pyObject = this.getLocals();
        this.setSystemState();
        __builtin__.execfile_flags(string, pyObject, pyObject, this.cflags);
        Py.flushLine();
    }

    public void execfile(InputStream inputStream) {
        this.execfile(inputStream, "<iostream>");
    }

    public void execfile(InputStream inputStream, String string) {
        this.setSystemState();
        Py.runCode(Py.compile_flags(inputStream, string, CompileMode.exec, this.cflags), null, this.getLocals());
        Py.flushLine();
    }

    public PyCode compile(String string) {
        return this.compile(string, "<script>");
    }

    public PyCode compile(Reader reader) {
        return this.compile(reader, "<script>");
    }

    public PyCode compile(String string, String string2) {
        return this.compile(new StringReader(string), string2);
    }

    public PyCode compile(Reader reader, String string) {
        mod mod2 = ParserFacade.parseExpressionOrModule(reader, string, this.cflags);
        this.setSystemState();
        return Py.compile_flags(mod2, string, CompileMode.eval, this.cflags);
    }

    public PyObject getLocals() {
        if (this.threadLocals == null) {
            return this.globals;
        }
        PyObject pyObject = this.threadLocals.get();
        if (pyObject != null) {
            return pyObject;
        }
        return this.globals;
    }

    public void setLocals(PyObject pyObject) {
        if (this.threadLocals == null) {
            this.globals = pyObject;
        } else {
            this.threadLocals.set(pyObject);
        }
    }

    public void set(String string, Object object) {
        this.getLocals().__setitem__(string.intern(), Py.java2py(object));
    }

    public void set(String string, PyObject pyObject) {
        this.getLocals().__setitem__(string.intern(), pyObject);
    }

    public PyObject get(String string) {
        return this.getLocals().__finditem__(string.intern());
    }

    public <T> T get(String string, Class<T> clazz) {
        PyObject pyObject = this.getLocals().__finditem__(string.intern());
        if (pyObject == null) {
            return null;
        }
        return Py.tojava(pyObject, clazz);
    }

    public void cleanup() {
        this.setSystemState();
        PySystemState pySystemState = Py.getSystemState();
        pySystemState.callExitFunc();
        try {
            pySystemState.stdout.invoke("flush");
        }
        catch (PyException pyException) {
            // empty catch block
        }
        try {
            pySystemState.stderr.invoke("flush");
        }
        catch (PyException pyException) {
            // empty catch block
        }
        pySystemState.cleanup();
    }
}

