/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.lang.reflect.Method;
import java.util.Properties;
import junit.framework.TestCase;
import org.python.core.PySystemState;
import org.python.util.InteractiveConsole;
import org.python.util.JLineConsole;
import org.python.util.jython;

public class jythonTest
extends TestCase {
    private static final String PYTHON_CONSOLE = "python.console";
    private Properties _originalRegistry;

    protected void setUp() throws Exception {
        this._originalRegistry = PySystemState.registry;
        Properties properties = this._originalRegistry != null ? new Properties(this._originalRegistry) : new Properties();
        PySystemState.registry = properties;
    }

    protected void tearDown() throws Exception {
        PySystemState.registry = this._originalRegistry;
    }

    public void testNewInterpreter() throws Exception {
        jythonTest.assertEquals(JLineConsole.class, this.invokeNewInterpreter(true).getClass());
    }

    public void testNewInterpreter_registry() throws Exception {
        PySystemState.registry.setProperty(PYTHON_CONSOLE, "org.python.util.InteractiveConsole");
        jythonTest.assertEquals(InteractiveConsole.class, this.invokeNewInterpreter(true).getClass());
    }

    public void testNewInterpreter_unknown() throws Exception {
        PySystemState.registry.setProperty(PYTHON_CONSOLE, "foo.bar.NoConsole");
        jythonTest.assertEquals(JLineConsole.class, this.invokeNewInterpreter(true).getClass());
    }

    public void testNewInterpreter_NonInteractive() throws Exception {
        jythonTest.assertEquals(InteractiveConsole.class, this.invokeNewInterpreter(false).getClass());
    }

    private InteractiveConsole invokeNewInterpreter(boolean bl) throws Exception {
        Method method = jython.class.getDeclaredMethod("newInterpreter", Boolean.TYPE);
        jythonTest.assertNotNull((Object)method);
        method.setAccessible(true);
        Object object = method.invoke(null, bl);
        jythonTest.assertNotNull((Object)object);
        jythonTest.assertTrue((boolean)(object instanceof InteractiveConsole));
        return (InteractiveConsole)object;
    }
}

