/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import java.io.IOException;
import java.io.OutputStream;
import org.mozilla.classfile.ClassFileField;
import org.mozilla.classfile.ClassFileMethod;
import org.mozilla.classfile.ConstantPool;
import org.mozilla.classfile.ExceptionTableEntry;
import org.mozilla.javascript.ObjArray;

public class ClassFileWriter {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_ABSTRACT = 1024;
    private static final int LineNumberTableSize = 16;
    private static final int ExceptionTableSize = 4;
    private static final long FileHeaderConstant = -3819410108756852691L;
    private static final boolean DEBUGSTACK = false;
    private static final boolean DEBUGLABELS = false;
    private static final boolean DEBUGCODE = false;
    private String generatedClassName;
    private ExceptionTableEntry[] itsExceptionTable;
    private int itsExceptionTableTop;
    private int[] itsLineNumberTable;
    private int itsLineNumberTableTop;
    private byte[] itsCodeBuffer = new byte[256];
    private int itsCodeBufferTop;
    private ConstantPool itsConstantPool;
    private ClassFileMethod itsCurrentMethod;
    private short itsStackTop;
    private short itsMaxStack;
    private short itsMaxLocals;
    private ObjArray itsMethods = new ObjArray();
    private ObjArray itsFields = new ObjArray();
    private ObjArray itsInterfaces = new ObjArray();
    private short itsFlags;
    private short itsThisClassIndex;
    private short itsSuperClassIndex;
    private short itsSourceFileNameIndex;
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private long[] itsFixupTable;
    private int itsFixupTableTop;
    private ObjArray itsVarDescriptors;
    private char[] tmpCharBuffer = new char[64];

    public ClassFileWriter(String className, String superClassName, String sourceFileName) {
        this.generatedClassName = className;
        this.itsConstantPool = new ConstantPool(this);
        this.itsThisClassIndex = this.itsConstantPool.addClass(className);
        this.itsSuperClassIndex = this.itsConstantPool.addClass(superClassName);
        if (sourceFileName != null) {
            this.itsSourceFileNameIndex = this.itsConstantPool.addUtf8(sourceFileName);
        }
        this.itsFlags = 1;
    }

    public final String getClassName() {
        return this.generatedClassName;
    }

    public void addInterface(String interfaceName) {
        short interfaceIndex = this.itsConstantPool.addClass(interfaceName);
        this.itsInterfaces.add(new Short(interfaceIndex));
    }

    public void setFlags(short flags) {
        this.itsFlags = flags;
    }

    static String getSlashedForm(String name) {
        return name.replace('.', '/');
    }

    public static String classNameToSignature(String name) {
        int nameLength = name.length();
        int colonPos = 1 + nameLength;
        char[] buf = new char[colonPos + 1];
        buf[0] = 76;
        buf[colonPos] = 59;
        name.getChars(0, nameLength, buf, 1);
        int i = 1;
        while (i != colonPos) {
            if (buf[i] == '.') {
                buf[i] = 47;
            }
            ++i;
        }
        return new String(buf, 0, colonPos + 1);
    }

    public void addField(String fieldName, String type, short flags) {
        short fieldNameIndex = this.itsConstantPool.addUtf8(fieldName);
        short typeIndex = this.itsConstantPool.addUtf8(type);
        this.itsFields.add(new ClassFileField(fieldNameIndex, typeIndex, flags));
    }

    public void addField(String fieldName, String type, short flags, int value) {
        short fieldNameIndex = this.itsConstantPool.addUtf8(fieldName);
        short typeIndex = this.itsConstantPool.addUtf8(type);
        ClassFileField field = new ClassFileField(fieldNameIndex, typeIndex, flags);
        field.setAttributes(this.itsConstantPool.addUtf8("ConstantValue"), (short)0, (short)0, this.itsConstantPool.addConstant(value));
        this.itsFields.add(field);
    }

    public void addField(String fieldName, String type, short flags, long value) {
        short fieldNameIndex = this.itsConstantPool.addUtf8(fieldName);
        short typeIndex = this.itsConstantPool.addUtf8(type);
        ClassFileField field = new ClassFileField(fieldNameIndex, typeIndex, flags);
        field.setAttributes(this.itsConstantPool.addUtf8("ConstantValue"), (short)0, (short)2, this.itsConstantPool.addConstant(value));
        this.itsFields.add(field);
    }

    public void addField(String fieldName, String type, short flags, double value) {
        short fieldNameIndex = this.itsConstantPool.addUtf8(fieldName);
        short typeIndex = this.itsConstantPool.addUtf8(type);
        ClassFileField field = new ClassFileField(fieldNameIndex, typeIndex, flags);
        field.setAttributes(this.itsConstantPool.addUtf8("ConstantValue"), (short)0, (short)2, this.itsConstantPool.addConstant(value));
        this.itsFields.add(field);
    }

    public void addVariableDescriptor(String name, String type, int startPC, int register) {
        short nameIndex = this.itsConstantPool.addUtf8(name);
        short descriptorIndex = this.itsConstantPool.addUtf8(type);
        int[] chunk = new int[]{nameIndex, descriptorIndex, startPC, register};
        if (this.itsVarDescriptors == null) {
            this.itsVarDescriptors = new ObjArray();
        }
        this.itsVarDescriptors.add(chunk);
    }

    public void startMethod(String methodName, String type, short flags) {
        short methodNameIndex = this.itsConstantPool.addUtf8(methodName);
        short typeIndex = this.itsConstantPool.addUtf8(type);
        this.itsCurrentMethod = new ClassFileMethod(methodNameIndex, typeIndex, flags);
        this.itsMethods.add(this.itsCurrentMethod);
    }

    public void stopMethod(short maxLocals) {
        int attrLength;
        if (this.itsCurrentMethod == null) {
            throw new IllegalStateException("No method to stop");
        }
        this.fixLabelGotos();
        this.itsMaxLocals = maxLocals;
        int lineNumberTableLength = 0;
        if (this.itsLineNumberTable != null) {
            lineNumberTableLength = 8 + this.itsLineNumberTableTop * 4;
        }
        int variableTableLength = 0;
        if (this.itsVarDescriptors != null) {
            variableTableLength = 8 + this.itsVarDescriptors.size() * 10;
        }
        if ((attrLength = 14 + this.itsCodeBufferTop + 2 + this.itsExceptionTableTop * 8 + 2 + lineNumberTableLength + variableTableLength) > 65536) {
            throw new ClassFileFormatException("generated bytecode for method exceeds 64K limit.");
        }
        byte[] codeAttribute = new byte[attrLength];
        int index = 0;
        short codeAttrIndex = this.itsConstantPool.addUtf8("Code");
        index = ClassFileWriter.putInt16(codeAttrIndex, codeAttribute, index);
        index = ClassFileWriter.putInt32(attrLength -= 6, codeAttribute, index);
        index = ClassFileWriter.putInt16(this.itsMaxStack, codeAttribute, index);
        index = ClassFileWriter.putInt16(this.itsMaxLocals, codeAttribute, index);
        index = ClassFileWriter.putInt32(this.itsCodeBufferTop, codeAttribute, index);
        System.arraycopy(this.itsCodeBuffer, 0, codeAttribute, index, this.itsCodeBufferTop);
        index += this.itsCodeBufferTop;
        if (this.itsExceptionTableTop > 0) {
            index = ClassFileWriter.putInt16(this.itsExceptionTableTop, codeAttribute, index);
            int i = 0;
            while (i < this.itsExceptionTableTop) {
                ExceptionTableEntry ete = this.itsExceptionTable[i];
                short startPC = (short)this.getLabelPC(ete.itsStartLabel);
                short endPC = (short)this.getLabelPC(ete.itsEndLabel);
                short handlerPC = (short)this.getLabelPC(ete.itsHandlerLabel);
                short catchType = ete.itsCatchType;
                if (startPC == -1) {
                    throw new IllegalStateException("start label not defined");
                }
                if (endPC == -1) {
                    throw new IllegalStateException("end label not defined");
                }
                if (handlerPC == -1) {
                    throw new IllegalStateException("handler label not defined");
                }
                index = ClassFileWriter.putInt16(startPC, codeAttribute, index);
                index = ClassFileWriter.putInt16(endPC, codeAttribute, index);
                index = ClassFileWriter.putInt16(handlerPC, codeAttribute, index);
                index = ClassFileWriter.putInt16(catchType, codeAttribute, index);
                ++i;
            }
        } else {
            index = ClassFileWriter.putInt16(0, codeAttribute, index);
        }
        int attributeCount = 0;
        if (this.itsLineNumberTable != null) {
            ++attributeCount;
        }
        if (this.itsVarDescriptors != null) {
            ++attributeCount;
        }
        index = ClassFileWriter.putInt16(attributeCount, codeAttribute, index);
        if (this.itsLineNumberTable != null) {
            short lineNumberTableAttrIndex = this.itsConstantPool.addUtf8("LineNumberTable");
            index = ClassFileWriter.putInt16(lineNumberTableAttrIndex, codeAttribute, index);
            int tableAttrLength = 2 + this.itsLineNumberTableTop * 4;
            index = ClassFileWriter.putInt32(tableAttrLength, codeAttribute, index);
            index = ClassFileWriter.putInt16(this.itsLineNumberTableTop, codeAttribute, index);
            int i = 0;
            while (i < this.itsLineNumberTableTop) {
                index = ClassFileWriter.putInt32(this.itsLineNumberTable[i], codeAttribute, index);
                ++i;
            }
        }
        if (this.itsVarDescriptors != null) {
            short variableTableAttrIndex = this.itsConstantPool.addUtf8("LocalVariableTable");
            index = ClassFileWriter.putInt16(variableTableAttrIndex, codeAttribute, index);
            int varCount = this.itsVarDescriptors.size();
            int tableAttrLength = 2 + varCount * 10;
            index = ClassFileWriter.putInt32(tableAttrLength, codeAttribute, index);
            index = ClassFileWriter.putInt16(varCount, codeAttribute, index);
            int i = 0;
            while (i < varCount) {
                int[] chunk = (int[])this.itsVarDescriptors.get(i);
                int nameIndex = chunk[0];
                int descriptorIndex = chunk[1];
                int startPC = chunk[2];
                int register = chunk[3];
                int length = this.itsCodeBufferTop - startPC;
                index = ClassFileWriter.putInt16(startPC, codeAttribute, index);
                index = ClassFileWriter.putInt16(length, codeAttribute, index);
                index = ClassFileWriter.putInt16(nameIndex, codeAttribute, index);
                index = ClassFileWriter.putInt16(descriptorIndex, codeAttribute, index);
                index = ClassFileWriter.putInt16(register, codeAttribute, index);
                ++i;
            }
        }
        this.itsCurrentMethod.setCodeAttribute(codeAttribute);
        this.itsExceptionTable = null;
        this.itsExceptionTableTop = 0;
        this.itsLineNumberTableTop = 0;
        this.itsCodeBufferTop = 0;
        this.itsCurrentMethod = null;
        this.itsMaxStack = 0;
        this.itsStackTop = 0;
        this.itsLabelTableTop = 0;
        this.itsFixupTableTop = 0;
        this.itsVarDescriptors = null;
    }

    public void add(int theOpCode) {
        if (ClassFileWriter.opcodeCount(theOpCode) != 0) {
            throw new IllegalArgumentException("Unexpected operands");
        }
        int newStack = this.itsStackTop + ClassFileWriter.stackChange(theOpCode);
        if (newStack < 0 || Short.MAX_VALUE < newStack) {
            ClassFileWriter.badStack(newStack);
        }
        this.addToCodeBuffer(theOpCode);
        this.itsStackTop = (short)newStack;
        if (newStack > this.itsMaxStack) {
            this.itsMaxStack = (short)newStack;
        }
    }

    public void add(int theOpCode, int theOperand) {
        int newStack = this.itsStackTop + ClassFileWriter.stackChange(theOpCode);
        if (newStack < 0 || Short.MAX_VALUE < newStack) {
            ClassFileWriter.badStack(newStack);
        }
        switch (theOpCode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                if ((theOperand & Integer.MIN_VALUE) != Integer.MIN_VALUE && (theOperand < 0 || theOperand > 65535)) {
                    throw new IllegalArgumentException("Bad label for branch");
                }
                int branchPC = this.itsCodeBufferTop;
                this.addToCodeBuffer(theOpCode);
                if ((theOperand & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
                    this.addToCodeInt16(theOperand);
                    break;
                }
                int targetPC = this.getLabelPC(theOperand);
                if (targetPC != -1) {
                    int offset = targetPC - branchPC;
                    this.addToCodeInt16(offset);
                    break;
                }
                this.addLabelFixup(theOperand, branchPC + 1);
                this.addToCodeInt16(0);
                break;
            }
            case 16: {
                if ((byte)theOperand != theOperand) {
                    throw new IllegalArgumentException("out of range byte");
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer((byte)theOperand);
                break;
            }
            case 17: {
                if ((short)theOperand != theOperand) {
                    throw new IllegalArgumentException("out of range short");
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeInt16(theOperand);
                break;
            }
            case 188: {
                if (theOperand < 0 || theOperand >= 256) {
                    throw new IllegalArgumentException("out of range index");
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer(theOperand);
                break;
            }
            case 180: 
            case 181: {
                if (theOperand < 0 || theOperand >= 65536) {
                    throw new IllegalArgumentException("out of range field");
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeInt16(theOperand);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                if (theOperand < 0 || theOperand >= 65536) {
                    throw new IllegalArgumentException("out of range index");
                }
                if (theOperand >= 256 || theOpCode == 19 || theOpCode == 20) {
                    if (theOpCode == 18) {
                        this.addToCodeBuffer(19);
                    } else {
                        this.addToCodeBuffer(theOpCode);
                    }
                    this.addToCodeInt16(theOperand);
                    break;
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer(theOperand);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                if (theOperand < 0 || theOperand >= 65536) {
                    throw new ClassFileFormatException("out of range variable");
                }
                if (theOperand >= 256) {
                    this.addToCodeBuffer(196);
                    this.addToCodeBuffer(theOpCode);
                    this.addToCodeInt16(theOperand);
                    break;
                }
                this.addToCodeBuffer(theOpCode);
                this.addToCodeBuffer(theOperand);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected opcode for 1 operand");
            }
        }
        this.itsStackTop = (short)newStack;
        if (newStack > this.itsMaxStack) {
            this.itsMaxStack = (short)newStack;
        }
    }

    public void addLoadConstant(int k) {
        switch (k) {
            case 0: {
                this.add(3);
                break;
            }
            case 1: {
                this.add(4);
                break;
            }
            case 2: {
                this.add(5);
                break;
            }
            case 3: {
                this.add(6);
                break;
            }
            case 4: {
                this.add(7);
                break;
            }
            case 5: {
                this.add(8);
                break;
            }
            default: {
                this.add(18, this.itsConstantPool.addConstant(k));
            }
        }
    }

    public void addLoadConstant(long k) {
        this.add(20, this.itsConstantPool.addConstant(k));
    }

    public void addLoadConstant(float k) {
        this.add(18, this.itsConstantPool.addConstant(k));
    }

    public void addLoadConstant(double k) {
        this.add(20, this.itsConstantPool.addConstant(k));
    }

    public void addLoadConstant(String k) {
        this.add(18, this.itsConstantPool.addConstant(k));
    }

    public void add(int theOpCode, int theOperand1, int theOperand2) {
        int newStack = this.itsStackTop + ClassFileWriter.stackChange(theOpCode);
        if (newStack < 0 || Short.MAX_VALUE < newStack) {
            ClassFileWriter.badStack(newStack);
        }
        if (theOpCode == 132) {
            if (theOperand1 < 0 || theOperand1 >= 65536) {
                throw new ClassFileFormatException("out of range variable");
            }
            if (theOperand2 < 0 || theOperand2 >= 65536) {
                throw new ClassFileFormatException("out of range increment");
            }
            if (theOperand1 > 255 || theOperand2 < -128 || theOperand2 > 127) {
                this.addToCodeBuffer(196);
                this.addToCodeBuffer(132);
                this.addToCodeInt16(theOperand1);
                this.addToCodeInt16(theOperand2);
            } else {
                this.addToCodeBuffer(196);
                this.addToCodeBuffer(132);
                this.addToCodeBuffer(theOperand1);
                this.addToCodeBuffer(theOperand2);
            }
        } else if (theOpCode == 197) {
            if (theOperand1 < 0 || theOperand1 >= 65536) {
                throw new IllegalArgumentException("out of range index");
            }
            if (theOperand2 < 0 || theOperand2 >= 256) {
                throw new IllegalArgumentException("out of range dimensions");
            }
            this.addToCodeBuffer(197);
            this.addToCodeInt16(theOperand1);
            this.addToCodeBuffer(theOperand2);
        } else {
            throw new IllegalArgumentException("Unexpected opcode for 2 operands");
        }
        this.itsStackTop = (short)newStack;
        if (newStack > this.itsMaxStack) {
            this.itsMaxStack = (short)newStack;
        }
    }

    public void add(int theOpCode, String className) {
        int newStack = this.itsStackTop + ClassFileWriter.stackChange(theOpCode);
        if (newStack < 0 || Short.MAX_VALUE < newStack) {
            ClassFileWriter.badStack(newStack);
        }
        switch (theOpCode) {
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                short classIndex = this.itsConstantPool.addClass(className);
                this.addToCodeBuffer(theOpCode);
                this.addToCodeInt16(classIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad opcode for class reference");
            }
        }
        this.itsStackTop = (short)newStack;
        if (newStack > this.itsMaxStack) {
            this.itsMaxStack = (short)newStack;
        }
    }

    public void add(int theOpCode, String className, String fieldName, String fieldType) {
        int newStack = this.itsStackTop + ClassFileWriter.stackChange(theOpCode);
        char fieldTypeChar = fieldType.charAt(0);
        int fieldSize = fieldTypeChar == 'J' || fieldTypeChar == 'D' ? 2 : 1;
        switch (theOpCode) {
            case 178: 
            case 180: {
                newStack += fieldSize;
                break;
            }
            case 179: 
            case 181: {
                newStack -= fieldSize;
                break;
            }
            default: {
                throw new IllegalArgumentException("bad opcode for field reference");
            }
        }
        if (newStack < 0 || Short.MAX_VALUE < newStack) {
            ClassFileWriter.badStack(newStack);
        }
        short fieldRefIndex = this.itsConstantPool.addFieldRef(className, fieldName, fieldType);
        this.addToCodeBuffer(theOpCode);
        this.addToCodeInt16(fieldRefIndex);
        this.itsStackTop = (short)newStack;
        if (newStack > this.itsMaxStack) {
            this.itsMaxStack = (short)newStack;
        }
    }

    public void addInvoke(int theOpCode, String className, String methodName, String methodType) {
        int parameterInfo = ClassFileWriter.sizeOfParameters(methodType);
        int parameterCount = parameterInfo >>> 16;
        short stackDiff = (short)parameterInfo;
        int newStack = this.itsStackTop + stackDiff;
        if ((newStack += ClassFileWriter.stackChange(theOpCode)) < 0 || Short.MAX_VALUE < newStack) {
            ClassFileWriter.badStack(newStack);
        }
        switch (theOpCode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                this.addToCodeBuffer(theOpCode);
                if (theOpCode == 185) {
                    short ifMethodRefIndex = this.itsConstantPool.addInterfaceMethodRef(className, methodName, methodType);
                    this.addToCodeInt16(ifMethodRefIndex);
                    this.addToCodeBuffer(parameterCount + 1);
                    this.addToCodeBuffer(0);
                    break;
                }
                short methodRefIndex = this.itsConstantPool.addMethodRef(className, methodName, methodType);
                this.addToCodeInt16(methodRefIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad opcode for method reference");
            }
        }
        this.itsStackTop = (short)newStack;
        if (newStack > this.itsMaxStack) {
            this.itsMaxStack = (short)newStack;
        }
    }

    public void addPush(int k) {
        if ((byte)k == k) {
            if (k == -1) {
                this.add(2);
            } else if (k >= 0 && k <= 5) {
                this.add((byte)(3 + k));
            } else {
                this.add(16, (byte)k);
            }
        } else if ((short)k == k) {
            this.add(17, (short)k);
        } else {
            this.addLoadConstant(k);
        }
    }

    public void addPush(boolean k) {
        this.add(k ? 4 : 3);
    }

    public void addPush(long k) {
        int ik = (int)k;
        if ((long)ik == k) {
            this.addPush(ik);
            this.add(133);
        } else {
            this.addLoadConstant(k);
        }
    }

    public void addPush(double k) {
        if (k == 0.0) {
            this.add(14);
            if (1.0 / k < 0.0) {
                this.add(119);
            }
        } else if (k == 1.0 || k == -1.0) {
            this.add(15);
            if (k < 0.0) {
                this.add(119);
            }
        } else {
            this.addLoadConstant(k);
        }
    }

    public void addPush(String k) {
        int length = k.length();
        int limit = this.itsConstantPool.getUtfEncodingLimit(k, 0, length);
        if (limit == length) {
            this.addLoadConstant(k);
            return;
        }
        this.add(187, "java/lang/StringBuffer");
        this.add(89);
        this.addPush(length);
        this.addInvoke(183, "java/lang/StringBuffer", "<init>", "(I)V");
        int cursor = 0;
        while (true) {
            this.add(89);
            String s = k.substring(cursor, limit);
            this.addLoadConstant(s);
            this.addInvoke(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            this.add(87);
            if (limit == length) break;
            cursor = limit;
            limit = this.itsConstantPool.getUtfEncodingLimit(k, limit, length);
        }
        this.addInvoke(182, "java/lang/StringBuffer", "toString", "()Ljava/lang/String;");
    }

    public boolean isUnderStringSizeLimit(String k) {
        return this.itsConstantPool.isUnderUtfEncodingLimit(k);
    }

    public void addIStore(int local) {
        this.xop(59, 54, local);
    }

    public void addLStore(int local) {
        this.xop(63, 55, local);
    }

    public void addFStore(int local) {
        this.xop(67, 56, local);
    }

    public void addDStore(int local) {
        this.xop(71, 57, local);
    }

    public void addAStore(int local) {
        this.xop(75, 58, local);
    }

    public void addILoad(int local) {
        this.xop(26, 21, local);
    }

    public void addLLoad(int local) {
        this.xop(30, 22, local);
    }

    public void addFLoad(int local) {
        this.xop(34, 23, local);
    }

    public void addDLoad(int local) {
        this.xop(38, 24, local);
    }

    public void addALoad(int local) {
        this.xop(42, 25, local);
    }

    public void addLoadThis() {
        this.add(42);
    }

    private void xop(int shortOp, int op, int local) {
        switch (local) {
            case 0: {
                this.add(shortOp);
                break;
            }
            case 1: {
                this.add(shortOp + 1);
                break;
            }
            case 2: {
                this.add(shortOp + 2);
                break;
            }
            case 3: {
                this.add(shortOp + 3);
                break;
            }
            default: {
                this.add(op, local);
            }
        }
    }

    public int addTableSwitch(int low, int high) {
        int N;
        if (low > high) {
            throw new ClassFileFormatException("Bad bounds: " + low + ' ' + high);
        }
        int newStack = this.itsStackTop + ClassFileWriter.stackChange(170);
        if (newStack < 0 || Short.MAX_VALUE < newStack) {
            ClassFileWriter.badStack(newStack);
        }
        int entryCount = high - low + 1;
        int padSize = 3 & ~this.itsCodeBufferTop;
        int switchStart = N = this.addReservedCodeSpace(1 + padSize + 4 * (3 + entryCount));
        this.itsCodeBuffer[N++] = -86;
        while (padSize != 0) {
            this.itsCodeBuffer[N++] = 0;
            --padSize;
        }
        N += 4;
        N = ClassFileWriter.putInt32(low, this.itsCodeBuffer, N);
        ClassFileWriter.putInt32(high, this.itsCodeBuffer, N);
        this.itsStackTop = (short)newStack;
        if (newStack > this.itsMaxStack) {
            this.itsMaxStack = (short)newStack;
        }
        return switchStart;
    }

    public final void markTableSwitchDefault(int switchStart) {
        this.setTableSwitchJump(switchStart, -1, this.itsCodeBufferTop);
    }

    public final void markTableSwitchCase(int switchStart, int caseIndex) {
        this.setTableSwitchJump(switchStart, caseIndex, this.itsCodeBufferTop);
    }

    public final void markTableSwitchCase(int switchStart, int caseIndex, int stackTop) {
        if (stackTop < 0 || stackTop > this.itsMaxStack) {
            throw new IllegalArgumentException("Bad stack index: " + stackTop);
        }
        this.itsStackTop = (short)stackTop;
        this.setTableSwitchJump(switchStart, caseIndex, this.itsCodeBufferTop);
    }

    public void setTableSwitchJump(int switchStart, int caseIndex, int jumpTarget) {
        if (jumpTarget < 0 || jumpTarget > this.itsCodeBufferTop) {
            throw new IllegalArgumentException("Bad jump target: " + jumpTarget);
        }
        if (caseIndex < -1) {
            throw new IllegalArgumentException("Bad case index: " + caseIndex);
        }
        int padSize = 3 & ~switchStart;
        int caseOffset = caseIndex < 0 ? switchStart + 1 + padSize : switchStart + 1 + padSize + 4 * (3 + caseIndex);
        if (switchStart < 0 || switchStart > this.itsCodeBufferTop - 16 - padSize - 1) {
            throw new IllegalArgumentException(String.valueOf(switchStart) + " is outside a possible range of tableswitch" + " in already generated code");
        }
        if ((0xFF & this.itsCodeBuffer[switchStart]) != 170) {
            throw new IllegalArgumentException(String.valueOf(switchStart) + " is not offset of tableswitch statement");
        }
        if (caseOffset < 0 || caseOffset + 4 > this.itsCodeBufferTop) {
            throw new ClassFileFormatException("Too big case index: " + caseIndex);
        }
        ClassFileWriter.putInt32(jumpTarget - switchStart, this.itsCodeBuffer, caseOffset);
    }

    public int acquireLabel() {
        int top = this.itsLabelTableTop;
        if (this.itsLabelTable == null || top == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] tmp = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, tmp, 0, top);
                this.itsLabelTable = tmp;
            }
        }
        this.itsLabelTableTop = top + 1;
        this.itsLabelTable[top] = -1;
        return top | Integer.MIN_VALUE;
    }

    public void markLabel(int label) {
        if (label >= 0) {
            throw new IllegalArgumentException("Bad label, no biscuit");
        }
        if ((label &= Integer.MAX_VALUE) > this.itsLabelTableTop) {
            throw new IllegalArgumentException("Bad label");
        }
        if (this.itsLabelTable[label] != -1) {
            throw new IllegalStateException("Can only mark label once");
        }
        this.itsLabelTable[label] = this.itsCodeBufferTop;
    }

    public void markLabel(int label, short stackTop) {
        this.markLabel(label);
        this.itsStackTop = stackTop;
    }

    public void markHandler(int theLabel) {
        this.itsStackTop = 1;
        this.markLabel(theLabel);
    }

    private int getLabelPC(int label) {
        if (label >= 0) {
            throw new IllegalArgumentException("Bad label, no biscuit");
        }
        if ((label &= Integer.MAX_VALUE) >= this.itsLabelTableTop) {
            throw new IllegalArgumentException("Bad label");
        }
        return this.itsLabelTable[label];
    }

    private void addLabelFixup(int label, int fixupSite) {
        if (label >= 0) {
            throw new IllegalArgumentException("Bad label, no biscuit");
        }
        if ((label &= Integer.MAX_VALUE) >= this.itsLabelTableTop) {
            throw new IllegalArgumentException("Bad label");
        }
        int top = this.itsFixupTableTop;
        if (this.itsFixupTable == null || top == this.itsFixupTable.length) {
            if (this.itsFixupTable == null) {
                this.itsFixupTable = new long[40];
            } else {
                long[] tmp = new long[this.itsFixupTable.length * 2];
                System.arraycopy(this.itsFixupTable, 0, tmp, 0, top);
                this.itsFixupTable = tmp;
            }
        }
        this.itsFixupTableTop = top + 1;
        this.itsFixupTable[top] = (long)label << 32 | (long)fixupSite;
    }

    private void fixLabelGotos() {
        byte[] codeBuffer = this.itsCodeBuffer;
        int i = 0;
        while (i < this.itsFixupTableTop) {
            long fixup = this.itsFixupTable[i];
            int label = (int)(fixup >> 32);
            int fixupSite = (int)fixup;
            int pc = this.itsLabelTable[label];
            if (pc == -1) {
                throw new RuntimeException();
            }
            int offset = pc - (fixupSite - 1);
            if ((short)offset != offset) {
                throw new ClassFileFormatException("Program too complex: too big jump offset");
            }
            codeBuffer[fixupSite] = (byte)(offset >> 8);
            codeBuffer[fixupSite + 1] = (byte)offset;
            ++i;
        }
        this.itsFixupTableTop = 0;
    }

    public int getCurrentCodeOffset() {
        return this.itsCodeBufferTop;
    }

    public short getStackTop() {
        return this.itsStackTop;
    }

    public void setStackTop(short n) {
        this.itsStackTop = n;
    }

    public void adjustStackTop(int delta) {
        int newStack = this.itsStackTop + delta;
        if (newStack < 0 || Short.MAX_VALUE < newStack) {
            ClassFileWriter.badStack(newStack);
        }
        this.itsStackTop = (short)newStack;
        if (newStack > this.itsMaxStack) {
            this.itsMaxStack = (short)newStack;
        }
    }

    private void addToCodeBuffer(int b) {
        int N = this.addReservedCodeSpace(1);
        this.itsCodeBuffer[N] = (byte)b;
    }

    private void addToCodeInt16(int value) {
        int N = this.addReservedCodeSpace(2);
        ClassFileWriter.putInt16(value, this.itsCodeBuffer, N);
    }

    private int addReservedCodeSpace(int size) {
        if (this.itsCurrentMethod == null) {
            throw new IllegalArgumentException("No method to add to");
        }
        int oldTop = this.itsCodeBufferTop;
        int newTop = oldTop + size;
        if (newTop > this.itsCodeBuffer.length) {
            int newSize = this.itsCodeBuffer.length * 2;
            if (newTop > newSize) {
                newSize = newTop;
            }
            byte[] tmp = new byte[newSize];
            System.arraycopy(this.itsCodeBuffer, 0, tmp, 0, oldTop);
            this.itsCodeBuffer = tmp;
        }
        this.itsCodeBufferTop = newTop;
        return oldTop;
    }

    public void addExceptionHandler(int startLabel, int endLabel, int handlerLabel, String catchClassName) {
        if ((startLabel & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Bad startLabel");
        }
        if ((endLabel & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Bad endLabel");
        }
        if ((handlerLabel & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Bad handlerLabel");
        }
        short catch_type_index = catchClassName == null ? (short)0 : this.itsConstantPool.addClass(catchClassName);
        ExceptionTableEntry newEntry = new ExceptionTableEntry(startLabel, endLabel, handlerLabel, catch_type_index);
        int N = this.itsExceptionTableTop;
        if (N == 0) {
            this.itsExceptionTable = new ExceptionTableEntry[4];
        } else if (N == this.itsExceptionTable.length) {
            ExceptionTableEntry[] tmp = new ExceptionTableEntry[N * 2];
            System.arraycopy(this.itsExceptionTable, 0, tmp, 0, N);
            this.itsExceptionTable = tmp;
        }
        this.itsExceptionTable[N] = newEntry;
        this.itsExceptionTableTop = N + 1;
    }

    public void addLineNumberEntry(short lineNumber) {
        if (this.itsCurrentMethod == null) {
            throw new IllegalArgumentException("No method to stop");
        }
        int N = this.itsLineNumberTableTop;
        if (N == 0) {
            this.itsLineNumberTable = new int[16];
        } else if (N == this.itsLineNumberTable.length) {
            int[] tmp = new int[N * 2];
            System.arraycopy(this.itsLineNumberTable, 0, tmp, 0, N);
            this.itsLineNumberTable = tmp;
        }
        this.itsLineNumberTable[N] = (this.itsCodeBufferTop << 16) + lineNumber;
        this.itsLineNumberTableTop = N + 1;
    }

    public void write(OutputStream oStream) throws IOException {
        byte[] array = this.toByteArray();
        oStream.write(array);
    }

    private int getWriteSize() {
        int size = 0;
        if (this.itsSourceFileNameIndex != 0) {
            this.itsConstantPool.addUtf8("SourceFile");
        }
        size += 8;
        size += this.itsConstantPool.getWriteSize();
        size += 2;
        size += 2;
        size += 2;
        size += 2;
        size += 2 * this.itsInterfaces.size();
        size += 2;
        int i = 0;
        while (i < this.itsFields.size()) {
            size += ((ClassFileField)this.itsFields.get(i)).getWriteSize();
            ++i;
        }
        size += 2;
        i = 0;
        while (i < this.itsMethods.size()) {
            size += ((ClassFileMethod)this.itsMethods.get(i)).getWriteSize();
            ++i;
        }
        if (this.itsSourceFileNameIndex != 0) {
            size += 2;
            size += 2;
            size += 4;
            size += 2;
        } else {
            size += 2;
        }
        return size;
    }

    public byte[] toByteArray() {
        int dataSize = this.getWriteSize();
        byte[] data = new byte[dataSize];
        int offset = 0;
        short sourceFileAttributeNameIndex = 0;
        if (this.itsSourceFileNameIndex != 0) {
            sourceFileAttributeNameIndex = this.itsConstantPool.addUtf8("SourceFile");
        }
        offset = ClassFileWriter.putInt64(-3819410108756852691L, data, offset);
        offset = this.itsConstantPool.write(data, offset);
        offset = ClassFileWriter.putInt16(this.itsFlags, data, offset);
        offset = ClassFileWriter.putInt16(this.itsThisClassIndex, data, offset);
        offset = ClassFileWriter.putInt16(this.itsSuperClassIndex, data, offset);
        offset = ClassFileWriter.putInt16(this.itsInterfaces.size(), data, offset);
        int i = 0;
        while (i < this.itsInterfaces.size()) {
            short interfaceIndex = (Short)this.itsInterfaces.get(i);
            offset = ClassFileWriter.putInt16(interfaceIndex, data, offset);
            ++i;
        }
        offset = ClassFileWriter.putInt16(this.itsFields.size(), data, offset);
        i = 0;
        while (i < this.itsFields.size()) {
            ClassFileField field = (ClassFileField)this.itsFields.get(i);
            offset = field.write(data, offset);
            ++i;
        }
        offset = ClassFileWriter.putInt16(this.itsMethods.size(), data, offset);
        i = 0;
        while (i < this.itsMethods.size()) {
            ClassFileMethod method = (ClassFileMethod)this.itsMethods.get(i);
            offset = method.write(data, offset);
            ++i;
        }
        if (this.itsSourceFileNameIndex != 0) {
            offset = ClassFileWriter.putInt16(1, data, offset);
            offset = ClassFileWriter.putInt16(sourceFileAttributeNameIndex, data, offset);
            offset = ClassFileWriter.putInt32(2, data, offset);
            offset = ClassFileWriter.putInt16(this.itsSourceFileNameIndex, data, offset);
        } else {
            offset = ClassFileWriter.putInt16(0, data, offset);
        }
        if (offset != dataSize) {
            throw new RuntimeException();
        }
        return data;
    }

    static int putInt64(long value, byte[] array, int offset) {
        offset = ClassFileWriter.putInt32((int)(value >>> 32), array, offset);
        return ClassFileWriter.putInt32((int)value, array, offset);
    }

    private static void badStack(int value) {
        String s = value < 0 ? "Stack underflow: " + value : "Too big stack: " + value;
        throw new IllegalStateException(s);
    }

    /*
     * Exception decompiling
     */
    private static int sizeOfParameters(String pString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CASE]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static int putInt16(int value, byte[] array, int offset) {
        array[offset + 0] = (byte)(value >>> 8);
        array[offset + 1] = (byte)value;
        return offset + 2;
    }

    static int putInt32(int value, byte[] array, int offset) {
        array[offset + 0] = (byte)(value >>> 24);
        array[offset + 1] = (byte)(value >>> 16);
        array[offset + 2] = (byte)(value >>> 8);
        array[offset + 3] = (byte)value;
        return offset + 4;
    }

    static int opcodeCount(int opcode) {
        switch (opcode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: 
            case 196: 
            case 202: 
            case 254: 
            case 255: {
                return 0;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 188: 
            case 189: 
            case 192: 
            case 193: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                return 1;
            }
            case 132: 
            case 197: {
                return 2;
            }
            case 170: 
            case 171: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Bad opcode: " + opcode);
    }

    static int stackChange(int opcode) {
        switch (opcode) {
            case 80: 
            case 82: {
                return -4;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 148: 
            case 151: 
            case 152: {
                return -3;
            }
            case 55: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 88: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 127: 
            case 129: 
            case 131: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 173: 
            case 175: {
                return -2;
            }
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 87: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 137: 
            case 142: 
            case 144: 
            case 149: 
            case 150: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return -1;
            }
            case 0: 
            case 47: 
            case 49: 
            case 95: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 132: 
            case 134: 
            case 138: 
            case 139: 
            case 143: 
            case 145: 
            case 146: 
            case 147: 
            case 167: 
            case 169: 
            case 177: 
            case 178: 
            case 179: 
            case 184: 
            case 188: 
            case 189: 
            case 190: 
            case 192: 
            case 193: 
            case 196: 
            case 200: 
            case 202: 
            case 254: 
            case 255: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 89: 
            case 90: 
            case 91: 
            case 133: 
            case 135: 
            case 140: 
            case 141: 
            case 168: 
            case 187: 
            case 197: 
            case 201: {
                return 1;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 92: 
            case 93: 
            case 94: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Bad opcode: " + opcode);
    }

    private static String bytecodeStr(int code) {
        return "";
    }

    final char[] getCharBuffer(int minimalSize) {
        if (minimalSize > this.tmpCharBuffer.length) {
            int newSize = this.tmpCharBuffer.length * 2;
            if (minimalSize > newSize) {
                newSize = minimalSize;
            }
            this.tmpCharBuffer = new char[newSize];
        }
        return this.tmpCharBuffer;
    }

    public static class ClassFileFormatException
    extends RuntimeException {
        private static final long serialVersionUID = 1263998431033790599L;

        ClassFileFormatException(String message) {
            super(message);
        }
    }
}

