/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.Cropping;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.WrapperUtils;

public class CroppingCapability
extends CapabilityBase {
    private StateChangedObservable croppingChanged = new StateChangedObservable(){

        protected int registerNative(String string, OutArg outArg) {
            return NativeMethods.xnRegisterToCroppingChange(CroppingCapability.this.toNative(), this, string, outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromCroppingChange(CroppingCapability.this.toNative(), l);
        }
    };

    public CroppingCapability(ProductionNode productionNode) {
        super(productionNode);
    }

    public void setCropping(Cropping cropping) {
        int n = NativeMethods.xnSetCropping(this.toNative(), cropping.getXOffset(), cropping.getYOffset(), cropping.getXSize(), cropping.getYSize(), cropping.isEnabled());
        WrapperUtils.throwOnError(n);
    }

    public Cropping getCropping() {
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        OutArg outArg3 = new OutArg();
        OutArg outArg4 = new OutArg();
        OutArg outArg5 = new OutArg();
        int n = NativeMethods.xnGetCropping(this.toNative(), outArg, outArg2, outArg3, outArg4, outArg5);
        WrapperUtils.throwOnError(n);
        return new Cropping((Integer)outArg.value, (Integer)outArg2.value, (Integer)outArg3.value, (Integer)outArg4.value, (Boolean)outArg5.value);
    }

    public IStateChangedObservable getCroppingChangedEvent() {
        return this.croppingChanged;
    }
}

