/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.BoundingBox3D;
import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.Generator;
import org.OpenNI.GesturePositionEventArgs;
import org.OpenNI.GestureProgressEventArgs;
import org.OpenNI.GestureRecognizedEventArgs;
import org.OpenNI.IObservable;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.Query;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.WrapperUtils;

public class GestureGenerator
extends Generator {
    private Observable gestureRecognizedEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterGestureCallbacks(GestureGenerator.this.toNative(), this, "callback", null, outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterHandCallbacks(GestureGenerator.this.toNative(), l);
        }

        public void callback(String string, Point3D point3D, Point3D point3D2) {
            this.notify(new GestureRecognizedEventArgs(string, point3D, point3D2));
        }
    };
    private Observable gestureProgressEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterGestureCallbacks(GestureGenerator.this.toNative(), this, null, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterHandCallbacks(GestureGenerator.this.toNative(), l);
        }

        public void callback(String string, Point3D point3D, float f2) {
            this.notify(new GestureProgressEventArgs(string, point3D, f2));
        }
    };
    private Observable gestureIntermediateStageCompletedEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterToGestureIntermediateStageCompleted(GestureGenerator.this.toNative(), this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromGestureIntermediateStageCompleted(GestureGenerator.this.toNative(), l);
        }

        public void callback(String string, Point3D point3D) {
            this.notify(new GesturePositionEventArgs(string, point3D));
        }
    };
    private Observable gestureReadyForNextIntermediateStageEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterToGestureReadyForNextIntermediateStage(GestureGenerator.this.toNative(), this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromGestureReadyForNextIntermediateStage(GestureGenerator.this.toNative(), l);
        }

        public void callback(String string, Point3D point3D) {
            this.notify(new GesturePositionEventArgs(string, point3D));
        }
    };
    private StateChangedObservable gestureChangedEvent = new StateChangedObservable(){

        protected int registerNative(String string, OutArg outArg) {
            return NativeMethods.xnRegisterToGestureChange(GestureGenerator.this.toNative(), this, string, outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromGestureChange(GestureGenerator.this.toNative(), l);
        }
    };

    GestureGenerator(Context context, long l, boolean bl) {
        super(context, l, bl);
    }

    public static GestureGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnCreateGestureGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        GestureGenerator gestureGenerator = (GestureGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.GESTURE);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return gestureGenerator;
    }

    public static GestureGenerator create(Context context, Query query) {
        return GestureGenerator.create(context, query, null);
    }

    public static GestureGenerator create(Context context) {
        return GestureGenerator.create(context, null, null);
    }

    public void addGesture(String string) {
        int n = NativeMethods.xnAddGesture(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public void addGesture(String string, BoundingBox3D boundingBox3D) {
        if (boundingBox3D == null) {
            this.addGesture(string);
            return;
        }
        int n = NativeMethods.xnAddGesture(this.toNative(), string, boundingBox3D.getMins().getX(), boundingBox3D.getMins().getY(), boundingBox3D.getMins().getZ(), boundingBox3D.getMaxs().getX(), boundingBox3D.getMaxs().getY(), boundingBox3D.getMaxs().getZ());
        WrapperUtils.throwOnError(n);
    }

    public void removeGesture(String string) {
        int n = NativeMethods.xnRemoveGesture(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public int getNumberOfAvailableGestures() {
        return NativeMethods.xnGetNumberOfAvailableGestures(this.toNative());
    }

    public boolean isGestureAvailable(String string) {
        return NativeMethods.xnIsGestureAvailable(this.toNative(), string);
    }

    public boolean isGestureProgressSupported(String string) {
        return NativeMethods.xnIsGestureProgressSupported(this.toNative(), string);
    }

    public String[] enumerateAllGestures() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnEnumerateAllGestures(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (String[])outArg.value;
    }

    public String[] getAllActiveGestures() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetAllActiveGestures(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (String[])outArg.value;
    }

    public IObservable getGestureRecognizedEvent() {
        return this.gestureRecognizedEvent;
    }

    public IObservable getGestureProgressEvent() {
        return this.gestureProgressEvent;
    }

    public IObservable getGestureIntermediateStageCompletedEvent() {
        return this.gestureIntermediateStageCompletedEvent;
    }

    public IObservable getGestureReadyForNextIntermediateStageEvent() {
        return this.gestureReadyForNextIntermediateStageEvent;
    }

    public IStateChangedObservable getGestureChangedEvent() {
        return this.gestureChangedEvent;
    }
}

