/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.IRMap;
import org.OpenNI.IRMetaData;
import org.OpenNI.MapGenerator;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.Query;
import org.OpenNI.WrapperUtils;

public class IRGenerator
extends MapGenerator {
    private IRMap currIRMap;
    private int currIRMapFrameID;

    IRGenerator(Context context, long l, boolean bl) {
        super(context, l, bl);
    }

    public static IRGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnCreateIRGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        IRGenerator iRGenerator = (IRGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.IR);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return iRGenerator;
    }

    public static IRGenerator create(Context context, Query query) {
        return IRGenerator.create(context, query, null);
    }

    public static IRGenerator create(Context context) {
        return IRGenerator.create(context, null, null);
    }

    public IRMap getIRMap() {
        int n = this.getFrameID();
        if (this.currIRMap == null || this.currIRMapFrameID != n) {
            long l = NativeMethods.xnGetIRMap(this.toNative());
            MapOutputMode mapOutputMode = this.getMapOutputMode();
            this.currIRMap = new IRMap(l, mapOutputMode.getXRes(), mapOutputMode.getYRes());
            this.currIRMapFrameID = n;
        }
        return this.currIRMap;
    }

    public void getMetaData(IRMetaData iRMetaData) {
        NativeMethods.xnGetIRMetaData(this.toNative(), iRMetaData);
    }

    public IRMetaData getMetaData() {
        IRMetaData iRMetaData = new IRMetaData();
        this.getMetaData(iRMetaData);
        return iRMetaData;
    }
}

