/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import java.util.ArrayList;
import org.OpenNI.IObservable;
import org.OpenNI.IObserver;
import org.OpenNI.OutArg;
import org.OpenNI.WrapperUtils;

public abstract class Observable
implements IObservable {
    private ArrayList observers = new ArrayList();
    private long hCallback;

    public void addObserver(IObserver iObserver) {
        if (this.observers.size() == 0) {
            OutArg outArg = new OutArg();
            int n = this.registerNative(outArg);
            WrapperUtils.throwOnError(n);
            this.hCallback = (Long)outArg.value;
        }
        this.observers.add(iObserver);
    }

    public void deleteObserver(IObserver iObserver) {
        this.observers.remove(iObserver);
        if (this.observers.size() == 0) {
            this.unregisterNative(this.hCallback);
        }
    }

    public void notify(Object object) {
        for (IObserver iObserver : this.observers) {
            iObserver.update(this, object);
        }
    }

    protected abstract int registerNative(OutArg var1);

    protected abstract void unregisterNative(long var1);
}

