/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeInfoList;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.PlayerSeekOrigin;
import org.OpenNI.ProductionNode;
import org.OpenNI.RecordMedium;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.WrapperUtils;

public class Player
extends ProductionNode {
    private StateChangedObservable eofReached = new StateChangedObservable(){

        protected int registerNative(String string, OutArg outArg) {
            return NativeMethods.xnRegisterToEndOfFileReached(Player.this.toNative(), this, string, outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromEndOfFileReached(Player.this.toNative(), l);
        }
    };

    Player(Context context, long l, boolean bl) {
        super(context, l, bl);
    }

    public static Player create(Context context, String string) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnCreatePlayer(context.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        Player player = (Player)context.createProductionNodeObject((Long)outArg.value, NodeType.PLAYER);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return player;
    }

    public String getFormat() {
        return NativeMethods.xnGetPlayerSupportedFormat(this.toNative());
    }

    public void setSource(RecordMedium recordMedium, String string) {
        int n = NativeMethods.xnSetPlayerSource(this.toNative(), recordMedium.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public RecordMedium getSourceMedium() {
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        int n = NativeMethods.xnGetPlayerSource(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return RecordMedium.fromNative((Integer)outArg.value);
    }

    public String getSource() {
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        int n = NativeMethods.xnGetPlayerSource(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return (String)outArg2.value;
    }

    public void setRepeat(boolean bl) {
        int n = NativeMethods.xnSetPlayerRepeat(this.toNative(), bl);
        WrapperUtils.throwOnError(n);
    }

    public void readNext() {
        int n = NativeMethods.xnPlayerReadNext(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void seekToTimestamp(PlayerSeekOrigin playerSeekOrigin, long l) {
        int n = NativeMethods.xnSeekPlayerToTimeStamp(this.toNative(), l, playerSeekOrigin.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void seekToFrame(ProductionNode productionNode, PlayerSeekOrigin playerSeekOrigin, int n) {
        int n2 = NativeMethods.xnSeekPlayerToFrame(this.toNative(), productionNode.getName(), n, playerSeekOrigin.toNative());
        WrapperUtils.throwOnError(n2);
    }

    public long tellTimestamp() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnTellPlayerTimestamp(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (Long)outArg.value;
    }

    public int tellFrame(ProductionNode productionNode) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnTellPlayerFrame(this.toNative(), productionNode.getName(), outArg);
        WrapperUtils.throwOnError(n);
        return (Integer)outArg.value;
    }

    public int getNumberOfFrames(ProductionNode productionNode) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetPlayerNumFrames(this.toNative(), productionNode.getName(), outArg);
        WrapperUtils.throwOnError(n);
        return (Integer)outArg.value;
    }

    public NodeInfoList enumerateNodes() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnEnumeratePlayerNodes(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return new NodeInfoList((Long)outArg.value);
    }

    public boolean isEOF() {
        return NativeMethods.xnIsPlayerAtEOF(this.toNative());
    }

    public IStateChangedObservable getEOFReachedEvent() {
        return this.eofReached;
    }

    public double getPlaybackSpeed() {
        return NativeMethods.xnGetPlaybackSpeed(this.toNative());
    }

    public void setPlaybackSpeed(double d2) {
        int n = NativeMethods.xnSetPlaybackSpeed(this.toNative(), d2);
        WrapperUtils.throwOnError(n);
    }
}

