/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Capability;
import org.OpenNI.Context;
import org.OpenNI.ErrorStateCapability;
import org.OpenNI.GeneralIntCapability;
import org.OpenNI.LockHandle;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeInfo;
import org.OpenNI.NodeWrapper;
import org.OpenNI.OutArg;
import org.OpenNI.WrapperUtils;

public class ProductionNode
extends NodeWrapper {
    ProductionNode(Context context, long l, boolean bl) {
        super(context, l, bl);
    }

    public static ProductionNode fromNative(long l) {
        return Context.createProductionNodeFromNative(l);
    }

    public NodeInfo getInfo() {
        return new NodeInfo(NativeMethods.xnGetNodeInfo(this.toNative()));
    }

    public void addNeededNode(ProductionNode productionNode) {
        int n = NativeMethods.xnAddNeededNode(this.toNative(), productionNode.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void removeNeededNode(ProductionNode productionNode) {
        int n = NativeMethods.xnRemoveNeededNode(this.toNative(), productionNode.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean isCapabilitySupported(String string) {
        return NativeMethods.xnIsCapabilitySupported(this.toNative(), string);
    }

    public void setIntProperty(String string, long l) {
        int n = NativeMethods.xnSetIntProperty(this.toNative(), string, l);
        WrapperUtils.throwOnError(n);
    }

    public void setRealProperty(String string, double d2) {
        int n = NativeMethods.xnSetRealProperty(this.toNative(), string, d2);
        WrapperUtils.throwOnError(n);
    }

    public void setStringProperty(String string, String string2) {
        int n = NativeMethods.xnSetStringProperty(this.toNative(), string, string2);
        WrapperUtils.throwOnError(n);
    }

    public void setGeneralProperty(String string, int n, long l) {
        int n2 = NativeMethods.xnSetGeneralProperty(this.toNative(), string, n, l);
        WrapperUtils.throwOnError(n2);
    }

    public void setGeneralProperty(String string, byte[] byArray) {
        int n = NativeMethods.xnSetGeneralPropertyArray(this.toNative(), string, byArray);
        WrapperUtils.throwOnError(n);
    }

    public long getIntProperty(String string) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetIntProperty(this.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        return (Long)outArg.value;
    }

    public double getRealProperty(String string) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetRealProperty(this.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        return (Double)outArg.value;
    }

    public String getStringProperty(String string) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetStringProperty(this.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        return (String)outArg.value;
    }

    public void getGeneralProperty(String string, int n, long l) {
        int n2 = NativeMethods.xnGetGeneralProperty(this.toNative(), string, n, l);
        WrapperUtils.throwOnError(n2);
    }

    public void getGeneralProperty(String string, byte[] byArray) {
        int n = NativeMethods.xnGetGeneralPropertyArray(this.toNative(), string, byArray);
        WrapperUtils.throwOnError(n);
    }

    public LockHandle lockForChanges() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnLockNodeForChanges(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return new LockHandle((Integer)outArg.value);
    }

    public void unlockForChanges(LockHandle lockHandle) {
        int n = NativeMethods.xnUnlockNodeForChanges(this.toNative(), lockHandle.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void lockedNodeStartChanges(LockHandle lockHandle) {
        int n = NativeMethods.xnLockedNodeStartChanges(this.toNative(), lockHandle.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void lockedNodeEndChanges(LockHandle lockHandle) {
        int n = NativeMethods.xnLockedNodeEndChanges(this.toNative(), lockHandle.toNative());
        WrapperUtils.throwOnError(n);
    }

    public ErrorStateCapability getErrorStateCapability() {
        return new ErrorStateCapability(this);
    }

    public GeneralIntCapability getGeneralIntCapability(Capability capability) {
        return new GeneralIntCapability(this, capability);
    }
}

