/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CodecID;
import org.OpenNI.Context;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.RecordMedium;
import org.OpenNI.WrapperUtils;

public class Recorder
extends ProductionNode {
    Recorder(Context context, long l, boolean bl) {
        super(context, l, bl);
    }

    public static Recorder create(Context context, String string) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnCreateRecorder(context.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        Recorder recorder = (Recorder)context.createProductionNodeObject((Long)outArg.value, NodeType.RECORDER);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return recorder;
    }

    public String getFormat() {
        return NativeMethods.xnGetRecorderFormat(this.toNative());
    }

    public void setDestination(RecordMedium recordMedium, String string) {
        int n = NativeMethods.xnSetRecorderDestination(this.toNative(), recordMedium.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public RecordMedium getDestinationMedium() {
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        int n = NativeMethods.xnGetRecorderDestination(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return RecordMedium.fromNative((Integer)outArg.value);
    }

    public String getDestination() {
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        int n = NativeMethods.xnGetRecorderDestination(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return (String)outArg2.value;
    }

    public void addNodeToRecording(ProductionNode productionNode, CodecID codecID) {
        int n = NativeMethods.xnAddNodeToRecording(this.toNative(), productionNode.toNative(), codecID.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void addNodeToRecording(ProductionNode productionNode) {
        this.addNodeToRecording(productionNode, CodecID.Null);
    }

    public void removeNodeToRecording(ProductionNode productionNode) {
        int n = NativeMethods.xnRemoveNodeFromRecording(this.toNative(), productionNode.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void Record() {
        int n = NativeMethods.xnRecord(this.toNative());
        WrapperUtils.throwOnError(n);
    }
}

