/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.BreakFormula;
import org.scilab.forge.jlatexmath.ColorAtom;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.DefaultTeXFontParser;
import org.scilab.forge.jlatexmath.EmptyAtom;
import org.scilab.forge.jlatexmath.FormulaNotFoundException;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.MatrixAtom;
import org.scilab.forge.jlatexmath.MiddleAtom;
import org.scilab.forge.jlatexmath.PredefMacros;
import org.scilab.forge.jlatexmath.PredefinedCommands;
import org.scilab.forge.jlatexmath.PredefinedTeXFormulaParser;
import org.scilab.forge.jlatexmath.PredefinedTeXFormulas;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.RomanAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormulaSettingsParser;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.TypedAtom;
import org.scilab.forge.jlatexmath.VCenteredAtom;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TeXFormula {
    private static final String[][] a = new String[][]{{"lbrace", "rbrace"}, {"lsqbrack", "rsqbrack"}, {"lbrack", "rbrack"}, {"downarrow", "downarrow"}, {"uparrow", "uparrow"}, {"updownarrow", "updownarrow"}, {"Downarrow", "Downarrow"}, {"Uparrow", "Uparrow"}, {"Updownarrow", "Updownarrow"}, {"vert", "vert"}, {"Vert", "Vert"}};
    public static float a = 1.0f;
    public static Map a;
    public static Map b;
    public static String[] a;
    public static String[] b;
    public static String[] c;
    public static Map c;
    public List a;
    protected Map d;
    private TeXParser a;
    public Atom a;
    public String a;
    public boolean a = false;

    public static void addSymbolMappings(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResourceParseException(string, fileNotFoundException);
        }
        TeXFormula.addSymbolMappings(fileInputStream, string);
    }

    public static void addSymbolMappings(InputStream inputStream, String string) {
        TeXFormulaSettingsParser teXFormulaSettingsParser = new TeXFormulaSettingsParser(inputStream, string);
        teXFormulaSettingsParser.parseSymbolMappings(a, b);
        teXFormulaSettingsParser.parseSymbolToFormulaMappings(c, b);
    }

    public static void registerExternalFont(Character.UnicodeBlock unicodeBlock, String string, String string2) {
        if (string == null && string2 == null) {
            c.remove(unicodeBlock);
            return;
        }
        c.put(unicodeBlock, new FontInfos(string, string2));
        if (unicodeBlock.equals(Character.UnicodeBlock.BASIC_LATIN)) {
            a.clear();
        }
    }

    public static void registerExternalFont(Character.UnicodeBlock unicodeBlock, String string) {
        TeXFormula.registerExternalFont(unicodeBlock, string, string);
    }

    public static void setDPITarget(float f) {
        a = f / 72.0f;
    }

    public static void setDefaultDPI() {
        if (!GraphicsEnvironment.isHeadless()) {
            TeXFormula.setDPITarget(Toolkit.getDefaultToolkit().getScreenResolution());
        }
    }

    public TeXFormula() {
        this.a = new TeXParser("", this, false);
    }

    public TeXFormula(String string, Map map) {
        this.d = map;
        this.a = this.a;
        this.a = new TeXParser(string, this);
        this.a.parse();
    }

    public TeXFormula(String string) {
        this(string, (String)null);
    }

    public TeXFormula(String string, boolean bl) {
        this.a = null;
        this.a = new TeXParser(string, this, bl);
        this.a.parse();
    }

    public TeXFormula(String string, String string2) {
        this.a = string2;
        this.a = new TeXParser(string, this);
        this.a.parse();
    }

    public TeXFormula(String string, String string2, boolean bl, boolean bl2) {
        this.a = string2;
        this.a = new TeXParser(string, this, bl, bl2);
        this.a.parse();
    }

    public TeXFormula(TeXFormula teXFormula) {
        if (teXFormula != null) {
            this.addImpl(teXFormula);
        }
    }

    protected TeXFormula(TeXParser teXParser) {
        this.d = teXParser.a.d;
        this.a = new TeXParser(teXParser.getIsPartial(), "", this, false);
    }

    protected TeXFormula(TeXParser teXParser, String string) {
        this(teXParser, string, null);
    }

    protected TeXFormula(TeXParser teXParser, String string, boolean bl) {
        this.a = null;
        this.d = teXParser.a.d;
        boolean bl2 = teXParser.getIsPartial();
        this.a = new TeXParser(bl2, string, this, bl);
        if (bl2) {
            try {
                this.a.parse();
            }
            catch (Exception exception) {}
        } else {
            this.a.parse();
        }
    }

    protected TeXFormula(TeXParser teXParser, String string, String string2) {
        this.a = string2;
        this.d = teXParser.a.d;
        boolean bl = teXParser.getIsPartial();
        this.a = new TeXParser(bl, string, this);
        if (bl) {
            try {
                this.a.parse();
            }
            catch (Exception exception) {
                if (this.a == null) {
                    this.a = new EmptyAtom();
                }
            }
        } else {
            this.a.parse();
        }
    }

    protected TeXFormula(TeXParser teXParser, String string, String string2, boolean bl, boolean bl2) {
        this.a = string2;
        this.d = teXParser.a.d;
        boolean bl3 = teXParser.getIsPartial();
        this.a = new TeXParser(bl3, string, this, bl, bl2);
        if (bl3) {
            try {
                this.a.parse();
            }
            catch (Exception exception) {
                if (this.a == null) {
                    this.a = new EmptyAtom();
                }
            }
        } else {
            this.a.parse();
        }
    }

    public static TeXFormula getAsText(String string, int n) {
        TeXFormula teXFormula = new TeXFormula();
        if (string == null || "".equals(string)) {
            teXFormula.add(new EmptyAtom());
            return teXFormula;
        }
        String[] stringArray = string.split("\n|\\\\\\\\|\\\\cr");
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        for (String string2 : stringArray) {
            TeXFormula teXFormula2 = new TeXFormula(string2, "mathnormal", true, false);
            arrayOfAtoms.add(new RomanAtom(teXFormula2.a));
            arrayOfAtoms.addRow();
        }
        arrayOfAtoms.checkDimensions();
        teXFormula.add(new MatrixAtom(false, arrayOfAtoms, 0, n));
        return teXFormula;
    }

    public static TeXFormula getPartialTeXFormula(String string) {
        TeXFormula teXFormula;
        block3: {
            teXFormula = new TeXFormula();
            if (string == null) {
                teXFormula.add(new EmptyAtom());
                return teXFormula;
            }
            TeXParser teXParser = new TeXParser(true, string, teXFormula);
            try {
                teXParser.parse();
            }
            catch (Exception exception) {
                if (teXFormula.a != null) break block3;
                teXFormula.a = new EmptyAtom();
            }
        }
        return teXFormula;
    }

    public static void registerFonts(boolean bl) {
        DefaultTeXFontParser.registerFonts(bl);
    }

    public void setLaTeX(String string) {
        this.a.reset(string);
        if (string != null && string.length() != 0) {
            this.a.parse();
        }
    }

    public TeXFormula add(Atom atom) {
        if (atom != null) {
            if (atom instanceof MiddleAtom) {
                this.a.add((MiddleAtom)atom);
            }
            if (this.a == null) {
                this.a = atom;
            } else {
                if (!(this.a instanceof RowAtom)) {
                    this.a = new RowAtom(this.a);
                }
                ((RowAtom)this.a).add(atom);
            }
        }
        return this;
    }

    public TeXFormula add(String string) {
        if (string != null && string.length() != 0) {
            this.a = null;
            this.add(new TeXFormula(string));
        }
        return this;
    }

    public TeXFormula append(String string) {
        return this.append(false, string);
    }

    public TeXFormula append(boolean bl, String string) {
        if (string != null && string.length() != 0) {
            TeXParser teXParser = new TeXParser(bl, string, this);
            teXParser.parse();
        }
        return this;
    }

    public TeXFormula add(TeXFormula teXFormula) {
        this.addImpl(teXFormula);
        return this;
    }

    private void addImpl(TeXFormula teXFormula) {
        if (teXFormula.a != null) {
            if (teXFormula.a instanceof RowAtom) {
                this.add(new RowAtom(teXFormula.a));
            } else {
                this.add(teXFormula.a);
            }
        }
    }

    public void setLookAtLastAtom(boolean bl) {
        if (this.a instanceof RowAtom) {
            ((RowAtom)this.a).a = bl;
        }
    }

    public boolean getLookAtLastAtom() {
        if (this.a instanceof RowAtom) {
            return ((RowAtom)this.a).a;
        }
        return false;
    }

    public TeXFormula centerOnAxis() {
        this.a = new VCenteredAtom(this.a);
        return this;
    }

    public static void addPredefinedTeXFormula(InputStream inputStream) {
        new PredefinedTeXFormulaParser(inputStream, "TeXFormula").parse(a);
    }

    public static void addPredefinedCommands(InputStream inputStream) {
        new PredefinedTeXFormulaParser(inputStream, "Command").parse(MacroInfo.a);
    }

    public TeXFormula addStrut(int n, float f, float f2, float f3) {
        return this.add(new SpaceAtom(n, f, f2, f3));
    }

    public TeXFormula addStrut(int n) {
        return this.add(new SpaceAtom(n));
    }

    public TeXFormula addStrut(int n, float f, int n2, float f2, int n3, float f3) {
        return this.add(new SpaceAtom(n, f, n2, f2, n3, f3));
    }

    private Box createBox(TeXEnvironment teXEnvironment) {
        if (this.a == null) {
            return new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.a.createBox(teXEnvironment);
    }

    private DefaultTeXFont createFont(float f, int n) {
        DefaultTeXFont defaultTeXFont = new DefaultTeXFont(f);
        if (n == 0) {
            defaultTeXFont.setSs(false);
        }
        if ((n & 8) != 0) {
            defaultTeXFont.setRoman(true);
        }
        if ((n & 0x10) != 0) {
            defaultTeXFont.setTt(true);
        }
        if ((n & 1) != 0) {
            defaultTeXFont.setSs(true);
        }
        if ((n & 4) != 0) {
            defaultTeXFont.setIt(true);
        }
        if ((n & 2) != 0) {
            defaultTeXFont.setBold(true);
        }
        return defaultTeXFont;
    }

    public TeXIcon createTeXIcon(int n, float f) {
        TeXEnvironment teXEnvironment = new TeXEnvironment(n, new DefaultTeXFont(f));
        Box box = this.createBox(teXEnvironment);
        TeXIcon teXIcon = new TeXIcon(box, f);
        teXIcon.a = teXEnvironment.a;
        return teXIcon;
    }

    public TeXIcon createTeXIcon(int n, float f, int n2) {
        TeXEnvironment teXEnvironment = new TeXEnvironment(n, this.createFont(f, n2));
        Box box = this.createBox(teXEnvironment);
        TeXIcon teXIcon = new TeXIcon(box, f);
        teXIcon.a = teXEnvironment.a;
        return teXIcon;
    }

    public TeXIcon createTeXIcon(int n, float f, int n2, Color color) {
        TeXEnvironment teXEnvironment = new TeXEnvironment(n, this.createFont(f, n2));
        Box box = this.createBox(teXEnvironment);
        TeXIcon teXIcon = new TeXIcon(box, f);
        if (color != null) {
            teXIcon.setForeground(color);
        }
        teXIcon.a = teXEnvironment.a;
        return teXIcon;
    }

    public TeXIcon createTeXIcon(int n, float f, boolean bl) {
        TeXEnvironment teXEnvironment = new TeXEnvironment(n, new DefaultTeXFont(f));
        Box box = this.createBox(teXEnvironment);
        TeXIcon teXIcon = new TeXIcon(box, f, bl);
        teXIcon.a = teXEnvironment.a;
        return teXIcon;
    }

    public TeXIcon createTeXIcon(int n, float f, int n2, float f2, int n3) {
        return this.createTeXIcon(n, f, 0, n2, f2, n3);
    }

    public TeXIcon createTeXIcon(int n, float f, int n2, int n3, float f2, int n4) {
        TeXEnvironment teXEnvironment = new TeXEnvironment(n, (TeXFont)this.createFont(f, n2), n3, f2);
        Box box = this.createBox(teXEnvironment);
        HorizontalBox horizontalBox = new HorizontalBox(box, teXEnvironment.getTextwidth(), n4);
        TeXIcon teXIcon = new TeXIcon(horizontalBox, f, true);
        teXIcon.a = teXEnvironment.a;
        return teXIcon;
    }

    public TeXIcon createTeXIcon(int n, float f, int n2, float f2, int n3, int n4, float f3) {
        return this.createTeXIcon(n, f, 0, n2, f2, n3, n4, f3);
    }

    public TeXIcon createTeXIcon(int n, float f, int n2, int n3, float f2, int n4, int n5, float f3) {
        TeXEnvironment teXEnvironment = new TeXEnvironment(n, (TeXFont)this.createFont(f, n2), n3, f2);
        Box box = this.createBox(teXEnvironment);
        float f4 = f3 * SpaceAtom.getFactor(n5, teXEnvironment);
        HorizontalBox horizontalBox = new HorizontalBox(BreakFormula.split(box, teXEnvironment.getTextwidth(), f4), teXEnvironment.getTextwidth(), n4);
        TeXIcon teXIcon = new TeXIcon(horizontalBox, f, true);
        teXIcon.a = teXEnvironment.a;
        return teXIcon;
    }

    public void createImage(String string, int n, float f, String string2, Color color, Color color2, boolean bl) {
        TeXIcon teXIcon = this.createTeXIcon(n, f);
        teXIcon.setInsets(new Insets(1, 1, 1, 1));
        int n2 = teXIcon.getIconWidth();
        int n3 = teXIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, bl ? 2 : 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color != null && !bl) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n2, n3);
        }
        teXIcon.setForeground(color2);
        teXIcon.paintIcon(null, graphics2D, 0, 0);
        try {
            FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(new File(string2));
            ImageIO.write((RenderedImage)bufferedImage, string, fileImageOutputStream);
            fileImageOutputStream.flush();
            fileImageOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("I/O error : Cannot generate " + string2);
        }
        graphics2D.dispose();
    }

    public void createPNG(int n, float f, String string, Color color, Color color2) {
        this.createImage("png", n, f, string, color, color2, color == null);
    }

    public void createGIF(int n, float f, String string, Color color, Color color2) {
        this.createImage("gif", n, f, string, color, color2, color == null);
    }

    public void createJPEG(int n, float f, String string, Color color, Color color2) {
        this.createImage("jpeg", n, f, string, color, color2, false);
    }

    public static Image createBufferedImage(String string, int n, float f, Color color, Color color2) {
        TeXFormula teXFormula = new TeXFormula(string);
        TeXIcon teXIcon = teXFormula.createTeXIcon(n, f);
        teXIcon.setInsets(new Insets(2, 2, 2, 2));
        int n2 = teXIcon.getIconWidth();
        int n3 = teXIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, color2 == null ? 2 : 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, n2, n3);
        }
        teXIcon.setForeground(color == null ? Color.BLACK : color);
        teXIcon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public Image createBufferedImage(int n, float f, Color color, Color color2) {
        TeXIcon teXIcon = this.createTeXIcon(n, f);
        teXIcon.setInsets(new Insets(2, 2, 2, 2));
        int n2 = teXIcon.getIconWidth();
        int n3 = teXIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, color2 == null ? 2 : 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, n2, n3);
        }
        teXIcon.setForeground(color == null ? Color.BLACK : color);
        teXIcon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void setDEBUG(boolean bl) {
        Box.a = bl;
    }

    public TeXFormula setBackground(Color color) {
        if (color != null) {
            this.a = this.a instanceof ColorAtom ? new ColorAtom(color, null, (ColorAtom)this.a) : new ColorAtom(this.a, color, null);
        }
        return this;
    }

    public TeXFormula setColor(Color color) {
        if (color != null) {
            this.a = this.a instanceof ColorAtom ? new ColorAtom(null, color, (ColorAtom)this.a) : new ColorAtom(this.a, null, color);
        }
        return this;
    }

    public TeXFormula setFixedTypes(int n, int n2) {
        this.a = new TypedAtom(n, n2, this.a);
        return this;
    }

    public static TeXFormula get(String string) {
        TeXFormula teXFormula = (TeXFormula)a.get(string);
        if (teXFormula == null) {
            String string2 = (String)b.get(string);
            if (string2 == null) {
                throw new FormulaNotFoundException(string);
            }
            TeXFormula teXFormula2 = new TeXFormula(string2);
            a.put(string, teXFormula2);
            return teXFormula2;
        }
        return new TeXFormula(teXFormula);
    }

    static {
        a = new HashMap(150);
        b = new HashMap(150);
        a = new String[65536];
        b = new String[65536];
        c = new String[65536];
        c = new HashMap();
        TeXFormulaSettingsParser teXFormulaSettingsParser = new TeXFormulaSettingsParser();
        teXFormulaSettingsParser.parseSymbolMappings(a, b);
        new PredefinedCommands();
        new PredefinedTeXFormulas();
        new PredefMacros();
        teXFormulaSettingsParser.parseSymbolToFormulaMappings(c, b);
        try {
            DefaultTeXFont.registerAlphabet((AlphabetRegistration)Class.forName("org.scilab.forge.jlatexmath.cyrillic.CyrillicRegistration").newInstance());
            DefaultTeXFont.registerAlphabet((AlphabetRegistration)Class.forName("org.scilab.forge.jlatexmath.greek.GreekRegistration").newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class FontInfos {
        String a;
        String b;

        FontInfos(String string, String string2) {
            this.a = string;
            this.b = string2;
        }
    }
}

