/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.swt;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.opengl.JoglVersion;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import javax.media.opengl.Threading;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.ThreadingImpl;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GLCanvas
extends Canvas
implements GLAutoDrawable {
    private final GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private GLDrawable drawable;
    private GLContext context;
    private AbstractGraphicsDevice device;
    private final long nativeWindowHandle;
    private final ProxySurface proxySurface;
    private int ctxCreationFlags = 0;
    private final GLCapabilitiesImmutable glCapsRequested;
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private volatile boolean sendReshape;
    private final Runnable initAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.init(GLCanvas.this);
        }
    };
    private final Runnable displayAction = new Runnable(){

        @Override
        public void run() {
            if (GLCanvas.this.sendReshape) {
                GLCanvas.this.drawableHelper.reshape(GLCanvas.this, 0, 0, GLCanvas.this.getWidth(), GLCanvas.this.getHeight());
                GLCanvas.this.sendReshape = false;
            }
            GLCanvas.this.drawableHelper.display(GLCanvas.this);
        }
    };
    private final Runnable makeCurrentAndDisplayAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.displayAction, GLCanvas.this.initAction);
        }
    };
    private final Runnable swapBuffersAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawable.swapBuffers();
        }
    };
    private final Runnable makeCurrentAndSwapBuffersAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.swapBuffersAction, GLCanvas.this.initAction);
        }
    };
    private final Runnable postDisposeGLAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.context = null;
            if (null != GLCanvas.this.drawable) {
                GLCanvas.this.drawable.setRealized(false);
                GLCanvas.this.drawable = null;
            }
        }
    };
    private final Runnable disposeOnEDTGLAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.drawableHelper.disposeGL(GLCanvas.this, GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.postDisposeGLAction);
        }
    };
    private final Runnable disposeGraphicsDeviceAction = new Runnable(){

        @Override
        public void run() {
            if (null != GLCanvas.this.device) {
                GLCanvas.this.device.close();
                GLCanvas.this.device = null;
            }
        }
    };
    private volatile Rectangle clientArea;

    public GLCanvas(Composite composite, int n, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        super(composite, n | 0x40000);
        GLProfile.initSingleton();
        SWTAccessor.setRealized((Control)this, true);
        this.clientArea = this.getClientArea();
        this.device = SWTAccessor.getDevice((Control)this);
        this.nativeWindowHandle = SWTAccessor.getWindowHandle((Control)this);
        if (null == gLCapabilitiesImmutable) {
            gLCapabilitiesImmutable = new GLCapabilities(GLProfile.getDefault(this.device));
        }
        this.glCapsRequested = gLCapabilitiesImmutable;
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilitiesImmutable.getGLProfile());
        this.proxySurface = gLDrawableFactory.createProxySurface(this.device, this.nativeWindowHandle, gLCapabilitiesImmutable, gLCapabilitiesChooser);
        this.drawable = gLDrawableFactory.createGLDrawable(this.proxySurface);
        this.drawable.setRealized(true);
        this.context = this.drawable.createContext(gLContext);
        this.context.setSynchronized(true);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (!GLCanvas.this.drawableHelper.isExternalAnimatorAnimating()) {
                    GLCanvas.this.display();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                GLCanvas.this.clientArea = GLCanvas.this.getClientArea();
                GLCanvas.this.sendReshape = true;
            }
        });
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) throws IndexOutOfBoundsException {
        this.drawableHelper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public void destroy() {
        this.drawable.setRealized(false);
        this.dispose();
    }

    @Override
    public void display() {
        this.runInGLThread(this.makeCurrentAndDisplayAction, this.displayAction);
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.drawableHelper.getAnimator();
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return this.drawableHelper.getAutoSwapBufferMode();
    }

    @Override
    public GLContext getContext() {
        return this.context;
    }

    @Override
    public int getContextCreationFlags() {
        return this.ctxCreationFlags;
    }

    @Override
    public GL getGL() {
        GLContext gLContext = this.getContext();
        return gLContext == null ? null : gLContext.getGL();
    }

    @Override
    public void invoke(boolean bl, GLRunnable gLRunnable) {
        this.drawableHelper.invoke(this, bl, gLRunnable);
    }

    @Override
    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        this.drawableHelper.setAnimator(gLAnimatorControl);
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        this.drawableHelper.setAutoSwapBufferMode(bl);
    }

    @Override
    public void setContext(GLContext gLContext) {
        this.context = gLContext;
        if (gLContext instanceof GLContextImpl) {
            ((GLContextImpl)gLContext).setContextCreationFlags(this.ctxCreationFlags);
        }
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.ctxCreationFlags = n;
    }

    @Override
    public GL setGL(GL gL) {
        GLContext gLContext = this.getContext();
        if (gLContext != null) {
            gLContext.setGL(gL);
            return gL;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext createContext(GLContext gLContext) {
        this.lock.lock();
        try {
            GLDrawable gLDrawable = this.drawable;
            GLContext gLContext2 = gLDrawable != null ? gLDrawable.createContext(gLContext) : null;
            return gLContext2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        return (GLCapabilitiesImmutable)this.proxySurface.getGraphicsConfiguration().getChosenCapabilities();
    }

    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        return (GLCapabilitiesImmutable)this.proxySurface.getGraphicsConfiguration().getRequestedCapabilities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLDrawableFactory getFactory() {
        this.lock.lock();
        try {
            GLDrawable gLDrawable = this.drawable;
            GLDrawableFactory gLDrawableFactory = gLDrawable != null ? gLDrawable.getFactory() : null;
            return gLDrawableFactory;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public GLProfile getGLProfile() {
        return this.glCapsRequested.getGLProfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHandle() {
        this.lock.lock();
        try {
            GLDrawable gLDrawable = this.drawable;
            long l = gLDrawable != null ? gLDrawable.getHandle() : 0L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getHeight() {
        Rectangle rectangle = this.clientArea;
        if (rectangle == null) {
            return 0;
        }
        return rectangle.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NativeSurface getNativeSurface() {
        this.lock.lock();
        try {
            GLDrawable gLDrawable = this.drawable;
            NativeSurface nativeSurface = gLDrawable != null ? gLDrawable.getNativeSurface() : null;
            return nativeSurface;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getWidth() {
        Rectangle rectangle = this.clientArea;
        if (rectangle == null) {
            return 0;
        }
        return rectangle.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRealized() {
        this.lock.lock();
        try {
            GLDrawable gLDrawable = this.drawable;
            boolean bl = gLDrawable != null ? gLDrawable.isRealized() : false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setRealized(boolean bl) {
    }

    @Override
    public void swapBuffers() throws GLException {
        this.runInGLThread(this.makeCurrentAndSwapBuffersAction, this.swapBuffersAction);
    }

    public void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.lock.lock();
        try {
            Display display = this.getDisplay();
            if (null != this.context) {
                boolean bl = false;
                GLAnimatorControl gLAnimatorControl = this.getAnimator();
                if (null != gLAnimatorControl) {
                    bl = gLAnimatorControl.pause();
                }
                if (this.context.isCreated()) {
                    if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
                        this.runInDesignatedGLThread(this.disposeOnEDTGLAction);
                    } else if (this.context.isCreated()) {
                        this.drawableHelper.disposeGL(this, this.drawable, this.context, this.postDisposeGLAction);
                    }
                }
                if (bl) {
                    gLAnimatorControl.resume();
                }
            }
            if (display.getThread() == Thread.currentThread()) {
                this.disposeGraphicsDeviceAction.run();
            } else {
                display.syncExec(this.disposeGraphicsDeviceAction);
            }
        }
        finally {
            this.lock.unlock();
        }
        super.dispose();
    }

    protected boolean isRenderThread() {
        if (Threading.isSingleThreaded()) {
            if (ThreadingImpl.getMode() != ThreadingImpl.Mode.ST_WORKER) {
                Display display = this.getDisplay();
                return display != null && display.getThread() == Thread.currentThread();
            }
            return Threading.isOpenGLThread();
        }
        return true;
    }

    private void runInGLThread(Runnable runnable, Runnable runnable2) {
        if (Threading.isSingleThreaded() && !this.isRenderThread()) {
            this.runInDesignatedGLThread(runnable);
        } else {
            this.drawableHelper.invokeGL(this.drawable, this.context, runnable2, this.initAction);
        }
    }

    private void runInDesignatedGLThread(Runnable runnable) {
        if (ThreadingImpl.getMode() != ThreadingImpl.Mode.ST_WORKER) {
            Display display = this.getDisplay();
            assert (display.getThread() != Thread.currentThread()) : "Incorrect use of thread dispatching.";
            display.syncExec(runnable);
        } else {
            Threading.invokeOnOpenGLThread(true, runnable);
        }
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println((Object)JoglVersion.getInstance());
        System.err.println(JoglVersion.getDefaultOpenGLInfo(null).toString());
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice()));
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(128, 128);
        shell.setLayout((Layout)new FillLayout());
        GLCanvas gLCanvas = new GLCanvas((Composite)shell, 0, gLCapabilities, null, null);
        gLCanvas.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLInfo(gL, null));
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        shell.open();
        gLCanvas.display();
        display.dispose();
    }
}

