/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.GLArrayDataEditable;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import jogamp.opengl.util.GLArrayHandler;
import jogamp.opengl.util.GLFixedArrayHandler;
import jogamp.opengl.util.glsl.GLSLArrayHandler;

public class GLArrayDataClient
extends GLArrayDataWrapper
implements GLArrayDataEditable {
    private boolean isValidated = false;
    protected boolean sealed;
    protected boolean bufferEnabled;
    protected boolean bufferWritten;
    protected boolean enableBufferAlways;
    protected int initialElementCount;
    protected GLArrayHandler glArrayHandler;
    protected boolean usesGLSL;

    public static GLArrayDataClient createFixed(int n, int n2, int n3, boolean bl, int n4) throws GLException {
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(null, n, n2, n3, bl, 0, null, n4, false, gLFixedArrayHandler, 0, 0L, 0, 0, false);
        return gLArrayDataClient;
    }

    public static GLArrayDataClient createFixed(int n, int n2, int n3, boolean bl, int n4, Buffer buffer) throws GLException {
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(null, n, n2, n3, bl, n4, buffer, n2 * n2, false, gLFixedArrayHandler, 0, 0L, 0, 0, false);
        return gLArrayDataClient;
    }

    public static GLArrayDataClient createGLSL(String string, int n, int n2, boolean bl, int n3) throws GLException {
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(string, -1, n, n2, bl, 0, null, n3, true, gLSLArrayHandler, 0, 0L, 0, 0, true);
        return gLArrayDataClient;
    }

    public static GLArrayDataClient createGLSL(String string, int n, int n2, boolean bl, int n3, Buffer buffer) throws GLException {
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(string, -1, n, n2, bl, n3, buffer, n * n, true, gLSLArrayHandler, 0, 0L, 0, 0, true);
        return gLArrayDataClient;
    }

    @Override
    public final boolean isVBOWritten() {
        return this.bufferWritten;
    }

    @Override
    public final boolean sealed() {
        return this.sealed;
    }

    @Override
    public final boolean enabled() {
        return this.bufferEnabled;
    }

    @Override
    public final void setVBOWritten(boolean bl) {
        this.bufferWritten = bl;
    }

    @Override
    public void destroy(GL gL) {
        this.reset(gL);
        super.destroy(gL);
    }

    @Override
    public void reset(GL gL) {
        this.enableBuffer(gL, false);
        this.reset();
    }

    @Override
    public void seal(GL gL, boolean bl) {
        this.seal(bl);
        this.enableBuffer(gL, bl);
    }

    @Override
    public void enableBuffer(GL gL, boolean bl) {
        if (this.enableBufferAlways || this.bufferEnabled != bl) {
            ShaderState shaderState;
            if (bl) {
                this.checkSeal(true);
                this.init_vbo(gL);
            }
            if (this.usesGLSL) {
                shaderState = ShaderState.getShaderState(gL);
                if (null == shaderState) {
                    throw new GLException("A ShaderState must be bound to the GL context, use 'ShaderState.setShaderState(gl)'");
                }
            } else {
                shaderState = null;
            }
            if (bl) {
                this.glArrayHandler.syncData(gL, true, shaderState);
                this.glArrayHandler.enableState(gL, true, shaderState);
            } else {
                this.glArrayHandler.enableState(gL, false, shaderState);
                this.glArrayHandler.syncData(gL, false, shaderState);
            }
            this.bufferEnabled = bl;
        }
    }

    @Override
    public void setEnableAlways(boolean bl) {
        this.enableBufferAlways = bl;
    }

    @Override
    public void reset() {
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.sealed = false;
        this.bufferEnabled = false;
        this.bufferWritten = false;
    }

    @Override
    public void seal(boolean bl) {
        if (this.sealed == bl) {
            return;
        }
        this.sealed = bl;
        this.bufferWritten = false;
        if (bl) {
            if (null != this.buffer) {
                this.buffer.flip();
            }
        } else if (null != this.buffer) {
            this.buffer.position(this.buffer.limit());
            this.buffer.limit(this.buffer.capacity());
        }
    }

    @Override
    public void rewind() {
        if (this.buffer != null) {
            this.buffer.rewind();
        }
    }

    @Override
    public void padding(int n) {
        if (this.buffer == null || this.sealed) {
            return;
        }
        while (n < this.strideB) {
            Buffers.putb((Buffer)this.buffer, (byte)0);
            ++n;
        }
    }

    @Override
    public void put(Buffer buffer) {
        if (this.sealed) {
            return;
        }
        this.growBufferIfNecessary(buffer.remaining());
        Buffers.put((Buffer)this.buffer, (Buffer)buffer);
    }

    @Override
    public void putb(byte by) {
        if (this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.putb((Buffer)this.buffer, (byte)by);
    }

    @Override
    public void puts(short s) {
        if (this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.puts((Buffer)this.buffer, (short)s);
    }

    @Override
    public void puti(int n) {
        if (this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.puti((Buffer)this.buffer, (int)n);
    }

    @Override
    public void putx(int n) {
        this.puti(n);
    }

    @Override
    public void putf(float f) {
        if (this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.putf((Buffer)this.buffer, (float)f);
    }

    @Override
    public String toString() {
        return "GLArrayDataClient[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttribute + ", dataType 0x" + Integer.toHexString(this.componentType) + ", bufferClazz " + this.componentClazz + ", elements " + this.getElementCount() + ", components " + this.components + ", stride " + this.strideB + "b " + this.strideL + "c" + ", initialElementCount " + this.initialElementCount + ", sealed " + this.sealed + ", bufferEnabled " + this.bufferEnabled + ", bufferWritten " + this.bufferWritten + ", buffer " + this.buffer + ", alive " + this.alive + "]";
    }

    protected final boolean growBufferIfNecessary(int n) {
        if (this.buffer == null || this.buffer.remaining() < n) {
            this.growBuffer(Math.max(this.initialElementCount, n));
            return true;
        }
        return false;
    }

    protected final void growBuffer(int n) {
        if (!this.alive || this.sealed) {
            throw new GLException("Invalid state: " + this);
        }
        n += n / this.components * (this.strideL - this.components);
        int n2 = this.buffer != null ? this.buffer.capacity() : 0;
        int n3 = n2 + n * this.components;
        if (this.componentClazz == ByteBuffer.class) {
            ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)n3);
            if (this.buffer != null) {
                this.buffer.flip();
                byteBuffer.put((ByteBuffer)this.buffer);
            }
            this.buffer = byteBuffer;
        } else if (this.componentClazz == ShortBuffer.class) {
            ShortBuffer shortBuffer = Buffers.newDirectShortBuffer((int)n3);
            if (this.buffer != null) {
                this.buffer.flip();
                shortBuffer.put((ShortBuffer)this.buffer);
            }
            this.buffer = shortBuffer;
        } else if (this.componentClazz == IntBuffer.class) {
            IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)n3);
            if (this.buffer != null) {
                this.buffer.flip();
                intBuffer.put((IntBuffer)this.buffer);
            }
            this.buffer = intBuffer;
        } else if (this.componentClazz == FloatBuffer.class) {
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer((int)n3);
            if (this.buffer != null) {
                this.buffer.flip();
                floatBuffer.put((FloatBuffer)this.buffer);
            }
            this.buffer = floatBuffer;
        } else {
            throw new GLException("Given Buffer Class not supported: " + this.componentClazz + ":\n\t" + this);
        }
        if (DEBUG) {
            System.err.println("*** Grow: comps: " + this.components + ", " + n2 / this.components + "/" + n2 + " -> " + n3 / this.components + "/" + n3 + ", " + this);
        }
    }

    protected final void checkSeal(boolean bl) throws GLException {
        if (!this.alive) {
            throw new GLException("Invalid state: " + this);
        }
        if (this.sealed != bl) {
            if (bl) {
                throw new GLException("Not Sealed yet, seal first:\n\t" + this);
            }
            throw new GLException("Already Sealed, can't modify VBO:\n\t" + this);
        }
    }

    protected void init(String string, int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, boolean bl2, GLArrayHandler gLArrayHandler, int n6, long l, int n7, int n8, boolean bl3) throws GLException {
        super.init(string, n, n2, n3, bl, n4, buffer, bl2, n6, l, n7, n8);
        this.initialElementCount = n5;
        this.glArrayHandler = gLArrayHandler;
        this.usesGLSL = bl3;
        this.sealed = false;
        this.bufferEnabled = false;
        this.enableBufferAlways = false;
        this.bufferWritten = false;
        if (null == this.buffer && n5 > 0) {
            this.growBuffer(n5);
        }
    }

    protected void init_vbo(GL gL) {
        if (!this.isValidated) {
            this.isValidated = true;
            this.validate(gL.getGLProfile(), true);
        }
    }

    protected GLArrayDataClient() {
    }
}

