/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.FloatUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.fixedfunc.GLMatrixFunc;

public class ProjectFloat {
    private final float[] matrix = new float[16];
    private final float[][] tempInvertMatrix = new float[4][4];
    private final float[] in = new float[4];
    private final float[] out = new float[4];
    private FloatBuffer matrixBuf;
    private FloatBuffer tempInvertMatrixBuf;
    private FloatBuffer inBuf;
    private FloatBuffer outBuf;
    private FloatBuffer forwardBuf;
    private FloatBuffer sideBuf;
    private FloatBuffer upBuf;

    public static final int getRequiredFloatBufferSize() {
        return 49;
    }

    public ProjectFloat() {
        this(false);
    }

    public ProjectFloat(boolean bl) {
        this(bl ? null : Buffers.newDirectByteBuffer((int)(ProjectFloat.getRequiredFloatBufferSize() * 4)), bl ? new float[ProjectFloat.getRequiredFloatBufferSize()] : null, 0);
    }

    public ProjectFloat(Buffer buffer, float[] fArray, int n) {
        int n2 = n;
        int n3 = 16;
        this.matrixBuf = Buffers.slice2Float((Buffer)buffer, (float[])fArray, (int)n2, (int)n3);
        this.tempInvertMatrixBuf = Buffers.slice2Float((Buffer)buffer, (float[])fArray, (int)(n2 += n3), (int)n3);
        n2 += n3;
        n3 = 4;
        this.inBuf = Buffers.slice2Float((Buffer)buffer, (float[])fArray, (int)n2, (int)n3);
        this.outBuf = Buffers.slice2Float((Buffer)buffer, (float[])fArray, (int)(n2 += n3), (int)n3);
        n2 += n3;
        n3 = 3;
        this.forwardBuf = Buffers.slice2Float((Buffer)buffer, (float[])fArray, (int)n2, (int)n3);
        this.sideBuf = Buffers.slice2Float((Buffer)buffer, (float[])fArray, (int)(n2 += n3), (int)n3);
        this.upBuf = Buffers.slice2Float((Buffer)buffer, (float[])fArray, (int)(n2 += n3), (int)n3);
    }

    public void destroy() {
        this.matrixBuf = null;
        this.tempInvertMatrixBuf = null;
        this.inBuf = null;
        this.outBuf = null;
        this.forwardBuf = null;
        this.sideBuf = null;
        this.upBuf = null;
    }

    public boolean gluInvertMatrixf(float[] fArray, int n, float[] fArray2, int n2) {
        int n3;
        int n4;
        float[][] fArray3 = this.tempInvertMatrix;
        for (n4 = 0; n4 < 4; ++n4) {
            for (n3 = 0; n3 < 4; ++n3) {
                fArray3[n4][n3] = fArray[n4 * 4 + n3 + n];
            }
        }
        FloatUtil.makeIdentityf(fArray2, n2);
        for (n4 = 0; n4 < 4; ++n4) {
            float f;
            int n5;
            int n6 = n4;
            for (n3 = n4 + 1; n3 < 4; ++n3) {
                if (!(Math.abs(fArray3[n3][n4]) > Math.abs(fArray3[n4][n4]))) continue;
                n6 = n3;
            }
            if (n6 != n4) {
                for (n5 = 0; n5 < 4; ++n5) {
                    f = fArray3[n4][n5];
                    fArray3[n4][n5] = fArray3[n6][n5];
                    fArray3[n6][n5] = f;
                    f = fArray2[n4 * 4 + n5 + n2];
                    fArray2[n4 * 4 + n5 + n2] = fArray2[n6 * 4 + n5 + n2];
                    fArray2[n6 * 4 + n5 + n2] = f;
                }
            }
            if (fArray3[n4][n4] == 0.0f) {
                return false;
            }
            f = fArray3[n4][n4];
            for (n5 = 0; n5 < 4; ++n5) {
                float[] fArray4 = fArray3[n4];
                int n7 = n5;
                fArray4[n7] = fArray4[n7] / f;
                int n8 = n4 * 4 + n5 + n2;
                fArray2[n8] = fArray2[n8] / f;
            }
            for (n3 = 0; n3 < 4; ++n3) {
                if (n3 == n4) continue;
                f = fArray3[n3][n4];
                for (n5 = 0; n5 < 4; ++n5) {
                    float[] fArray5 = fArray3[n3];
                    int n9 = n5;
                    fArray5[n9] = fArray5[n9] - fArray3[n4][n5] * f;
                    int n10 = n3 * 4 + n5 + n2;
                    fArray2[n10] = fArray2[n10] - fArray2[n4 * 4 + n5 + n2] * f;
                }
            }
        }
        return true;
    }

    public boolean gluInvertMatrixf(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        int n;
        int n2;
        int n3 = floatBuffer.position();
        int n4 = floatBuffer2.position();
        FloatBuffer floatBuffer3 = this.tempInvertMatrixBuf;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                floatBuffer3.put(n2 * 4 + n, floatBuffer.get(n2 * 4 + n + n3));
            }
        }
        FloatUtil.makeIdentityf(floatBuffer2);
        for (n2 = 0; n2 < 4; ++n2) {
            float f;
            int n5;
            int n6 = n2;
            for (n = n2 + 1; n < 4; ++n) {
                if (!(Math.abs(floatBuffer3.get(n * 4 + n2)) > Math.abs(floatBuffer3.get(n2 * 4 + n2)))) continue;
                n6 = n;
            }
            if (n6 != n2) {
                for (n5 = 0; n5 < 4; ++n5) {
                    f = floatBuffer3.get(n2 * 4 + n5);
                    floatBuffer3.put(n2 * 4 + n5, floatBuffer3.get(n6 * 4 + n5));
                    floatBuffer3.put(n6 * 4 + n5, f);
                    f = floatBuffer2.get(n2 * 4 + n5 + n4);
                    floatBuffer2.put(n2 * 4 + n5 + n4, floatBuffer2.get(n6 * 4 + n5 + n4));
                    floatBuffer2.put(n6 * 4 + n5 + n4, f);
                }
            }
            if (floatBuffer3.get(n2 * 4 + n2) == 0.0f) {
                return false;
            }
            f = floatBuffer3.get(n2 * 4 + n2);
            for (n5 = 0; n5 < 4; ++n5) {
                floatBuffer3.put(n2 * 4 + n5, floatBuffer3.get(n2 * 4 + n5) / f);
                floatBuffer2.put(n2 * 4 + n5 + n4, floatBuffer2.get(n2 * 4 + n5 + n4) / f);
            }
            for (n = 0; n < 4; ++n) {
                if (n == n2) continue;
                f = floatBuffer3.get(n * 4 + n2);
                for (n5 = 0; n5 < 4; ++n5) {
                    floatBuffer3.put(n * 4 + n5, floatBuffer3.get(n * 4 + n5) - floatBuffer3.get(n2 * 4 + n5) * f);
                    floatBuffer2.put(n * 4 + n5 + n4, floatBuffer2.get(n * 4 + n5 + n4) - floatBuffer2.get(n2 * 4 + n5 + n4) * f);
                }
            }
        }
        return true;
    }

    public void gluOrtho2D(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4) {
        gLMatrixFunc.glOrthof(f, f2, f3, f4, -1.0f, 1.0f);
    }

    public void gluPerspective(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4) {
        float f5 = f / 2.0f * (float)Math.PI / 180.0f;
        float f6 = f4 - f3;
        float f7 = (float)Math.sin(f5);
        if (f6 == 0.0f || f7 == 0.0f || f2 == 0.0f) {
            return;
        }
        float f8 = (float)Math.cos(f5) / f7;
        FloatUtil.makeIdentityf(this.matrixBuf);
        this.matrixBuf.put(0, f8 / f2);
        this.matrixBuf.put(5, f8);
        this.matrixBuf.put(10, -(f4 + f3) / f6);
        this.matrixBuf.put(11, -1.0f);
        this.matrixBuf.put(14, -2.0f * f3 * f4 / f6);
        this.matrixBuf.put(15, 0.0f);
        gLMatrixFunc.glMultMatrixf(this.matrixBuf);
    }

    public void gluLookAt(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        FloatBuffer floatBuffer = this.forwardBuf;
        FloatBuffer floatBuffer2 = this.sideBuf;
        FloatBuffer floatBuffer3 = this.upBuf;
        floatBuffer.put(0, f4 - f);
        floatBuffer.put(1, f5 - f2);
        floatBuffer.put(2, f6 - f3);
        floatBuffer3.put(0, f7);
        floatBuffer3.put(1, f8);
        floatBuffer3.put(2, f9);
        FloatUtil.normalize(floatBuffer);
        FloatUtil.cross(floatBuffer, floatBuffer3, floatBuffer2);
        FloatUtil.normalize(floatBuffer2);
        FloatUtil.cross(floatBuffer2, floatBuffer, floatBuffer3);
        FloatUtil.makeIdentityf(this.matrixBuf);
        this.matrixBuf.put(0, floatBuffer2.get(0));
        this.matrixBuf.put(4, floatBuffer2.get(1));
        this.matrixBuf.put(8, floatBuffer2.get(2));
        this.matrixBuf.put(1, floatBuffer3.get(0));
        this.matrixBuf.put(5, floatBuffer3.get(1));
        this.matrixBuf.put(9, floatBuffer3.get(2));
        this.matrixBuf.put(2, -floatBuffer.get(0));
        this.matrixBuf.put(6, -floatBuffer.get(1));
        this.matrixBuf.put(10, -floatBuffer.get(2));
        gLMatrixFunc.glMultMatrixf(this.matrixBuf);
        gLMatrixFunc.glTranslatef(-f, -f2, -f3);
    }

    public boolean gluProject(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4) {
        float[] fArray4 = this.in;
        float[] fArray5 = this.out;
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = 1.0f;
        FloatUtil.multMatrixVecf(fArray, n, fArray4, 0, fArray5);
        FloatUtil.multMatrixVecf(fArray2, n2, fArray5, 0, fArray4);
        if (fArray4[3] == 0.0f) {
            return false;
        }
        fArray4[3] = 1.0f / fArray4[3] * 0.5f;
        fArray4[0] = fArray4[0] * fArray4[3] + 0.5f;
        fArray4[1] = fArray4[1] * fArray4[3] + 0.5f;
        fArray4[2] = fArray4[2] * fArray4[3] + 0.5f;
        fArray3[0 + n4] = fArray4[0] * (float)nArray[2 + n3] + (float)nArray[0 + n3];
        fArray3[1 + n4] = fArray4[1] * (float)nArray[3 + n3] + (float)nArray[1 + n3];
        fArray3[2 + n4] = fArray4[2];
        return true;
    }

    public boolean gluProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int[] nArray, int n, float[] fArray, int n2) {
        FloatBuffer floatBuffer3 = this.inBuf;
        FloatBuffer floatBuffer4 = this.outBuf;
        floatBuffer3.put(0, f);
        floatBuffer3.put(1, f2);
        floatBuffer3.put(2, f3);
        floatBuffer3.put(3, 1.0f);
        FloatUtil.multMatrixVecf(floatBuffer, floatBuffer3, floatBuffer4);
        FloatUtil.multMatrixVecf(floatBuffer2, floatBuffer4, floatBuffer3);
        if (floatBuffer3.get(3) == 0.0f) {
            return false;
        }
        floatBuffer3.put(3, 1.0f / floatBuffer3.get(3) * 0.5f);
        floatBuffer3.put(0, floatBuffer3.get(0) * floatBuffer3.get(3) + 0.5f);
        floatBuffer3.put(1, floatBuffer3.get(1) * floatBuffer3.get(3) + 0.5f);
        floatBuffer3.put(2, floatBuffer3.get(2) * floatBuffer3.get(3) + 0.5f);
        fArray[0 + n2] = floatBuffer3.get(0) * (float)nArray[2 + n] + (float)nArray[0 + n];
        fArray[1 + n2] = floatBuffer3.get(1) * (float)nArray[3 + n] + (float)nArray[1 + n];
        fArray[2 + n2] = floatBuffer3.get(2);
        return true;
    }

    public boolean gluProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3) {
        FloatBuffer floatBuffer4 = this.inBuf;
        FloatBuffer floatBuffer5 = this.outBuf;
        floatBuffer4.put(0, f);
        floatBuffer4.put(1, f2);
        floatBuffer4.put(2, f3);
        floatBuffer4.put(3, 1.0f);
        FloatUtil.multMatrixVecf(floatBuffer, floatBuffer4, floatBuffer5);
        FloatUtil.multMatrixVecf(floatBuffer2, floatBuffer5, floatBuffer4);
        if (floatBuffer4.get(3) == 0.0f) {
            return false;
        }
        floatBuffer4.put(3, 1.0f / floatBuffer4.get(3) * 0.5f);
        floatBuffer4.put(0, floatBuffer4.get(0) * floatBuffer4.get(3) + 0.5f);
        floatBuffer4.put(1, floatBuffer4.get(1) * floatBuffer4.get(3) + 0.5f);
        floatBuffer4.put(2, floatBuffer4.get(2) * floatBuffer4.get(3) + 0.5f);
        int n = intBuffer.position();
        int n2 = floatBuffer3.position();
        floatBuffer3.put(0 + n2, floatBuffer4.get(0) * (float)intBuffer.get(2 + n) + (float)intBuffer.get(0 + n));
        floatBuffer3.put(1 + n2, floatBuffer4.get(1) * (float)intBuffer.get(3 + n) + (float)intBuffer.get(1 + n));
        floatBuffer3.put(2 + n2, floatBuffer4.get(2));
        return true;
    }

    public boolean gluUnProject(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4) {
        float[] fArray4 = this.in;
        float[] fArray5 = this.out;
        FloatUtil.multMatrixf(fArray, n, fArray2, n2, this.matrix, 0);
        if (!this.gluInvertMatrixf(this.matrix, 0, this.matrix, 0)) {
            return false;
        }
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = 1.0f;
        fArray4[0] = (fArray4[0] - (float)nArray[0 + n3]) / (float)nArray[2 + n3];
        fArray4[1] = (fArray4[1] - (float)nArray[1 + n3]) / (float)nArray[3 + n3];
        fArray4[0] = fArray4[0] * 2.0f - 1.0f;
        fArray4[1] = fArray4[1] * 2.0f - 1.0f;
        fArray4[2] = fArray4[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVecf(this.matrix, fArray4, fArray5);
        if ((double)fArray5[3] == 0.0) {
            return false;
        }
        fArray5[3] = 1.0f / fArray5[3];
        fArray3[0 + n4] = fArray5[0] * fArray5[3];
        fArray3[1 + n4] = fArray5[1] * fArray5[3];
        fArray3[2 + n4] = fArray5[2] * fArray5[3];
        return true;
    }

    public boolean gluUnProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int[] nArray, int n, float[] fArray, int n2) {
        FloatBuffer floatBuffer3 = this.inBuf;
        FloatBuffer floatBuffer4 = this.outBuf;
        FloatUtil.multMatrixf(floatBuffer, floatBuffer2, this.matrixBuf);
        if (!this.gluInvertMatrixf(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        floatBuffer3.put(0, f);
        floatBuffer3.put(1, f2);
        floatBuffer3.put(2, f3);
        floatBuffer3.put(3, 1.0f);
        floatBuffer3.put(0, (floatBuffer3.get(0) - (float)nArray[0 + n]) / (float)nArray[2 + n]);
        floatBuffer3.put(1, (floatBuffer3.get(1) - (float)nArray[1 + n]) / (float)nArray[3 + n]);
        floatBuffer3.put(0, floatBuffer3.get(0) * 2.0f - 1.0f);
        floatBuffer3.put(1, floatBuffer3.get(1) * 2.0f - 1.0f);
        floatBuffer3.put(2, floatBuffer3.get(2) * 2.0f - 1.0f);
        FloatUtil.multMatrixVecf(this.matrixBuf, floatBuffer3, floatBuffer4);
        if (floatBuffer4.get(3) == 0.0f) {
            return false;
        }
        floatBuffer4.put(3, 1.0f / floatBuffer4.get(3));
        fArray[0 + n2] = floatBuffer4.get(0) * floatBuffer4.get(3);
        fArray[1 + n2] = floatBuffer4.get(1) * floatBuffer4.get(3);
        fArray[2 + n2] = floatBuffer4.get(2) * floatBuffer4.get(3);
        return true;
    }

    public boolean gluUnProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3) {
        FloatBuffer floatBuffer4 = this.inBuf;
        FloatBuffer floatBuffer5 = this.outBuf;
        FloatUtil.multMatrixf(floatBuffer, floatBuffer2, this.matrixBuf);
        if (!this.gluInvertMatrixf(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        floatBuffer4.put(0, f);
        floatBuffer4.put(1, f2);
        floatBuffer4.put(2, f3);
        floatBuffer4.put(3, 1.0f);
        int n = intBuffer.position();
        int n2 = floatBuffer3.position();
        floatBuffer4.put(0, (floatBuffer4.get(0) - (float)intBuffer.get(0 + n)) / (float)intBuffer.get(2 + n));
        floatBuffer4.put(1, (floatBuffer4.get(1) - (float)intBuffer.get(1 + n)) / (float)intBuffer.get(3 + n));
        floatBuffer4.put(0, floatBuffer4.get(0) * 2.0f - 1.0f);
        floatBuffer4.put(1, floatBuffer4.get(1) * 2.0f - 1.0f);
        floatBuffer4.put(2, floatBuffer4.get(2) * 2.0f - 1.0f);
        FloatUtil.multMatrixVecf(this.matrixBuf, floatBuffer4, floatBuffer5);
        if (floatBuffer5.get(3) == 0.0f) {
            return false;
        }
        floatBuffer5.put(3, 1.0f / floatBuffer5.get(3));
        floatBuffer3.put(0 + n2, floatBuffer5.get(0) * floatBuffer5.get(3));
        floatBuffer3.put(1 + n2, floatBuffer5.get(1) * floatBuffer5.get(3));
        floatBuffer3.put(2 + n2, floatBuffer5.get(2) * floatBuffer5.get(3));
        return true;
    }

    public boolean gluUnProject4(float f, float f2, float f3, float f4, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float f5, float f6, float[] fArray3, int n4) {
        float[] fArray4 = this.in;
        float[] fArray5 = this.out;
        FloatUtil.multMatrixf(fArray, n, fArray2, n2, this.matrix, 0);
        if (!this.gluInvertMatrixf(this.matrix, 0, this.matrix, 0)) {
            return false;
        }
        fArray4[0] = f;
        fArray4[1] = f2;
        fArray4[2] = f3;
        fArray4[3] = f4;
        fArray4[0] = (fArray4[0] - (float)nArray[0 + n3]) / (float)nArray[2 + n3];
        fArray4[1] = (fArray4[1] - (float)nArray[1 + n3]) / (float)nArray[3 + n3];
        fArray4[2] = (fArray4[2] - f5) / (f6 - f5);
        fArray4[0] = fArray4[0] * 2.0f - 1.0f;
        fArray4[1] = fArray4[1] * 2.0f - 1.0f;
        fArray4[2] = fArray4[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVecf(this.matrix, fArray4, fArray5);
        if (fArray5[3] == 0.0f) {
            return false;
        }
        fArray3[0 + n4] = fArray5[0];
        fArray3[1 + n4] = fArray5[1];
        fArray3[2 + n4] = fArray5[2];
        fArray3[3 + n4] = fArray5[3];
        return true;
    }

    public boolean gluUnProject4(float f, float f2, float f3, float f4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, float f5, float f6, FloatBuffer floatBuffer3) {
        FloatBuffer floatBuffer4 = this.inBuf;
        FloatBuffer floatBuffer5 = this.outBuf;
        FloatUtil.multMatrixf(floatBuffer, floatBuffer2, this.matrixBuf);
        if (!this.gluInvertMatrixf(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        floatBuffer4.put(0, f);
        floatBuffer4.put(1, f2);
        floatBuffer4.put(2, f3);
        floatBuffer4.put(3, f4);
        int n = intBuffer.position();
        floatBuffer4.put(0, (floatBuffer4.get(0) - (float)intBuffer.get(0 + n)) / (float)intBuffer.get(2 + n));
        floatBuffer4.put(1, (floatBuffer4.get(1) - (float)intBuffer.get(1 + n)) / (float)intBuffer.get(3 + n));
        floatBuffer4.put(2, (floatBuffer4.get(2) - f5) / (f6 - f5));
        floatBuffer4.put(0, floatBuffer4.get(0) * 2.0f - 1.0f);
        floatBuffer4.put(1, floatBuffer4.get(1) * 2.0f - 1.0f);
        floatBuffer4.put(2, floatBuffer4.get(2) * 2.0f - 1.0f);
        FloatUtil.multMatrixVecf(this.matrixBuf, floatBuffer4, floatBuffer5);
        if (floatBuffer5.get(3) == 0.0f) {
            return false;
        }
        int n2 = floatBuffer3.position();
        floatBuffer3.put(0 + n2, floatBuffer5.get(0));
        floatBuffer3.put(1 + n2, floatBuffer5.get(1));
        floatBuffer3.put(2 + n2, floatBuffer5.get(2));
        floatBuffer3.put(3 + n2, floatBuffer5.get(3));
        return true;
    }

    public void gluPickMatrix(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, IntBuffer intBuffer) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        int n = intBuffer.position();
        gLMatrixFunc.glTranslatef(((float)intBuffer.get(2 + n) - 2.0f * (f - (float)intBuffer.get(0 + n))) / f3, ((float)intBuffer.get(3 + n) - 2.0f * (f2 - (float)intBuffer.get(1 + n))) / f4, 0.0f);
        gLMatrixFunc.glScalef((float)intBuffer.get(2) / f3, (float)intBuffer.get(3) / f4, 1.0f);
    }

    public void gluPickMatrix(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, int[] nArray, int n) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        gLMatrixFunc.glTranslatef(((float)nArray[2 + n] - 2.0f * (f - (float)nArray[0 + n])) / f3, ((float)nArray[3 + n] - 2.0f * (f2 - (float)nArray[1 + n])) / f4, 0.0f);
        gLMatrixFunc.glScalef((float)nArray[2 + n] / f3, (float)nArray[3 + n] / f4, 1.0f);
    }
}

