/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.glsl;

import com.jogamp.opengl.util.GLArrayDataEditable;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import jogamp.opengl.util.GLArrayHandler;
import jogamp.opengl.util.GLArrayHandlerFlat;

public class GLSLArrayHandlerInterleaved
implements GLArrayHandler {
    private GLArrayDataEditable ad;
    private List<GLArrayHandlerFlat> subArrays = new ArrayList<GLArrayHandlerFlat>();

    public GLSLArrayHandlerInterleaved(GLArrayDataEditable gLArrayDataEditable) {
        this.ad = gLArrayDataEditable;
    }

    @Override
    public final void setSubArrayVBOName(int n) {
        for (int i = 0; i < this.subArrays.size(); ++i) {
            this.subArrays.get(i).getData().setVBOName(n);
        }
    }

    @Override
    public final void addSubHandler(GLArrayHandlerFlat gLArrayHandlerFlat) {
        this.subArrays.add(gLArrayHandlerFlat);
    }

    private final void syncSubData(GL gL, boolean bl, boolean bl2, Object object) {
        for (int i = 0; i < this.subArrays.size(); ++i) {
            this.subArrays.get(i).syncData(gL, bl, bl2, object);
        }
    }

    @Override
    public final void syncData(GL gL, boolean bl, Object object) {
        if (!this.ad.isVBO()) {
            throw new InternalError("Interleaved handle is not VBO: " + this.ad);
        }
        if (bl) {
            Buffer buffer = this.ad.getBuffer();
            boolean bl2 = this.ad.isVBOWritten();
            gL.glBindBuffer(this.ad.getVBOTarget(), this.ad.getVBOName());
            if (!bl2) {
                if (null != buffer) {
                    gL.glBufferData(this.ad.getVBOTarget(), buffer.limit() * this.ad.getComponentSizeInBytes(), buffer, this.ad.getVBOUsage());
                }
                this.ad.setVBOWritten(true);
            }
            this.syncSubData(gL, true, !bl2, object);
        } else {
            gL.glBindBuffer(this.ad.getVBOTarget(), 0);
        }
    }

    @Override
    public final void enableState(GL gL, boolean bl, Object object) {
        for (int i = 0; i < this.subArrays.size(); ++i) {
            this.subArrays.get(i).enableState(gL, bl, object);
        }
    }
}

