/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyList;
import org.python.core.PyModuleDerived;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.core.imp;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="module")
public class PyModule
extends PyObject {
    private final PyObject moduleDoc = new PyString("module(name[, doc])\n\nCreate a module object.\nThe name must be a string; the optional doc argument can have any type.");
    public PyObject __dict__;

    public PyModule() {
    }

    public PyModule(PyType subType) {
        super(subType);
    }

    public PyModule(PyType subType, String name) {
        super(subType);
        this.module___init__(new PyString(name), Py.None);
    }

    public PyModule(String name) {
        this(name, null);
    }

    public PyModule(String name, PyObject dict) {
        this.__dict__ = dict;
        this.module___init__(new PyString(name), Py.None);
    }

    @ExposedNew
    final void module___init__(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("__init__", args, keywords, new String[]{"name", "doc"});
        PyObject name = ap.getPyObject(0);
        PyObject docs = ap.getPyObject(1, Py.None);
        this.module___init__(name, docs);
    }

    private void module___init__(PyObject name, PyObject doc) {
        this.ensureDict();
        this.__dict__.__setitem__("__name__", name);
        this.__dict__.__setitem__("__doc__", doc);
    }

    public PyObject fastGetDict() {
        return this.__dict__;
    }

    public PyObject getDict() {
        return this.__dict__;
    }

    public void setDict(PyObject newDict) {
        throw Py.TypeError("readonly attribute");
    }

    public void delDict() {
        throw Py.TypeError("readonly attribute");
    }

    protected PyObject impAttr(String name) {
        if (this.__dict__ == null) {
            return null;
        }
        PyObject path = this.__dict__.__finditem__("__path__");
        PyObject pyName = this.__dict__.__finditem__("__name__");
        if (path == null || pyName == null) {
            return null;
        }
        PyObject attr = null;
        String fullName = (pyName.__str__().toString() + '.' + name).intern();
        if (path != Py.None) {
            if (path instanceof PyList) {
                attr = imp.find_module(name, fullName, (PyList)path);
            } else {
                throw Py.TypeError("__path__ must be list or None");
            }
        }
        if (attr == null) {
            attr = PySystemState.packageManager.lookupName(fullName);
        }
        if (attr != null) {
            PyObject found = Py.getSystemState().modules.__finditem__(fullName);
            if (found != null) {
                attr = found;
            }
            this.__dict__.__setitem__(name, attr);
            return attr;
        }
        return null;
    }

    public PyObject __findattr_ex__(String name) {
        PyObject attr = super.__findattr_ex__(name);
        if (attr != null) {
            return attr;
        }
        return this.impAttr(name);
    }

    public void __setattr__(String name, PyObject value) {
        this.module___setattr__(name, value);
    }

    final void module___setattr__(String name, PyObject value) {
        if (name != "__dict__") {
            this.ensureDict();
        }
        super.__setattr__(name, value);
    }

    public void __delattr__(String name) {
        this.module___delattr__(name);
    }

    final void module___delattr__(String name) {
        super.__delattr__(name);
    }

    public String toString() {
        return this.module_toString();
    }

    final String module_toString() {
        PyObject name = null;
        PyObject filename = null;
        if (this.__dict__ != null) {
            name = this.__dict__.__finditem__("__name__");
            filename = this.__dict__.__finditem__("__file__");
        }
        if (name == null) {
            name = new PyString("?");
        }
        if (filename == null) {
            return String.format("<module '%s' (built-in)>", name);
        }
        return String.format("<module '%s' from '%s'>", name, filename);
    }

    public PyObject __dir__() {
        if (this.__dict__ == null) {
            throw Py.TypeError("module.__dict__ is not a dictionary");
        }
        return this.__dict__.invoke("keys");
    }

    private void ensureDict() {
        if (this.__dict__ == null) {
            this.__dict__ = new PyStringMap();
        }
    }

    static {
        PyType.addBuilder(PyModule.class, new PyModule$PyExposer());
    }

    public class PyModule$module___init___exposer
    extends PyBuiltinMethod {
        public PyModule$module___init___exposer(String string) {
            super(string);
            this.doc = "";
        }

        public PyModule$module___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyModule$module___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyModule)this.self).module___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyModule$module___setattr___exposer
    extends PyBuiltinMethodNarrow {
        public PyModule$module___setattr___exposer(String string) {
            super(string, 3, 3);
            this.doc = "";
        }

        public PyModule$module___setattr___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyModule$module___setattr___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyModule)this.self).module___setattr__(pyObject.asString(), pyObject2);
            return Py.None;
        }
    }

    public class PyModule$module___delattr___exposer
    extends PyBuiltinMethodNarrow {
        public PyModule$module___delattr___exposer(String string) {
            super(string, 2, 2);
            this.doc = "";
        }

        public PyModule$module___delattr___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyModule$module___delattr___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyModule)this.self).module___delattr__(pyObject.asString());
            return Py.None;
        }
    }

    public class PyModule$module_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyModule$module_toString_exposer(String string) {
            super(string, 1, 1);
            this.doc = "";
        }

        public PyModule$module_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyModule$module_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            String string = ((PyModule)this.self).module_toString();
            return string == null ? Py.None : Py.newString(string);
        }
    }

    public class PyModule$__dict___descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyModule$__dict___descriptor() {
            super("__dict__", PyObject.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyModule)pyObject).__dict__;
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public void invokeSet(PyObject pyObject, Object object) {
            ((PyModule)pyObject).setDict((PyObject)object);
        }

        public boolean implementsDescrSet() {
            return true;
        }

        public void invokeDelete(PyObject pyObject) {
            ((PyModule)pyObject).delDict();
        }

        public boolean implementsDescrDelete() {
            return true;
        }
    }

    public class PyModule$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            PyModule pyModule = new PyModule(this.for_type);
            if (bl) {
                pyModule.module___init__(pyObjectArray, stringArray);
            }
            return pyModule;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new PyModuleDerived(pyType);
        }
    }

    public class PyModule$PyExposer
    extends BaseTypeBuilder {
        public PyModule$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyModule$module___init___exposer("__init__"), new PyModule$module___setattr___exposer("__setattr__"), new PyModule$module___delattr___exposer("__delattr__"), new PyModule$module_toString_exposer("__repr__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyModule$__dict___descriptor()};
            super("module", PyModule.class, Object.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new PyModule$exposed___new__());
        }
    }
}

