/****************************************************************************

۰
۰
۰
۰                                                                     
۰                           
۰                                                   
۰                                             
۰                                                  
۰                                                   
۰                                   
۰                                                                     
۰ BOY! 
۰ SOFT!!! 
۰ Copy Right. Mxico 1993.


   ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ
ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͻ
       THIS SOFTWARE IS DISTRIBUTED FREE AND WITH *NO* WARRANTIES.        
    THIS SOFTWARE IS NOT GUARANTEED TO WORK UNDER ALL CIRCUNSTANCES.      
    I SHALL NOT BE RESPONSIBLE FOR ANY HARM OR DAMAGE CAUSED BY THIS      
     PROGRAMS. I APOLOGIZE FOR NOT DISTRIBUTING A BUG FREE SOFTWARE       
                 BUT THIS IS NOT A COMMERCIAL PACKAGE.                    
ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͼ
   ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ

ͻ                                                                 ͻ
                                                                         
ͼ
       WARNING:                                                       
       THERE ARE A LOT OF GRAMMATH AND SPELLING ERRORS BECAUSE MY     
       NATIVE LANGUAJE IS SPANISH NOT ENGLISH. BECAUSE OF THAT IT     
       IS VERY PROBABLY THAT SOME OF THE COMMENTS OR TEXT TALKS       
       ABOUT SOMETHING THAT I DID NOT WANT TO SAY EXACTLY OR ALMOST   
       IN THAT WAY. SO ANY CORRECTIONS ARE WELCOME.                   
       I AM NOT RESPONSIBLE OF HARM ,LOSE OR DAMAGE CAUSED BY THIS    
       ERRORS OR SOFTWARE BUGS (YOU ARE WARNED THAT BOTH MAY EXIST).  
ͻ
                                                                         
ͼ                                                                 ͼ

ͻ
ͻ
͹ W                                                                        
͹ A                          T H I S     S O F T W A R E     I S    N O T  
͹ R               G U A R A N T E E D     T O     W O R K    N O R    I T  
͹ N                             W I L L     W O R K    U N D E R    A L L  
͹ N                                            C I R C U N S T A N C E S.  
͹ ING !!!                                                                  
ͼ
ͼ
****************************************************************************/

/****************************************************************************
*                                                                           *
*                                                                           *
*    Program Name:      FDS_CRT.C                                           *
*    Author:            Federico de la Mora Salazar                         *
*    Date:              June, 1993. (Mxico)                                *
*    Compiler(s):       Turbo C 2.0                                         *
*    Description:       This are some low level functions written to        *
*                       interact with the video system. The can obtain      *
*                       basic information about the video and change some   *
*                       things. There are also rutines that show how to     *
*                       write directly to screen with a simple way to avoid *
*                       snow on cga's.                                      *
*                       This is not a <conio.h> replacement. This functions *
*                       are used by some other of my programs however their *
*                       main task is to provide simple examples to move     *
*                       around without calling a lot of interrupts.         *
*                       This is not an standalone program so may be you'd   *
*                       like to change its extension to .h.                 *
*                                                                           *
*    Special Note:      Define CGA if you want to compile with "snow        *
*                       checking"                                           *
*                                                                           *
*                                                                           *
****************************************************************************/


#if     !defined(__CRT__)
#define          __CRT__
#define VIDEO_INT       0x10

/****************************************************************************
************ HEADER FILES USED BY FDS_CRT.C *********************************
****************************************************************************/

#include <dos.h>
#include <conio.h>
#include <string.h>

/****************************************************************************
************ FUNCTIONS PROTOTYPES *******************************************
****************************************************************************/

void get_video_address (void);
void setcursor_size_bios (int start, int end);
void getcursor_size_bios (int *page,
	 int *row,
	 int *column,
	 int *start,
	 int *end);
int getcursor_size (int *start, int *end);
void setvideo_page_bios (int page);
int getvideo_page_bios (int *vidmode, int *width);
int getvideo_mode (void);
int getvideo_width (void);
int getvideo_screensize (void);
int getvideo_memoffset (void);
int getvideo_pagenum (void);
int getvideo_rows_vga(void);
void draw_box (int left,
	 int top,
	 int right,
	 int bottom,
	 int fg,
	 int bg,
	 char *msg);
void dputch (int x, int y, char attrib, char chr);
void printstr (int x, int y, char attrib, char *str);
void emucga_cursor_vga(int al);
void setvideo_refresh_vga(int al);

/****************************************************************************
************ GLOBAL VARIABLES ***********************************************
****************************************************************************/

/* Before using any function that writes directly to the screen call the
 * function get_video_address(). This function will store the video address
 * in the next variable.*/
char far *vid_address;

/****************************************************************************
************ MACROS *********************************************************
****************************************************************************/

/* This macro avoids snow on a cga card whe writing directly to the screen.  *
 * The main purpose of this macro is wait for the vertical retrace to end,   *
 * after that, the program can write directly to the screen almost 1 Kb      *
 * of video data before the next retrace starts.                             *
 */

#if     defined(CGA)
#define         CHECK_SNOW      while( !(inport(0x3DA) & 0x08)  );
#else
#define         CHECK_SNOW
#endif

/****************************************************************************
************ FUNCTIONS ******************************************************
****************************************************************************/

/****************************************************************************
* Function Name:        get_video_address                                   *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          Stores the video address of the current text mode   *
*                       in the variable vid_address.                        *
****************************************************************************/
void get_video_address(void) {
     int vid_mode;

     vid_mode = *((char far *) 0x449);
     if(vid_mode==0x07)
	vid_address = (char far *) 0xB0000000L;
     else
	vid_address = (char far *) 0xB8000000L;
     return;
}

/****************************************************************************
* Function Name:        setcursor_size_bios                                 *
* Parameters:           New cursor starting and ending scan lines.          *
* Returns:              Nothing                                             *
* Description:          Sets a new size for the text cursor.                *
****************************************************************************/
void setcursor_size_bios(int start, int end) {
    union REGS r_in, r_out;

     r_in.h.ch = start;                     /* Starting scan line          */
     r_in.h.cl = end;                       /* Ending   scan line          */
     r_in.h.ah = 0x01;                      /* Rom BIOS function:
					     *   Set cursor size
					     */
					    /* The cursor will dissapear   */
					    /* if CH=0x20. Bit 5 of CH on. */

     int86(VIDEO_INT,&r_in,&r_out);
     return;
}

/****************************************************************************
* Function Name:        getcursor_size_bios                                 *
* Parameters:           The address of the variables to return the current  *
*                       video page number, the cursor position (column, row)*
*                       an the starting and ending scan lines of the text   *
*                       cursor.                                             *
* Returns:              Nothing                                             *
* Description:          Returns the information reported by the BIOS about  *
*                       the text cursor and current page.                   *
****************************************************************************/
void getcursor_size_bios(int *page, int *row, int *column,
			 int *start, int *end) {
    union REGS r_in, r_out;

     r_in.h.bh = getvideo_pagenum();         /* BH must contain the number of
					      * the page that we want to get
					      * the information of so we past
					      * the current (active) video
					      * page number
					      */
     r_in.h.ah = 0x03;                       /* Rom BIOS function:
					      *   Get cursor size
					      */
     int86(VIDEO_INT,&r_in,&r_out);
     *page   = r_out.h.bh;                   /* Active video page          */
     *row    = r_out.h.dh;                   /* y cursor position          */
     *column = r_out.h.dl;                   /* x cursor position          */
     *start  = r_out.h.ch;                   /* starting scan line of crsor*/
     *end    = r_out.h.cl;                   /* ending scan line of cursor */

     return;
}

/****************************************************************************
* Function Name:        getcursor_size                                      *
* Parameters:           Addresses of the vars to store cursor begin and end.*
* Returns:              The height of a character in scan lines             *
* Description:          Looks at low BIOS addresses for cursor's size.      *
****************************************************************************/
int getcursor_size(int *start, int *end) {

     *start = (int) *((char far*) 0x0461);  /* Adresses where the BIOS     */
     *end   = (int) *((char far*) 0x0460);  /* stores cursor begin and end.*/

     /*  The easiest way to now the number of scan lines that builds the   */
     /*  cursor is looking for the height in scan lines of the current     */
     /*  character type in text mode.                                      */
     /*  The scan lines are numbered from the top of the cursor to the     */
     /*  bottom, in other words, the highest scan line is the number 0.    */

     return ((int) *( (char far*) 0x0485)); /* Adresses where the BIOS     */
					    /* stores character's height.  */
}

/****************************************************************************
* Function Name:        setvideo_page_bios                                  *
* Parameters:           Page number to change to.                           *
* Returns:              Nothing                                             *
* Description:          Sets a new active video page. The max number varies *
*                       depending of the video mode.                        *
****************************************************************************/
void setvideo_page_bios(int page) {
    union REGS r_in, r_out;

     r_in.h.ah = 0x05;                      /* Rom BIOS function:
					     *   Set video page
					     */
     r_in.h.al = page;                      /* New active video page       */
     int86(VIDEO_INT,&r_in,&r_out);

     return;
}

/****************************************************************************
* Function Name:        getvideo_page_bios                                  *
* Parameters:           Addresses of the variables to return the video mode *
*                       the number of text columns.                         *
* Returns:              Nothing                                             *
* Description:          Calls rom bbios video interrupt to get info about   *
*                       video mode.                                         *
****************************************************************************/
int getvideo_page_bios(int *vidmode, int *width) {
    union REGS r_in, r_out;

     r_in.h.ah = 0x0F;                      /* Rom BIOS function:
					     *   Get current video mode
					     */
     int86(VIDEO_INT,&r_in,&r_out);
     *vidmode = r_out.h.al;                 /* Current video mode          */
     *width   = r_out.h.ah;                 /* Number of text columns      */

     return r_out.h.bh;                     /* Active display page number  */
}

/****************************************************************************
* Function Name:        getvideo_mode                                       *
* Parameters:           None                                                *
* Returns:              Current video mode.                                 *
****************************************************************************/
int getvideo_mode(void) {
     /* Video mode currently being used by the BIOS                        */
     return ((int) *( (char far*) 0x0449));
}

/****************************************************************************
* Function Name:        getvideo_width                                      *
* Parameters:           None                                                *
* Returns:              Number of text columns.                             *
****************************************************************************/
int getvideo_width(void) {
     /* Number of text columns on the screen                                                                   */
     return ((int) *( (int far*) 0x044A));
}

/****************************************************************************
* Function Name:        getvideo_screensize                                 *
* Parameters:           None                                                *
* Returns:              Screen size in bytes (for the current video mode.   *
****************************************************************************/
int getvideo_screensize(void) {
     /* Bytes required to represent a screenful of video data. This value is
      * allways evenly divisible by 1024. In most of the video modes this
      * value is a bit bigger than the real screen size
      */
     return ((int) *( (int far*) 0x044C));
}

/****************************************************************************
* Function Name:        getvideo_memoffset                                  *
* Parameters:           None                                                *
* Returns:              Returns the offset address to the active page number*
****************************************************************************/
int getvideo_memoffset(void) {
     /* Offset in the video mem to the active page                         */
     return ((int) *( (int far*) 0x044E));
}

/****************************************************************************
* Function Name:        getvideo_pagenum                                    *
* Parameters:           None                                                *
* Returns:              Current video page number.                          *
****************************************************************************/
int getvideo_pagenum(void) {
     /* Current video page being used by the BIOS                          */
     return ((int) *( (char far*) 0x0462));
}

/****************************************************************************
* Function Name:        getvideo_rows_vga                                   *
* Parameters:           None                                                *
* Returns:              Number of text columns for the current text mode.   *
* Note:                 Requires ega or vga BIOS.                           *
****************************************************************************/
int getvideo_rows_vga(void) {
     /* Return the number of rows that can be displayed on the screen      */
     return ((int) *( (char far*) 0x0484)) + 1;
}

/****************************************************************************
* Function Name:        draw_box                                            *
* Parameters:           left:   starting column.                            *
*                       top:    starting row.                               *
*                       right:  ending column.                              *
*                       bottom: ending row.                                 *
*                       fg:     foregorund color.                           *
*                       bg:     background color.                           *
*                       msg:    String containing the title (It's printed   *
*                               centered).                                  *
* Returns:              Nothing                                             *
* Description:          This function draws a box writing directly to the   *
*                       screen, using the color specified (this function    *
*                       uses the same color numbers defined in conio.h).    *
*                       The function window defined in conio.h is called to *
*                       let the conio.h functions work with the box as a    *
*                       window.                                             *
****************************************************************************/
void draw_box(int left, int top, int right, int bottom,
              int fg, int bg, char *msg) {
     int cont, max_X, max_Y, attrib;

     max_X  = (right-left) + 1;
     max_Y  = (bottom-top);
     attrib = (bg<<4) | fg;

     textcolor(fg);
     textbackground(bg);
     window(left, top, right, bottom);
     clrscr();

     dputch(left, top, attrib, '');
     for(cont=2; cont<max_X; cont++)
	 dputch(left+cont-1, top, attrib, '');
     dputch(right, top, attrib, '');
     for(cont=1; cont<max_Y; cont++)
	 dputch(left, top+cont, attrib, '');
     for(cont=1; cont<max_Y; cont++)
	 dputch(right, top+cont, attrib, '');

     dputch(left, bottom, attrib, '');
     for(cont=2; cont<max_X; cont++)
	 dputch(left+cont-1, bottom, attrib, '');
     dputch(right, bottom, attrib, '');
     dputch(left-1+(max_X-strlen(msg))/2, top, attrib, '[');
     printstr(left+(max_X-strlen(msg))/2,   top, attrib, msg);
     dputch(left+(max_X-strlen(msg))/2+strlen(msg), top, attrib, ']');
     window(left+1, top+1, right-1, bottom-1);

     return;
}

/****************************************************************************
* Function Name:        dputch                                              *
* Parameters:           x:      column.                                     *
*                       y:      row.                                        *
*                       attrib: Character attribute.                        *
*                       chr:    character to be written.                    *
* Returns:              Nothing                                             *
* Description:          Call this function to write a chracter and a its    *
*                       color attribute directly to the screen. To avoid    *
*                       snow define CGA (look) the the definition of        *
*                       CHECK_SNOW at the beginning of this file.           *
****************************************************************************/
void dputch(int x, int y, char attrib, char chr) {
  char far *vid;

  x--; y--;
  vid = vid_address;
  vid += (x*2) + (y*getvideo_width()*2);
  CHECK_SNOW
  *vid++ = chr;
  *vid   = attrib;
  return;
}

/****************************************************************************
* Function Name:        printstr                                            *
* Parameters:           x:      column.                                     *
*                       y:      row.                                        *
*                       attrib: Character attribute.                        *
*                       chr:    string to be written.                       *
* Returns:              Nothing                                             *
* Description:          It works the same as dputch() but instead of witing *
*                       a char it writes a string of characters.            *
****************************************************************************/
void printstr(int x, int y, char attrib, char *str) {
     int cont;

     for (cont=0; str[cont]; cont++)
	  dputch(x+cont,y, attrib, str[cont]);
     return;
}

/****************************************************************************
* Function Name:        emucga_cursor_vga                                   *
* Parameters:           al: (This parameter accepts one of two possible     *
*                            values)                                        *
*                          enable  = 0                                      *
*                          disable = 1                                      *
* Returns:              Nothing                                             *
* Description:          Enables or disables the emulation of the CGA cursor *
*                       emulation on vga's.                                 *
*                       When the emulation is ON the cursor will simulated  *
*                       that it's eight scan lines in height. When disable  *
*                       it will be sixteen scan lines in height.            *
****************************************************************************/
void emucga_cursor_vga(int al) {
    union REGS r_in, r_out;


     r_in.h.al = al;                       /* Emulate cga cursor on vga   */
					   /* al: Enable   0
					    *     Disable  1
					    */
     r_in.h.bl = 0x34;
     r_in.h.ah = 0x12;                     /* Rom BIOS function 0x12,
					    * subfunction 0x34:
					    *   Enable/Disable BIOS cursor
					    *   emulation.
					    */
     int86(VIDEO_INT,&r_in,&r_out);
     return;
}

/****************************************************************************
* Function Name:        setvideo_refresh_vga                                *
* Parameters:           al: (This parameter accepts one of two possible     *
*                            values)                                        *
*                          enable  = 0                                      *
*                          disable = 1                                      *
* Returns:              Nothing                                             *
* Description:          Enables or disables the screen refresh. The screen  *
*                       is constantly being updated by the BIOS. It reads   *
*                       from the video buffer the data that builds the      *
*                       display. If the refresh is turned off, the screen   *
*                       will be blank until you turn the refresh on, but the*
*                       writes to the video beffer will be faster.          *
****************************************************************************/
void setvideo_refresh_vga(int al) {
    union REGS r_in, r_out;


     r_in.h.al = al;                       /* Turn on or off video refresh
					    * on vga's. If off the screen
					    * will become blank until you
					    * turn in on. However writiting
					    * directly to the video buffer
					    * will be faster.
					    */
					   /* al: Enable   0
					    *     Disable  1
					    */
     r_in.h.bl = 0x36;
     r_in.h.ah = 0x12;                     /* Rom BIOS function 0x12,
					    * subfunction 0x36:
					    *   Enable/Disable video refresh.
					    */
     int86(VIDEO_INT,&r_in,&r_out);
     return;
}

#endif


