/****************************************************************************

۰
۰
۰
۰                                                                     
۰                           
۰                                                   
۰                                             
۰                                                  
۰                                                   
۰                                   
۰                                                                     
۰ BOY! 
۰ SOFT!!! 
۰ Copy Right. Mxico 1993.


   ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ
ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͻ
       THIS SOFTWARE IS DISTRIBUTED FREE AND WITH *NO* WARRANTIES.        
    THIS SOFTWARE IS NOT GUARANTEED TO WORK UNDER ALL CIRCUNSTANCES.      
    I SHALL NOT BE RESPONSIBLE FOR ANY HARM OR DAMAGE CAUSED BY THIS      
     PROGRAMS. I APOLOGIZE FOR NOT DISTRIBUTING A BUG FREE SOFTWARE       
                 BUT THIS IS NOT A COMMERCIAL PACKAGE.                    
ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͻ  ͼ
   ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ  ͼ

ͻ                                                                 ͻ
                                                                         
ͼ
       WARNING:                                                       
       THERE ARE A LOT OF GRAMMATH AND SPELLING ERRORS BECAUSE MY     
       NATIVE LANGUAJE IS SPANISH NOT ENGLISH. BECAUSE OF THAT IT     
       IS VERY PROBABLY THAT SOME OF THE COMMENTS OR TEXT TALKS       
       ABOUT SOMETHING THAT I DID NOT WANT TO SAY EXACTLY OR ALMOST   
       IN THAT WAY. SO ANY CORRECTIONS ARE WELCOME.                   
       I AM NOT RESPONSIBLE OF HARM ,LOSE OR DAMAGE CAUSED BY THIS    
       ERRORS OR SOFTWARE BUGS (YOU ARE WARNED THAT BOTH MAY EXIST).  
ͻ
                                                                         
ͼ                                                                 ͼ

ͻ
ͻ
͹ W                                                                        
͹ A                          T H I S     S O F T W A R E     I S    N O T  
͹ R               G U A R A N T E E D     T O     W O R K    N O R    I T  
͹ N                             W I L L     W O R K    U N D E R    A L L  
͹ N                                            C I R C U N S T A N C E S.  
͹ ING !!!                                                                  
ͼ
ͼ
****************************************************************************/

/****************************************************************************
*                                                                           *
*                                                                           *
*    Program Name:      FDS_LIST.C                                          *
*    Author:            Federico de la Mora Salazar                         *
*    Date:              June, 1993. (Mxico)                                *
*    Compiler(s):       Turbo C 2.0                                         *
*    Description:       This is program lister with messages in Spanish.    *
*                       It emulates a little the external DOS command xcopy.*
*                       The program will read firts all the files before    *
*                       sending it to a destination file or printer.        *
*                       It can expand tabs, create margins and build        *
*                       a header with the file name, size, date and time of *
*                       creation and page. The header is fully configurable.*
*                       Be sure to compile this program with the compact    *
*                       model or most of its abilities will be under used.  *
*                                                                           *
*    How to compile:                                                        *
*            tcc -1 -G -O -Z -N- -f -a- -k -w -v- -r -mc fds_list.c         *
*            make -ffds_list         (Edit this file for your own needs)    *
*                                                                           *
****************************************************************************/


#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <conio.h>
#include <dir.h>
#include <alloc.h>
#include <errno.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

/****************************************************************************
*                                                                           *
*                               CONSTANTS.                                  *
*                               CONSTANTES.                                 *
*                                                                           *
****************************************************************************/

#define F_EOF      '\x1B'
#define CR_LF        "\n"
#define FF           "\f"
#define MAX_LINEA     512
#define BUFSIZE      8192

#if     !defined(TRUE)
#define TRUE         1
#define FALSE        0
#endif

#if     !defined(ON) || !defined(OFF)
#define ON           1
#define OFF          0
#endif


/****************************************************************************
*                                                                           *
*           ESTRUCTURA Y VARIABLES PARA EL MANEJO DE LA LISTA LINEAL.       *
*           STRUCTURE AND VARIABLES TO BE USED BY THE LINEAR LIST.          *
*                                                                           *
****************************************************************************/

struct struct_lista {
	char     *cadena;
	struct struct_lista *next;
};

struct struct_lista *lista;


/****************************************************************************
*                                                                           *
*           VARIABLES GLOBALES UTILIZADAS PARA EL FORMATO DE PAGINA.        *
*           GLOBAL VARIABLES USED FOR PAGE FORMAT.                          *
*                                                                           *
****************************************************************************/

int       lines_page  = 61;
int       chars_line  = 80;
int       left_margin = 0;
int       top_margin  = 0;

int       num_page     = OFF;
int       archivo_time = OFF;
int       archivo_date = OFF;
int       size         = OFF;
int       name         = OFF;
int       tab_size     = (-1);  /* Not tab expansion */
int       borrar_FF    = OFF;
int       page;
int       Header_flag;

char     *Header;
FILE     *file_in, *file_out;
char      linea_file[MAX_LINEA];
char      linea_lista[MAX_LINEA];
char      str_chars[64];
int       last_isFF, x, len;

int       last_is_CHAR = 0;
int       line_num = 0;

/****************************************************************************
*                                                                           *
*                           VARIABLES GLOBALES.                             *
*                           GLOBAL VARIABLES.                               *
*                                                                           *
****************************************************************************/

char      switchar;
int       interactivo = 1;
int       original_brk;
int       done;
int       curx, cury;

/****************************************************************************
*                                                                           *
*                       CADENAS PREINICIALIZADAS.                           *
*                       PREINITIALIZED STRINGS.                             *
*                                                                           *
****************************************************************************/

char      destino[127] = "LPT1";
char      msg_error[80] = "Parametro Erroneo: ";
char      str_space[] = " ";

/****************************************************************************
*                                                                           *
*                              CODIGOS DE SALIDA.                           *
*                              EXIT CODES.                                  *
*                                                                           *
****************************************************************************/

#define NORMAL                  0
#define HELP                    1
#define BREAK                 252
#define BAD_PARAMETER         253
#define CHARS_LINE_TOO_BIG    254
#define HEADER_TOO_BIG        255
#define ERRNO                 errno

/****************************************************************************
*                                                                           *
*                        PROTOTIPOS DE FUNCIONES.                           *
*                        FUNCTION PROTOTYPES.                               *
*                                                                           *
****************************************************************************/

void      entrada(char *prog_name);
void      salida(void);
void      Print_Help(void);
void      Print_Error(const char *Err_Source);
char      Ask(const char *mensage, const char *param);
char     *Build_Header(struct ffblk * ffblk);
void      Procesar_argv(int argc, char *argv[]);
int       Maneja_Brk(void);
int       insert_lista(char *valor);
int       leer_lista(char *valor);
void      vacia_lista(void);
void      prepara_linea(char *linea);
void      Print_File(const char *File_Name);

/****************************************************************************
*                                                                           *
*                           FUNCIONES.                                      *
*                           FUNCTIONS.                                      *
*                                                                           *
****************************************************************************/

/****************************************************************************
* Function Name:        entrada                                             *
* Parameters:           This program's name.                                *
* Returns:              Nothing                                             *
* Description:          Prints welcome mesage and avalaible memory.         *
****************************************************************************/
void      entrada(char *prog_name)
{
	float     mem_libre;

#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
	mem_libre = (float) coreleft() + farcoreleft();
	mem_libre /= 1024;
#else
	mem_libre = (float) coreleft() / 1024;
#endif

	cprintf("IMPRESOR DE CODIGO FUENTE. %s\n\r", prog_name);
	cprintf("Autor: FEDERICO DE LA MORA. Todos los derechos reservados\n\r");
	cprintf("Memoria disponible: %3.2f Kb\n\r", mem_libre);
}

/****************************************************************************
* Function Name:        salida                                              *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          Restores ^C state.                                  *
****************************************************************************/
void      salida(void)
{
	setcbrk(original_brk);
	cprintf("\n\rTHAT'S ALL FOLKS!!!\n\r");
}

/****************************************************************************
* Function Name:        Print_Help                                          *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          Print help about parameters.                        *
****************************************************************************/
void      Print_Help(void)
{
	cprintf("\n\r");
	cprintf("Sintaxis:  ORIGEN [DESTINO] [Parametros]\n\r");
	cprintf("\n\r");
	cprintf("Origen:    Archivo(s) a imprimir. (Se permiten ? y *)\n\r");
	cprintf("Destino:   Destino de la impresin (Default Destino=%s), es opcional.\n\r", destino);
	cprintf("Parametros:\n\r");
	cprintf("%cHn:       Contenido del Header en cada pgina. (Default=No se crea Header)\n\r", switchar);
	cprintf("             puede ser: [d] dia  [t] hora  [s] tamao  [n] nombre del archivo\n\r");
	cprintf("                        [p] numerar pginas            [l] todos los ant.\n\r");
	cprintf("%cC#        Caracteres por Linea.             (Default #=%d)\n\r", switchar, chars_line);
	cprintf("%cP#        Lineas por Pgina.                (Default #=%d)\n\r", switchar, lines_page);
	cprintf("%cT#        Margen Superior.                  (Default #=%d)\n\r", switchar, top_margin);
	cprintf("%cL#        Margen Izquierdo.                 (Default #=%d)\n\r", switchar, left_margin);
	cprintf("%cS#        tamao del tabulador.             (Default #=Se envia tab a destino)\n\r", switchar);
	cprintf("%cQ         Imprime sin confirmacion.         (Default=Pide Confirmacion)\n\r", switchar);
	cprintf("%cF         Ignorar form feed de origen.      (Default=Se envia a destino)\n\r", switchar);
	cprintf("\n\r");
	cprintf("Todos los parametros pueden ser escritos en maysculas y/o minsculas,\n\r");
	cprintf("adems debe haber un espacio de separacion entre cada uno.\n\r");

	exit(HELP);
}

/****************************************************************************
* Function Name:        Print_Error                                         *
* Parameters:           The file that caused the error.                     *
* Returns:              Nothing                                             *
* Description:          Print error description and then quits.             *
****************************************************************************/
void      Print_Error(const char *Err_Source)
{
	sound(65);
	delay(750);
	nosound();
	printf("\n\rError: ");
	switch (errno) {
	case ENOFILE:
		printf("Archivo y/o Directorio NO Encontrado");
		break;
	case ENOPATH:
		printf("Camino(Path) no encontrado");
		break;
	case EACCES:
		printf("Acceso NO Permitido");
		break;
	case EINVENV:
		printf("Ambiente NO Valido");
		break;
	case EINVFMT:
		printf("Formato NO Valido");
		break;
	case EINVACC:
		printf("Codigo de Acceso NO Valido");
		break;
	case EINVDAT:
		printf("Datos NO Validos");
		break;
	case EINVDRV:
		printf("El Drive especificado NO es Valido");
		break;
	case ENOTSAM:
		printf("No es el mismo dispositivo");
		break;
	case ENMFILE:
		printf("No hay ms archivos");
		break;
	default:
		printf("Desconocido. Numero %d", errno);
	}                       /* switch */
	printf("!!!\n\r");
	if (Err_Source != NULL)
		printf("Causado por: %s\n\r", Err_Source);

	/*
	 * Using perror will ensure that the error messages will be displayed
	 * in English and Spanish
	 */

	perror("Compiler routines report");
	exit(errno);
}

/****************************************************************************
* Function Name:        Ask                                                 *
* Parameters:           mensage:        Prompt message.                     *
*                       param:          Valid answers.                      *
* Returns:              A valid user response.                              *
* Description:          Prints a rpomt and the waits until a key contained  *
*                       in param is pressed, that key is returned.          *
****************************************************************************/
char      Ask(const char *mensage, const char *param)
{
	char      answer;
	register int cont;

	if (interactivo) {
		cputs(mensage);
		for (;;) {
			cont = 0;
			answer = toupper(getche());
			if (answer == '\x3') {
				cputs("\b   ^C");
				Maneja_Brk();
			}
			while (param[cont])
				if (answer == param[cont])
					return answer;
				else
					cont++;
			putchar('\b');
		}               /* for */
	} else
		return (param[0]);
}

/****************************************************************************
* Function Name:        Build_Header                                        *
* Parameters:           A struct previously filled by findfirst or findnext.*
* Returns:              The header for the current page.                    *
* Description:          Builds a header based on the information reported   *
*                       by the struct.                                      *
****************************************************************************/
char     *Build_Header(struct ffblk * ffblk)
{
	/*
	 * Devuelve un puntero a la cadena Header que ha sido declarada
	 * static
	 */
	static char Header[MAX_LINEA];
	static char Temporal_Header[MAX_LINEA];
	register int cont;
	Temporal_Header[0] = NULL;
	Header[0] = NULL;

	if (name) {
		strcpy(Temporal_Header, ffblk->ff_name);
		for (cont = strlen(Temporal_Header); cont <= 14; cont++)
			strcat(Temporal_Header, str_space);
	}
	if (size) {
		char      tamanno[11];
		ltoa(ffblk->ff_fsize / 1024L, tamanno, 10);
		strcat(Temporal_Header, tamanno);
		strcat(Temporal_Header, " Kb");
		for (cont = strlen(tamanno); cont <= 13; cont++)
			strcat(Temporal_Header, str_space);
	}
	if (archivo_date) {
		unsigned  anno, mes, dia, fecha;
		char      str_mes[11], str_dia[3], str_anno[5];
		fecha = ffblk->ff_fdate;
		anno = (fecha / 512) + 1980;
		fecha %= 512;
		mes = fecha / 32;
		dia = fecha % 32;
		ltoa(dia, str_dia, 10);
		if (strlen(str_dia) < 2)
			strcat(Temporal_Header, str_space);
		strcat(Temporal_Header, str_dia);
		strcat(Temporal_Header, " de ");
		switch (mes) {
		case 1:
			strcpy(str_mes, "Enero");
			break;
		case 2:
			strcpy(str_mes, "Febrero");
			break;
		case 3:
			strcpy(str_mes, "Marzo");
			break;
		case 4:
			strcpy(str_mes, "Abril");
			break;
		case 5:
			strcpy(str_mes, "Mayo");
			break;
		case 6:
			strcpy(str_mes, "Junio");
			break;
		case 7:
			strcpy(str_mes, "Julio");
			break;
		case 8:
			strcpy(str_mes, "Agosto");
			break;
		case 9:
			strcpy(str_mes, "Septiembre");
			break;
		case 10:
			strcpy(str_mes, "Octubre");
			break;
		case 11:
			strcpy(str_mes, "Noviembre");
			break;
		case 12:
			strcpy(str_mes, "Diciembre");
			break;
		}
		strcat(Temporal_Header, str_mes);
		strcat(Temporal_Header, " de ");
		ltoa(anno, str_anno, 10);
		strcat(Temporal_Header, str_anno);
		for (cont = strlen(str_mes); cont <= 12; cont++)
			strcat(Temporal_Header, str_space);
	}
	if (archivo_time) {
		unsigned  hora, minutos, tiempo;
		int       mas12;
		char      str_hora[3], str_minutos[3];
		tiempo = ffblk->ff_ftime;
		hora = tiempo / 2048;
		tiempo %= 2048;
		minutos = tiempo / 32;
		if (hora > 12) {
			mas12 = 1;
			hora -= 12;
		} else
			mas12 = 0;
		ultoa(hora, str_hora, 10);
		ultoa(minutos, str_minutos, 10);
		strcat(Temporal_Header, str_hora);
		strcat(Temporal_Header, ":");
		if (minutos < 10)
			strcat(Temporal_Header, "0");
		strcat(Temporal_Header, str_minutos);
		if (mas12)
			strcat(Temporal_Header, "pm");
		else
			strcat(Temporal_Header, "am");
		for (cont = strlen(str_hora) + strlen(str_minutos) + 1; cont <= 6; cont++)
			strcat(Temporal_Header, str_space);
	}
	if (num_page) {
		char      str_page[11];
		int       length;
		itoa(page, str_page, 10);       /* Se utiliza la varible
						 * *GLOBAL* page */
		length = strlen(str_page);
		length += 7;
		for (cont = strlen(Temporal_Header); cont < (chars_line - left_margin - length); cont++)
			strcat(Temporal_Header, str_space);
		strcat(Temporal_Header, "Pgina ");
		strcat(Temporal_Header, str_page);
	}
	if (Temporal_Header)
		for (cont = 1; cont <= left_margin; cont++)
			strcat(Header, str_space);

	strcat(Header, Temporal_Header);
	strcat(Header, CR_LF);
	strcat(Header, CR_LF);
	strcat(Header, CR_LF);
	return Header;
}

/****************************************************************************
* Function Name:        Procesar_argv                                       *
* Parameters:           The same received by main().                        *
* Returns:              Nothing                                             *
* Description:          Parses the information passed to the program in the *
*                       command line.                                       *
****************************************************************************/
void      Procesar_argv(int argc, char *argv[])
{
	register int arg = 0;
	register int I;
	char      c;

	strupr(argv[1]);
	if (argc == 1 || !strcmp(argv[1] + 1, "?")
	    || !strcmp(argv[1] + 1, "HELP")
	    || !strcmp(argv[1] + 1, "AYUDA")
	    || !strcmp(argv[1] + 1, "H"))
		Print_Help();
	if ((argv[2][0] != switchar) && (argv[2] != NULL)) {
		strcpy(destino, strupr(argv[2]));
		arg = 1;
	}
	arg += 2;
	while (argv[arg]) {
		if ((argv[arg][0] == switchar) && (toupper(argv[arg][1]) == 'H')) {
			I = 2;
			while (toupper(argv[arg][I])) {
				c = toupper(argv[arg][I++]);
				if (c == 'L') {
					archivo_date = 1;
					archivo_time = 1;
					size = 1;
					name = 1;
					num_page = 1;
				} else if (c == 'D')
					archivo_date = 1;
				else if (c == 'T')
					archivo_time = 1;
				else if (c == 'S')
					size = 1;
				else if (c == 'N')
					name = 1;
				else if (c == 'P')
					num_page = 1;
				else {
					cputs("\n\rEl parametro /H solo permite las opciones: d,t,s,n,p,l\n\r");
					sound(65);
					delay(750);
					nosound();
					exit(BAD_PARAMETER);
				}
			}       /* while */
		} else if ((argv[arg][0] == switchar) && (toupper(argv[arg][1]) == 'T')) {
			I = 2;
			while (isdigit(argv[arg][I]))
				top_margin = (top_margin * 10) + (argv[arg][I++] - '0');
		} else if ((argv[arg][0] == switchar) && (toupper(argv[arg][1]) == 'L')) {
			I = 2;
			while (isdigit(argv[arg][I]))
				left_margin = (left_margin * 10) + (argv[arg][I++] - '0');
		} else if ((argv[arg][0] == switchar) && (toupper(argv[arg][1]) == 'P')) {
			I = 2;
			lines_page = 0;
			while (isdigit(argv[arg][I]))
				lines_page = (lines_page * 10) + (argv[arg][I++] - '0');
		} else if ((argv[arg][0] == switchar) && (toupper(argv[arg][1]) == 'C')) {
			I = 2;
			chars_line = 0;
			while (isdigit(argv[arg][I]))
				chars_line = (chars_line * 10) + (argv[arg][I++] - '0');
			if (chars_line < 1 || chars_line > 256) {
				cputs("\n\rTamao de linea NO VALIDO (Debe ser: 1tamao256\n\r");
				exit(CHARS_LINE_TOO_BIG);
			}
		} else if ((argv[arg][0] == switchar) && (toupper(argv[arg][1]) == 'S')) {
			I = 2;
			tab_size = 0;
			while (isdigit(argv[arg][I]))
				tab_size = (tab_size * 10) + (argv[arg][I++] - '0');
		} else if ((argv[arg][0] == switchar) && (toupper(argv[arg][1]) == 'Q')) {
			interactivo = 0;
		} else if ((argv[arg][0] == switchar) && (toupper(argv[arg][1]) == 'F')) {
			borrar_FF = 1;
		} else if (argv[arg] != NULL) {
			strcat(msg_error, argv[arg]);
			cprintf("%s\n\r", msg_error);
			sound(65);
			delay(750);
			nosound();
			exit(BAD_PARAMETER);
		}
		arg++;
	}                       /* while */
	Header_flag = archivo_date || archivo_time || size || name || num_page;
	return;
}

/****************************************************************************
* Function Name:        Maneja_Brk                                          *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          Restores ^C state.                                  *
*                       produce a beep with every key pressed.              *
****************************************************************************/
int       Maneja_Brk(void)
{
	static char linea_temp[MAX_LINEA];

	setcbrk(0);
	cputs("\n\rCancelado con <Crtl C>\n\r");
	cputs("Liberando Memoria...\n\r");
	while (lista)
		leer_lista(linea_temp);
	cputs("Cerrando Archivos...\n\r");
	fcloseall();
	exit(BREAK);
	return (0);
}

/****************************************************************************
* Function Name:        insert_lista                                        *
* Parameters:           String to insert in the list.                       *
* Returns:              0 to indicate success. 1 if list is full.           *
* Description:          Inserts a string in the linear list.                *
****************************************************************************/
int       insert_lista(char *valor)
{
	struct struct_lista *New;
	struct struct_lista *Aux;
	int       pstruct = 0;
	int       pcadena = 0;

	if (!valor[0])
		return 1;       /* Ignore empty strings */

	if (coreleft() < 2048L)
		return 0;

	New = (struct struct_lista *) malloc(sizeof(struct struct_lista));
	if (New)
		pstruct = 1;

	New->cadena = strdup(valor);
	if (New->cadena)
		pcadena = 1;

	if (pstruct && pcadena) {
		New->next = NULL;
		strcpy(New->cadena, valor);
		if (lista == NULL)
			lista = New;
		else {
			Aux = lista;
			while (Aux->next)
				Aux = Aux->next;
			Aux->next = New;
		}
		return 1;
	} else {
		if (pstruct)
			free(New);
		if (pcadena)
			free(New->cadena);
		return 0;       /* Lista Llena */
	}
}

/****************************************************************************
* Function Name:        leer_lista                                          *
* Parameters:           None                                                *
* Returns:              0 to indicate success. 1 if list is empty.          *
* Description:          Restrieves an element from the list.                *
****************************************************************************/
int       leer_lista(char *valor)
{
	struct struct_lista *Aux;

	if (lista) {
		Aux = lista;
		lista = lista->next;
		strcpy(valor, Aux->cadena);
		free(Aux->cadena);
		free(Aux);
		return 1;
	} else
		return 0;
}

/****************************************************************************
* Function Name:        vacia_lista                                         *
* Parameters:           None                                                *
* Returns:              Nothing                                             *
* Description:          Reads an eleemnt from the list and sends it to      *
*                       the destination file until the list is empty.       *
****************************************************************************/
void      vacia_lista(void)
{
	gotoxy(curx + 4, cury);
	if (interactivo) {
		cprintf("Writing. Press a key.");
		bioskey(0);
	} else
		cprintf("Writing.");
	while (leer_lista(linea_lista))
		fputs(linea_lista, file_out);
	gotoxy(curx + 4, cury);
	clreol();
	gotoxy(curx, cury);

	return;
}

/****************************************************************************
* Function Name:        prepara_linea                                       *
* Parameters:           A string to be prepare for printing.                *
* Returns:              Nothing                                             *
* Description:          Prepares a string to be send to the output file.    *
****************************************************************************/
void      prepara_linea(char *linea)
{
	char      temp[MAX_LINEA];
	int       x, length, size,
		  cont, posicion;

	length   = strlen(linea);
	cont     = 0;
	size     = 0;
	posicion = 0;
	temp[0]  = NULL;

	if (last_is_CHAR && !strcmp(linea_file, CR_LF)) {
		last_is_CHAR = FALSE;
		linea[0] = NULL;
		return;
	}
	if (linea_file[strlen(linea_file) - 1] != '\n')
		last_is_CHAR = TRUE;

	/* Wipe spaces at the end of the line */
	while (isspace(linea[length - 1]))
		length--;
	linea[length] = NULL;
	/* Insert left margin at the beginning of the line. */
	for (x = 1; x <= left_margin; x++) {
		temp[cont++] = ' ';
		size++;
	}

	/* Edit line, specifically tabs and form feeds. */
	while (linea[posicion]) {
		if (linea[posicion] == '\f' && borrar_FF)
			posicion++;
		else if (linea[posicion] == '\t') {
			if (tab_size < 0) {     /* Left tab unchanged      */
				temp[cont++] = linea[posicion++];
				size++;
			}
			else {                  /* Expand TAB.             */
				posicion++;
				for (x = 1; x <= tab_size; x++) {
					temp[cont++] = ' ';
					size++;
				}
			}
		} else {
			if(size >= (chars_line - left_margin) ) {
				size = 0;
				temp[cont++] = '\n';
			}
			temp[cont++] = linea[posicion++];
			size++;
		}
	}
	temp[cont] = NULL;
	strcat(temp, CR_LF);
	strcpy(linea, temp);
}

/****************************************************************************
* Function Name:        Print_File                                          *
* Parameters:           File(s) to print (wilcards permited).               *
* Returns:              Nothing                                             *
* Description:          Sends the specified files to output emulating xcopy.*
****************************************************************************/
void      Print_File(const char *File_Name)
{

	struct ffblk ffblk;
	char      temp[128];
	char      drive[MAXDRIVE];
	char      dir[MAXDIR];
	char      name[MAXFILE];
	char      ext[MAXEXT];
	int       begin_flag = FALSE;

	if ((file_out = fopen(destino, "wt")) == NULL)
		Print_Error(destino);

	last_is_CHAR = 0;
	line_num = 0;
	page = 0;
	done = FALSE;
	str_chars[0] = NULL;
	lista = NULL;           /* Inicializar lista */


	if (findfirst(File_Name, &ffblk, FA_RDONLY | FA_ARCH))
		Print_Error(File_Name);

	fnsplit(File_Name, drive, dir, name, ext);
	strcpy(temp, drive);
	strcat(temp, dir);
	strcat(temp, ffblk.ff_name);

	if (strcmp(temp, destino)) {    /* Check if we are triying to open
					 * destino again */
		cprintf("\n\r%-12s %7.2f Kb  ", ffblk.ff_name, (float) ffblk.ff_fsize / 1024);
		if (Ask("Imprimir(Y/N)?: ", "YN") == 'Y') {
			if ((file_in = fopen(temp, "rt")) == NULL)
				Print_Error(temp);
			done = FALSE;
			cputs("   Pgina ");
			curx = wherex();
			cury = wherey();

			do {
					if (!line_num && !begin_flag) {
						begin_flag = TRUE;
						page++;
						gotoxy(curx, cury);
						cprintf("%d", page);
						for (x = 1; x <= top_margin; x++) {
							if (!insert_lista(CR_LF)) {
								vacia_lista();
								insert_lista(CR_LF);
							}
							line_num++;
						}
						if (Header_flag) {
							Header = Build_Header(&ffblk);
							if (!insert_lista(Header)) {
								vacia_lista();
								insert_lista(Header);
							}
							line_num += 3;
						}
						if(top_margin || Header_flag)
							last_isFF = FALSE;
					}
					else if (line_num == lines_page) {
						if (!insert_lista(FF)) {
							vacia_lista();
							insert_lista(FF);
						}
						line_num   = 0;
						begin_flag = FALSE;
						last_isFF = TRUE;
					}
					else if (!fgets(linea_file, chars_line - left_margin + 1, file_in)) {
						done = TRUE;
						break;
					} else {
						line_num++;
						last_isFF = FALSE;
						prepara_linea(linea_file);
						if (!insert_lista(linea_file)) {
							vacia_lista();
							insert_lista(linea_file);
						}
					}
			} while (!done);
			if (!last_isFF)
				if (!insert_lista(FF)) {
					vacia_lista();
					insert_lista(FF);
				}
		}
		fclose(file_in);
	}
	while (!findnext(&ffblk)) {
		done       = FALSE;
		begin_flag = FALSE;
		strcpy(temp, drive);
		strcat(temp, dir);
		strcat(temp, ffblk.ff_name);
		if (!strcmp(temp, destino))     /* Check if we are triying */
			continue;               /* to open destino again   */
		cprintf("\n\r%-12s %7.2f Kb  ", ffblk.ff_name, (float) ffblk.ff_fsize / 1024);
		if (Ask("Imprimir(Y/N)?: ", "YN") == 'Y') {
			if ((file_in = fopen(temp, "rt")) == NULL)
				Print_Error(temp);
			cputs("   Pgina ");
			curx = wherex();
			cury = wherey();
			last_is_CHAR = 0;
			line_num = 0;
			page = 0;
			done = FALSE;
			str_chars[0] = NULL;

			do {
					if (!line_num && !begin_flag) {
						begin_flag = TRUE;
						page++;
						gotoxy(curx, cury);
						cprintf("%d", page);
						for (x = 1; x <= top_margin; x++) {
							if (!insert_lista(CR_LF)) {
								vacia_lista();
								insert_lista(CR_LF);
							}
							line_num++;
						}
						if (Header_flag) {
							Header = Build_Header(&ffblk);
							if (!insert_lista(Header)) {
								vacia_lista();
								insert_lista(Header);
							}
							line_num += 3;
						}
						if(top_margin || Header_flag)
							last_isFF = FALSE;
					}
					else if (line_num == lines_page) {
						if (!insert_lista(FF)) {
							vacia_lista();
							insert_lista(FF);
						}
						line_num   = 0;
						begin_flag = FALSE;
						last_isFF = TRUE;
					}
					else if (!fgets(linea_file, chars_line - left_margin + 1, file_in)) {
						done = TRUE;
						break;
					} else {
						line_num++;
						last_isFF = FALSE;
						prepara_linea(linea_file);
						if (!insert_lista(linea_file)) {
							vacia_lista();
							insert_lista(linea_file);
						}
					}
			} while (!done);

			if (!last_isFF)
				if (!insert_lista(FF)) {
					vacia_lista();
					insert_lista(FF);
				}
			fclose(file_in);
		}
	}
	if (lista)
		vacia_lista();
	fclose(file_out);
}

/****************************************************************************
*                                                                           *
*                                  MAIN                                     *
*                                                                           *
****************************************************************************/

void      main(int argc, char *argv[])
{

	switchar = getswitchar();
	original_brk = getcbrk();
	setcbrk(1);
	ctrlbrk(Maneja_Brk);
	atexit(salida);
	entrada(argv[0]);
	Procesar_argv(argc, argv);
	Print_File(argv[1]);
	exit(NORMAL);           /* Terminacion NORMAL */
}
