{ **********************************************************************
  *                          File REG_IN.INC                           *
  *                            Version 1.1                             *
  *                     (c) J. Debord, July 1997                       *
  **********************************************************************
   Include file used by several linear or nonlinear regression programs
  ********************************************************************** }

{ ----------------------------------------------------------------------
  The following routine reads an input file for linear or nonlinear
  regression. Input files are ASCII files with the following structure :

    Line 1 : Title of study
    Line 2 : Number of variables (must be 2 here !)
    Line 3 : Name of variable x
    Line 4 : Name of variable y
    Line 5 : Number of points (must be > number of fitted parameters !)

    The next lines contain the coordinates (x, y) of the points (1 point
    by line). The values of x and y must be separated by spaces or tabs.
  ---------------------------------------------------------------------- }

  procedure ReadInputFile;
  var
    InF  : Text;     { Input file }
    Nvar : Integer;  { Number of variables }
    K    : Integer;  { Loop variable }
  begin
    ErrCode := 0;
    Assign(InF, InFName);
    Reset(InF);

    ReadLn(InF, Title);
    ReadLn(InF, Nvar);

    if Nvar <> 2 then
      begin
        WriteLn('Data file must contain 2 variables !');
        ErrCode := - 1;
        Exit;
      end;

    ReadLn(InF, XName);
    ReadLn(InF, YName);
    ReadLn(InF, N);

    DimVector(X, N);
    DimVector(Y, N);
    DimVector(Ycalc, N);
    DimVector(W, N);

    for K := 1 to N do
      Read(InF, X^[K], Y^[K]);

    Close(InF);
  end;
