{ **********************************************************************
  *                         File REG_OUT.INC                           *
  *                           Version 1.1                              *
  *                     (c) J. Debord, July 1997                       *
  **********************************************************************
   Include file used by several linear or nonlinear regression programs
  ********************************************************************** }

{ ----------------------------------------------------------------------
  The following routine writes the result of a regression program
    in an output file
  ---------------------------------------------------------------------- }

  procedure WriteOutputFile;
  var
    OutFName : String;    { Name of output file }
    OutF     : Text;      { Output file }
    Line1,
    Line2    : String;    { Separating lines }
    Delta    : Float;     { Residual }
    Test     : TRegTest;  { Regression tests }
    Sr       : Float;     { Residual error }
    S        : PVector;   { Standard deviations of parameters }
    T        : PVector;   { Student's t }
    Prob     : PVector;   { Probabilities }
    SY       : Float;     { Standard deviation of observation }
    I, K     : Integer;   { Loop variables }
  begin
    DimVector(S, Ubound);
    DimVector(T, Ubound);
    DimVector(Prob, Ubound);

    K := Pos('.', InFName);
    OutFName := Copy(InFName, 1, Pred(K)) + '.OUT';
    Assign(OutF, OutFName);
    Rewrite(OutF);

    Line1 := StrChar(73, '-');
    Line2 := StrChar(73, '=');

    WriteLn(OutF, Line2);
    WriteLn(OutF, 'Data file  : ', InFName);
    WriteLn(OutF, 'Study name : ', Title);
    WriteLn(OutF, 'x variable : ', XName);
    WriteLn(OutF, 'y variable : ', YName);
    WriteLn(OutF, 'Function   : ', FuncName);

    { Update var/cov matrix and compute regression tests
      Note : RegTest or WRegTest must always be called BEFORE ParamTest }
    WRegTest(Y, Ycalc, W, N, Lbound, Ubound, V, Test);
    ParamTest(B, V, N, Lbound, Ubound, S, T, Prob);

    WriteLn(OutF, Line1);
    WriteLn(OutF, 'Parameter    Est.value         Std.dev.        t Student       Prob(>|t|)');
    WriteLn(OutF, Line1);
    for I := Lbound to Ubound do
      WriteLn(OutF, ParamName(I):5, B^[I]:17:4, S^[I]:17:4, T^[I]:17:2, Prob^[I]:17:4);
    WriteLn(OutF, Line1);
    WriteLn(OutF, 'Number of observations            : n   = ', N:5);

    with Test do
      begin
        Sr := Sqrt(Vr);
        WriteLn(OutF, 'Residual error                    : s   = ', Sr:10:4);
        if (R2 >= 0.0) and (R2 <= 1.0) then
          WriteLn(OutF, 'Coefficient of determination      : r2  = ', R2:10:4);
        if (R2a >= 0.0) and (R2a <= 1.0) then
          WriteLn(OutF, 'Adjusted coeff. of determination  : r2a = ', R2a:10:4);
        Write(OutF,   'Variance ratio (explained/resid.) : F   = ', F:10:4);
        WriteLn(OutF, '    Prob(>F) = ', Prob:6:4);
      end;

    WriteLn(OutF, Line1);
    WriteLn(OutF, '  i        Y obs.       Y calc.      Residual      Std.dev.      Std.res.');
    WriteLn(OutF, Line1);
    for K := 1 to N do
      begin
        Delta := Y^[K] - Ycalc^[K];
        SY := Sr / Sqrt(W^[K]);
        WriteLn(OutF, K:3, Y^[K]:14:4, Ycalc^[K]:14:4, Delta:14:4, SY:14:4, (Delta / SY):14:4);
      end;
    WriteLn(OutF, Line2);

    Close(OutF);
    WriteLn('Results written to file ', OutFName);

    DelVector(S, Ubound);
    DelVector(T, Ubound);
    DelVector(Prob, Ubound);
  end;
