{ **********************************************************************
  *                         Program TESTFUNC.PAS                       *
  *                              Version 1.0                           *
  *                      (c) J. Debord, August 1997                    *
  **********************************************************************
  This program tests the accuracy of the elementary transcendental
  functions. For each function, 20 random arguments are picked, then
  the function is computed, the reciprocal function is applied to the
  result, and the relative error between this last result and the
  original argument is computed.
  ********************************************************************** }

uses
  Crt, FMath, Matrices, Stat;

const
  NARG = 20;      { Number of arguments }
  BLANK = '   ';  { Separator }

var
  X, Y : PVector;  { Random arguments }

  procedure Pause;
  begin
    GotoXY(1, 25);
    Write('Press <Enter> to continue');
    ReadLn;
    ClrScr;
  end;

  procedure RanArgs(X : PVector; Lbound, Ubound : Float);
  { Fills a table of random arguments between Lbound and Ubound,
    rounded to 4 decimal places and sorted in increasing order. }
  var
    I : integer;
    T : Float;
  begin
    for I := 1 to NARG do
      begin
        T := (Ubound - Lbound) * RanMar + Lbound;
        X^[I] := Int(10000 * T) / 10000;
      end;
    QSort(X, 1, NARG);
  end;

  procedure Test_Exp;
  var
    I : Integer;
    Z, T, R : Float;
  begin
    RanArgs(X, -10, 10);
    WriteLn('   X                       Y = Exp(X)                    X = Ln(Y)    Rel.Error');
    WriteLn('-------------------------------------------------------------------------------');
    for I := 1 to NARG do
      begin
        Z := Exp(X^[I]);
        T := Ln(Z);
        R := (X^[I] - T) / X^[I];
        WriteLn(X^[I]:8:4, BLANK, Z:26, BLANK, T:26, BLANK, R:10);
      end;
    Pause;
  end;

  procedure Test_Exp10;
  var
    I : Integer;
    Z, T, R : Float;
  begin
    RanArgs(X, -5, 5);
    WriteLn('   X                     Y = Exp10(X)                 X = Log10(Y)    Rel.Error');
    WriteLn('-------------------------------------------------------------------------------');
    for I := 1 to NARG do
      begin
        Z := Exp10(X^[I]);
        T := Log10(Z);
        R := (X^[I] - T) / X^[I];
        WriteLn(X^[I]:8:4, BLANK, Z:26, BLANK, T:26, BLANK, R:10);
      end;
    Pause;
  end;

  procedure Test_Exp2;
  var
    I : Integer;
    Z, T, R : Float;
  begin
    RanArgs(X, -15, 15);
    WriteLn('   X                      Y = Exp2(X)                  X = Log2(Y)    Rel.Error');
    WriteLn('-------------------------------------------------------------------------------');
    for I := 1 to NARG do
      begin
        Z := Exp2(X^[I]);
        T := Log2(Z);
        R := (X^[I] - T) / X^[I];
        WriteLn(X^[I]:8:4, BLANK, Z:26, BLANK, T:26, BLANK, R:10);
      end;
    Pause;
  end;

  procedure Test_Pow;
  var
    I : Integer;
    Z, T, R : Float;
  begin
    RanArgs(X, 0, 10);
    RanArgs(Y, -5, 5);
    WriteLn('  X      Y                  Z = Pow(X, Y)              Y = Log(Z, X)  Rel.Error');
    WriteLn('-------------------------------------------------------------------------------');
    for I := 1 to NARG do
      begin
        Z := Pow(X^[I], Y^[I]);    { X^Y }
        T := Log(Z, X^[I]);        { Log(X^Y, X) = Y }
        R := (Y^[I] - T) / Y^[I];
        WriteLn(X^[I]:6:4, Y^[I]:8:4, ' ', Z:26, ' ', T:26, ' ', R:10);
      end;
    Pause;
  end;

  procedure Test_Sin;
  var
    I : Integer;
    Z, T, R : Float;
  begin
    RanArgs(X, -PIDIV2, PIDIV2);
    WriteLn('   X                       Y = Sin(X)                X = ArcSin(Y)    Rel.Error');
    WriteLn('-------------------------------------------------------------------------------');
    for I := 1 to NARG do
      begin
        Z := Sin(X^[I]);
        T := ArcSin(Z);
        R := (X^[I] - T) / X^[I];
        WriteLn(X^[I]:8:4, BLANK, Z:26, BLANK, T:26, BLANK, R:10);
      end;
    Pause;
  end;

  procedure Test_Cos;
  var
    I : Integer;
    Z, T, R : Float;
  begin
    RanArgs(X, 0, PI);
    WriteLn('   X                       Y = Cos(X)                X = ArcCos(Y)    Rel.Error');
    WriteLn('-------------------------------------------------------------------------------');
    for I := 1 to NARG do
      begin
        Z := Cos(X^[I]);
        T := ArcCos(Z);
        R := (X^[I] - T) / X^[I];
        WriteLn(X^[I]:8:4, BLANK, Z:26, BLANK, T:26, BLANK, R:10);
      end;
    Pause;
  end;

  procedure Test_Tan;
  var
    I : Integer;
    Z, T, R : Float;
  begin
    RanArgs(X, -PIDIV2, PIDIV2);
    WriteLn('   X                       Y = Tan(X)                X = ArcTan(Y)    Rel.Error');
    WriteLn('-------------------------------------------------------------------------------');
    for I := 1 to NARG do
      begin
        Z := Tan(X^[I]);
        T := ArcTan(Z);
        R := (X^[I] - T) / X^[I];
        WriteLn(X^[I]:8:4, BLANK, Z:26, BLANK, T:26, BLANK, R:10);
      end;
    Pause;
  end;

  procedure Test_Sinh;
  var
    I : Integer;
    Z, T, R : Float;
  begin
    RanArgs(X, 0, 5);
    WriteLn('   X                      Y = Sinh(X)               X = ArcSinh(Y)    Rel.Error');
    WriteLn('-------------------------------------------------------------------------------');
    for I := 1 to NARG do
      begin
        Z := Sinh(X^[I]);
        T := ArcSinh(Z);
        R := (X^[I] - T) / X^[I];
        WriteLn(X^[I]:8:4, BLANK, Z:26, BLANK, T:26, BLANK, R:10);
      end;
    Pause;
  end;

  procedure Test_Cosh;
  var
    I : Integer;
    Z, T, R : Float;
  begin
    RanArgs(X, 0, 5);
    WriteLn('   X                      Y = Cosh(X)               X = ArcCosh(Y)    Rel.Error');
    WriteLn('-------------------------------------------------------------------------------');
    for I := 1 to NARG do
      begin
        Z := Cosh(X^[I]);
        T := ArcCosh(Z);
        R := (X^[I] - T) / X^[I];
        WriteLn(X^[I]:8:4, BLANK, Z:26, BLANK, T:26, BLANK, R:10);
      end;
    Pause;
  end;

  procedure Test_Tanh;
  var
    I : Integer;
    Z, T, R : Float;
  begin
    RanArgs(X, -5, 5);
    WriteLn('   X                      Y = Tanh(X)               X = ArcTanh(Y)    Rel.Error');
    WriteLn('-------------------------------------------------------------------------------');
    for I := 1 to NARG do
      begin
        Z := Tanh(X^[I]);
        T := ArcTanh(Z);
        R := (X^[I] - T) / X^[I];
        WriteLn(X^[I]:8:4, BLANK, Z:26, BLANK, T:26, BLANK, R:10);
      end;
    Pause;
  end;

begin
  ClrScr;
  DimVector(X, NARG);
  DimVector(Y, NARG);
  Test_Exp;
  Test_Exp10;
  Test_Exp2;
  Test_Pow;
  Test_Sin;
  Test_Cos;
  Test_Tan;
  Test_Sinh;
  Test_Cosh;
  Test_Tanh;
end.
