@echo off

rem This is a demonstration batch by Prof. Timo Salmi Fri 8-Oct-2004

rem It shows how to test within a batch files if the MS-DOS version
rem is 3.3 or later. The reason for this demonstration is that you
rem might wish to have differences in your batch depending on which
rem MS-DOS version is available. For example the call command was not
rem available until version 3.3. This batch does not truly cover
rem Win95/98/Me and NT/2000/XP

rem Bear in mind that for the early MS-DOS versions FIND did not return
rem an errorlevel value. Therefore the indirect test format is used.

if "%OS%"=="Windows_NT" goto _xp
if not "%windir%"=="" goto _win

rem If none of the 3.3, 4., 5. or 6. is found then tmpfind.$$$ will be
rem empty.
ver | find "3.3" > tmpfind.$$$
ver | find "4." >> tmpfind.$$$
ver | find "5." >> tmpfind.$$$
ver | find "6." >> tmpfind.$$$

rem If tmpfind.$$$ is empty (0 bytes) copying it will produce
rem nothing.
copy tmpfind.$$$ tmpfind1.$$$ > nul
del tmpfind.$$$

rem We test whether tmpfind1$$$ exists. Thus we are indirectly
rem testing whether 3.3, 4. or .5 was found.
if exist tmpfind1.$$$ echo MS-DOS version is at least 3.3
if not exist tmpfind1.$$$ echo MS-DOS version is earlier than 3.3

if exist tmpfind1.$$$ del tmpfind1.$$$

set test_=
ver | find "MS-DOS Version 6." > nul
if errorlevel 0 if not errorlevel 1 set test_=ok
set | find "windir=" > nul
if errorlevel 0 if not errorlevel 1 if "%test_%"=="ok" echo Windows 3.1x
set test_=
goto _out

rem Much later kludges. Much more refined detection would be possible
:_win
echo Win95/98/Me
ver | find "Windows 95" > nul
if errorlevel 0 if not errorlevel 1 echo Windows 95
goto _out

:_xp
echo NT/2000/XP
ver | find "Microsoft Windows XP" > nul
if errorlevel 0 if not errorlevel 1 echo XP
goto _out

:_out
rem Allow distinguishing between calling the batch from CLI or Desktop
if "%USERNAME%"=="ts" if not "%dosbox%"=="true" if not "%cmdbox%"=="true" pause
echo on
