#define STUFF_SIZE 129                      /* buffer size for fgets        */
#define ASIZE 6550                          /* determines # of conferences  */
                                            /* we can handle                */
 
#define VERSION  "4.60"                     /* version number               */
#define REL_DATE "Dec. 25, 1993"            /* release date (keep format!)  */

#define ARC     1                           /* Result code for ARC(TM)      */
#define ZOO     2                           /* Result code for ZOO          */
#define ARJ     3                           /* Result code for ARJ          */
#define LHARC   4                           /* Result code for LHARC        */
#define LHA     5                           /* Result code for LHA          */
#define ZIP     6                           /* Result code for ZIP          */
#define UNKNOWN 10                          /* Result code for UNKNOWN      */

unsigned personal = 0;                      /* count of personal messages   */
unsigned MsgsPerConference = 0;             /* count of messages/conference */
unsigned TotalMsgsInQWK = 0;                /* count of messages in packet  */

int arctype = 0;                            /* archive type returned from   */
                                            /* whicharc() function          */

char zipflag;                               /* flag telling whether to use  */
                                            /* pkunzip.exe or unzip.exe     */

struct hdr                                  /* message header structure     */
{
   char _private;                           /* first byte is privacy flag   */
                                            /* ' ' means mail has been read */
                                            /* '-' means not read           */
                                            /* '+' means private message    */
   char _msg[7];                            /* message number in ASCII      */
   char _date[8];                           /* date in ASCII (mm-dd-yy)     */
   char _time[5];                           /* time in ASCII (hh:mm)        */
   char _to[25];                            /* name of receiver             */
   char _from[25];                          /* name of sender               */
   char _subj[25];                          /* message subject              */
   char _pass[12];                          /* message password (obsolete)  */
   char _ref[8];                            /* msg refers to this msg #     */
   char _count[6];                          /* # of 128-byte blocks in msg  */
   char _active;                            /* message status flag          */
                                            /*    225 (0xE1) == active      */
                                            /*    226 (0xE2) == killed      */
   char _confnum[2];                        /* conference number            */
   char _lognum[2];                         /* logical message number       */
                                            /*  currently only used by      */
                                            /*  1st Reader                  */
   char _nettag;                            /* network tag - if non-zero,   */
                                            /*  message has network tagline */
} header;



struct conf                                 /* conference header structure  */
{
   int _num;                                /* conference number            */
   int _msgs;                               /* # of msgs in conference      */
   char _name[15];                          /* conf. name (14 chars max)    */
} confs[ASIZE];

/* prototypes for ANSI C */

void _cdecl main(int argc, char **argv);
void strip(char *s);
char *byp(char *s);
int  nummsg(int n);
int  readblk(FILE *fp, char *buff);
int  readhdr(FILE *fp);
void strncp(char *d, char *s, int n);
void sep(FILE *fp);
void _cdecl erase(char *pathname);
int WhichArc(char *pName);
