/*****************************************************************************
*                           BC 3.2 INCLUDE FILE                              *
*                       INSTRUMENT DATA FOR FFT.CPP                          *
*                              FFT_DATA.INC                                  *
*                                                                            *
*  This product is copyrighted (C) 1996 by Henk Thomassen. Permission is     *
*  granted for non-commercial use and distribution.                          *
******************************************************************************
* REMARK:  s = actual data for instrument                                    *
*   	   m[?] = data for scope, absolute, fase, real and imag		     *
*   									     *
*          v1.0 Jan 1996                                                     *
*                                                                            *
******************************************************************************
* If you have any questions or remarks please contact me                     *
* Henk Thomassen, thomass@IAEhv.nl                                           *
*****************************************************************************/
struct systemTYPE {
	int      y_loglin;
	int      y_divisions;

	int      ylog_scale;
	int      ylog_scalemax;
	float    ylog_division[15];
	int      ylog_min;
	int      ylog_max;
	char     ylog_scaletxt[10];
	int      ylog_upmax;
	int      ylog_downmax;

	int      ylin_scale;
	int      ylin_scalemax;
	float    ylin_division[15];
	int      ylin_scalemul[15];
	char     ylin_scaletxt[15][11];
	int      ylin_min;
	int      ylin_max;
	int      ylin_upmax;
	int      ylin_downmax;

	int      xlin_scale;
	int      xlin_scalemax;
	int      x_divisions;
	float    xlin_division[15];
	int      xlin_min;
	int      xlin_max;
	char     xlin_scaletxt[10];

	int      x_magnifier[15];
	int      x_multiplier[15];
	int      samples[15];
	int      power[15];
	long     sample_freq[15];

	int	 window_mode;
	int	 plot;
	int      refresh;
	int      input_mode;

	int      peakon; } s,m[5] =

//////////////////////////////////////////////////////// scope
   // y_loglin, y_divisions, ylog_scale ylog_scalemax
 {{  linear,          8,         0,           0,
   //ylog_division[1]
   {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
   //ylog_min, ylog_max, ylog_scaletxt,ylog_upmax, ylog_downmax
   0,          0,         "",       0,         0,
   //ylin_scale,maxscalelin
   0,        1,
   //ylin_division
   {32,10,5,2,1,0.5,0.2,0.1,0,0,0,0,0,0,0},
   //ylin_scalemul
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //ylin_scaletxt
   {"DAC output","  Dots   ","  Dots   ","  Dots   ","  Dots   ","Dots","Dots","Dots","Dots","Dots","Dots","Dots","Dots","Dots","Dots"},
   //ylin_min, ylin_max, ylin_upmax, ylin_downmax
   -4,       +4,         20,        -20,
   //xlin_scale, xlin_scalemax, x_divisions
   0,               8,          10,
   //xlin_division
   {0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0,0,0,0,0,0,0,0},
   //xlin_min, xlin_max, xlin_scaletxt,
   0,          10,       "mS",
   //x_magnifier
   {6,4,2,1,1,1,1,1,0,0,0,0,0,0,0},
   //x_multiplier
   {1,1,1,1,1,1,2,8,0,0,0,0,0,0,0},
   //samples
   {86,129,257,513,513,513,1025,4097,0,0,0,0,0,0,0},
   //power
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //sample_freq
   {42500,25600,25600,25600,10240,5120,5120,8129,0,0,0,0,0,0,0},
   //window_mode, plot, refresh,   input_mode, peakon
   none,lines, yes_refresh, sb16_16, off_peak },

  ///////////////////////////////////////////////////////////// absolute
   // y_loglin, y_divisions, ylog_scale ylog_scalemax
  {  logaritmic,          8,         3,           5,
   //ylog_division[1]
   {1,2,5,10,20,0,0,0,0,0,0,0,0,0,0},
   //ylog_min, ylog_max, ylog_scaletxt,ylog_upmax, ylog_downmax
   -10,          -2,      "dBm",     60,         -160,
   //ylin_scale,maxscalelin
     11,        15,
   //ylin_division
   {1e-5,2e-5,5e-5,1e-4,2e-4,5e-4,1e-3,2e-3,5e-3,1e-2,2e-2,5e-2,1e-1,2e-1,5e-1},
   //ylin_scalemul
   {1e3,1e3,1e3,1e3,1e3,1e3,1e3,1e3,1e3,1e3,1,1,1,1,1},
   //ylin_scaletxt
   {"uW","uW","uW","uW","uW","uW","uW","uW","uW","uW","mW","mW","mW","mW","mW"},
   //ylin_min, ylin_max, ylin_upmax, ylin_downmax
   0,           8,        20,         -20,
   //xlin_scale, xlin_scalemax, x_divisions
   1,       9,          10,
   //xlin_division
   {2250,2000,1750,1500,1250,1000,750,500,250,0,0,0,0,0,0},
   //xlin_min, xlin_max, xlin_scaletxt
   0,          10,        "Hz",
   //x_magnifier
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //x_multiplier
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //samples
   {1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025},
   //power
   {10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
   //sample_freq
   {45000,40000,35000,30000,25000,20000,15000,10000,5000,0,0,0,0,0,0},
   //window_mode, plot, refresh,   input_mode, peakon
   hanning,      lines, yes_refresh, sb16_16, on_peak },

  ///////////////////////////////////////////////////////////// fase
   // y_loglin, y_divisions, ylog_scale ylog_scalemax
  {  linear,          8,         0,           0,
   //ylog_division[1]
   {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
   //ylog_min, ylog_max, ylog_scaletxt,ylog_upmax, ylog_downmax
   0,          0,        "",        0,          0,
   //ylin_scale,maxscalelin
   0,            1,
   //ylin_division
   {M_PI/4,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
   //ylin_scalemul
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //ylin_scaletxt
   {"RAD","PHASE","PHASE","PHASE","PHASE","PHASE","PHASE","PHASE","PHASE","PHASE","PHASE","PHASE","PHASE","PHASE","PHASE"},
   //ylin_min, ylin_max, ylin_upmax, ylin_downmax
    -4,       4,         10,         -10,
   //xlin_scale, xlin_scalemax, x_divisions
   1,       9,          10,
   //xlin_division
   {2250,2000,1750,1500,1250,1000,750,500,250,0,0,0,0,0,0},
   //xlin_min, xlin_max, xlin_scaletxt
   0,          10, "Hz",
   //x_magnifier
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //x_multiplier
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //samples
   {1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025},
   //power
   {10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
   //sample_freq
   {45000,40000,35000,30000,25000,20000,15000,10000,5000,0,0,0,0,0,0},
   //window_mode, plot, refresh,   input_mode, peakon
   hanning,      lines, yes_refresh, sb16_16, on_peak },

  ///////////////////////////////////////////////////////////// real
   // y_loglin, y_divisions, ylog_scale ylog_scalemax
  {  linear,          8,         0,           0,
   //ylog_division[1]
   {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  //ylog_min, ylog_max, ylog_scaletxt ,ylog_upmax, ylog_downmax
   0,          0,     "",              0,        0,
   //ylin_scale,maxscalelin
     11,        15,
   //ylin_division
   {1e-5,2e-5,5e-5,1e-4,2e-4,5e-4,1e-3,2e-3,5e-3,1e-2,2e-2,5e-2,1e-1,2e-1,5e-1},
   //ylin_scalemul
   {1e3,1e3,1e3,1e3,1e3,1e3,1e3,1e3,1e3,1e3,1,1,1,1,1},
   //ylin_scaletxt
   {"mVre","mVre","mVre","mVre","mVre","mVre","mVre","mVre","mVre","mVre","Vre","Vre","Vre","Vre","Vre"},
   //ylin_min, ylin_max,ylin_upmax, ylin_downmax
   -4,       4,           20,         -20,
   //xlin_scale, xlin_scalemax, x_divisions
   1,       9,          10,
   //xlin_division
   {2250,2000,1750,1500,1250,1000,750,500,250,0,0,0,0,0,0},
   //xlin_min, xlin_max, xlin_scaletxt
   0,         10,         "Hz",
   //x_magnifier
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //x_multiplier
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //samples
   {1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025},
   //power
   {10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
   //sample_freq
   {45000,40000,35000,30000,25000,20000,15000,10000,5000,0,0,0,0,0,0},
   //window_mode, plot, refresh,   input_mode, peakon
   hanning,      lines, yes_refresh, sb16_16, on_peak },

  ///////////////////////////////////////////////////////////// imag
   // y_loglin, y_divisions, ylog_scale ylog_scalemax
  {  linear,           8,         0,           0,
   //ylog_division[1]
   {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
   //ylog_min, ylog_max, ylog_scaletxt,ylog_upmax, ylog_downmax
    0,          -0,        "",             0,     0,
   //ylin_scale,maxscalelin
   11,        15,
   //ylin_division
   {1e-5,2e-5,5e-5,1e-4,2e-4,5e-4,1e-3,2e-3,5e-3,1e-2,2e-2,5e-2,1e-1,2e-1,5e-1},
   //ylin_scalemul
   {1e3,1e3,1e3,1e3,1e3,1e3,1e3,1e3,1e3,1e3,1,1,1,1,1},
   //ylin_scaletxt
   {"mVim","mVim","mVim","mVim","mVim","mVim","mVim","mVim","mVim","mVim","Vim","Vim","Vim","Vim","Vim"},
   //ylin_min, ylin_max, ylin_upmax, ylin_downmax
   -4,       4,          20,         -20,
   //xlin_scale, xlin_scalemax, x_divisions
   1,       9,          10,
   //xlin_division
   {2250,2000,1750,1500,1250,1000,750,500,250,0,0,0,0,0,0},
   //xlin_min, xlin_max, xlin_scaletxt
   0,         10,        "Hz",
   //x_magnifier
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //x_multiplier
   {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
   //samples
   {1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025},
   //power
   {10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
   //sample_freq
   {45000,40000,35000,30000,25000,20000,15000,10000,5000,0,0,0,0,0,0},
   //window_mode, plot, refresh,   input_mode, peakon
   hanning,      lines, yes_refresh, sb16_16, on_peak }};


/*****************************************************************************
* SHORTCUT FOR:                                                              *
*****************************************************************************/
float xdiv(){
  return( s.xlin_division[s.xlin_scale]);
}

/*****************************************************************************
* SHORTCUT FOR:                                                              *
*****************************************************************************/
float ydivlin(){
  return( s.ylin_scalemul[s.ylin_scale]*s.ylin_division[s.ylin_scale]);
}

/*****************************************************************************
* SHORTCUT FOR: Ydivision if yscale is logaritmic                            *
*****************************************************************************/
float ydivlog(){
  return(s.ylog_division[s.ylog_scale]);
}

/*****************************************************************************
* SHORTCUT FOR: scale presision on x-axis                                    *
*****************************************************************************/
int prex(){
  int t=(xdiv()!=0) ?  (int)(-log10(fabs(xdiv())/6.0)):0;
  if(t<0) t=0;
  return(t);
}

/*****************************************************************************
* SHORTCUT FOR: scale presision on Ylin axes                                 *
*****************************************************************************/
int preylin(){
  int t = (ydivlin()!=0) ? (int)(-log10(fabs(ydivlin())/9.0)):0;
  if(t<0) t=0;
  return(t);
}

/*****************************************************************************
* SHORTCUT FOR: scale presision on Ylog axes                                 *
*****************************************************************************/
int preylog(){
  int t = (ydivlog()!=0) ? (int)(-log10(fabs(ydivlog())/6.0)):0;
  if(t<0) t=0;
  return(t);
}

/*****************************************************************************
* SHORTCUT FOR: scale presision for Xvalue for peak indicator                *
*****************************************************************************/
int o_prex(){
  int t=(xdiv()!=0) ?  (int)(-log10(fabs(xdiv())))+2:0;
  if(t<0) t=0;
  return(t);
}

/*****************************************************************************
* SHORTCUT FOR: scale presision for peak indicator is Y-axes is lin          *
*****************************************************************************/
int o_preylin(){
  int t = (ydivlin()!=0) ? (int)(-log10(fabs(ydivlin())))+2:0;
  if(t<0) t=0;
  return(t);
}

/*****************************************************************************
* SHORTCUT FOR: scale presision for peak indicator is Y-axes is log          *
*****************************************************************************/
int o_preylog(){
  int t = (ydivlog()!=0) ? (int)(-log10(fabs(ydivlog())))+2:0;
  if(t<0) t=0;
  return(t);
}

/***************************** END ******************************************/
