/*****************************************************************************
*                           BC 3.2 LIBRARY                                   *
*                    GRAPHICAL ROUTINES FOR FFT.CCP                          *
*                            GRAPHICS.h                                      *
*                                                                            *
*  This product is copyrighted (C) 1996 by Henk Thomassen. Permission is     *
*  granted for non-commercial use and distribution.                          *
******************************************************************************
* REMARK:  Display is used in the VGA 640x480 resolution.                    *
*          To eliminate flikker when writing to the screen, double           *
*          buffering is used for the display arrea with screen[] as          *
*          display buffer.                                                   *
*                                                                            *
*          v1.0 Jan 1996                                                     *
*                                                                            *
******************************************************************************
* If you have any questions or remarks please contact me                     *
* Henk Thomassen, thomass@IAEhv.nl                                           *
*****************************************************************************/

#define MAXKNOPS          25
#define MAXSLIDES         10
#define DISPLAY_X         64
#define DISPLAY_Y         28
#define DISPLAY_W        512
#define DISPLAY_H        304

// knop related
void setknop(int n, int on);
int init_knop(int n, int x, int y, int b, int h, int c1, int c2, int on);
int knopin(int n);
int xy_onknop(int x,int y,int n);
void moveknop(int n, void(*f)());

// pmknop related
int init_pmknop(int n, int x, int y, int w, int h,int gfx);
void set_pmknop(int n);
int xy_onpmknop(int x,int y,int n);
void movepmknop(int n, void(*f)());
int pmknopin(int n);


// graphics related
int opengraph();
void setcolors();
void fbar(int x, int y, int x1, int y1, int c);
void kader(int x, int y, int x1, int x2);

// fft display related
void cabinet(int x, int y, int h, int w);
void emboss(int x1,int y1,int x2,int y2);

// slide related
int openslides();
int init_slide(int n, int x, int y, int l, unsigned pos);
void closeslides();
int slidepos(int n);
void moveslide(int n,int xx, int yy, void(*f)());

// mixer related
void sb16_mixer(int x, int y);
void init_sb16mix(int x, int y, int p);
int gettotalamp();

// graphics
void vLine(int x,int y1,int y2);
void hLine(int x1,int x2,int y);
void box(int x1,int y1,int x2,int y2);
void PutDot(int x,int y);
void putdotbuf(int x,int y);
void clearDisplay0();
void cleardisplaybuf();
void copydisplaybuf();
extern "C" { void linebuf(int x0, int y0, int x1, int y1);}

// font
void textxy(int x, int y, unsigned char *s);
