/*****************************************************************************
*                         BC 3.2 INCLUDE FILE                                *
*                         MOUSE ROUTINES V1.0                                *
*                               MOUSE.H                                      *
*                                                                            *
*  This product is copyrighted (C) 1996 by Henk Thomassen. Permission is     *
*  granted for non-commercial use and distribution.                          *
******************************************************************************
* REMARK:  Only basic set of MOUSE-functions included.                       *
*          Use the mouse event handler to detect mouse-actions.              *
*                                                                            *
*          v1.0 Jan 1996                                                     *
*                                                                            *
******************************************************************************
* If you have any questions or remarks please contact me                     *
* Henk Thomassen, thomass@IAEhv.nl                                           *
*****************************************************************************/

#define    MOUSEINT     0x33
#define    FALSE        (0)
#define    TRUE         (!FALSE)
				      // event if
#define MEVENT_MOV      0x01          //       move mouse
#define MEVENT_KLD      0x02          //       press   left key
#define MEVENT_KLU      0x04          //       release
#define MEVENT_KRD      0x08          //       press   right key
#define MEVENT_KRU      0x10          //       release
#define MEVENT_OFF      0x00          // no mouse events

extern int  mouse_present;            // TRUE if mouse deteced
extern unsigned int LastMask;         // when changing Mask temporarily,
				      // save these values BEFORE the change, and
				      // restore when neccessary


// ----------------- Function prototypes -----------------

void initmouse(void); 		              // result in mouse_present
void showmouse(void);                         // switch mouse cursor on
void hidemouse(void);                         //                     off
unsigned mousex (void);                       // get actual mouse X
unsigned mousey (void);                       //                  Y
void mousebox(unsigned left,unsigned top,
	      unsigned right,unsigned bottom);// limit mouse rectangle
void arrowmouse(void);                        // mouse cursor=arrow
void targetmouse(void);                       // mouse cursor=target cross
void setmouseevent(unsigned mask);            // events will be stored
int  mousein(int mx, int my, int x1,          // true if mx,my inside
	     int y1, int x2, int y2);         //   x1,y1  x2,y2
int getevent(int &x, int &y, int &k);         // if TRUE, get mouse event
					      // result in x,y= mouse position
					      //             k=mouse keys
int event();                                  // TRUE if event stored
int waistevent();                             // delete event

/******************************* END ***************************************/
