/*****************************************************************************
*                           BC 3.2 LIBRARY                                   *
*                         SB16 ROUTINES V1.0                                 *
*                              SB16.H                                        *
*                                                                            *
*  This product is copyrighted (C) 1996 by Henk Thomassen. Permission is     *
*  granted for non-commercial use and distribution.                          *
******************************************************************************
* REMARK: All sb16 mixer routines in this library are ALLWAYS setting the    *
*         right and left channel in a equal state. ( volume, in- and output  *
*         settings)                                                          *
*                                                                            *
*	  The sbinit() routine is an adaptation from Ethan Brodsky's         *
*	  init routine. (free ware 1995)                                     *
*                                                                            *
*          v1.0 Jan 1996                                                     *
*                                                                            *
******************************************************************************
* If you have any questions or remarks please contact me                     *
* Henk Thomassen, thomass@IAEhv.nl                                           *
*****************************************************************************/
extern int far *raw_16;
extern char far *raw_8;
extern int sb_baseio;
extern int sb_irq;
extern int sb_dma;
extern int sb_dma16;
extern int sb_dspversion;
extern int sb16_present;

int detect_blaster();
int sbinit(int baseio, int irq, int dma, int dma16);
int sbmalloc( void );
void sbfree();
void sbsettc(unsigned int f);
void sbrec8( unsigned short len );
unsigned short dmacount8( void );
void sbrec16( unsigned short len );
unsigned short dmacount16( void );

int getVolume(int n);
void setVolume(int n, unsigned char v);
void setSBswitch(int n, int on);
int getSBswitch(int n);
unsigned char SBgetmixreg(unsigned char r);


