;============== NEW INT ROUTINES

;This procedure is hooked into int 13h of BIOS.
;This code will check to see if the current drive that is being written to is
;protected or not and wo what degree.  If there is no protection set, this
;routine jumps to the original int address and it performs as nothing has
;happened.  If there is a protection and the write will violate the protection
;that is set for that drive, this routine will fake a write protect error and
;return to the calling address never having entered the real write routine.



New_Disk_Intr   proc    far                     ;Interrupt 13h
                push    si
                push    dx
                xor     dh,dh                   ;clear dh
                cmp     dl,80h                  ;if it is a hard disk
                jb      @F                      ;jump if below 80h
                sub     dl,7Eh                  ; ,bring drive # into range
        @@:     mov     si,dx                   ;put dl in si
                pop     dx
                cmp     cs:Doption[si],byte ptr 0 ;check protection of current
                                                  ;  drive
                je      do_old_int                ;if no prot. then pass contol
                cmp     cs:Doption[si],byte ptr 1 ;check protection of current
                je      Level_1                   ;  drive

Level_2:        cmp     ah,3                    ;
                je      Fake_WP                 ;
                cmp     ah,Bh                   ;
                je      Fake_WP                 ;  Catch all the disk requests
                cmp     ah,6                    ;  that write to a disk
                je      Fake_WP                 ;
                cmp     ah,7                    ;
                je      Fake_WP
Level_1:        cmp     ah,5                    ;catch the format request
                je      Fake_WP
                jmp     do_old_int

Fake_WP:        pop     si
                mov     ax,0300h                ;yes, fake a write protect
                stc                             ;indicate error
                sti                             ;allow interrupts
                ret     2                       ;return, clearing old flags

do_old_int:     pop     si
                jmp     dword ptr cs:old_disk_intr
                                                ;pass control to old int
New_Disk_Intr   endp

;This procedure is hooked into int 26h of dos.  26h is the DOS write interrupt.
;This code will check to see if the current drive that is being written to is
;protected or not and wo what degree.  If there is no protection set, this
;routine jumps to the original int address and it performs as nothing has
;happened.  If there is a protection and the write will violate the protection
;that is set for that drive, this routine will fake a write protect error and
;return to the calling address never having entered the real write routine.

new_dos_write   proc    far                     ;interrupt 26h
                push    si                      ;save si
                push    ax                      ;save ax
                xor     ah,ah                   ;clear ah
                mov     si,ax                   ;move drive into si
                pop     ax                      ;restore ax
                cmp     cs:Doption[si],byte ptr 0 ;if no protection
                je      do_old_write            ; then continue
                cmp     cs:Doption[si],byte ptr 2 ;if protection = 2
                je      Fake_protect            ; then fake a write protect

                jmp     Fake_protect
                cmp     dx,0                    ;write to boot record?
                jne     do_old_write            ;no, do old int

Fake_protect:   pop     si                      ;restore si
                sti                             ;allow interrupts
                mov     ax,4006h                ;fake a seek error
                stc                             ;signal error
                ret                             ;exit, keep stack
do_old_write:   pop     si                      ;restore si
                jmp     dword ptr cs:old_dos_write
                                                ;pass control to old int
new_dos_write   endp

;This routine hooks into the keyboard interrupt.  Anytime a key is pressed,
;this routine determines if the MainMenu should be poped up or not.

new_keyboard    proc    far
                cmp     cs:status,inactive
                je      activate
                jmp     dword ptr cs:old_keyboard_intr
activate:       inc     cs:status
                pushf
                call    dword ptr cs:old_keyboard_intr
                sti
                push    ax
                mov     ah,2
                int     16h
                and     al,00001111b            ; mask out status bits
                cmp     al,00001010b            ; is both shifts pressed
                pop     ax
                jne     do_old_kbd

DO_IT:          pusha               ; save all the registers
                push    ds
                call    MainMenu
                pop     ds
                popa                ; restore the registers

do_old_kbd:     cli
                dec     cs:status
                iret
new_keyboard    endp

;-------------- COMMUNICATION ROUTINES, none defined
;this allow future expansion by providing internal access to RWP.
;
;For example, a program could use this interrupt to change the protection
;levels for itself or turn RWP on and off.

comm_routine    proc    near
                iret
comm_routine    endp
