;This is the main body of the resident menu section.
;It swaps the video buffer with the menu, gets input from the user to select
;which drives are to be protected and at what level, it updates the status
;variables to the drive protection changes, finally it restores the old screen
;and returns to the program that it interrupted.

MainMenu    proc    near

            call    SwapBuffer              ; Load the menu

            mov     ah,3                    ; get cursor function
            xor     bh,bh                   ; page 0
            int     10h                     ; call BIOS
            mov     old_pos,dx              ; store old cursor position

            mov     dh,option               ; move option to dh
            add     dh,10                   ; add 10 lines to it
            mov     dl,37                   ; column 37
            xor     bh,bh                   ; page 0
            mov     ah,2                    ; move cursor function
            int     10h                     ; call BIOS

WaitForKey: mov     ah,0                    ; wait for a key
            int     16h                     ; call BIOS
            cmp     ax,011Bh                ; is the key an ESC
            jne     @F                      ; if not, jump forward
            jmp     escape                  ; if so quit the loop
    @@:     cmp     ax,4800h                ; it it an up arrow
            je      up                      ; if so, process the up arrow
            cmp     ax,5000h                ; is it a down arrow
            je      down                    ; if so, process the down arrow
            cmp     ax,4B00h                ; is it a left arrow
            je      left                    ; if so, process the left arrow
            cmp     ax,4D00h                ; is it a right arrow
            je      right                   ; if so, process the right arrow
            jmp     WaitForKey              ; get another key

up:         cmp     option,0                ; if option
            jne     @F                      ;           = 0
            mov     option,4                ;               then option = 4
    @@:     dec     option                  ; decrement option
            mov     dh,option               ; move option to dh
            add     dh,10                   ; add 10 lines to option
            mov     dl,37                   ; column 37
            xor     bh,bh                   ; page 0
            mov     ah,2                    ; move cursor function
            int     10h                     ; call BIOS
            jmp     WaitForKey              ; get another key

down:       inc     option                  ; increment option
            cmp     option,4                ; if option
            jne     @F                      ;           = 4
            mov     option,0                ;               then option =0
    @@:     mov     dh,option               ; move option to dh
            add     dh,10                   ; add 10 lines to it
            mov     dl,37                   ; column 37
            xor     bh,bh                   ; page 0
            mov     ah,2                    ; move cursor function
            int     10h                     ; call BIOS
            jmp     WaitForKey              ; get another key

left:       mov     al,option               ; get the option
            xor     ah,ah                   ; mov ah,0
            mov     si,ax                   ; set index to option
            mov     al,byte ptr DOption[si] ; get disk option
            cmp     al,0h                   ; if disk option
            je      @F                      ;                > 0
            dec     al                      ;                    then decrement
            mov     DOption[si],al          ; store DiskOption
    @@:     add     al,30h                  ; convert it to ascii
            mov     ah,10                   ; print function
            mov     cx,1                    ; repeat 1 time
            mov     bx,0                    ; page 0
            int     10h                     ; call BIOS
            jmp     WaitForKey              ; get another key

right:      mov     al,option               ; get the option
            xor     ah,ah                   ; mov ah,0
            mov     si,ax                   ; set index to option
            mov     al,byte ptr DOption[si] ; get disk option
            cmp     al,2h                   ; if disk option
            je      @F                      ;                < 2
            inc     al                      ;                    then increment
            mov     DOption[si],al          ; store DiskOption
    @@:     add     al,30h                  ; convert it to ascii
            mov     ah,10                   ; print function
            mov     cx,1                    ; do not repeat
            xor     bx,bx                   ; page 0
            int     10h                     ; call BIOS
            jmp     WaitForKey              ; get another key

escape:     call    SwapBuffer              ; Restore the screen
            mov     ah,2                    ; move cursor function
            mov     dx,old_pos              ; restore old cursor position
            xor     bh,bh                   ; page 0
            int     10h                     ; call BIOS
            ret                             ; return
MainMenu    endp


