; this procedure does an in place swap of the text screen and the buffer.
; the text and attributes have been seperated into two sections so that the
; screen can be created, viewed, and edited with very little difficulty.
; This routine may cause snow on CGA cards but will have no such effect on
; EGA or VGA cards.

SwapBuffer  proc    near
            push    es                      ; store ES
            mov     ax,Disp_buffer          ; location of screen
            mov     es,ax                   ; load new ES
            mov     bx,5*160                ; start on 5th line
            xor     si,si                   ; start at beginning of data
rows:       mov     di,20                   ; start at 10th column
lines:      mov     ax,es:[bx][di]          ; get character from screen
            xchg    vid_buffer_text[si],al  ; exchange buffer char with screen
            xchg    vid_buffer_attr[si],ah  ; exchange buffer attr with screen
            mov     es:[bx][di],ax          ; write character to screen
            inc     si                      ; next byte of buffer
            add     di,2                    ; next char of screen
            cmp     di,140                  ; end at 70th column
            jne     lines                   ; no, keep going
            add     bx,160                  ; next line
            cmp     bx,20*160               ; end on 20th line
            jne     rows                    ; no, keep going
            pop     es                      ; restore ES
            ret
SwapBuffer  endp


