            Title Resident Write Protect Protect
            Page 82,132

;-------------- CONSTANTS

DISP_BUFFER     equ     0B800H  ; color graphics buffer
ACTIVE          equ     1
INACTIVE        equ     0
CR              equ     13
LF              equ     10
KEYBOARD_INTR   equ     9h      ; keyboard interrupt vector
DISK_INTR       equ     13h     ; BIOS disk interrupt vector
DOS_WRITE       equ     26h     ; DOS write interrupt vector
FREE_INT1       equ     60h     ; Program signiture will be attached to a
FREE_INT_LAST   equ     67h     ;   vector in this range
DISK_ENTRY      equ     DISK_INTR*4     ;
KEYBOARD_ENTRY  equ     KEYBOARD_intr*4 ; Abs Locations in int table of vectors
DOS_WRITE_ENTRY equ     DOS_WRITE*4     ;

                .286    ; allow 286 instructions

;-------------- Dummy segment pointing to the interrupt table

INT_TABLE       SEGMENT AT 0
INT_TABLE       ENDS

;-------------- BEGINING

code            SEGMENT
                assume  cs:code
                org     44                      ;here is the environment
environ_addr    dw      ?                       ; pointer
                org     100h                    ;make this a .COM file
RWP:            jmp     beginning               ;install interrupt

;-------------- DATA

                include RWP-WIND.INC    ; window screen definition

option          db      0
DOption         db      0,0,1,1   ; default disk protection levels
old_pos         dw      ?         ; old cursor position
COMMUNICATE:    jmp     comm_routine
program_name    db      'RWP Ver 1.0',0
copyright       db      '(C)1990 R Hall'
status          db      0         ; flag to tell if keyboard int is
                                  ; currently being serviced
old_disk_intr   dw      ?,?       ; pointer to old INT 13h
old_keyboard_intr dw    ?,?       ; pointer to old INT 9h
old_dos_write   dw      ?,?       ; pointer to old INT 26h
ident_intr      db      DOS_WRITE
keyboard_status dw      ?

IDENT_LENGTH    equ     OFFSET copyright - OFFSET program_name

;-------------- Resident Procedures ------------------

                include RWP-SWAP.INC    ; proc to swap window & screen
                include RWP-MENU.INC    ; proc to get options from keyboard
                include RWP-INT.INC     ; procs that take over the interrupts

LastByteToSave:                 ; all above this line stays resident,
                                ; all below goes away after termination.

;============================================================================


;-------------- Non-Resident data -----

start_up_msg    db      lf,cr,'Ŀ'
                db      lf,cr,' -=< Resident Write Protect (C)1990 >=- '
                db      lf,cr,'            Version 1.00               '
                db      lf,cr,'            by Randy Hall               '
                db      lf,cr,'  '
                db      lf,cr,'         RWP is now installed           '
                db      lf,cr,'   Press Left shift & Alt to activate   '
                db      lf,cr,''
                db      lf,lf,cr,'$'
already_msg     db      lf,cr,'Ŀ'
                db      lf,cr,'  RWP was already installed.  '
                db      lf,cr,''
                db      lf,lf,cr,'$'
no_ident_warning db     lf,cr,'Ŀ'
                db      lf,cr,'Warning -- Many resident utilities are   '
                db      lf,cr,'already installed.  RWP will not warn you'
                db      lf,cr,'if you install it more than once.        '
                db      lf,cr,''
                db      lf,lf,cr,'$'

;-------------- Non-Resident code -----

beginning:      assume  ds:code
                push    cs                      ; set up segments
                push    ds

;-------------- See if RWP is installed already

                mov     al,free_int1            ;scan the interrupt table
check_loop:     mov     ah,35h                  ;free range for RWP
                int     21h                     ;marker
                cmp     bx,0                    ;see if interrupt is in use
                jne     compare_strings         ;yes, see if it is marker
                mov     cx,es                   ;now check segment
                cmp     cx,0
                jne     compare_strings         ;else, this vector is free
                mov     ident_intr,al           ;remember it
                jmp     cont_loop

compare_strings: mov    di,bx                   ;es:di points to target
                add     di,3                    ;don't look at jump
                mov     si,offset program_name  ;ds:si points to name
                mov     cx,ident_length         ;see if target points to
                repe cmpsb                      ;same string as name
                jcxz    already_installed       ;matched => installed

cont_loop:      inc     al                      ;look at next interrupt
                cmp     al,free_int_last        ;time to stop?
                jne     check_loop              ;no, keep checking
                cmp     ident_intr,DOS_WRITE    ;a free interrupt?
                jne     not_installed           ;yes, so install it

                mov     dx,offset no_ident_warning
                mov     ah,9
                int     21h
                jmp     not_installed

;-------------- Already installed, so print a message and terminate

already_installed: mov  dx,offset already_msg   ;display message
                mov     ah,9
                int     21h
                mov     ax,4C01h                ;indicate error & terminate
                int     21h

;-------------- Not installed, so continue

not_installed:  mov     dx,offset start_up_msg  ;print message that
                mov     ah,9                    ;RWP has been installed
                int     21h

;-------------- Read old interrupts

                mov     al,disk_intr            ;read old disk interrupt
                mov     ah,35h
                int     21h
                mov     old_disk_intr,bx        ;save it
                mov     old_disk_intr+2,es

                mov     al,dos_write            ;read old int
                mov     ah,35h
                int     21h
                mov     old_dos_write,bx        ;save it
                mov     old_dos_write+2,es

                mov     al,keyboard_intr        ;read old int
                mov     ah,35h
                int     21h
                mov     old_keyboard_intr,bx    ;save it
                mov     old_keyboard_intr+2,es

;-------------- Free environment

                mov     ax,environ_addr         ;find environment
                mov     es,ax                   ;free it
                mov     ah,73
                int     21h

;-------------- Redirect interrupts

                mov     dx,offset communicate   ;set up communication
                mov     al,ident_intr           ;identifier interrupt
                mov     ah,25h
                int     21h

                mov     dx,offset new_keyboard  ; redirect keyboard interrupt
                mov     al,keyboard_intr
                mov     ah,25h
                int     21h

                mov     dx,offset new_disk_intr ; redirect disk interrupt
                mov     al,disk_intr
                mov     ah,25h
                int     21h

                mov     dx,offset new_dos_write ; redirect DOS disk
                mov     al,dos_write            ; write interrupt
                mov     ah,25h
                int     21h

;-------------- Terminate and stay resident

                mov     dx,offset LastByteToSave ; keep everything up to
                mov     cl,4                     ; the last resident byte
                shr     dx,cl
                inc     dx
                mov     al,0                    ; no error
                mov     ah,49                   ; terminate
                int     21h

code            ends
                end RWP
