program Colordesk;

{
 CA-DEMO.PAS -- Demonstration for the ColorApp Unit

 Written by Scott F. Earnest (scott@whiplash.res.cmu.edu)


 It's almost the same as a normal application!
}

uses
  ColorApp, App, Objects, Views, Menus, Drivers, Msgbox, Dialogs;

{Command constants}

const
  cmOptionsVideo = 1501;
  cmMessageHello = 1502;
  cmAppAbout     = 1503;

{These are the raw screen images}

procedure data_25_lines; external;
{$L LINES_25}

procedure data_43_lines; external;
{$L LINES_43}

procedure data_50_lines; external;
{$L LINES_50}

{ -- Application Object --------------------------------------------------- }

type
  PDemoApp = ^TDemoApp;
  TDemoApp = object(TColorApplication)
    procedure LoadImages; virtual;
    procedure initmenubar; virtual;
    procedure About; virtual;
    procedure HandleEvent (var Event : TEvent); virtual;
  end;

procedure TDemoApp.LoadImages;

begin
  image25 := @data_25_lines;
  len25 := 2000;
  image43 := @data_43_lines;
  len43 := 3440;
  image50 := @data_50_lines;
  len50 := 4000;
end;

procedure TDemoApp.InitMenuBar;

var
  r : TRect;

begin
  getextent(R);
  R.B.Y := R.A.Y + 1;
  menubar := new(pmenubar, init(R, NewMenu(
    NewSubMenu('~A~ction', hcNoContext, NewMenu(
      NewItem('Toggle ~L~ines', 'F7', kbF7, cmOptionsVideo, hcNoContext,
      NewItem('Say ~H~ello...', 'F8', kbF8, cmMessageHello, hcNoContext,
      NewLine(
      NewItem('About...', 'F1', kbF1, cmAppAbout, hcNoContext,
      NewLine(
      NewItem('E~x~it', 'Alt-X',kbAltX, cmQuit, hcNoContext,
      nil))))))),
    nil)
  )));
end;

procedure TDemoApp.About;

var
  D: PDialog;
  Control: PView;
  R: TRect;

begin
  R.Assign (0,0,40,12);
  D := New(PDialog, Init(R, 'About'));
  with D^ do
  begin
    Options := Options or ofCentered;
    Flags := Flags and not (wfMove or wfGrow or wfZoom or wfClose);
    R.Grow(-1, -1);
    Dec(R.B.Y, 1);
    Insert(New(PStaticText, Init(R,
      #13#3'Color DeskTop Demo'#13#13+
      #3'by Scott F. Earnest'#13+
      #3'(scott@whiplash.res.cmu.edu)'#13#13+
      #3'Screens created with TheDraw(TM)'#13)));
    R.Assign (15,9,25,11);
    Insert(New(PButton, Init(R, 'O~K', cmOk, bfDefault)));
  end;
  if ValidView(D)<>nil then
  begin
    DeskTop^.ExecView(D);
    Dispose(D, Done);
  end;
end;

procedure TDemoApp.HandleEvent (var Event : TEvent);

begin
  inherited HandleEvent (Event);
  if Event.What=evCommand then
    case Event.Command of
      cmOptionsVideo : begin
                         SetScreenMode(ScreenMode xor smFont8x8);
                         ClearEvent (Event);
                       end;
      cmMessageHello : begin
                         messagebox (#3'Hello!  Move me around!'#13,nil,
                                      mfInformation or mfOKButton);
                         ClearEvent (Event);
                       end;
      cmAppAbout     : begin
                         About;
                         ClearEvent (Event);
                       end;
    end;
end;

var
  Appl : TDemoApp;

begin
  Appl.init;
  Appl.About;
  Appl.run;
  Appl.done;
end.