{$A+}
{$B-}
{$D+}
{$E+}
{$F+}
{$I+}
{$L+}
{$N-}
{$O-}
{$R-}
{$S+}
{$V-}
{$M 16384,0,655360}

PROGRAM DelBAK;
{---------------------------------------------------------------------------
  Version     - 0.23
  Purpose     - Find and delete BAK files in any subdirectory. Count
                the deleted files and total the disk space recovered.
  Reference   - Turbo Technix Sept/Oct 1988 p36.
  Language    - Borland International Turbo Pascal 4.xx
  Written by  - Keith S. Brown
  Revised     - 1988.0909 V:0.00 (KSB) Wrote initial version.
              - 1988.1102 V:0.10 (KSB) If No then delete local BAK
              - 1991.0628 V:0.20 (KSB) Revised logic to activate /Q option.
  		Made small fixes for TP5.5 compatibility.
              - 1992.0313 V:0.21 (KSB) Mod'd to delete ReadOnly BAK files.
              - 1992.0316 V:0.22 (KSB) Del RO BAK files no longer default.
              - 1992.0324 V:0.23 (KSB) Fixed bug.
---------------------------------------------------------------------------}
USES
  DOS,      CRT,
  MetaDirE;

CONST
  version= '0.23';

TYPE
  del_Rec= RECORD
    confirm : BOOLEAN;  {confirm each delete if T}
    del_All : BOOLEAN;  {delete all BAK files on disk if T}
    del_RO  : BOOLEAN;  {delete RO if T}
  END {RECORD};

VAR
  path   : STRING;
  errorCode   : BYTE;
  total  : LongINT;
  count  : LongINT;
  Delete : Del_Rec;
  fAttr  : WORD;


{}FUNCTION GetAns:CHAR;
{---------------------------------------------------------------------------
---------------------------------------------------------------------------}
  VAR
    ch   : CHAR;
    valid: BOOLEAN;
  BEGIN
    HighVideo;  Write('Y');
    NormVideo;  Write('es/');
    HighVideo;  Write('N');
    NormVideo;  Write('o/');
    HighVideo;  Write('Q');
    NormVideo;  Write('uit');

    valid := FALSE;
    REPEAT
      ch := UpCase(ReadKey);
      IF ch = #0 THEN
        ch := ReadKey
      ELSE
      IF ch IN ['Y','N','Q',#27] THEN
        valid := TRUE;
    UNTIL valid;

    IF ch = #27 THEN
      ch := 'Q';

    GetAns := ch;
{}END {GetAns};




{}FUNCTION  AttribStr(a:BYTE):STRING;
{---------------------------------------------------------------------------
  Purpose     - Convert a File's attributes to a displayable format.
---------------------------------------------------------------------------}
  CONST
    aStr : STRING[8]    = '  ADVSHR';
  VAR
    s,t  : STRING;
    i    : WORD;
  BEGIN
    t := '';
    i :=  8;
    REPEAT
      IF (a AND $01) = 1 THEN
        t := t + aStr[i];

      Dec(i);
      a := a SHR 1;
    UNTIL a = 0;

    IF Length(t) > 0 THEN
      AttribStr := '['+t+']'
    ELSE
      AttribStr := '';
{}END {AttribStr};




{}PROCEDURE DelFile(VAR s:SearchRec; p:PathStr);
{---------------------------------------------------------------------------
  Revised     - 1991.0628 (KSB) corrected logic.
              - 1992.0313 (KSB) Mod'd to delete protected BAK files.
---------------------------------------------------------------------------}
  VAR
    DFV  : FILE;
    attr : WORD;
  BEGIN
    IF (NOT Delete.del_RO) AND ((s.Attr AND $01) = 1) THEN
      Exit;

    IF Delete.confirm THEN BEGIN
      Write(p+s.NAME:16,'  ',AttribStr(s.attr),'  ');
      CASE GetAns OF
       'N' :
        BEGIN WriteLn; Exit;
        END {BEGIN};
       'Q' : Halt;
      END {CASE};
    END {IF};

    Inc(total,s.Size);
    Inc(count);
    Assign(DFV,p+s.NAME);
    SetFattr(DFV,0);         {zero out attributes}
    Erase(DFV);

    IF NOT Delete.confirm THEN
      WriteLn(p+s.NAME,' (deleted)')
    ELSE
      WriteLn(' (deleted)');
{}END {DelFile};




{}PROCEDURE Validate;
{---------------------------------------------------------------------------
  Revised     - 1991.0628 (KSB) Corrected logic.
              - 1991.0313 (KSB) Revised interface.
              - 1992.0316 (KSB) Changed default.
              - 1992.0324 (KSB) Fixed bug.
---------------------------------------------------------------------------}
  VAR
    p    : BYTE;
    s    : STRING;
    L    : BYTE ABSOLUTE s;
    c    : CHAR;

{}{}PROCEDURE Help;
    BEGIN
      WriteLn('DelBak   - Klingon Software Services -   Version:',version);
      WriteLn('             Copyright 1988..1992');
      WriteLn;
      WriteLn('PURPOSE:');
      WriteLn('   Delete all *.BAK files found in directory or on disk.');
      WriteLn;
      WriteLn('SYNTAX:');
      WriteLn('   DelBAK [/ooo]');
      WriteLn;
      WriteLn('OPTIONS:');
      WriteLn('   Q   query before deleting');
      WriteLn('   A   delete all bak files on disk (except Read Only)');
      WriteLn('   R   delete Read Only BAK files.');
      WriteLn;
      WriteLn('EXAMPLE:');
      WriteLn('   DelBak /QAR    - Search entire disk. Query before delete.');
      WriteLn('                    Delete all BAK files including Read Only BAKs.');
      Halt;
{}{}END {Help};


{}{}FUNCTION GetChar:CHAR;
    BEGIN
      IF L=0 THEN
        GetChar := #255
      ELSE BEGIN
        GetChar := UpCase(s[1]);
        s := Copy(s,2,L);
      END {IF};
{}{}END {GetChar};


  BEGIN
    Delete.confirm := FALSE;
    Delete.del_All := FALSE;
    Delete.del_RO  := FALSE;

    IF (ParamCount > 0) THEN BEGIN
      s := ParamStr(1);
      IF s[1] <> '/' THEN
        Help;

      REPEAT
        c := GetChar;

        CASE c OF
          '/' :;
          'A' : Delete.del_All := TRUE;
      'H','?' : Help;
          'Q' : Delete.confirm := TRUE;
          'R' : Delete.del_RO  := TRUE;
        END {CASE};
      UNTIL L=0;
    END {IF};

    GetDir(0,path);
    IF Length(path) = 2 THEN
      path := path + '\'
    ELSE
      path[0] := #3;

    IF NOT Delete.del_All THEN BEGIN
      Write('Delete ALL *.BAK files in current volume? ');
      CASE GetAns OF
       'N' : Delete.del_all := FALSE;
       'Y' : Delete.del_all := TRUE;         {1992.0324}
       'Q' : Halt;
      END {CASE};
      WriteLn;
    END {IF};
{}END {Validate};




BEGIN
  total   := 0;
  count   := 0;
  Validate;

  IF Delete.del_RO THEN
    fAttr := ReadOnly+Hidden+SysFile+VolumeID+Archive
  ELSE
    fAttr := Hidden+SysFile+VolumeID+Archive;

  IF Delete.del_all THEN
    SearchEngineAll(path,'*.BAK',fAttr, DelFile, errorCode)
  ELSE
    SearchEngine('*.BAK',fAttr,DelFile,errorCode);

  WriteLn;
  WriteLn(count,' *.BAK files deleted, saving ',total:8,' bytes');
END {BEGIN}.
