{
  SPEEDMRK.PAS

  Speed test for the game optimized videoroutines.

  SonicSprites are 34x38 pixels
  Background consists of four 320x320 sprites

  Function
  1. Draw Background Sprites to a virutal page called VirtualPage
  2. Draws 100 transparent Sonics to VirtualPage
  3. Copys VirtualPage to visible screen
  4. starts at with point 1

  Compiler switches:
  - switch all off
  - switch on: FAR calls, WORD, 286 Instructions
               Extendes syntax, typed @ operator, open arrays
               80x87 Code, Emulation

}

program SpeedTest_for_Video13Libary;

uses crt, dos, _Video13, _VideoHi;


const
  maxSonic = 150; { maximum number of sonics }

type
  TSonic =
    record
      x,y    : integer;
      actGFX : byte;    { current sprite grafix }
      speed  : byte;    { sonic speed }
   end;

  TBack  =
    record
      x,y    : integer;
      gfx    : byte;    { background number }
     end;

var
  SonicGFX    : array[1..4] of TSprite; { sonic gfx }
  Sonic       : array[1..maxSonic] of TSonic; { the maxSonic Sonics }

  BackGFX     : array[1..4] of TSprite; { the background gfx }
  Back        : array[1..4] of TBack;   { the type of the background }

  Pal         : TPal;
  VirtualPage : TPage101h;

  actBack     : byte;

  StartTime, EndTime, Frame : Longint;


{ gets the system time }
function GetTime100 : LongInt;
var
  Hour, Minute, Second, Sec100: Word;
  Temp : LongInt;

begin
  GetTime( Hour, Minute, Second, Sec100 );
  Temp := longint( Hour ) * 60 * 60 * 100 +
          longint( Minute ) * 60 * 100 +
          longint( Second ) * 100 +
          Sec100;
  GetTime100 := Temp;
end;


function IntToStr( HelpInt : LongInt ): string;
var
  HelpString : string;
begin
  Str( HelpInt , HelpString );
  IntToStr := HelpString;
end;


procedure InitAll;

var
  b        : byte;
  curSonic : byte;

begin
  InitVideo101h;
  SetVideoMode101h( Mode101h );
  InitPage101h( VirtualPage );
  LoadPalette( '.\PAL\SONIC.PAL', pal );

  for b := 1 to 4 do
    begin
      { Load a CLB-file. Has a filesize limit of 64KB!!! }
      LoadImprocesCLB( '.\TITLE\TITLE' + IntToStr(b) + '.CLB',
                       BackGFX[ b ] );
      Back[ b ].x   := ( b - 1 ) * 320;
      Back[ b ].y   := 0;
      Back[ b ].gfx := b;
    end;

  for b := 1 to 4 do
    LoadImprocesCLB( '.\GFX\SONIC1-' + IntToStr(b) + '.CLB', SonicGFX[ b ] );

  for curSonic := 1 to maxSonic do
    with Sonic[ curSonic ] do
      begin
        x:=random( 640 );
        y:=random( 360 ) + 20;
        actGFX := 1;
        speed := random( 4 ) + 2;
      end;
end;

procedure CloseAll;
var
  b:byte;
begin
  for b := 1 to 4 do CloseSprite( SonicGFX[ b ] );
  for b := 1 to 4 do CloseSprite( BackGFX[ b ] );
  ClosePage101h( VirtualPage );
  CloseVideo101h;
  SetVideoMode101h
  ( Mode3h );
end;

var
  curSonic : byte;

begin
  InitAll;
  SetPalette( Pal );
  ActivePage101h( VirtualPage );

  { init time and frame counter }
  StartTime := GetTime100;
  Frame := 0;

{  setWindow101h(10,10,309,389); { Set the borders of the screen. Try it out }

  repeat
    inc( Frame );
    {ClearPage(VirtualPage);} { this is not necessary since the background
                                Sprites fill the whole screen}
    for actback := 1 to 4 do
      with back[ actBack ] do
        begin
          PutSpriteWindowEff101h( x, y + 20, BackGFX[ gfx ] );
          PutSpriteWindowEff101h( x, y + 220, BackGFX[ gfx ] );
          if x > -320 then
              dec( x, 2 )
            else
              x := 960;
        end;

    for curSonic := 1 to maxSonic do
      with sonic[ curSonic ] do
        begin
          PutSpriteWindowTransEff101h( x, y, 0, sonicGFX[ actGFX ] );
        if actGFX < 4 then
            inc( actGFX )
          else
            actGFX := 1;
        if x < 639 then
            inc( x, speed )
          else

            x := -50;
      end;

    {retrace;} {Waits switched off, in order to get frame rates >70}

    CopyP2V101h(VirtualPage);

  until keypressed;
  ReadKey;

  EndTime := GetTime100;

  CloseAll;

  { display frames/sec and kb/sec }
  WriteLn( ( Frame / ( EndTime - StartTime ) ) * 100 : 5 : 2,
           ' Frames per second' );
  WriteLn( ( 4 * 64000 + 34 * 38 * maxSonic ) *
           ( Frame / ( EndTime - StartTime ) ) * 100 / 1024 : 5 : 2,
           ' KBytes per second' );
  WriteLn( 'plus 300 KByte/Frame for copying virtual page to '+
           'VideoMemory' );
end.