{
  TUTOR2.PAS

  explains the usage of virtual pages
}

uses dos, crt, _Video13, _VideoHi;

var
  sonicGFX : TSprite;   { this is a sprite }
  sonicPAL : TPal;      { this is a 256 color palette }
  Page1    : TPage101h; { this is a virtual page }

  x, y     : integer; { needed for the sonic position }

begin
  { initialise the Video101h variables. Call this procedure first }
  InitVideo101h;

  { load the Sonic-Palette palette }
  loadPalette( '.\PAL\SONIC.PAL', sonicPAL );

  { loads SONIC1-1.CLB to the sonicGFX sprite }
  LoadImprocesCLB( '.\GFX\SONIC1-1.CLB', sonicGFX );

  { initialise the Page1 }
  InitPage101h( Page1 );

  { switch on the 640x480x256 Mode }
  SetVideoMode101h( Mode101h );

  { sets the above loaded palette }
  SetPalette( sonicPAL );

  { all outputs go now to Page1, our first virtual page }
  ActivePage101h( Page1 );

  { initialise the sonic position }
  x := 0;
  y := 0;

  repeat
    { Clears the page Page1; fills it with 0's }
    ClearPage101h( Page1 );

    { draws the sprite sonicGFX to Screenposition x,y }
    PutSpriteWindowEff101h( x, y, sonicGFX );

    SetRGBColor( 0, 0, 0, 0 ); { set background color to black }

    { wait for a verticale retrace of the monitor;
      use this to make smooth scrolling and flicker free animations }
    Retrace;


    SetRGBColor( 0, 30, 0, 0 ); { set background color to middle red }

    { copy the virtual Page Page1 to the VisualPage; also posssible would
      be CopyP2P ( Page1, VisualPage ) }
    CopyP2V101h( Page1 );

    if  x< 639 then { let the sonic doing some movements }
        inc( x, 5 )
      else
        begin
          x := 0;
          inc( y, 5 );
        end;
    if y > 479 then y := 0;

  until keypressed; { draw until a key is pressed }
  ReadKey;

  { gives the page memory back to system }
  ClosePage101h(Page1);

  { gives the sprite memory back to system }
  CloseSprite( sonicGFX );

  { switch back to normal text mode 80x25 }
  SetVideoMode101h( Mode3h );

  { Closes the Video101h. Should be the last instruction in your programm }
  CloseVideo101h;
end.