{
  TUTOR3.PAS

  explains the usage of SetWindow
}

uses dos, crt, _Video13, _VideoHi;

var
  sonicGFX : TSprite;   { this is a sprite }
  titleGFX : TSprite;   { just another sprite }
  sonicPAL : TPal;      { this is a 256 color palette }
  page1    : TPage101h; { this is a virtual page }

  x,y      : integer; { needed for the sonic position }

begin
  { initialise the Video101h variables. Call this procedure first }
  InitVideo101h;

  { load the Sonic-Palette palette }
  loadPalette( '.\PAL\SONIC.PAL', sonicPAL );

  { loads SONIC1-1.CLB to the sonicGFX sprite and
          TITLE1.CLB to the titleGFX sprite }
  LoadImprocesCLB( '.\GFX\SONIC1-1.CLB', sonicGFX );
  LoadImprocesCLB( '.\TITLE\TITLE1.CLB',   titleGFX );

  { initialise the Page1 }
  InitPage101h( Page1 );

  { switch on the 640x480x256 Mode }
  SetVideoMode101h( Mode101h );

  { sets the above loaded palette }
  SetPalette(sonicPAL);

  { all outputs go now to Page1, our first virtual page }
  ActivePage101h( Page1 );

  { initialise the sonic position }
  x := 0;
  y := 0;

  { sets new window borders.
    Usage : SetWindow101h( x1,y1 ,x2,y2);
    (x1, y1) is the upper left point of the window,
    (x2, y2) is the bottom right point of the window. }
  SetWindow101h( 20, 10, 620, 220 );

  repeat
    { Clears the Page Page1; fills it with 0's }
    ClearPage101h(Page1);

    { draws the sprite titleGFX four times on the screen }
    PutSpriteWindowEff101h(   0,  20, titleGFX );
    PutSpriteWindowEff101h( 320,  20, titleGFX );

    { PutSpriteWindowEff101h(   0, 260, titleGFX );
    PutSpriteWindowEff101h( 320, 260, titleGFX ); }
    { we want to draw it in one retrace, even on a 486 }

    { draws the sprite sonicGFX to Screenposition x,y }
    PutSpriteWindowEff101h( x, y, sonicGFX );

    { draws a transparent version of sonic to position 640-x, y }
    PutSpriteWindowTransEff101h( 640 - x, y, 0, sonicGFX );

    SetRGBColor( 0, 0, 0, 0 ); { set background color to black }

    { wait for a verticale retrace of the monitor;
      use this to make smooth scrolling and flicker free animations }
    Retrace;


    SetRGBColor( 0, 30, 0, 0 ); { set background color to middle red }

    { copy the virtual Page Page1 to the VisualPage; also posssible would
      be CopyP2P ( Page1, VisualPage ) }
    CopyP2V101h( Page1 );

    if x < 639 then { let the sonic doing some movements }
        inc( x, 5 )
      else
        begin
          x := 0;
          inc( y, 5 );
        end;
    if y > 479 then y := 0;

  until keypressed; { wait for a key pressed }
  ReadKey;

  { gives the page memory back to system }
  ClosePage101h(Page1);

  { gives the sprite memory back to system }
  CloseSprite( sonicGFX );
  CloseSprite( titleGFX );

  { switch back to normal text mode 80x25 }
  SetVideoMode101h( Mode3h );

  { Closes the Video101h. Should be the last instruction in your programm }
  CloseVideo101h;
end.