{
  TUTOR4.PAS

  shows simple animation of an sonic
}

uses dos,crt, _Video13, _VideoHi;

var
  sonicGFX : array[1..4] of TSprite; { this is a array of sprites }
  titleGFX : TSprite;                { just another sprite }
  sonicPAL : TPal;                   { this is a 256 color palette }
  page1    : TPage101h;              { this is a virtual page }

  x,y        : integer; { needed for the sonic position      }
  phase      : byte;    { current animation phase ( 1 to 4 ) }
  phaseDelay : byte;    { how often shall each phase drawn, before
                          switching to the next one }
  actDelay   : byte;    { how often is the current phase shown? }

  b : byte; { just needed for the loading and closing the sprites }

{ Have a look at the online manual of Turbo/Borland Pascal (Keyword: STR)
  Converts any integer type to a string }
function IntToStr( HelpInt : LongInt ): string;
var
  HelpString : string;
begin
  Str( HelpInt , HelpString );
  IntToStr := HelpString;
end;

begin
  InitVideo101h; {Inits special Video101h variables. Should be called first}
  loadPalette('.\PAL\SONIC.PAL',sonicPAL);        {loads a palette}

  { Load SONIC1's to the array }
  for b := 1 to 4 do
    LoadImprocesCLB( '.\GFX\SONIC1-' + IntToStr( b ) + '.CLB', sonicGFX[ b ] );

  { loads TITLE1.CLB to the titleGFX sprite }
  LoadImprocesCLB( '.\TITLE\TITLE1.CLB',   titleGFX );

  { initialise the Page1 }
  InitPage101h( Page1 );

  { switch on the 640x480x256 Mode }
  SetVideoMode101h( Mode101h );

  { sets the above loaded palette }
  SetPalette(sonicPAL);

  { all outputs go now to Page1, our first virtual page }
  ActivePage101h( Page1 );

  { initialise the sonic position and animation values }
  x := 0;
  y := 0;
  phase      := 1; { current animation phase is 1 }
  phaseDelay := 5; { new animation phase after 5 frames }
  actDelay   := 0; { the current animation phase had been drawn, 0 times }

  repeat
    { Clears the Page Page1; fills it with 0's }
    ClearPage101h(Page1);

    { draws the sprite titleGFX to screenposition 0,0 }
    PutSpriteWindowEff101h(   0,   0, titleGFX );
    PutSpriteWindowEff101h( 320,   0, titleGFX );

    { draws the sprite sonicGFX to Screenposition x,y }
    PutSpriteWindowTransEff101h( x, y, 0, sonicGFX[phase] );

    SetRGBColor( 0, 0, 0, 0 ); { set background color to black }

    { wait for a verticale retrace of the monitor;
      use this to make smooth scrolling and flicker free animations }
    Retrace;

    SetRGBColor( 0, 30, 0, 0 ); { set background color to middle red }

    { copy the virtual Page Page1 to the VisualPage; also posssible would
      be CopyP2P ( Page1, VisualPage ) }
    CopyP2V101h( Page1 );

    if x < 639 then { let the sonic doing some movements }
        inc( x, 5 )
      else
        begin
          x := 0;
          inc( y, 5 );
        end;
    if y > 479 then y := 0;

    { check, if we have to take the next animation phase }
    if actDelay < phaseDelay then
        inc( actDelay ) { no, just increment the delay-Counter }
      else
        begin
          actDelay := 0;  { yes, take the next animation phase }

          { animation reached the end? }
          if phase < 4 then
              inc( phase ) { take the next animation phase }
            else
              phase := 1; { start animation from beginning }
        end;

  until keypressed; { wait for a key pressed }
  ReadKey;

  { gives the page memory back to system }
  ClosePage101h(Page1);

  { gives the sprite memory back to system }
  for b := 1 to 4 do CloseSprite( sonicGFX[ b ] );
  CloseSprite( titleGFX );

  { switch back to normal text mode 80x25 }
  SetVideoMode101h( Mode3h );

  { Closes the Video101h. Should be the last instruction in your programm }
  CloseVideo101h;
end.