{
  TUTOR5.PAS

  How to handle more than just one Sprite?
  How to handle them elegant?
}

uses dos,crt,_Video13,_VideoHi;

type
  TSonic = record
    x,y        : integer; { needed for the sonic position      }
    phase      : byte;    { current animation phase ( 1 to 4 ) }
    phaseDelay : byte;    { how often shall each phase drawn, before
                            switching to the next one }
    actDelay   : byte;    { how often is the current phase shown? }
    speed      : byte;    { how fast is the sonic? }
  end;

var
  sonicGFX : array[1..4] of TSprite; { this is a array of sprites }
  titleGFX : TSprite;                { just another sprite }
  sonicPAL : TPal;                   { this is a 256 color palette }
  page1    : TPage101h;              { this is a virtual page }

  b : byte; { just needed for the loading and closing the sprites }


  { Great Idea. But don't get confused. Sonic and sonicGFX are NOT
    the same }
  Sonic        : array[1..20] of TSonic;

  currentSonic : byte; { counter for the current sonic }

  titleY   : integer;  { start position of TITLE      }
  direction: shortint; { increase or decrease titleY? }


{ Have a look at the online manual of Turbo/Borland Pascal (Keyword: STR)
  Converts any integer type to a string }
function IntToStr( HelpInt : LongInt ): string;
var
  HelpString : string;
begin
  Str( HelpInt , HelpString );
  IntToStr := HelpString;
end;


begin
  { initialise the Video101h variables. Call this procedure first }
  InitVideo101h;

  { load the Sonic-Palette palette }
  loadPalette( '.\PAL\SONIC.PAL', sonicPAL );

  { Load SONIC1's to the array }
  for b := 1 to 4 do
    LoadImprocesCLB( '.\GFX\SONIC1-' + IntToStr( b ) + '.CLB', sonicGFX[ b ] );

  { loads TITLE1.CLB to the titleGFX sprite }
  LoadImprocesCLB( '.\TITLE\TITLE1.CLB',   titleGFX );

  { initialise the Page1 }
  InitPage101h( Page1 );

  { switch on the 640x400x256 Mode }
  SetVideoMode101h( Mode101h );

  { sets the above loaded palette }
  SetPalette(sonicPAL);

  { all outputs go now to Page1, our first virtual page }
  ActivePage101h( Page1 );

  { initialise the 20 sonics }
  for currentSonic := 1 to 20 do
    begin
      Sonic[ currentSonic ].x          := random( 640 );
      Sonic[ currentSonic ].y          := random( 400 );
      Sonic[ currentSonic ].phase      := 1 + random( 4 );
      Sonic[ currentSonic ].phaseDelay := 5;
      Sonic[ currentSonic ].actDelay   := 0;
      Sonic[ currentSonic ].speed      := 4 + 4 * random( 4 );
    end;

  titleY    := 0; { current title Y - Position is 0 }
  direction := 4; { move title screen down }

  repeat
    { Clears the Page Page1; fills it with 0's }
    ClearPage101h( Page1 );

    { draws the sprite titleGFX to screenposition 0,0 }
    PutSpriteWindowEff101h(   0,  40, titleGFX );
    PutSpriteWindowEff101h( 320,  40, titleGFX );

    PutSpriteWindowEff101h(   0, 240, titleGFX );
    PutSpriteWindowEff101h( 320, 240, titleGFX );

    { draw the 20 sonics }
    for currentSonic := 1 to 20 do
      PutSpriteWindowTransEff101h(
        Sonic[ currentSonic ].x, Sonic[ currentSonic ].y,
        0, sonicGFX[ Sonic[ currentSonic ].phase ] );

    { draw another title above the sonics at 0,titleY.
      Nice effect :-) }
    PutSpriteWindowEff101h( 0, titleY, titleGFX );
    PutSpriteWindowEff101h( 320, 280 - titleY, titleGFX );
    TitleY := TitleY + direction; { make the title move }
    if titleY = -200 then direction :=  4; { move down }
    if titleY =  480 then direction := -4; { move up }

    { wait for a verticale retrace of the monitor;
      use this to make smooth scrolling and flicker free animations }
    Retrace;

    { copy the virtual Page Page1 to the VisualPage; also posssible would
      be CopyP2P ( Page1, VisualPage ) }
    CopyP2V101h( Page1 );

    { move the 20 sonics }
    for currentSonic := 1 to 20 do
      { the "with" command makes it more easier to acces the currentSonic
      for detailed information see the online manual of Turbo/Borland
      Pascal (Keyword: WITH) }
      with Sonic[ currentSonic ] do
        begin
          if x < 639 then     { make the current Sonic move }
              inc( x, speed )
            else
              x := -30;
          { change the animations phase if necessary }
          if actDelay < phaseDelay then
              inc( actDelay )
            else
              begin
                actDelay := 1;
                if phase < 4 then
                    inc( phase )
                  else
                    phase := 1;
              end;
        end;

  until keypressed; { wait for a key pressed }
  ReadKey;

  { gives the page memory back to system }
  ClosePage101h( Page1 );

  { gives the sprite memory back to system }
  for b := 1 to 4 do CloseSprite( sonicGFX[ b ] );
  CloseSprite( titleGFX );

  { switch back to normal text mode 80x25 }
  SetVideoMode( Mode3h );

  { Closes the Video101h. Should be the last instruction in your programm }
  CloseVideo101h;
end.