{
  _BIGLOAD.PAS : Shareware-version.

         -  put all files in a huge one
         -  Supports Real Mode and Protected Mode.
         -  easy to use
         -  handles each type of file
         -  supports seek on text files

  (c) vIRtECH 1996

  Version 2.0

  Distribition via any media is explicit allowed.

  DISCLAIMER:

  We give no warranty for this code, because it was firstly coded for us,
  and not for the public.
  But after lot of people asking us for releasing the source, we decided,
  to make it as unit avialable.
  But however, I really don't think that there is a bug in this unit.
  We use this videosystem in our own productions for years without
  any problems.

  for more information, questions and register contact us:

    Ansgar Scherp
    scherp.ansgar@informatik.uni-oldenburg.de

    Joachim Gelhaus
    j.gelhaus@flight.gun.de

    http://www.informatik.uni-oldenburg.de/~virtech/

    Mailbox : + 49 (0) 4441 / 851887
    Hotline : + 49 (0) 4441 / 851717 (english, german)

  Use : Just put before the normal I/O-Functions like Reset, BlockRead,
        Close,... the word "Big".
        Reset will than be BigReset and BlockRead will be BigBlockRead.
        You have also to specify a input stream number for each opened
        file of the BigFile.

  Examples :
    BigAssign( 1, 'HALLO.TXT' );
    BigReset( 1, 0 );
    BigReadB( 1, b );

}

unit _BigLoad;

interface

const
  { maximum number of opened files }
  MaxOpenedFiles =   4; { four should be enoguh for everyone :-) }

  MaxFiles       =  25; { maximum Number of files when index
                          shall be loaded into memory }
  MaxNameLength  =  40; { maximum length of the filenames, like
                          ".\LEVEL\DESIGN\DATA.OUT" }

type
  { shall the index read from disk or loaded into memory? }
  THandleIndex = ( IndexFromMemory, IndexFromDisk );
  { maximum length of filename plus path }
  FileString = String[MaxNameLength];

{ *** PROCEDURES, TO READ FROM A BIGFILE *** }

{ Attention:
  The variable filenr must have a value between 1 and MaxOpenedFiles and
  spezifies the stream-number you want to read from }

{ use this procedure to initialises the BigFile; HI has the value
  IndexFromMemory or IndexFromDisk }
procedure BigFileInit( name: FileString; HI : THandleIndex );
{ use this procedure to close the BigFile }
procedure BigFileClose;

{ checks if a file with the specified name exists in the opened BigFile }
function  BigFileExists( Name:FileString ):boolean;
{ returns the size of the currently openend file of stream filenr }
function  BigFileSize( filenr:byte ):longint;
{ like the pascal command Assign, but requires a stream number filenr;
  opens a file for reading }
procedure BigAssign(filenr:byte;Name:FileString );
{ sets the fileposition-pointer of the file opened with BigAssign to the
  beginning of the file }
procedure BigReset( filenr:byte; size : longint );
{ reads from stream number filenr to the buffer (2nd parameter; pointer) a
  specified number of bytes (3rd parameter; length). In the 4th parameter
  (wordl) you'll find the number of bytes really read from file. }
procedure BigBlockRead( filenr:byte; var pointer; length : longint;
                                                  var wordl : word );
{ checks, if we have already reached the file end }
function  BigEOF( filenr:byte ):boolean;
{ seek in the current stream at position BigSeek_i }
procedure BigSeek( filenr:byte ; BigSeek_i:longint);
{ reads a byte from specified input stream }
procedure BigReadB( filenr:byte; var byte );
{ reads a string from specified input stream }
procedure BigReadS( filenr:byte; var BigReadSs : String );
{ closes a file of the BigFile by closing its input stram filenr }
procedure BigClose( filenr:byte );

{ *** PROCEDURE TO CREATE A BIGFILE *** }
{ open a file with the name filename for creating a new BigFile }
procedure BigFileCreateOpen( FileName : FileString );
{ closes the file containing a BigFile }
procedure BigFileCreateClose;
{ adds the files specified by the directory and file name to the
  BigFile; also allows wildcards }
procedure Add2BigFile( DirName, FileName : FileString );
{ adds the temporary indexfile to the bigfile }
procedure AddIndex2BigFile;

{ For detailed information have a look at the online manual of your
  Turbo/Borland Pascal. }

implementation

uses dos;

const
  { only for temporary usage }
  TempIndexFileName = 'INDEXTMP.$$$';

type
  TIndex =
    record
      FileName  : FileString; { Path and Name of the file }
      FileStart : longint;    { starting position in the Bigfile }
      FileSize  : longint;    { the size of the file }
    end;
  TIndexArray = array[1..MaxFiles] of TIndex;

var
  BigF       : file; { *** for I/O from/to BigFile *** }
  IndexF     : file of TIndex; { *** for O to temp. Indexfile *** }

  IndexSet   : ^TIndexArray; { *** the index-array *** }
  IndexCount : word;

  Index      : TIndex; { *** the index-array *** }

  IndexStart  : Longint; {ab hier startet das IndexFile}
  HandleIndex : THandleIndex;

  ActFile :
    record
      Size  : array[1..MaxOpenedFiles] of longint;  {Gre des Files}
      Pos   : array[1..MaxOpenedFiles] of longint;  {Position. NICHT die reale im BIGFile}
      Start : array[1..MaxOpenedFiles] of longint;  {Realer Start im BIGFile}
      Ende  : array[1..MaxOpenedFiles] of longint;  {Reales Ende im BIGFile}
    end;

  BigFileName      : FileString;

  Help : word;

  CopiedFiles : LongInt;

procedure BigFileInit(name:FileString; HI : THandleIndex );
begin
 HandleIndex := HI;
 {}
 if pos('.',name) = 0 then
     BigFileName := name + '.WAD'
   else
     BigFileName := name;
 {$I-} assign(BigF,BigFileName); reset(BigF,1); {$I+}
 if IOResult<>0 then
   begin
     writeln('FileSystem error: ',BigFileName);
     halt(0);
   end;
 {}
 seek( BigF, filesize(Bigf)-SizeOf( Indexstart ) );
 blockread( BigF , IndexStart , SizeOf( indexStart ) );
 {}
 if HandleIndex = IndexFromMemory then
     begin { *** LOAD Index to memory *** }
       New( IndexSet );
       Seek( BigF, IndexStart );
       IndexCount := 0;
       {}
       repeat
         inc( IndexCount );
         if IndexCount > MaxFiles then
           begin
              writeln('FileSystem error: Maximum files in BigFile exceded.');
              halt(0);
           end;
         {$I-}
         Blockread( BigF, IndexSet^[IndexCount] , SizeOf( Index ) );
         {$I+}
       until IOResult <> 0;
       Dec( IndexCount );
       Writeln('BigFileSystem initialized and index of ',IndexCount,
               ' files loaded to memory ...');
     end
   else Writeln('BigFileSystem initialized ...');
end;

procedure BigFileClose;
begin
  if HandleIndex = IndexFromMemory then
    Dispose( IndexSet );
  close( bigf );
end;

function BigFileExists(Name:FileString):boolean;
var i:byte;
begin
  for i := 1 to Length(Name) do
    Name[i] := UpCase(Name[i]);
  {}
  Case HandleIndex of
    IndexFromDisk :
      begin
        Seek( BigF, IndexStart );
        repeat
          Blockread( BigF, Index , SizeOf( Index ) );
        until ( Eof( BigF ) ) or ( Index.FileName = Name );
        if Index.FileName = Name then
            BigFileExists:=TRUE
          else
            BigFileExists:=FALSE;
      end;
    IndexFromMemory :
      begin
        Help := 0;
        repeat
          inc( Help );
        until ( Help > IndexCount ) or ( IndexSet^[Help].FileName = Name );
        if IndexSet^[Help].FileName = Name then
            BigFileExists := TRUE
          else
            BigFileExists := FALSE;
      end;
  end;
end;

procedure BigAssign(filenr:byte;Name:FileString);
var i:byte;
begin
  for i := 1 to Length(Name) do
    Name[i] := UpCase(Name[i]);
  {}
  Case HandleIndex of
    IndexFromDisk :
      begin
        seek(bigf,indexstart);
        repeat
          blockread(bigf, Index , sizeof( Index ));
        until (eof(bigf)) or ( Index.filename=Name);

        Actfile.Start[filenr] := Index.FileStart;
        Actfile.Size[filenr]  := Index.FileSize;
        Actfile.Ende[filenr]  := Actfile.Start[filenr]+Actfile.Size[filenr];
      end;
    IndexFromMemory :
      begin
        Help := 0;
        repeat
          inc( Help );
        until ( Help > IndexCount ) or ( IndexSet^[Help].FileName = Name );

        Actfile.Start[filenr] := IndexSet^[Help].FileStart;
        Actfile.Size[filenr]  := IndexSet^[Help].FileSize;
        Actfile.Ende[filenr]  := Actfile.Start[filenr]+Actfile.Size[filenr];
      end;
  end;
end;

procedure BigReset( filenr:byte; size : longint );
begin
  Actfile.Pos[filenr]:=0;
  seek(bigf,Actfile.Start[filenr])
end;

procedure BigBlockRead(filenr:byte;var pointer;length:longint;var wordl:word);
begin
  if Actfile.Pos[filenr] + length > Actfile.Size[filenr] then
    length := Actfile.Size[filenr] - Actfile.Pos[filenr] + 1;

  seek(bigf,Actfile.Start[filenr]+Actfile.Pos[filenr]);
  blockread(bigf,pointer, length);
  inc(Actfile.Pos[filenr],length);
  wordl:=length;
end;

function BigEOF(filenr:byte):boolean;
begin
  if Actfile.Pos[filenr]>=Actfile.Size[filenr] then BigEOF:=true else BigEOF:=false;
end;

procedure BigSeek(filenr:byte; BigSeek_i:longint);
begin
  Actfile.Pos[filenr]:=BigSeek_i;
end;

procedure BigReadB(filenr:byte; var byte);
var BigReadBbr:word;
begin
  BigBlockRead(filenr, byte, 1, BigReadBbr);
end;

procedure BigReadS(filenr:byte; var BigReadSs: String);
var BigReadSb:byte;
begin
  BigReadSs:='';
  repeat
    BigReadB(filenr,BigReadSb);
    BigReadSs:=BigReadSs+chr(BigReadSb);
   until (BigReadSb=$0A) or (BigEOF(filenr));
  {NEU!!!}
  BigreadSs[0] := chr(length(bigreadss)-2);
end;

function BigFileSize(filenr:byte):longint;
begin
  BigFileSize:=Actfile.Size[filenr];
end;

procedure BigClose(filenr:byte);
begin end;

{ *************************************************************************
    Die Routinen zum Erzeugen eines BigFiles, schreiben von Dateien usw...
  ************************************************************************* }

{Modifizierte Version aus dem _BIGLOAD-Systems}
procedure BigFileCreateOpen( FileName : FileString );
begin
  writeln('Initialising Bigfile "', FileName,'"...');
  {}
  if pos( '.' , FileName ) = 0 then
      BigFileName := FileName + '.WAD'
    else
      BigFileName := FileName;
  assign ( BigF   , BigFileName);
  rewrite( BigF   , 1 );
  assign ( Indexf , TempIndexFileName );
  rewrite( IndexF );
  CopiedFiles := 0;
end;

procedure BigFileCreateClose;
begin
  close( BigF );
  close( Indexf );
end;

procedure Add2BigFile( DirName, FileName : FileString);

var
  DirInfo : SearchRec;

  procedure CopyToBigFile;
  var
    FromF: file;
    NumRead, NumWritten: Word;
    Buf: array[1..2048] of Char;
  begin
    Inc( CopiedFiles );
  {  Assign(FromF, DirInfo.Name); { Open input file }

    Assign(FromF, Index.Filename);
    Reset(FromF, 1);  { Record size = 1 }
    Writeln('Copying ', DirInfo.Name, ' ',FileSize(FromF), ' bytes...');
    repeat
      BlockRead(FromF, Buf, SizeOf(Buf), NumRead);
      BlockWrite(BigF, Buf, NumRead, NumWritten);
    until (NumRead = 0) or (NumWritten <> NumRead);
    Close(FromF);
  end;

begin
  writeln('Scanning for ', DirName + FileName );
  FindFirst( DirName + FileName , Archive, DirInfo);
  while DosError = 0 do
  begin
    Index.Filename:= DirName + DirInfo.Name;
    Index.FileSize:= DirInfo.Size;
    Index.FileStart:=filepos(bigf);
    write( IndexF,Index );
    CopyToBigFile;
    FindNext(DirInfo);
  end;
end;

procedure AddIndex2BigFile;
  var groesse : longint;
      satz : TIndex;
begin
  writeln('Adding "',TempIndexFileName,'" to BigFile...');
  { hole bigfilegroesse }
  Assign( BigF , BigFileName );
  Reset( BigF , 1 );
  groesse := FileSize( BigF );
  { gehe ans ende }
  Seek( BigF , groesse );
  { oeffne indexfile }
  Assign(IndexF,TempIndexFileName);
  Reset(IndexF);
  { und kopiere es hinten dran }
  while not eof(IndexF) do
    begin
      Read( IndexF, satz);
      BlockWrite(BigF, satz, SizeOf(satz));
    end;
  BlockWrite(BigF, groesse, SizeOf(groesse));
  { und alles zu machen }
  Close(BigF);
  Close(IndexF);
  Erase( IndexF );
  {}
  Writeln('Wrote ', CopiedFiles, ' Files to "', BigFileName,'".');
end;


end.