{ _DPMI - Low-level DOS Protected-Mode Interface Libary
  (c) vIRtECH 1995 Joachim Gelhaus, Ansgar Scherp

1.1 - Supported Procedures/Functions (and finally the work :-)):
      ClearRealRegs(Var RealRegs : TRealModeRegs) ;
      SimRealModeInt( IntNo : Byte ; Var RealRegs   : TRealModeRegs) : boolean;
      GetSimRealModeIntError:string;
      AllocateLowMem(Var Pt : TLowMemoryBlock ; Size : Word);
      FreeLowMem(Var Pt : TLowMemoryBlock) ;
      DisplayDPMIInfo;

      FOLLOWING ARE NOT TESTED YET! DON'T USE THEM!!!!
      SetProtectedIntVec(No : Byte ; p : Pointer) ;
      GetProtectedIntVec(No : Byte ; Var p : Pointer) ;
      HugeAdr(Selector : Word ; Ofst : LongInt) : Pointer ;
}

UNIT _DPMI;

INTERFACE

uses WinApi;

Type {hier kommen die Registerwerte fr die RealModeRegister rein}
  TRealModeRegs =
    Record
      Case Integer Of
        0: ( EDI, ESI, EBP, EXX, EBX, EDX, ECX, EAX: Longint;
             Flags, ES, DS, FS, GS, IP, CS, SP, SS: Word) ;
        1: ( DI,DIH, SI, SIH, BP, BPH, XX, XXH: Word;
             Case Integer of
               0: (BX, BXH, DX, DXH, CX, CXH, AX, AXH: Word);
               1: (BL, BH, BLH, BHH, DL, DH, DLH, DHH,
                   CL, CH, CLH, CHH, AL, AH, ALH, AHH: Byte));
    End ;

 { TLowMemoryBlock is used to point to a memory area within the first
    megabyte, which can thus be accessed both in protected and real mode. }
  TLowMemoryBlock     =
    Record
      ProtModePtr : Pointer;    { pointer valid in protected mode }
      ProtModeSel : Word;  { Selector valid in protected mode }
      ProtModeOfs : Word;  { offset valid in PM // always 0! }

      RealModePtr : Pointer;    { this Pointer is valid in real mode}
      RealModeSeg : Word ;      { segment valid in real mode (ofs=0) }
      RealModeOfs : Word ;      { offset valid in RM // Always 0! }

      BlockSize   : Word ;      { size of allocated memory area }
     End ;

{ Wird dazu benutzt einen LONGINT?/Pointer/DWORD? in zwei Words zu
  konvertieren, d.h. z.b. aus einem ProtectedMode Pointer den dazu-
  gehrigen Selector und den Offsetwert zu bestimmen }
  TDWord =
    Record
      {ACHTUNG: Scheinbar wird ein Pointer mit LO-WORD,HI-WORD abgelegt}
      Lo, Hi    : Word ;
    End ;

var SimRealModeIntErrorCode : word; {error-code of last realmodeint}

{Alle procedure/functions}
Procedure ClearRealRegs(Var RealRegs : TRealModeRegs) ;

Function SimRealModeInt( IntNo : Byte ; Var RealRegs   : TRealModeRegs) : boolean;
function GetSimRealModeIntError:string;

Procedure AllocateLowMem(Var Pt : TLowMemoryBlock ; Size : Word);
Procedure FreeLowMem(Var Pt : TLowMemoryBlock) ;

procedure DisplayDPMIInfo;

Procedure SetProtectedIntVec(No : Byte ; p : Pointer) ;
Procedure GetProtectedIntVec(No : Byte ; Var p : Pointer) ;

Function  HugeAdr(Selector : Word ; Ofst : LongInt) : Pointer ;


IMPLEMENTATION

Procedure ClearRealRegs(Var RealRegs : TRealModeRegs) ;
Begin
  FillChar(RealRegs, SizeOf(RealRegs), 0) ;
End ;

{ Important notes :
  - If SS and SP are set to 0, the DPMI server will provide a 30 bytes stack
  - Calling ClearRealRegs before initializing registers used for a
    RealModeInt sets SS ans SP to 0. }
Function SimRealModeInt( IntNo : Byte ; Var RealRegs   : TRealModeRegs) : boolean;
Assembler ;
Asm
  Mov  AX, $0300
  Mov  BL, IntNo {interrupt number}
{	BH = flags
	    bit 0: reset the interrupt controller and A20 line (DPMI 0.9)
		   reserved, must be 0 (DPMI 1.0+)
	    others must be 0}
  XOR  BH, BH
  XOR  CX, CX { number of words to copy from protected mode to real mode stack}
  LES  DI, RealRegs { selector:offset of real mode call structure (see below)}

  Int  $31

{  Return:
   - CF clear if successful
     real mode call structure modified (all fields except SS:SP, CS:IP
     filled with return values from real mode interrupt)
   - CF set on error
     AX = error code (DPMI 1.0+) (8012h,8013h,8014h,8021h)(see AX=0000h)
     protected mode stack unchanged}
  JNC  @Ok
    mov SimRealModeIntErrorCode, ax
    mov ax, false
  @Ok:
  mov ax, true {no error}
End ;

Procedure AllocateLowMem(Var Pt : TLowMemoryBlock ; Size : Word);
var adr:longint;
Begin
{Der Rckgabewert enthlt einen Paragraphsegmentwert in seinem
 hherwertigen und einen Selektor in seinem niederwertigen WORD. Eine
 Anwendung kann den Wert des Paragraphsegments im Real-Modus bzw. den
 Selektor im Protected-Modus dazu benutzen, auf Speicher zuzugreifen. Wenn
 Windows kein Speicherobjekt der geforderten Gre reservieren kann, wird 0
 zurckgegeben.}
     Adr:=GlobalDOSAlloc(Size) ;
     If Adr=0 Then Size:=0 ;

     Pt.ProtModePtr := Ptr(TDWord(Adr).Lo, 0) ;
     Pt.ProtModeSel := TDWord(Adr).Lo;
     Pt.ProtModeOfs := 0;

     Pt.RealModePtr := Ptr(TDWord(Adr).Hi, 0) ;
     Pt.RealModeSeg := TDWord(Adr).Hi ;
     Pt.RealModeOfs := 0;

     Pt.BlockSize:=Size ;
End ;

Procedure FreeLowMem(Var Pt : TLowMemoryBlock) ;
Begin
 { GlobalDOSFree(Pt.ProtModeSel) ;}
  GlobalDOSFree(Seg(Pt.ProtModePtr^));
  FillChar(Pt, SizeOf(Pt), 0) ;           { Fills with NIL }
End ;

procedure DisplayDPMIInfo;
var flags : longint;
begin
  writeln('DOS Protected Mode Interface Information:');
  flags := GetWinFlags;
  if (flags and wf_PMode) = wf_PMode then writeln('Running under protected mode.');
  if (flags and wf_CPU086) = wf_CPU086 then writeln('System CPU : 8086 ');
  if (flags and wf_CPU186) = wf_CPU186 then writeln('System CPU : 80186 ');
  if (flags and wf_CPU286) = wf_CPU286 then writeln('System CPU : 80286 ');
  if (flags and wf_CPU386) = wf_CPU386 then writeln('System CPU : 80386 ');
  if (flags and wf_CPU486) = wf_CPU486 then writeln('System CPU : 80486 ');
  if (flags and wf_80x87 ) = wf_80x87 then writeln('Numerical coprocessor found.');
  if (flags and wf_Standard) = wf_Standard then writeln('Running in Standard-Mode.');
  if (flags and wf_Enhanced ) = wf_Enhanced then writeln('Running in Enhanced-Mode.');
  if (flags and wf_LargeFrame) = wf_LargeFrame then writeln(' Windows-EMS: Large-Frame-Configuration ');
  if (flags and wf_SmallFrame) = wf_SmallFrame then writeln(' Windows-EMS: Small-Frame-Configuration ');
end;

function GetSimRealModeIntError:string;
var t : string;
begin
  t := '';
  case SimRealModeIntErrorCode of
     $0000..$7FFF : t :='DOS error passed through by DPMI';
     $8001	: t :='unsupported function';
     $8002	: t :='object in wrong state for function';
     $8003	: t :='system integrity would be endangered';
     $8004	: t :='deadlock detected';
     $8005	: t :='pending serialization request cancelled';
     $8010	: t :='out of DPMI internal resources';
     $8011	: t :='descriptor unavailable';
     $8012	: t :='linear memory unavailable';
     $8013	: t :='physical memory unavailable';
     $8014	: t :='backing store unavailable';
     $8015	: t :='callback unavailable';
     $8016	: t :='handle unavailable';
     $8017	: t :='maximum lock count exceeded';
     $8018	: t :='shared memory already serialized exclusively by another';
     $8019	: t :='shared memory already serialized shared by another client';
     $8021	: t :='invalid value for numeric or flag parameter';
     $8022	: t :='invalid segment selector';
     $8023	: t :='invalid handle';
     $8024	: t :='invalid callback';
     $8025	: t :='invalid linear address';
     $8026	: t :='request not supported by hardware';
  end;
end;

Procedure SetProtectedIntVec(No : Byte ; p : Pointer) ; Assembler ;
Asm
     Mov  AX, $0205
     Mov  BL, No
     Mov  CX, TDWord[p].Hi        { Selector }
     Mov  DX, TDWord[p].Lo        { Offset }
     Int  $31
End ;

Procedure GetProtectedIntVec(No : Byte ; Var p : Pointer) ; Assembler ;
Asm
     Mov  AX, $0204
     Mov  BL, No
     Int  $31
     LES  DI, p
     { Mov  ES:[DI], DX }
     { Mov  ES:[DI+2], CX }
     Mov  TDWord[ES:DI].Lo, DX
     Mov  TDWord[ES:DI].Hi, CX
End ;

Function  HugeAdr(Selector : Word ; Ofst : LongInt) : Pointer ;
Assembler ;
Asm
     Mov  AX, SelectorInc

     Mul  TDWord[Ofst].Hi

     Add  AX, Selector             { First selector of bloc }
     Mov  DX, AX                   { New selector }

     Mov  AX, TDWord[Ofst].Lo     { Low word of offset is the same }
End ;

end.