{
  _VIDEO13.PAS

	 -  Fast video-unit especially for games.
	 -  Supports Real Mode and Protected Mode.
	 -  Use virtual screen as many as you like ( you memory have )
	 -  Set window-borders for easy drawing
	 -  Over 80(!) functions included
	 -  Freeware
	 -  Now includes BigFileSupport and Spritescaling!
	 -  Some minor and major bugs fixed ( hope so )

  This software is freeware !

  (c) vIRTUAL tECHNOLOGIES 1997

  Version 7.0a

  Distribition via any media is explicit allowed.

  DISCLAIMER:

  We give no warranty for this code, because it was firstly coded for us,
  and not for the public.
  But after lot of people asking us for releasing the source, we decided,
  to make it as unit avialable.
  But however, I really don't think that there are any bugs in this unit.
  We use this videosystem in our own productions for years without
  any problems.

  for more information, questions and register contact us:

    Ansgar Scherp
    scherp.ansgar@informatik.uni-oldenburg.de

    Joachim Gelhaus
    j.gelhaus@flight.gun.de

    http://www.informatik.uni-oldenburg.de/~virtech/

    Mailbox : + 49 (0) 4441 / 851887
    Hotline : + 49 (0) 4441 / 851717 (english, german)

  To create your own Sprites, Backgrounds... , we decided to included routines
  to load clipboard files and palette files as used by the shareware painting
  program Improces by John Wagner.
  LoadPCX and SavePCX routines for loading and saving a page from/to disk are
  also included.

}

unit _Video13;

interface

uses _BigLoad;

type
  { Typedefinition of a Sprite:
    word    : Sprite width
    word    : Sprite height
    pointer : Pointer to Sprite data }
  TSprite =
    record
      b,             {  width of a Sprite  }
      t   : word;    {  height of a Sprite  }
      Mem : pointer;
    end;

  { Palettetype }
  TPal =
    record r,g,b : Array[0..255] of byte; end;

  { the virtual Pagetype }
  TPage = Pointer;

const
  {  Videomode constants  }
  Mode13h : word = $13; { MCGA-Mode 320x200x256 }
  Mode3h  : word = $3;  { TextMode }

var
  { these are equal with the visual Page SegA000:0 }
  Page0,
  VisualPage : Pointer; { ready for use with each procedure/function }

const
  wx1 : integer = 0;   { the borders of the current window }
  wx2 : integer = 319;
  wy1 : integer = 0;
  wy2 : integer = 199;

var
  TransparentColor : Byte; { used by VideoHi }
  ActVPage : TPage; { current active virtual page }

{ initialise/close Video13hSystem }
procedure InitVideo13h;
procedure CloseVideo13h;

{ display an error message }
procedure Video13hError(t:string);

{ set the ActivePage, on which you want to draw }
procedure ActivePage(page : pointer);

{ set a video mode; Mode13h ($13) is for MCGA-Mode 320x200x256 }
procedure SetVideoMode(mode:word);

{ set window-edges of ActivePage }
procedure SetWindow(x1,y1,x2,y2:integer);

{ set the background color; r,g,b mean red,yellow, blue and their value
  is between 0-63 }
procedure SetBKGColor(r,g,b:byte);
{ set one color directly }
procedure SetRGBColor(co,r,g,b:byte);
{ fading one color directly }
procedure SetRGBColorFade(co,r,g,b:byte; VideoFade : byte);
{gets a color of the current Palette}
procedure GetRGBColor(co:integer; var r,g,b:byte);

{ set a whole palette }
procedure SetPalette( var pal : TPal);
{ set a totally black palette }
procedure SetZeroPalette;
{ use to fade a palette }
procedure SetPalettePerCent(var pal:TPal; pc:byte);
{gets the whole palette}
procedure GetPalette( var pal : TPal);

{ waits for a vertical retrace }
procedure Retrace;

{ copy a virtual screen to another virtual screen or to visual screen }
procedure CopyP2P(Src,Dst:pointer);
{ copy a virtual screen to visual screen }
procedure CopyP2V(src:Pointer);

{ clears a screen }
procedure ClearPage(dst:pointer);
{ clears the visual page }
procedure ClearVisualPage;

{ initialies a new virtual page }
procedure InitPage(VAR page : pointer);
{ closes a virtual page }
procedure ClosePage(page : pointer);

{ initialise a sprite; max. 64Kb huge! }
procedure InitSprite(VAR p : TSprite; b,t : word);
{ resets sprite a sprite }
procedure ResetSprite(VAR p : TSprite);
{ closes a sprite; does exactly the same as ResetSprite }
procedure CloseSprite(VAR p : TSprite);

{ load sprite from disk }
procedure LoadSprite(name : string; VAR p : TSprite);
{ save sprite to disk }
procedure SaveSprite(name : string; p : TSprite);

{ loads an ImprocesClipboard-Image }
procedure LoadImprocesCLB(name : string; VAR p : TSprite);
{ save a sprite as an ImprocesClipboard-Image }
procedure SaveImprocesCLB(name : string; p : TSprite);

{ load an Improces-Palette }
procedure LoadClipboardPal(name:string; VAR pal : TPal);

{ loads a palette }
procedure LoadPalette(name:string; VAR pal : TPal);
{ saves a palette }
procedure SavePalette(name:string; pal : TPal);

{ put a pixel to active screen }
procedure PutPixel(x,y : word; c : byte);
{ puts a pixel on current active screen looking for window-borders }
procedure PutPixelWindow(x,y:longint; col:byte);
{ puts a pixel to a Sprite}
procedure PutPixel2Sprite(p:TSprite; x,y : integer; c : byte);
{ gets a pixel from active screen }
function  GetPixel(x,y : word):byte;
{gets a Pixel from a Sprite}
function GetPixelfromSprite(x,y:integer; var p:TSprite):byte;

{ put/get a sprite using byte IO // the slowest but works with all
  sprite sizes }
procedure PutSpriteB(x,y : word; p: TSprite);
procedure GetSpriteB(x,y : word; p: TSprite);

{ put/get a sprite using word IO // two times faster as Put/GetSpriteB,
  but sprites-width MUST be devideable by 2 }
procedure PutSpriteW(x,y : word; p: TSprite);
procedure GetSpriteW(x,y : word; p: TSprite);

{ put/get a sprite using dword IO // two times faster as Put/GetSpriteW,
  but sprites-width MUST be devideable by 4 }
procedure PutSpriteD(x,y : word; p: TSprite);
procedure GetSpriteD(x,y : word; p: TSprite);

{ put/get a sprite on active screen looking for window-borders;
  using byte IO }
procedure PutSpriteWindow(x,y : integer; p: TSprite);
procedure GetSpriteWindow(x,y : integer; p: TSprite);

{ puts a sprite on active screen looking for window-borders;
  using word IO; sprite must be devideable by 2 }
procedure PutSpriteWindowW(x,y : integer; p: TSprite);
{ puts a sprite on active screen looking for window-borders;
  using word IO; sprite must be devideable by 4 }
procedure PutSpriteWindowD(x,y : integer; p: TSprite);
{ puts a sprite VERY fast on active screen looking for window-borders;
  uses dword IO as long as possible; works with EVERY spritesize }
procedure PutSpriteWindowEff( x,y : integer; p : TSprite );

{ same a PutSprite..., but can draw transparent sprites...
  this is using byte IO}
procedure PutSpriteTrans(x,y : word; trans:byte; p: TSprite);
{ using byte IO; checking for window-borders }
procedure PutSpriteWindowTrans(x,y : integer; trans : byte; p : TSprite);
{ using word IO; checking for window-borders; spritesize must be
  devideable by 2 }
procedure PutSpriteWindowWTrans(x,y : integer; trans : byte; p : TSprite);
{ using word IO as long as possible; very FAST!
  checking for window-borders; works with EVERY spritesize }
procedure PutSpriteWindowTransEff(x,y : integer; trans : byte; p : TSprite);

{ same a PutSprite..., but can hide a color... }
procedure PutSpriteHide(x,y : word; hide : byte; p: TSprite);
procedure PutSpriteWindowHide(x,y : integer; hide : byte; p : TSprite);

{ draws a sprite but taking spritecolors-subtract instead ;
  good for making shadows }
procedure PutSpriteWindowShadow(x,y : integer; subtract,border:byte; p : TSprite);

{ draws a box }
procedure Box(x1,y1,x2,y2:word; c:byte);

{ copies a box from page to page using byte IO }
procedure CopyBoxP2P(x1,y1,x2,y2:word; src, dst : pointer);
{ copies a box from page to page using word IO }
procedure CopyBoxP2PW(x1,y1,x2,y2:word; src, dst : pointer);
{ copies a box from page to page using dword IO }
procedure CopyBoxP2PD(x1,y1,x2,y2:word; src, dst : pointer);
{ copies a box from page to page using effective IO }
procedure CopyBoxP2PEff(x1,y1,x2,y2:word; src, dst : pointer);
{ copies a box from page to page using effective IO; checks window-borders }
procedure CopyBoxWindowP2PEff(x1,y1,x2,y2:integer; src, dst : pointer);

{ copies a box from page to page using byte IO }
procedure MoveBoxP2P(x1,y1,x2,y2:word; dst, src : pointer;x,y:word);
{ copies a box from page to page using word IO }
procedure MoveBoxP2PW(x1,y1,x2,y2:word; dst, src : pointer;x,y:word);
{ copies a box from page to page using dword IO }
procedure MoveBoxP2PD(x1,y1,x2,y2:word; dst, src : pointer;x,y:word);
{ copies a box from page to page using effective IO }
procedure MoveBoxP2PEff(x1,y1,x2,y2:integer; dst, src : pointer;x,y:integer);
{ copies a box from page to page using effecitve IO; checks window-borders }
procedure MoveBoxWindowP2PEff(x1,y1,x2,y2:integer; dst, src : pointer;x,y:integer);

{ moves the specified spritecolor(n) up to t-colors up/down in sprite }
procedure MoveSpriteColor(p: TSprite; t:shortint; n:byte);

{ draws a filled rectanlge checking for window borders }
procedure RectangleWindow(lx1,ly1,lx2,ly2,lx3,ly3,lx4,ly4:longint;color:byte);
{ draws a line checking for window borders }
procedure LineWindow(a,b,c,d,col:longint);
{ draws a filled trianlge checking for window borders }
procedure TriAngleWindow(X1,Y1,X2,Y2,X3,Y3:longint; Color:Byte);
{ draws a horizontal line }
procedure HorLine(XBegin,XEnd,y:integer; color:byte);
{ draws a vertical line }
procedure VertLine(XBegin,XEnd,y:integer; color:byte);
{ draws a line }
procedure Line(X1,Y1,X2,Y2 : integer; color:byte);
{ This draws a line from a,b to c,d of color col. }
Procedure Line2Sprite(p:TSprite;a,b,c,d,col:longint);

{ converts a sprite (size MUST be 320x200) to a page for direct read/write
  on sprite }
function  Sprite2Page( s : TSprite ) : TPage;

{ loads a PCX-image to active page }
procedure LoadPCX( Name : String; Page : TPage);
{ saves a 320x200 PCX File with Palette}
procedure SavePCX(PCXFile :String;P:TPage;var Pal:TPal);

{guess what}
procedure PutSprite2Sprite( x,y : integer; p, destp : TSprite);
{guess again:-)}
procedure PutSprite2SpriteTrans(x,y : integer; trans : byte; p, destp : Tsprite);
{fills a Sprite with 0's}
procedure ClearSprite(p:TSprite);

{ same like procedure wihtout Big; these are able to use the vIRtECH
  BigFileSystem }
procedure BigLoadSprite(name : string; VAR p : TSprite; FileS:byte);
procedure BigLoadImprocesCLB(name : string; VAR p : TSprite; Files:byte);
procedure BigLoadClipboardPal(name:string; VAR pal : TPal; FileS:byte);
procedure BigLoadPalette(name:string; VAR pal : TPal; FileS:byte);
procedure BigLoadPCX( Name : String; Page : TPage; No : byte );

{ scales a sprite; always using window-borders }
procedure PutSpriteScaled(x,y,dx,dy:integer; p:TSprite);
{ scales a sprite in cent; always using window-borders }
procedure PutSpritePerCent(x,y:integer; factor:real; p : TSprite);

{ scaling of transparent sprites }
procedure PutSpriteScaledTrans(x,y,dx,dy:integer; col :byte; p:TSprite);
procedure PutSpritePerCentTrans(x,y:integer; factor:real; col:byte; p : TSprite);

{ some little helpers }

function IntToStr(t:longint):string;
function StrToInt(t:string):longint;
function MaxI(A,B:Integer):Integer;
function MinI(A,B:Integer):Integer;
function InRangeI(value,min,max:integer):integer;
procedure SwapInt( VAR a, b );
function Sgn( a : Integer ) : Integer;

implementation

{
  No, this source is not free now!
  For register the unit or getting the source code, please contact us.
 }

{ **************************************************************************
  **************************************************************************
  **************************************************************************
  **************************************************************************
  ************************************************************************** }

VAR  { frs transparentespritezeichnen }
  FreeMemory : Longint; {Wieviel Speicher hatten wir bei der Initialisierung}

const
  Copyright = '(c) vIRTUAL tECHNOLOGIES 1993-1996 - Ansgar Scherp, Joachim Gelhaus';


function IntToStr(t:longint):string;
 var r : string;
begin
  str(t,r);
  Inttostr := r;
end;

function StrToInt(t:string):longint;
 var r : longint;
     check : integer;
begin
  val(t,r,check);
  Strtoint := r;
end;

procedure SetVideoMode(mode:word); assembler;
asm
  mov ax,mode
  int  10h
end;

procedure SetWindow(x1,y1,x2,y2:integer);
  var h : byte;
begin
  if x1 < 0 then x1 := 0;
  if x1 > 319 then x1 := 319;
  if y1 < 0 then y1 := 0;
  if y1 > 199 then y1 := 199;
  if x2 < 0 then x2 := 0;
  if x2 > 319 then x2 := 319;
  if y2 < 0 then y2 := 0;
  if y2 > 199 then y2 := 199;
  if x1 > x2 then begin h := x2; x2 := x1; x1 := h; end;
  if y1 > y2 then begin h := y2; y2 := y1; y1 := h; end;
  {unntig // fehler behoben...}
  {inc(x2); {damit auf spalte 319 auch gezeichnet wird // elemeniert }
  {inc(y2); {damit auf zeile 199 auch gezeichnet wird // }
  wx1 := x1;
  wx2 := x2;
  wy1 := y1;
  wy2 := y2;
end;


procedure InitVideo13h;
begin
  Page0 := ptr(SegA000,0);
  VisualPage := ptr(SegA000,0);
  ActVPage := ptr(SegA000,0);
  SetVideoMode(Mode13h);
  SetWindow(0,0,319,199);
  FreeMemory := MaxAvail;
end;

procedure CloseVideo13h;
begin
  if FreeMemory <> MaxAvail then begin
      writeln('MemoryManagement-error detected:');
      writeln('We have a memory-difference of totally '+
	      inttostr(FreeMemory-MaxAvail)+' bytes!'+#7);
     halt(2);
   end;
end;

procedure Video13hError(t:string);
begin
  SetVideoMode( Mode3h );
  write('Video13hSystemError at: ');
  writeln(t);
{  CloseVideo13h;}
  halt(1);
end;

procedure ActivePage(page : pointer);
begin
  ActVPage := page;
end;

procedure SetBKGColor(r,g,b:byte); assembler;
asm
  mov dx,$3c8
  mov al, 0
  out dx,al

  mov dx,$3c9

  mov al, r
  out dx,al

  mov al, g
  out dx,al

  mov al, b
  out dx,al
end;

procedure SetRGBColor(co,r,g,b:byte); {assembler;
asm
  mov dx,$3c8
  mov al, co
  out dx,al

  mov dx,$3c9

  mov al, r
  out dx,al

  mov al, g
  out dx,al

  mov al, b
  out dx,al
end;}
begin
  port[$3c8] := co;
  port[$3c9] := r;
  port[$3c9] := g;
  port[$3c9] := b;
end;

procedure GetRGBColor(co:integer; var r,g,b:byte);
{var r1,g1,b1:byte;
begin
asm
  mov dx,$3c8
  mov al, co
  out dx,al

  mov dx,$3c9

  in al,dx
  mov r1,al
  in al,dx
  mov g1,al
  in al,dx
  mov b1,al
end;
  r:=r1; g:=g1; b:=b1;
end;}
begin
  r := 0; g := 0; b := 0;
  port[$3c8] := co+1;
  r := port[$3c9];
  g := port[$3c9];
  b := port[$3c9];
end;

procedure SetRGBColorFade(co,r,g,b:byte; VideoFade : byte);
var h : real;
begin
  h := 0.01 * videofade;
  setRGBColor(co,byte(trunc(r*h)) , byte(trunc(g*h)) , byte(trunc(b*h)) );
end;


(*Procedure GetPalette (Var Pal : TPal); Assembler;
Asm
    PUSH DS
    XOR AX, AX       { Palette Start = 0 }
    MOV CX, 0300h
    LES DI, Pal      { Load ES:DI With Address Of PalBuf (For INSB) }
    MOV DX, 03C7h    { Tell VGA Card What DAC Color To Start With }
    OUT DX, AL
    INC DX           { Set DX To Equal DAC Data Port }
    INC DX
    CLD
    REP INSB
    POP DS
End;

Procedure SetPalette (Var Pal : TPal); Assembler;
Asm
    PUSH DS
    XOR AX, AX       { Palette Start = 0 }
    MOV CX,0300h
    LDS SI, Pal      { Load DS:SI With Address Of PalBuf (For OUTSB) }
    MOV DX, 03C8h    { Tell VGA Card What DAC Color To Start With }
    OUT DX, AL
    INC DX           { Set DX To Equal DAC Data Port }
    REP OUTSB
    POP DS
End;*)


procedure SetPalette( var pal : TPal);
  var a : byte;
begin
  for a := 0 to 255 do
    setRGBcolor(a,pal.r[a],pal.g[a],pal.b[a]);
end;

procedure GetPalette( var pal : TPal);
  var a : byte;
begin
  for a := 0 to 255 do
    getRGBcolor(a,pal.r[a],pal.g[a],pal.b[a]);
end;

procedure SetZeroPalette;
  var a : byte;
begin
  for a := 0 to 255 do
    setRGBcolor(a,0,0,0);
end;

procedure SetPalettepercent(var pal:TPal; pc:byte);
var c : byte;
    h : real;
    pal_fade:TPal;
begin
  h := 0.01 * pc;
  with pal_fade do
    for c:=0 to 255 do
    begin
      r[c]:=byte(trunc(pal.r[c] * h));
      g[c]:=byte(trunc(pal.g[c] * h));
      b[c]:=byte(trunc(pal.b[c] * h));
    end;
  setPalette(pal_fade);
end;

procedure Retrace; assembler;
asm
  mov dx,3dah
  @vert1:
    in al,dx
    test al,8
  jz @vert1
  @vert2:
    in al,dx
    test al,8
  jnz @vert2

end;

{WORD-VERSION // ab 386er}
procedure CopyP2P(Src,Dst:pointer); assembler;
ASM
  push DS

  les di, dst

  lds si, src

  mov cx, 16000

  db  66H
  rep movsw

  pop ds
END;


{WORD-VERSION // ab 386er}
procedure CopyP2V(src:Pointer); ASSEMBLER;
ASM
  push DS

  mov es, SegA000
  xor di, di

  lds si, src
  mov cx, 16000

  db  66H
  rep movsw

  pop ds
END;



{WORD-VERSION // ab 386er}
procedure ClearPage(dst:pointer); assembler;
asm
  les di,dst
  db 66H
  xor ax,ax

  mov cx,16000

  db 66H
  rep stosw
end;

procedure ClearVisualPage;
begin
  ClearPage(VisualPage);
end;

procedure PutPixel(x,y : word; c : byte); assembler;
asm
  mov ax,y
  mov bx,320
  mul bx
  add ax,x

  mov cl,c
  les di, ActVPage
  add di,ax

  mov [es:di],cl
end;

function GetPixel(x,y : word):byte;
  var c : byte;
begin
  asm
    mov ax,y
    mov bx,320
    mul bx
    add ax,x

    les di,ActVPage
    add di,ax
    mov cl,[es:di]
    mov c,cl
  end;
  GetPixel := c;
end;

procedure HorLine(XBegin,XEnd,y:integer; color:byte); assembler;
asm
  mov bx,xBegin
  mov cx,xEnd
  cmp bx,cx
  jb @skip
  xchg bx,cx
 @skip:
  inc cx
  sub cx,bx

  les di,ActVPage
  mov ax,y
  shl ax,6
  add di,ax

  shl ax,2
  add di,ax
  add di,bx
  mov al,Color
  shr cx,1
  jnc @skip2
  stosb
 @skip2:
  mov ah,al
  rep stosw
 @out:
end;

procedure VertLine(XBegin,XEnd,y:integer; color:byte); assembler;
asm
end;

procedure LineSlow(x1,y1,x2,y2:integer; farbe:byte);
var y   : integer;   {fr das Funktionsergebnis}
    m,b : real;     {Steigung und Achsenabschnitt}
    h : integer;

begin
 if x1 > x2 then begin h := x1; x1 := x2; x2 := h; end;
 if y1 > y2 then begin h := y1; y1 := y2; y2 := h; end;
 if x2<>x1 then begin {kann man Geradengleichung anwenden?}
   m:=(y2-y1)/(x2-x1);  {ja, berechne M}
   b:=y1-(m*x1);        {und B}
   for x1:=x1 to x2 do begin {Berechne in einer Schleife zu jedem}
      y:=trunc(m*x1+b); {X ein Y und}
      if (y >= 0) and (y<=199) and (x1>=0) and (x1<=319) then
	PutPixel(x1,y,farbe); {zeichne den Punkt Schleife schlieen}
    end;
  end
 else      {Es ist eine Senkrechte}
  begin
    for y1:=y1 to y2 do {setze in einer Schleife}
      PutPixel(x1,y1,farbe); {die Senkrechte}
  end;
end;


{Funktioniert nicht ganz richtig! }
procedure Line(X1,Y1,X2,Y2 : integer; color:byte);
begin
  LineSlow(x1,y1,x2,y2,color);
end;

procedure InitPage(VAR page : pointer);
begin
  if page <> NIL then Video13hError('Trying to open an already existing page!');
  GetMem(page,64000);
  ActVPage := page;
  ClearPage(ActVPage);
end;

procedure ClosePage(page : pointer);
begin
  if page = NIL then Video13hError('Trying to close an already closed page!');
  FreeMem(page,64000);
end;

procedure InitSprite(VAR p : TSprite; b,t : word);
begin
  if (b < 1) or (t < 1) then
      Video13hError('InitSprite: Breite/Hhe zu klein!');
  if p.mem <> NIL then Video13hError('Trying to open an already existing sprite!');
  GetMem(p.mem,b*t);
  p.b := b;
  p.t := t;
  {Leere den neuen Speicher}
  FillChar(p.mem^,b*t,0);
end;

procedure ResetSprite(VAR p : TSprite);
begin
  if (p.b > 0) and (p.t > 0) then FreeMem(p.mem, p.b * p.t);
  p.mem := nil;
  p.b := 0;
  p.t := 0;
end;

procedure CloseSprite(VAR p : TSprite);
begin
{  if p.mem = NIL then Video13hError('Trying to close an already closed sprite!');}
  if p.b*p.t > 0 then FreeMem(p.mem,p.b*p.t);
  p.mem := nil;
  p.b := 0;
  p.t := 0;
end;


{PIXEL BY PIXEL // LANGSAMSTE METHODE // ABER SICHER}
procedure PutSpriteBslow(x,y : Integer; p : TSprite);
  var spriteseg,spriteofs : word;
      x1,y1 : word;
      breite,tiefe,ausgleich : word;
      dseg, dofs : word;
begin
  breite := p.b;
  tiefe := p.t;
  ausgleich := 320-breite;
  spriteseg := seg(p.mem^);
  spriteofs := ofs(p.mem^);
  dseg := seg(actvpage^);
  dofs := ofs(actvpage^)+ 320*y+x;

  for y1 := 1 to tiefe do
    begin
      for x1 := 1 to breite do
	begin
	  mem[dseg:dofs] := mem[spriteseg:spriteofs];
	  inc(spriteofs);
	  inc(dofs);
	end;
      inc(dofs,ausgleich);
    end;
end;

{PIXEL BY PIXEL // LANGSAMSTE METHODE // ABER SICHER}
procedure GetSpriteBslow(x,y : word; p : TSprite);
  var spriteseg,spriteofs : word;
      x1,y1 : word;
      breite,tiefe,ausgleich : word;
      dseg, dofs : word;
begin
  breite := p.b;
  tiefe := p.t;
  ausgleich := 320-breite;
  spriteseg := seg(p.mem^);
  spriteofs := ofs(p.mem^);
  dseg := seg(actvpage^);
  dofs := ofs(actvpage^)+ 320*y+x;

  for y1 := 1 to tiefe do
    begin
      for x1 := 1 to breite do
	begin
	  mem[spriteseg:spriteofs] := mem[dseg:dofs];
	  inc(spriteofs);
	  inc(dofs);
	end;
      inc(dofs,ausgleich);
    end;
end;



{REP-BYTE-VERSION}
procedure PutSpriteB(x,y : word; p: TSprite);
  var ausgleich : word;
begin
  asm
    push ds

    mov ax,320
    sub ax, p.b {breite}
    mov ausgleich, ax

    les di,ActVPage   {dest}
    add di,x   {x dazu}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add di,ax

    lds si, p.mem      {src}

    mov dx, 0
    @@loop:
      mov cx, p.b
      rep movsb {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      add di, ausgleich

      inc dx
      cmp dx, p.t
      jnz @@loop

    pop ds
  end;
end;

{REP-BYTE-VERSION // 8bit}
procedure GetSpriteB(x,y : word; p: TSprite);
  var ausgleich : word;
begin
  asm
    push ds

    mov ax,320
    sub ax, p.b {breite}
    mov ausgleich, ax

    lds si,ActVPage   {dest }
    add si,x   {x dazu}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add si,ax

    les di, p.mem      {src}

    mov dx, 0
    @@loop:
      mov cx, p.b
      rep movsb {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      add si, ausgleich

      inc dx
      cmp dx, p.t
      jnz @@loop

    pop ds
  end;
end;


{REP-WORD-VERSION // 16bit}
procedure PutSpriteW(x,y : word; p: TSprite);
  var ausgleich : word;
begin
  asm
    push ds

    mov ax,320
    sub ax, p.b {breite}
    mov ausgleich, ax

    les di,ActVPage   {dest}
    add di,x   {x dazu}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add di,ax

    lds si, p.mem      {src}

    shr p.b,1 {div 2 // wegen word}

    mov dx, 0
    @@loop:
      mov cx, p.b
      rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      add di, ausgleich

      inc dx
      cmp dx, p.t
      jnz @@loop

    pop ds
  end;
end;

{REP-WORD-VERSION // 16bit}
procedure GetSpriteW(x,y : word; p: TSprite);
  var ausgleich : word;
begin
  asm
    push ds

    mov ax,320
    sub ax, p.b {breite}
    mov ausgleich, ax

    lds si,ActVPage   {dest }
    add si,x   {x dazu}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add si,ax

    les di, p.mem      {src}

    shr p.b,1 {div 2 // wegen word}

    mov dx, 0
    @@loop:
      mov cx, p.b
      rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      add si, ausgleich

      inc dx
      cmp dx, p.t
      jnz @@loop

    pop ds
  end;
end;


{REP-DOUBLE(WORD)-VERSION // 386+}
procedure PutSpriteD(x,y : word; p: TSprite);
  var ausgleich : word;
begin
  asm
    push ds

    mov ax,320
    sub ax, p.b {breite}
    mov ausgleich, ax

    les di,ActVPage   {dest}
    add di,x   {x dazu}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add di,ax

    lds si, p.mem      {src}

    shr p.b,2 {div 4 // wegen dword}

    mov dx, 0
    @@loop:
      mov cx, p.b
      db  66H
      rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      add di, ausgleich

      inc dx
      cmp dx, p.t
      jnz @@loop

    pop ds
  end;
end;

{REP-DOUBLE(WORD)-VERSION // 386+}
procedure GetSpriteD(x,y : word; p: TSprite);
  var ausgleich : word;
begin
  asm
    push ds

    mov ax,320
    sub ax, p.b {breite}
    mov ausgleich, ax

    lds si,ActVPage   {dest }
    add si,x   {x dazu}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add si,ax

    les di, p.mem      {src}

    shr p.b,2 {div 4 // wegen dword}

    mov dx, 0
    @@loop:

      mov cx, p.b
      db  66H
      rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      add si, ausgleich

      inc dx
      cmp dx, p.t
      jnz @@loop

    pop ds
  end;
end;


procedure LoadSprite(name : string; VAR p : TSprite);
  var f : file;
  { Header  b,        {BREITE}
	     t : word; {TIEFE}
   {          memSeg,memOfs : word; {Segment/Offset auf die
	     mem : pointer;
   }
begin
  if p.mem <> NIL then
    Video13hError('Trying to load a Sprite in an exiting one!');
  {$I-}
  assign(f,name);
  reset(f,1);
  {$I+}
  if IOResult <> 0 then Video13hError('Error occurred when trying to load "'+name+'".');
  {}
  blockread(f,p.b,2);
  blockread(f,p.t,2);
  GetMem(p.mem,p.b*p.t);
  blockread(f,p.mem^,p.b*p.t);
  close(f);
end;

procedure SaveSprite(name : string; p : TSprite);
  var f : file;
begin
  {$I-}
  assign(f,name);
  rewrite(f,1);
  {$I+}
  {}
  blockwrite(f,p.b,Sizeof(p.b));
  blockwrite(f,p.t,Sizeof(p.t));
{  blockwrite(f,p.memSeg,SizeOf(p.memSeg));
  blockwrite(f,p.memOfs,SizeOf(p.memOfs));}
  blockwrite(f,p.mem^,p.b*p.t);
  {}
  close(f);
  if IOResult <> 0 then Video13hError('Error occurred when trying to save "'+name+'".');
end;

procedure BigLoadSprite(name : string; VAR p : TSprite; FileS:byte);
  var nope : word;
begin
  if p.mem <> NIL then
    Video13hError('Trying to load a Sprite in an exiting one!');
  {$I-}
  bigassign(FileS,name);
  bigreset(FileS,1);
  {$I+}
  if IOResult <> 0 then Video13hError('Error occurred when trying to load "'+name+'".');
  {}
  bigblockread(FileS,p.b,2,nope);
  bigblockread(FileS,p.t,2,nope);
{  bigblockread(FileS,p.memSeg,2,nope);
  bigblockread(FileS,p.memOfs,2,nope);}
  GetMem(p.mem,p.b*p.t);
  bigblockread(FileS,p.mem^,p.b*p.t,nope);
  bigclose(FileS);
end;

procedure LoadImprocesCLB(name : string; VAR p : TSprite);
 { DIMS:0 0 319 199 }
  const scan : string[5] = 'DIMS:';
  var f : file;
      t : string[5];
      b : byte;
      h : word;
      x1,x2,y1,y2 : word;

  procedure LoadNumber(VAR z : word);
    var Check : Integer;
  begin
    t := '';
    repeat
      blockread(f,b,1);
      if IOResult <> 0 then Video13hError('"'+name+'" is not an IMPROCES-File.');
      if chr(b) <> ' ' then t := t + chr(b);
    until (chr(b) = ' ') or (Eof(f));
    Val(t,z,check);
    if Check <> 0 then Video13hError('Error in loading IMPROCES-File.');
  end;

begin
  if p.mem <> NIL then
    Video13hError('Trying to load a Sprite in an exiting one!');
  {$I-}
  assign(f,name);
  reset(f,1);
  if IOResult <> 0 then Video13hError('Error occurred when trying to load "'+name+'".');
  {}
  if filesize(f)-50 < 1 then seek(f,0) else seek(f,filesize(f)-50);
  t := '01234';
  repeat
    t[1] := t[2]; t[2] := t[3]; t[3] := t[4]; t[4] := t[5];
    blockread(f,t[5],1);
    if IOResult <> 0 then Video13hError('"'+name+'" is not an IMPROCES-File.');
  until t = 'DIMS:';
  {$I+}
  LoadNumber(x1);
  LoadNumber(y1);
  LoadNumber(x2);
  LoadNumber(y2);
  p.b := x2 - x1 + 1;
  p.t := y2 - y1 + 1;
{  video13herror(inttostr(x1)+'!'+inttostr(x2)+' OO'+inttostr(p.b)+'//'+inttostr(p.t));{}
  GetMem(p.mem,p.b*p.t);
  seek(f,0);
  blockread(f,p.mem^,p.b*p.t);
  blockread(f,b,1);
  close(f);
end;

procedure SaveImprocesCLB(name : string; p : TSprite);
 { DIMS:0 0 319 199 }
  const scan : string[5] = 'DIMS:';
  var f : file;
      t : string;

begin
  {$I-}
  assign(f,name);
  rewrite(f,1);
  {}
  blockwrite(f,p.mem^,p.b*p.t);
  t := scan + '0 0 ' + inttostr(p.b-1) + ' ' + inttostr(p.t-1);
  blockwrite(f,t,length(t)+1);
  close(f);
  if IOResult <> 0 then Video13hError('Error occurred when trying to save "'+name+'".');
end;

procedure BigLoadImprocesCLB(name : string; VAR p : TSprite; Files:byte);
 { DIMS:0 0 319 199 }
  const scan : string[5] = 'DIMS:';
  var t : string[5];
      b : byte;
      h,nope : word;
      x1,x2,y1,y2 : word;

  procedure LoadNumber(VAR z : word);
    var Check : Integer;
  begin
    t := '';
    repeat
      bigblockread(files,b,1,nope);
      if IOResult <> 0 then Video13hError('"'+name+'" is not an IMPROCES-File.');
      if chr(b) <> ' ' then t := t + chr(b);
    until (chr(b) = ' ') or (bigEof(files));
    Val(t,z,check);
    if Check <> 0 then Video13hError('Error in loading IMPROCES-File.');
  end;

begin
  if p.mem <> NIL then
    Video13hError('Trying to load a Sprite in an exiting one!');
  {$I-}
  bigassign(FileS,name);
  bigreset(FileS,1);
  if IOResult <> 0 then Video13hError('Error occurred when trying to load "'+name+'".');
  {}
  if bigfilesize(FileS)-50 < 1 then bigseek(FileS,0) else bigseek(FileS,bigfilesize(FileS)-50);
  t := '01234';
  repeat
    t[1] := t[2]; t[2] := t[3]; t[3] := t[4]; t[4] := t[5];
    bigblockread(FileS,t[5],1,nope);
    if IOResult <> 0 then Video13hError('"'+name+'" is not an IMPROCES-File.');
  until t = 'DIMS:';
  {$I+}
  LoadNumber(x1);
  LoadNumber(y1);
  LoadNumber(x2);
  LoadNumber(y2);
  p.b := x2 - x1 + 1;
  p.t := y2 - y1 + 1;
{  video13herror(inttostr(x1)+'!'+inttostr(x2)+' OO'+inttostr(p.b)+'//'+inttostr(p.t));{}
  GetMem(p.mem,p.b*p.t);
  bigseek(FileS,0);
  bigblockread(FileS,p.mem^,p.b*p.t,nope);
  bigblockread(FileS,b,1,nope);
  bigclose(fileS);
end;


procedure LoadClipboardPal(name:string; VAR pal : TPal);
  var f : file;
      a : byte;
begin
  {$I-}
  assign(f,name);
  reset(f,1);
  blockread(f,pal.r[0],1);
  for a := 0 to 255 do begin
      blockread(f,pal.r[a],1);
      blockread(f,pal.g[a],1);
      blockread(f,pal.b[a],1);
    end;
  if IOResult <> 0 then Video13hError('Error occurred when trying to load "'+name+'".');
  close(f);
  {$I+}
end;

procedure BigLoadClipboardPal(name:string; VAR pal : TPal; FileS:byte);
  var a : byte;
      nope : word;
begin
  {$I-}
  bigassign(FileS,name);
  bigreset(FileS,1);
  bigblockread(FileS,pal.r[0],1,nope);
  for a := 0 to 255 do begin
      bigblockread(FileS,pal.r[a],1,nope);
      bigblockread(FileS,pal.g[a],1,nope);
      bigblockread(FileS,pal.b[a],1,nope);
    end;
  if IOResult <> 0 then Video13hError('Error occurred when trying to load "'+name+'".');
  bigclose(FileS);
  {$I+}
end;

procedure LoadPalette(name:string; VAR pal : TPal);
  var f : file;
      a : byte;
begin
  {$I-}
  assign(f,name);
  reset(f,1);
  for a := 0 to 255 do begin
      blockread(f,pal.r[a],1);
      blockread(f,pal.g[a],1);
      blockread(f,pal.b[a],1);
    end;
  if IOResult <> 0 then Video13hError('Error occurred when trying to load "'+name+'".');
  close(f);
  {$I+}
end;

procedure BigLoadPalette(name:string; VAR pal : TPal; FileS:byte);
  var a : byte;
      nope : word;
begin
  {$I-}
  bigassign(FileS,name);
  bigreset(FileS,1);
  for a := 0 to 255 do begin
      bigblockread(FileS,pal.r[a],1,nope);
      bigblockread(FileS,pal.g[a],1,nope);
      bigblockread(FileS,pal.b[a],1,nope);
    end;
  if IOResult <> 0 then Video13hError('Error occurred when trying to load "'+name+'".');
  bigclose(FileS);
  {$I+}
end;

procedure SavePalette(name:string; pal : TPal);
  var f : file;
      a : byte;
begin
  {$I-}
  assign(f,name);
  rewrite(f,1);
  for a := 0 to 255 do begin
      blockwrite(f,pal.r[a],1);
      blockwrite(f,pal.g[a],1);
      blockwrite(f,pal.b[a],1);
    end;
  if IOResult <> 0 then Video13hError('Error occurred when trying to save "'+name+'".');
  close(f);
  {$I+}
end;


{ Die Spritefarbe 'trans' wird nicht! auf der Seite gezeichnet }
procedure PutSpriteTrans(x,y : word; trans:byte; p: TSprite);
  var ausgleich : word;
begin
  asm
    push ds

    mov ax,320
    sub ax, p.b {breite}
    mov ausgleich, ax

    les di,ActVPage   {dest}
    add di,x   {x dazu}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add di,ax

    lds si, p.mem      {src}

    mov dx,0
    @@loop:
      mov cx, p.b
      {***}
      @@loop2:

	mov al, [DS:SI]
	cmp al, trans
	jz @@weiter
	  mov [ES:DI], al
	@@weiter:

	inc di
	inc si

	dec cx
	cmp cx,0
	jnz @@loop2
      {***}

      add di, ausgleich

      inc dx
      cmp dx, p.t
      jnz @@loop

    pop ds
  end;
end;

{ Wenn auf dem Screen die Farbe Hide vorhanden ist, dann wird nicht gezeichnet}
procedure PutSpriteHide(x,y : word; hide : byte; p: TSprite);
  var ausgleich : word;
begin
  asm
    push ds

    mov ax,320
    sub ax, p.b {breite}
    mov ausgleich, ax

    les di,ActVPage   {dest}
    add di,x   {x dazu}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add di,ax

    lds si, p.mem      {src}

    mov dx,0
    @@loop:
      mov cx, p.b
      {***}
      @@loop2:

	mov al, [ES:DI]
	cmp al, hide
	jz @@weiter
	  mov al, [DS:SI]
	  mov [ES:DI], al
	@@weiter:

	inc di
	inc si

	dec cx
	cmp cx,0
	jnz @@loop2
      {***}

      add di, ausgleich

      inc dx
      cmp dx, p.t
      jnz @@loop

    pop ds
  end;
end;

procedure PutSpriteWindow(x,y : integer; p: TSprite);
  var breite,tiefe : integer;
      ausgleich : word;
      ltrag,otrag,rtrag,utrag : integer;
begin
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  asm inc wx2; inc wy2; end;
  {betrge berechnen}
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  {und weg damit wieder!!!}
  asm dec wx2; dec wy2 ; end;
  {reale breite und tiefe ermitteln}
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {neue x und y position bestimmen}
  x := x + ltrag;
  y := y + otrag;

  asm
    {eigentlicher spritecode}
    push ds

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di,ActVPage   {dest}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add ax,x   {x dazu}
    add di,ax

    lds si, p.mem { Source }
    mov ax, otrag {ausgleich}
    mov bx, p.b
    mul bx
    add si,ax

    mov dx,0
    @@loop:

      add si, ltrag {linker bertrag}

      mov  cx,breite
{      shr cx,2

      db $66; rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      mov cx, breite {Breite}

      rep movsb {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      add di, ausgleich {grafikausgleichen 320-breite}
      add si, rtrag     {rechter bertrag}

      inc dx
      cmp dx, tiefe
      jnz @@loop

    pop ds
  end;
end;

procedure PutSpriteWindowW(x,y : integer; p: TSprite);
  var breite,tiefe : integer;
      ausgleich : word;
      ltrag,otrag,rtrag,utrag : integer;
begin
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  asm inc wx2; inc wy2; end;
  {betrge berechnen}
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  {und weg damit wieder!!!}
  asm dec wx2; dec wy2 ; end;
  {reale breite und tiefe ermitteln}
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {neue x und y position bestimmen}
  x := x + ltrag;
  y := y + otrag;

  asm
    {eigentlicher spritecode}
    push ds

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di,ActVPage   {dest}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add ax,x   {x dazu}
    add di,ax

    lds si, p.mem { Source }
    mov ax, otrag {ausgleich}
    mov bx, p.b
    mul bx
    add si,ax

    mov dx,0
    @@loop:

      add si, ltrag {linker bertrag}

      mov  cx,breite
      shr cx,1

      rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      add di, ausgleich {grafikausgleichen 320-breite}
      add si, rtrag     {rechter bertrag}

      inc dx
      cmp dx, tiefe
      jnz @@loop

    pop ds
  end;
end;

procedure PutSpriteWindowD(x,y : integer; p: TSprite);
  var breite,tiefe : integer;
      ausgleich : word;
      ltrag,otrag,rtrag,utrag : integer;
begin
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  asm inc wx2; inc wy2; end;
  {betrge berechnen}
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  {und weg damit wieder!!!}
  asm dec wx2; dec wy2 ; end;
  {reale breite und tiefe ermitteln}
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {neue x und y position bestimmen}
  x := x + ltrag;
  y := y + otrag;
(*
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  asm inc wx2; inc wy2; end;
  {betrge berechnen}
  asm
    mov ltrag, 0
    mov otrag, 0
    mov rtrag, 0
    mov utrag, 0
  end;
{  if x < wx1 then ltrag := wx1-x;}
  asm
    mov ax, x
    sub ax, wx1
    cmp ax, 32768 {KEINE INT in ASM // Spriterange: ca. -32000..32000}
    jbe @@w1
      mov ax, wx1
      sub ax, x
      mov ltrag, ax
    @@w1:
{  if y < wy1 then otrag := wy1-y;}
    mov ax, y
    sub ax, wy1
    cmp ax, 32768 {KEINE INT in ASM // Spriterange: ca. -32000..32000}
    jbe @@w2
      mov ax, wy1
      sub ax, y
      mov otrag, ax
    @@w2:
  end;
  if x+p.b > wx2 then rtrag := x+p.b-wx2;
(*   asm
    mov ax, x
    add ax, p.b
    sub ax, wx2
    cmp ax, 32768 {KEINE INT in ASM // Spriterange: ca. -32000..32000}
    jbe @@w3
      mov ax, x
      add ax, p.b
      sub ax, wx2
      mov rtrag, ax
    @@w3:
  end;
  if y+p.t > wy2 then utrag := y+p.t-wy2;
  {und weg damit wieder!!!}
  asm
    dec wx2;
    dec wy2 ;
  {reale breite und tiefe ermitteln}
  {breite := p.b - ltrag - rtrag;}
    mov ax, p.b
    sub ax, ltrag
    sub ax, rtrag
    mov breite, ax
  {tiefe := p.t - otrag - utrag;}
    mov ax, p.t
    sub ax, otrag
    sub ax, utrag
    mov tiefe, ax
  {wenn kleiner oder gleich Null, dann raus}
{  if (breite <= 0) or (tiefe <= 0) then exit;}
   mov ax, breite
   cmp ax, 320 {man beachte: es gibt keine INTEGER in ASM}
   jae @@exit
   mov ax, tiefe
   cmp ax, 320 {man beachte: es gibt keine INTEGER in ASM}
   jae @@exit
  {neue x und y position bestimmen}
  {x := x + ltrag;}
    mov ax, x
    add ax, ltrag
    mov x, ax
  {y := y + otrag;}
    mov ax, y
    add ax, otrag
    mov y, ax *)
  asm
    {eigentlicher spritecode}
    push ds

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di,ActVPage   {dest}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add ax,x   {x dazu}
    add di,ax

    lds si, p.mem { Source }
    mov ax, otrag {ausgleich}
    mov bx, p.b
    mul bx
    add si,ax

    mov dx,0
    @@loop:

      add si, ltrag {linker bertrag}

      mov  cx,breite
      shr cx,2

      db $66; rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

{      mov cx, breite {Breite}

{      rep movsb {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      add di, ausgleich {grafikausgleichen 320-breite}
      add si, rtrag     {rechter bertrag}

      inc dx
      cmp dx, tiefe
      jnz @@loop

    pop ds
    @@exit:
  end;
end;


procedure GetSpriteWindow(x,y : integer; p: TSprite);
  var breite,tiefe : integer;
      ausgleich : word;
      ltrag,otrag,rtrag,utrag : integer;
begin
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  inc(wx2); inc(wy2);
  {betrge berechnen}
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  {und weg damit wieder!!!}
  dec(wx2); dec(wy2);
  {reale breite und tiefe ermitteln}
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {neue x und y position bestimmen}
  x := x + ltrag;
  y := y + otrag;

  asm
    push ds

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    lds si,ActVPage   {source}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add ax,x   {x dazu}
    add si,ax

    les di, p.mem { dest }
    mov ax, otrag
    mov bx, p.b
    mul bx
    add di,ax

    mov dx,0
    @@loop:

      add di, ltrag {linker bertrag}

      mov cx, breite {Breite}

      rep movsb {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      add si, ausgleich {grafikausgleichen 320-breite}
      add di, rtrag     {rechter bertrag}

      inc dx
      cmp dx, tiefe
      jnz @@loop

    pop ds
  end;
end;


procedure PutSpriteWindowTrans(x,y : integer; trans : byte; p : TSprite);
  var breite,tiefe : integer;
      ausgleich : word;
      ltrag,otrag,rtrag,utrag : integer;
begin
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  inc(wx2); inc(wy2);
  {betrge berechnen}
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  {und weg damit wieder!!!}
  dec(wx2); dec(wy2);
  {reale breite und tiefe ermitteln}
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {neue x und y position bestimmen}
  x := x + ltrag;
  y := y + otrag;

  asm
    push ds

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di,ActVPage   {dest}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add ax,x   {x dazu}
    add di,ax

    lds si, p.mem { Source }
    mov ax, otrag {ausgleich}
    mov bx, p.b
    mul bx
    add si,ax

    mov dx,0
    @@loop:

      add si, ltrag {linker bertrag}

      mov cx, breite {Breite}

      @@loop2:

	mov al, [DS:SI]
	cmp al, trans
	jz @@weiter
	  mov [ES:DI], al
	@@weiter:

	inc di
	inc si

	dec cx
	cmp cx,0
	jnz @@loop2

      add di, ausgleich {grafikausgleichen 320-breite}
      add si, rtrag     {rechter bertrag}

      inc dx
      cmp dx, tiefe
      jnz @@loop

    pop ds
  end;
end;

{ *** Transparent Sprites with WORD reading / writeing *** }
procedure PutSpriteWindowWTrans(x,y : integer; trans : byte; p : TSprite);
  var breite,tiefe : integer;
      ausgleich : word;
      ltrag,otrag,rtrag,utrag : integer;
begin
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  asm inc wx2; inc wy2; end;
  {betrge berechnen}
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  {und weg damit wieder!!!}
  asm dec wx2; dec wy2; end;
  {reale breite und tiefe ermitteln}
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {neue x und y position bestimmen}
  asm
    {x := x + ltrag;}
    mov ax,x
    add ax,ltrag
    mov x, ax
    {y := y + otrag;}
    mov ax,y
    add ax,otrag
    mov y, ax

  { BEACHTE!!!! BEIM LESEN EINES WORDS AX = AH/AL befindet sich der
    Inhalt von ah hinter dem inhalt von al, d.h.
    der Speicher is wie folgt aufgebaut:
    A000:0012  -> 12   = AL    \
    A000:0013  -> AA   = AH    / AX = AH/AL = AA12   }

    push ds

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di,ActVPage   {dest}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add ax,x   {x dazu}
    add di,ax

    lds si, p.mem { Source }
    mov ax, otrag {ausgleich}
    mov bx, p.b
    mul bx
    add si,ax

    mov dx,0
    @@loop:

      add si, ltrag {linker bertrag}

      mov cx, breite {Breite}
      shr cx,1       {nur die Hlfte der Abfragen}

      @@loop2:
	(*
	{ ******************************************************************
	   METHODE 1 : LESEN WORD // SCHREIBEN WORD oder BYTE
	   ERGEBNIS : 99% transparenz:  +6                BEI 2000 Sprites!
		       1% transparenz:  -60
	   + = schneller   - = langsamer  // Zeitangabe in hunderstel Sek.
	  ****************************************************************** }
	{ Read a word }
	mov ax, [DS:SI]
	mov bx, ax
	xor bh, trans
	xor bl, trans

	{NUR ABFRAGEN AUF ZERO, DA DER PROCESSOR DAS SCHNELLER MACHT!!!}
	{ *** ist das highbyte transparent??? *** }
	cmp bl,0
	jz @@weiter1
	  { *** ist das lowbyte gleich null? *** }
	  cmp bl,0
	  jz @@weiter3
	    { *** Word schreiben und weitermachen *** }
	    { einzelne stosw/stosb bitte nicht benutzten!!! ZU LANGSAM!!!
	    {stosw; inc si; inc si;
	    jmp @@weiter{}
	    {}mov [es:di],ax
	    inc di; inc si; inc di; inc si{}
	    jmp @@weiter
	  { *** ok, dann nur das Highbyte schreiben und raus *** }
	  @@weiter3:
	  {stosb; inc si{}
	  {}mov [es:di],al; inc di; inc si;{}
	  { *** ok, nun weitermachen!!! *** }
	  jmp @@weiter2
	{highbyte ist transparent, und das lowbyte???}
	@@weiter1:
	  inc di
	  inc si
	  {}
	  cmp bh,0
	  jz @@weiter2
	    { *** ok, das lowbyte schreiben *** }
	    {xchg al,ah; stosb; inc si{}
	    {}mov [es:di],ah; inc di; inc si{}
	    jmp @@weiter

	@@ganz_transparent:
	  inc di {ok, nun noch di und si anpassen}
	  inc si
	@@weiter2:
	  inc di
	  inc si
	@@weiter:
	*)
	{ ******************************************************************
	   METHODE 1 : LESEN WORD // SCHREIBEN BYTE
	   ERGEBNIS : 99% transparenz:  +200              BEI 2000 Sprites!
		       1% transparenz:  +110
	   + = schneller   - = langsamer  // Zeitangabe in hunderstel Sek.
	  ****************************************************************** }
	{ Read a word }
	mov ax, [DS:SI]

	{low-byte}
	cmp al, trans
	jz @@weiter1
	  mov [es:di],al
	@@weiter1:
	inc di
	inc si
	{high-byte}
	cmp ah, trans
	jz @@weiter2
	  mov [es:di],ah
	@@weiter2:
	inc di
	inc si


      dec cx
      cmp cx,0
      jnz @@loop2

      add di, ausgleich {grafikausgleichen 320-breite}
      add si, rtrag     {rechter bertrag}

      inc dx
      cmp dx, tiefe
      jnz @@loop

    pop ds
  end;
end;



procedure PutSpriteWindowHide(x,y : integer; hide : byte; p : TSprite);
  var breite,tiefe : integer;
      ausgleich : word;
      ltrag,otrag,rtrag,utrag : integer;
begin
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  inc(wx2); inc(wy2);
  {betrge berechnen}
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  {und weg damit wieder!!!}
  dec(wx2); dec(wy2);
  {reale breite und tiefe ermitteln}
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {neue x und y position bestimmen}
  x := x + ltrag;
  y := y + otrag;

  asm
    push ds

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di,ActVPage   {dest}
    mov ax,y   {y dazu}
    mov bx,320
    mul bx
    add ax,x   {x dazu}
    add di,ax

    lds si, p.mem { Source }
    mov ax, otrag {ausgleich}
    mov bx, p.b
    mul bx
    add si,ax

    mov dx,0
    @@loop:

      add si, ltrag {linker bertrag}

      mov cx, breite {Breite}

      @@loop2:

	mov al, [ES:DI]
	cmp al, hide
	jz @@weiter
	  mov al, [DS:SI]
	  mov [ES:DI], al
	@@weiter:

	inc di
	inc si

	dec cx
	cmp cx,0
	jnz @@loop2

      add di, ausgleich {grafikausgleichen 320-breite}
      add si, rtrag     {rechter bertrag}

      inc dx
      cmp dx, tiefe
      jnz @@loop

    pop ds
  end;
end;


procedure Box(x1,y1,x2,y2:word; c:byte); assembler;
  var breite,tiefe : word;
      ausgleich : word;
  asm
    push ds

    {HIER WAR EIN BUG DRIN!!! HABE ICH FR ZAPTBALL NICHT RAUSGENOMMEN,
DO ICH SONST 1000SACHEN NACHPRFEN HTTE MSSEN!!!}

    mov ax,x2
    sub ax,x1
    mov breite, ax
    inc breite

    mov ax,y2
    sub ax,y1
    mov tiefe,ax
    inc tiefe



    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di, ActVPage { DestPage }
    mov ax, y1
    mov bx, 320
    mul bx
    add ax, x1
    add di, ax

    mov al, c {farbe zuordnen}

    @@loop:
      mov cx, breite {Breite}
      rep stosb

      add di, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
  end;


procedure CopyBoxP2P(x1,y1,x2,y2:word; src, dst : pointer); assembler;
  var breite,tiefe : word;
      ausgleich : word;
  asm
    push ds

    mov ax,x2
    sub ax,x1
    mov breite, ax

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc breite
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add di, ax

    lds si, Src
    mov si, di

    @@loop:
      mov cx, breite {Breite}
      rep movsb

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
  end;

procedure CopyBoxP2PW(x1,y1,x2,y2:word; src, dst : pointer); assembler;
  var breite,tiefe : word;
      ausgleich : word;
  asm
    push ds

    mov ax,x2
    sub ax,x1
    mov breite, ax

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc breite
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add di, ax

    lds si, Src
    mov si, di

    @@loop:
      mov cx, breite {Breite}
      shr cx, 1
      rep movsw

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
  end;

procedure CopyBoxP2PD(x1,y1,x2,y2:word; src, dst : pointer); assembler;
  var breite,tiefe : word;
      ausgleich : word;
  asm
    push ds

    mov ax,x2
    sub ax,x1
    mov breite, ax

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc breite
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add di, ax

    lds si, Src
    mov si, di

    @@loop:
      mov cx, breite {Breite}
      shr cx, 2
      db $66;
      rep movsw

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
  end;

procedure CopyBoxP2PEff(x1,y1,x2,y2:word; src, dst : pointer);
var
  Rest,
  Breite,
  Tiefe,
  Ausgleich   : Word;
begin
  Breite := x2 - x1 + 1;
  Rest := Breite mod 4;
  breite := breite - Rest;
  case Rest of
    0 : {DWORD-Version}
    asm
    push ds

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

{    inc breite}
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add di, ax

    lds si, Src
    mov si, di

    @@loop:
      mov cx, breite {Breite}
      shr cx, 2
      db $66;
      rep movsw

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
    end;
    1 : {DWORD-Version + 1 BYTE }
    asm
    push ds

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    dec ausgleich { *** one Byte added at the end ***}

    les di, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add di, ax

    lds si, Src
    mov si, di

    @@loop:
      mov cx, breite {Breite}
      shr cx, 2
      db $66;
      rep movsw

      movsb { *** add one byte at the end *** }

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
    end;
    2 : {DWORD-Version + 1 WORD }
    asm
    push ds

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    dec ausgleich { *** one Byte added at the end ***}
    dec ausgleich { *** one Byte added at the end ***}

    les di, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add di, ax

    lds si, Src
    mov si, di

    @@loop:
      mov cx, breite {Breite}
      shr cx, 2
      db $66;
      rep movsw

      movsw { *** add one word at the end *** }

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
    end;
    3 : {DWORD-Version + 1 WORD + 1 BYTE }
    asm
    push ds

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    dec ausgleich { *** one Byte added at the end ***}
    dec ausgleich { *** one Byte added at the end ***}
    dec ausgleich { *** one Byte added at the end ***}

    les di, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add di, ax

    lds si, Src
    mov si, di

    @@loop:
      mov cx, breite {Breite}
      shr cx, 2
      db $66;
      rep movsw

      movsb { *** add one byte at the end *** }
      movsw { *** add one word at the end *** }

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
    end;
  end;
end;

procedure CopyBoxWindowP2PEff(x1,y1,x2,y2:integer; src, dst : pointer);
begin
  if ((x1 < wx1) and (x2 < wx1)) or
     ((x1 > wx2) and (x2 > wx2)) or
     ((y1 < wy1) and (y2 < wy1)) or
     ((y1 > wy2) and (y2 > wy2)) then exit;

  if x1 < wx1 then x1 := wx1;
  if x2 > wx2 then x2 := wx2;
  if y1 < wy1 then y1 := wy1;
  if y2 > wy2 then y2 := wy2;

  CopyBoxP2PEff(x1,y1,x2,y2,src,dst);
end;

procedure MoveBoxP2P(x1,y1,x2,y2:word; dst, src : pointer;x,y:word); assembler;
  var breite,tiefe : word;
      ausgleich : word;
      h : word;
  asm
    push ds

    mov ax,x2
    sub ax,x1
    mov breite, ax

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc breite
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    lds si, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add si, ax

    les di, Src       { SrcSeg}
    mov ax, y         { SrcOfs }
    mov bx, 320
    mul bx
    add ax, x
    add di, ax

    @@loop:
      mov cx, breite {Breite}
      rep movsb

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
  end;

procedure MoveBoxP2PW(x1,y1,x2,y2:word; dst, src : pointer;x,y:word); assembler;
  var breite,tiefe : word;
      ausgleich : word;
      h : word;
  asm
    push ds

    mov ax,x2
    sub ax,x1
    mov breite, ax

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc breite
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    lds si, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add si, ax

    les di, Src       { SrcSeg}
    mov ax, y         { SrcOfs }
    mov bx, 320
    mul bx
    add ax, x
    add di, ax

    @@loop:
      mov cx, breite {Breite}
      shr cx,1
      rep movsw

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
  end;

procedure MoveBoxP2PD(x1,y1,x2,y2:word; dst, src : pointer;x,y:word); assembler;
  var breite,tiefe : word;
      ausgleich : word;
      h : word;
  asm
    push ds

    mov ax,x2
    sub ax,x1
    mov breite, ax

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc breite
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    lds si, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add si, ax

    les di, Src       { SrcSeg}
    mov ax, y         { SrcOfs }
    mov bx, 320
    mul bx
    add ax, x
    add di, ax

    @@loop:
      mov cx, breite {Breite}
      shr cx,2

      db $66;
      rep movsw

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
  end;

procedure MoveBoxP2PEff(x1,y1,x2,y2:integer; dst, src : pointer;x,y:integer);
var
  Rest,
  Breite,
  Tiefe,
  Ausgleich   : integer;
begin
  Breite := x2 - x1 + 1;
  Rest := Breite mod 4;
  breite := breite - Rest;
  case Rest of
    0 : {DWORD-Version}
    asm
    push ds

    mov ax,x2
    sub ax,x1
    mov breite, ax

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc breite
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    lds si, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add si, ax

    les di, Src       { SrcSeg}
    mov ax, y         { SrcOfs }
    mov bx, 320
    mul bx
    add ax, x
    add di, ax

    @@loop:
      mov cx, breite {Breite}
      shr cx,2

      db $66;
      rep movsw

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
    end;
  1 : {add a byte}
    asm
    push ds

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc breite
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

{    dec ausgleich}

    lds si, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add si, ax

    les di, Src       { SrcSeg}
    mov ax, y         { SrcOfs }
    mov bx, 320
    mul bx
    add ax, x
    add di, ax

    @@loop:
      mov cx, breite {Breite}
      shr cx,2

      db $66;
      rep movsw

      movsb {ad a byte}

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
    end;
  2 : {add a word}
    asm
    push ds

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc breite
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    dec ausgleich

    lds si, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add si, ax

    les di, Src       { SrcSeg}
    mov ax, y         { SrcOfs }
    mov bx, 320
    mul bx
    add ax, x
    add di, ax

    @@loop:
      mov cx, breite {Breite}
      shr cx,2

      db $66;
      rep movsw

      movsw {ad a word}

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
    end;
  3 : {add a byte+word}
    asm
    push ds

    mov ax,y2
    sub ax,y1
    mov tiefe,ax

    inc breite
    inc tiefe

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    dec ausgleich
    dec ausgleich

    lds si, Dst       { DestSeg }
    mov ax, y1        { DestOfs }
    mov bx, 320
    mul bx
    add ax, x1
    add si, ax

    les di, Src       { SrcSeg}
    mov ax, y         { SrcOfs }
    mov bx, 320
    mul bx
    add ax, x
    add di, ax

    @@loop:
      mov cx, breite {Breite}
      shr cx,2

      db $66;
      rep movsw

      movsb {ad a byte+word}
      movsw

      add di, ausgleich
      add si, ausgleich

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
    end;
  end;
end;

procedure MoveBoxWindowP2PEff( x1,y1,x2,y2:integer; dst, src : pointer;
			       x,y:integer);
var
  Breite,Tiefe : word;
begin
  Breite := x2-x1;
  Tiefe  := y2-y1;
  if ((x1 < wx1) and (x2 < wx1)) or
     ((x1 > wx2) and (x2 > wx2)) or
     ((y1 < wy1) and (y2 < wy1)) or
     ((y1 > wy2) and (y2 > wy2))
     or
     ( x+breite < wx1 ) or
     ( x        > wx2 ) or
     ( y+tiefe  < wy1 ) or
     ( y        > wy2 ) then exit;


  {zielbild links ausserhalb des windows}
  if x  < wx1 then
    begin
      x1 := x1 + wx1 - x;
      x := wx1;
    end;
  {zielbild oben ausserhalb des windows}
  if y  < wy1 then
    begin
      y1 := y1 + wy1 - y;
      y := wy1;
    end;
  {zielbild rechts ausserhalb des windows}
  if x+breite > wx2 then
    begin
      x2 := x2 - ( x + breite - wx2);
    end;
  {zielbild unten ausserhalb des windows}
  if y+tiefe > wy2 then
    begin
      y2 := y2 - ( y + tiefe - wy2);
    end;
  {quelle links aus dem bild}
  if x1 < wx1 then
    begin
      x := x + ( wx1-x1 );
      x1 := wx1;
    end;
   {quelle rechts aus dem bild}
  if x2 > wx2 then x2 := wx2;
  {quelle oben aus dem bild}
  if y1 < wy1 then
    begin
      y := y + ( wy1-y1 );
      y1 := wy1;
    end;
  {quelle unten aus dem bild}
  if y2 > wy2 then y2 := wy2;

  if ((x1 < wx1) and (x2 < wx1)) or
     ((x1 > wx2) and (x2 > wx2)) or
     ((y1 < wy1) and (y2 < wy1)) or
     ((y1 > wy2) and (y2 > wy2))
     or
     ( x+breite < wx1 ) or
     ( x        > wx2 ) or
     ( y+tiefe  < wy1 ) or
     ( y        > wy2 ) then exit;

  MoveBoxP2PEff(x1,y1,x2,y2,dst,src, x,y);
end;

{nur fr sprites bis 65335-Byte Gre!!!}
procedure MoveSpriteColor(p: TSprite; t:shortint; n:byte);
  var Move : byte;
begin
  asm
    mov al,t {das wollen wir dann adden..}
    mov Move,al

    mov ax,word ptr p.b
    mov cx,word ptr p.t
    mul cx  {ax hat die lnge}

    les di, p.mem {[es:di] = ptr to sprite }

    @@loop:
      mov cl,[es:di] {farbe nehmen}
      cmp cl,n
      jz @@w
	add cl,Move  {um Move erhhen}
	mov [es:di],cl {farbe schreiben}
      @@w:
      inc di {offset erhhen}

      dec ax
      cmp ax,0
    jnz @@loop
  end;
end;

{Dir wirkliche Scale-routine}
{$F+}
{$L _SCALE1.OBJ}
{$L _SCALE2.OBJ}
procedure _Scale1( X,Y,DW,DY,SW,SH:integer;Bitmap:pointer); external;
procedure _Scale1Trans( X,Y,DW,DY,SW,SH:integer; Bitmap:pointer ); external;
{$F-}

{procedure, die fr _VIDEO13h.pas angepat wurde}
procedure PutSpriteScaled(x,y,dx,dy:integer; p:TSprite);
begin
  _scale1(x,y,dx,dy,p.b,p.t,Ptr(seg(p.mem^),ofs(p.mem^)));
end;


procedure PutSpritePerCent(x,y:integer; factor:real; p : TSprite);
begin
  _scale1(x,y,
	  trunc(p.b*0.01*factor),
	  trunc(p.t*0.01*factor),p.b,p.t,
	  Ptr(seg(p.mem^),ofs(p.mem^)));
end;

{procedure, die fr _VIDEO13h.pas angepat wurde}
procedure PutSpriteScaledTrans(x,y,dx,dy:integer; col :byte; p:TSprite);
begin
  TransparentColor := col;
  _scale1trans(x,y,dx,dy,p.b,p.t,Ptr(seg(p.mem^),ofs(p.mem^)));
end;


procedure PutSpritePerCentTrans(x,y:integer; factor:real; col:byte; p : TSprite);
begin
  TransparentColor := col;
  _scale1trans(x,y,
	  trunc(p.b*0.01*factor),
	  trunc(p.t*0.01*factor),p.b,p.t,
	  Ptr(seg(p.mem^),ofs(p.mem^)));
end;


procedure PutSpriteWindowShadow(x,y : integer; subtract,border:byte; p : TSprite);
  var breite,tiefe : integer;
      ausgleich : word;
      ltrag,otrag,rtrag,utrag : integer;
begin
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  if (breite <= 0) or (tiefe <= 0) then exit;
  x := x + ltrag;
  y := y + otrag;
  dec(border);
  asm
    push ds

    cld {ClearDirectionFlag // di&si werden erhht bei mosv}

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    les di, ActVPage  { DestSeg }
    mov ax, y         { DestOfs }
    mov bx, 320
    mul bx
    add ax, x
    add di, ax

    lds si, p.mem { SourceSeg }

    @@loop:
      add si, ltrag
      mov cx, breite {Breite}
      {rep movsb {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

      @@loop2:

	mov al, [DS:SI]
	cmp al, 0
	jz @@weiter
	  mov al,[ES:DI]
	  cmp al,border
	  jbe @@weiter
	  sub al,subtract
	  mov [ES:DI], al
	@@weiter:

	inc di
	inc si

	dec cx
	cmp cx,0
	jnz @@loop2


      add di, ausgleich
      add si, rtrag

      dec tiefe
      cmp tiefe,0
      jnz @@loop

    pop ds
  end;
end;

{**************************************************************************}

function MaxI(A,B:Integer):Integer;
begin
inline(
$58/                       {pop   ax       }
$5B/                       {pop   bx       }
$3B/$C3/                   {cmp   ax,bx    }
$7F/$01/                   {jg    +1       }
$93);                      {xchg  ax,bx    }
end;

function MinI(A,B:Integer):Integer;
begin
inline(
$58/                       {pop   ax       }
$5B/                       {pop   bx       }
$3B/$C3/                   {cmp   ax,bx    }
$7C/$01/                   {jl    +1       }
$93);                      {xchg  ax,bx    }
end;

function InRangeI(value,min,max:integer):integer;
begin
inline(
$59/                       {pop   cx  max  }
$5B/                       {pop   bx  min  }
$58/                       {pop   ax  val  }
$3B/$C3/                   {cmp   ax,bx    }
$7F/$03/                   {jg    +3       }
$93/                       {xchg  ax,bx    }
$Eb/$05/                   {jmp   +5       }
$3B/$C1/                   {cmp   ax,cx    }
$7C/$01/                   {jl    +1       }
$91);                      {xchg  ax,cx    }
{ Sign }
end;

PROCEDURE SwapInt( VAR a, b ); ASSEMBLER;
ASM
	LES     DI,[A]
	MOV     AX,ES:[DI]
	LES     DI,[B]
	XCHG    AX,ES:[DI]
	LES     DI,[A]
	MOV     ES:[DI],AX
END;


FUNCTION Sgn( a : Integer ) : Integer; ASSEMBLER;
ASM
	MOV     AX,[a]
	SAR     AX,$0E
	AND     AL,$FE
	INC     AX
END;

{**************************************************************************}

procedure PutPixelWindow(x,y:longint; col:byte);
begin
  if ( x >= wx1) and ( x <= wx2) and
     ( y >= wy1) and ( y <= wy2) then
       putpixel(x,y,col);
end;

(*procedure RectangleWindow( x1,y1, x2,y2, x3,y3, x4,y4 :longint; c:byte);
var pos:array[0..199,0..1] of longint;
  xdiv1,xdiv2,xdiv3,xdiv4:longint;
  ydiv1,ydiv2,ydiv3,ydiv4:longint;
  dir1,dir2,dir3,dir4:byte;
  ly,gy,y,tmp,step:longint;
begin
  { determine highest and lowest point + vertical window checking }
  ly:=MaxI(MinI(MinI(MinI(y1,y2),y3),y4), wy1);
  gy:=MinI(MaxI(MaxI(MaxI(y1,y2),y3),y4), wy2);

  if ly>wy2 then exit;
  if gy<wy1 then exit;

  { check directions (-1=down, 1=up) and calculate constants }
  dir1:=byte(y1<y2); xdiv1:=x2-x1; ydiv1:=y2-y1;
  dir2:=byte(y2<y3); xdiv2:=x3-x2; ydiv2:=y3-y2;
  dir3:=byte(y3<y4); xdiv3:=x4-x3; ydiv3:=y4-y3;
  dir4:=byte(y4<y1); xdiv4:=x1-x4; ydiv4:=y1-y4;

  y:=y1;
  step:=dir1*2-1;
  if y1<>y2 then begin
    repeat
      if InRangeI(y,ly,gy)=y then begin
	tmp:=xdiv1*(y-y1) div ydiv1+x1;
	pos[y,dir1]:=InRangeI(tmp,wx1,wx2);
      end;
      inc(y,step);
    until y=y2+step;
  end
  else begin
    if (y>=ly) and (y<=gy) then begin
      pos[y,dir1]:=InRangeI(x1,wx1,wx2);
    end;
  end;

  y:=y2;
  step:=dir2*2-1;
  if y2<>y3 then begin
    repeat
      if InRangeI(y,ly,gy)=y then begin
	tmp:=xdiv2*(y-y2) div ydiv2+x2;
	pos[y,dir2]:=InRangeI(tmp,wx1,wx2);
      end;
      inc(y,step);
    until y=y3+step;
  end
  else begin
    if (y>=ly) and (y<=gy) then begin
      pos[y,dir2]:=InRangeI(x2,wx1,wx2);
    end;
  end;

  y:=y3;
  step:=dir3*2-1;
  if y3<>y4 then begin
    repeat
      if InRangeI(y,ly,gy)=y then begin
	tmp:=xdiv3*(y-y3) div ydiv3+x3;
	pos[y,dir3]:=InRangeI(tmp,wx1,wx2);
      end;
      inc(y,step);
    until y=y4+step;
  end
  else begin
    if (y>=ly) and (y<=gy) then begin
      pos[y,dir3]:=InRangeI(x3,wx1,wx2);
    end;
  end;

  y:=y4;
  step:=dir4*2-1;
  if y4<>y1 then begin
    repeat
      if InRangeI(y,ly,gy)=y then begin
	tmp:=xdiv4*(y-y4) div ydiv4+x4;
	pos[y,dir4]:=InRangeI(tmp,wx1,wx2);
      end;
      inc(y,step);
    until y=y1+step;
  end
  else begin
    if (y>=ly) and (y<=gy) then begin
      pos[y,dir4]:=InRangeI(x4,wx2,wx2);
    end;
  end;

  for y:=ly to gy do horline(pos[y,0],pos[y,1],y,c);
end;(**)
(**)
(**)
Procedure RectangleWindow(lx1,ly1,lx2,ly2,lx3,ly3,lx4,ly4:longint;color:byte);
  { This draw a polygon with 4 points at x1,y1 , x2,y2 , x3,y3 , x4,y4
    in color col }
var
  x1,x2,x3,x4,y1,y2,y3,y4 : longint;
  x:longint;
  MinY,MaxY:longint;
  MinX,MaxX:longint;
  counter : longint;
  mul1, mul2, mul3, mul4 : longint;
  div1, div2, div3, div4 : longint;

begin
  if ((lx1 > wx2) and (lx2 > wx2) and (lx3 > wx2) and (lx4 > wx2)) or
     ((lx1 < wx1) and (lx2 < wx1) and (lx3 < wx1) and (lx4 < wx1)) or
     ((ly1 > wy2) and (ly2 > wy2) and (ly3 > wy2) and (ly4 > wy2)) or
     ((ly1 < wy1) and (ly2 < wy1) and (ly3 < wy1) and (ly4 < wy1)) then
     begin
       exit;
     end;

  x1 := integer(lx1); x2 := integer(lx2);
  x3 := integer(lx3); x4 := integer(lx4);
  y1 := integer(ly1); y2 := integer(ly2);
  y3 := integer(ly3); y4 := integer(ly4);
{  x1 := lx1;x2 := lx2;x3 := lx3;x4 := lx4;
  y1 := ly1;y2 := ly2;y3 := ly3;y4 := ly4;}

  MinY:=y1; MaxY:=y1;
  { Choose the min y MinY and max y MaxY }
  if y2<MinY then MinY:=y2;
  if y2>MaxY then MaxY:=y2;
  if y3<MinY then MinY:=y3;
  if y3>MaxY then MaxY:=y3;
  if y4<MinY then MinY:=y4;
  if y4>MaxY then MaxY:=y4;
  { Choose the min y MinY and max y MaxY }
  if MinY < wy1 then MinY:=wy1;
  if MaxY > wy2 then MaxY:=wy2;
  if MinY > wy2 then exit;
  if MaxY < wy1 then exit; { Verticle range checking }

  mul1 := x1-x4;
  mul2 := x2-x1;
  mul3 := x3-x2;
  mul4 := x4-x3;
  div1 := y1-y4;
  div2 := y2-y1;
  div3 := y3-y2;
  div4 := y4-y3;  { Constansts needed for intersection calc }

  for counter := MinY to MaxY do
    begin
      MinX:=320;
      MaxX:=-1;
      { Check that counter is between y1 and y4 }
      if (y4 >= counter) or (y1 >= counter) then
	if ( y4<=counter) or (y1 <= counter) then
	  if not(y4=y1) then
	    begin
	      x := counter-y4;
	      x := x * mul1;
	      x := x div div1;
	      inc(x,x4); { Point of intersection on x axis }
	      { Set point as start or end of horiz line }
	      if x < MinX then MinX := x;
	      if x > MaxX then MaxX := x;
	    end;
      { Check that counter is between y1 and y2 }
      if (y1 >= counter) or (y2 >= counter) then
	if (y1 <= counter) or (y2 <= counter) then
	  if not(y1=y2) then
	    begin
	      x := counter-y1;
	      x := x * mul2;
	      x := x div div2;
	      inc(x,x1); { Point of intersection on x axis }
	      if x<MinX then MinX:=x;
	      if x>MaxX then MaxX:=x;       { Set point as start or end of horiz line }
	    end;
      { Check that counter is between y2 and y3 }
      if (y2 >= counter) or (y3 >= counter) then
	if (y2 <= counter) or (y3 <= counter) then
	  if not(y2=y3) then
	    begin
	      x := counter-y2;
	      x := x * mul3;
	      x := x div div3;
	      inc(x,x2); { Point of intersection on x axis }
	      if x<MinX then MinX:=x;
	      if x>MaxX then MaxX:=x;       { Set point as start or end of horiz line }
	    end;
      { Check that counter is between y3 and y4 }
      if (y3 >= counter) or (y4 >= counter) then
	if (y3 <= counter) or (y4 <= counter) then
	  if not(y3=y4) then
	    begin
	      x := counter-y3;
	      x := x * mul4;
	      x := x div div4;
	      inc(x,x3); { Point of intersection on x axis }
	      if x<MinX then MinX:=x;
	      if x>MaxX then MaxX:=x;       { Set point as start or end of horiz line }
	    end;
      { Range checking on horizontal line }
      if MinX < wx1 then MinX:=wx1;
      if MaxX > wx2 then MaxX:=wx2;
      if MinX<=MaxX then horline(MinX,MaxX,counter,color);  { Draw the horizontal line }
    end;
  end;
(**)

{ -------------------------------------------------------------------------- }

Procedure LineWindow(a,b,c,d,col:longint);
  { This draws a line from a,b to c,d of color col. }
Function sgn(a:real):longint;
   BEGIN
	if a>0 then sgn:=+1;
	if a<0 then sgn:=-1;
	if a=0 then sgn:=0;
   END;
var u,s,v,d1x,d1y,d2x,d2y,m,n:real;
    i:integer;
BEGIN
     u:= c - a;
     v:= d - b;
     d1x:= SGN(u);
     d1y:= SGN(v);
     d2x:= SGN(u);
     d2y:= 0;
     m:= ABS(u);
     n := ABS(v);
     IF NOT (M>N) then
     BEGIN
	  d2x := 0 ;
	  d2y := SGN(v);
	  m := ABS(v);
	  n := ABS(u);
     END;
     s := INT(m / 2);
     FOR i := 0 TO round(m) DO
     BEGIN
	  PutPixelWindow(a,b,col);
	  s := s + n;
	  IF not (s<m) THEN
	  BEGIN
	       s := s - m;
	       a:= a +round(d1x);
	       b := b + round(d1y);
	  END
	  ELSE
	  BEGIN
	       a := a + round(d2x);
	       b := b + round(d2y);
	  END;
     END;
END;

Procedure TriAngleWindow(X1,Y1,X2,Y2,X3,Y3:longint; Color:Byte);
begin
 RectangleWindow(x1,y1,x2,y2,x3,y3,x3,y3,color);
end;

function Sprite2Page( s : TSprite ) : TPage;
begin
  Sprite2Page := s.mem;
  if (s.b <> 320) or (s.t <> 200)
    then Video13hError(' Spritesize is unequal to pagesize (320x200).');
end;

{ *************************************************************************

   PCX - ROUTINES

 ************************************************************************* }

type
  PCXPalettePtr = ^T_PCXPalette;
  T_PCXPalette = array[0..767] of Byte;
  PCXHeaderPtr=  ^T_PCXHeader;
  T_PCXHeader   =
    record
      Signature      :  Char;
      Version        :  Char;
      Encoding       :  Char;
      BitsPerPixel   :  Char;
      XMin,YMin,
      XMax,YMax      :  Integer;
      HRes,VRes      :  Integer;
      Palette        :  Array [0..47] of byte;
      Reserved       :  Char;
      Planes         :  Char;
      BytesPerLine   :  Integer;
      PaletteType    :  Integer;
      Filler         :  Array [0..57] of byte;
    end;

Procedure ExtractLineASM (BytesWide:Integer;Var Source,Dest:Pointer);
var
  DestSeg,
  DestOfs,
  SourceSeg,
  SourceOfs   :  Word;

begin
  SourceSeg := Seg (Source^);
  SourceOfs := Ofs (Source^);
  DestSeg   := Seg (Dest^);
  DestOfs   := Ofs (Dest^);

  asm
    push  ds
    push  si

    cld

    mov   ax,DestSeg
    mov   es,ax
    mov   di,DestOfs     { es:di -> destination pointer }

    mov   ax,SourceSeg
    mov   ds,ax
    mov   si,SourceOfs   { ds:si -> source buffer }

    mov   bx,di
    add   bx,BytesWide   { bx holds position to stop for this row }
    xor   cx,cx

  @@GetNextByte:
    cmp   bx,di          { are we done with the line }
    jbe   @@ExitHere

    lodsb                { al contains next byte }

    mov   ah,al
    and   ah,0C0h
    cmp   ah,0C0h

    jne    @@SingleByte
			 { must be a run of bytes }
    mov   cl,al
    and   cl,3Fh
    lodsb
    rep   stosb
    jmp   @@GetNextByte

  @@SingleByte:
    stosb
    jmp   @@GetNextByte

  @@ExitHere:

    mov   SourceSeg,ds
    mov   SourceOfs,si
    mov   DestSeg,es
    mov   DestOfs,di

    pop   si
    pop   ds
  end;

  Source := Ptr (SourceSeg,SourceOfs);
  Dest   := Ptr (DestSeg,DestOfs);
end;

Procedure DisplayPCX ( X,Y : Integer; PCXHeader : Pointer; Page : TPage );
var
  I,NumRows,
  BytesWide   :  Integer;
  Header      :  PCXHeaderPtr;
  DestPtr     :  Pointer;
  Offset      :  Word;

begin
  Header    := Ptr (Seg(PCXHeader^),Ofs(PCXHeader^));
  PCXHeader := Ptr (Seg(PCXHeader^),Ofs(PCXHeader^)+128);
  Offset    := Y * 320 + X;
  NumRows   := Header^.YMax - Header^.YMin + 1;
  BytesWide := Header^.XMax - Header^.XMin + 1;
  If Odd (BytesWide) then Inc (BytesWide);

  For I := 1 to NumRows do begin
    ExtractLineASM (BytesWide, PCXHeader , Page );
    Inc (Offset,320);
    end;
end;
{ end PCX stuff }

procedure LoadPCX( Name : String; Page : TPage );

VAR
  f         : File;          { PCX file }
  PCXHeader : PCXHeaderPtr;  { PCX header structure & file }
  Pal       : PCXPalettePtr; { PCX palette }
  Shade,
  Size      : Word;          { RGB shade, file size }

BEGIN
  { *** first load PCX-File into memory *** }
  Assign( f , Name);
  Reset( f, 1);
  Size := FileSize(F);
  GetMem( PCXHeader , Size);
  Blockread(F, PCXHeader^ , Size);
  Close(F);
  { *** get palette location *** }
  Pal := Ptr( Seg(PCXHeader^), Ofs(PCXHeader^) + Size - 768);
  { *** set palette *** }
  Port[968] := 0;
  FOR Shade := 0 TO 767 DO
    Port[969] := Pal^[Shade] SHR 2;
  { *** decode PCX to screen *** }
  DisplayPCX(0, 0, PCXHeader, Page );
  FreeMem(PCXHeader,Size);
END;

procedure BigLoadPCX( Name : String; Page : TPage; No : byte );

VAR
  PCXHeader : PCXHeaderPtr;  { PCX header structure & file }
  Pal       : PCXPalettePtr; { PCX palette }
  Shade,
  Size      : Word;          { RGB shade, file size }
  Check     : word;          { IO checker }

BEGIN
  { *** first load PCX-File into memory *** }
  {$I-}
  BigAssign( No, Name);
  BigReset( No , 1);
  {$I+}
  if IOResult <> 0 then
    Video13hError('Error occurred when trying to load "'+name+'".');
  Size := BigFileSize( No );
  GetMem( PCXHeader , Size);
  BigBlockread( No , PCXHeader^ , Size, Check);
  BigClose( No );
  { *** get palette location *** }
  Pal := Ptr( Seg(PCXHeader^), Ofs(PCXHeader^) + Size - 768);
  { *** set palette *** }
  Port[968] := 0;
  FOR Shade := 0 TO 767 DO
    Port[969] := Pal^[Shade] SHR 2;
  { *** decode PCX to screen *** }
  DisplayPCX(0, 0, PCXHeader, Page );
  Dispose( PCXHeader );
END;

PROCEDURE RLEComp(VAR SrcPtr:TPage; y:word;SrcNum :WORD; TgtPtr:Pointer; VAR TgtNum :WORD);
(*
  Methode   unkomprimiert     komprimiert

  RLE      D                  => D                 mit     D < 192
  ---
	   (D),(D),...,(D)    => (n+192),(D)       mit n+192 =  193..255
	                            bzw.    n =    1.. 63
	       n-mal

  SrcPtr enthlt die zu packenden Daten, deren Gre SrcNum angibt.
  TgtPtr ist der Zielbereich fr die komprimierten Daten, deren Gre
  nach dem Aufruf der Packroutine durch TgtNum bergeben wird.
  Es mu also vor Aufruf sichergestellt werden, da der Zielbereich
  gengend gro allokiert wird. Zu beachten ist, da der Umfang der
  gepackten Daten unter Umstnden grer als der des Quellbereichs
  sein kann; Bei der RLE-Methode im unangenehmsten Falle DOPPELT so gro!
*)
CONST Enc1      = $C0;
      Enc2      = Enc1 XOR $FF;
VAR   Source:Pointer;
      Target:Pointer;
      b,b1      :BYTE;
      i, j      :INTEGER;
      y1:word;
BEGIN
  Source := SrcPtr;
  Target := TgtPtr;
  TgtNum := 0;
  i := 0; {x}
  REPEAT
    j := i;
{    y1:=103;
    writelN(y1*320);
    writelN(' ',y,' ',j,' ',y*320);}
    b := mem[seg(Source^):ofs(Source^)+y*320+j];
    REPEAT
      Inc(j);
      if j<320 then b1:=mem[seg(Source^):ofs(Source^)+y*320+j] else b1:=b xor 1;
    UNTIL (j - i >= Enc2) OR (j >= SrcNum) OR (b1 <> b);
    IF (j - i > 1) OR (b >= Enc1) THEN BEGIN
      mem[seg(Target^):ofs(Target^)+TgtNum] := Enc1 + j - i;
      Inc(TgtNum);
      mem[seg(Target^):ofs(Target^)+TgtNum] := b;
    END
    ELSE mem[seg(Target^):ofs(Target^)+TgtNum] := b;
    Inc(TgtNum);
    i := j;
  UNTIL i >= SrcNum;
END;


PROCEDURE SavePCX(PCXFile :String;P:TPage;var Pal:TPal);
(*
  Sichert ein im Videospeicher befindliches Bild im PCX-Format v2.5 ab.
  Modus ist 320x200x256.
*)
Type  RGBType         = RECORD
	R, G, B       :BYTE;
      END;
      PCXHeaderType   = RECORD
	ID,
	Version,
	Compression,
	BitsPerPlane  :BYTE;
	x0, y0,
	x1, y1,
	xDpI, yDpI    :WORD;
	Palette       :ARRAY[0..15] OF RGBType;
	Reserved1,
	BitPlanes     :BYTE;
	BytesPerLine,
	PaletteType   :WORD;
	Reserved2     :ARRAY[1..58] OF BYTE;
      END;
CONST BeginPal        :BYTE = $0C;
VAR   PCXHeader       :PCXHeaderType;
      n, y            :WORD;
      f               :FILE;
      Buffer          :ARRAY[1..5000] OF BYTE;
      RGBPalette      :ARRAY[0..255] OF RGBType;
BEGIN
  FOR n := 0 TO 255 DO WITH RGBPalette[n] DO BEGIN
    R := Pal.R[n] SHL 2; (* Intensitten von 0..63 *)
    G := Pal.G[n] SHL 2; (* nach 0..252 skalieren  *)
    B := Pal.B[n] SHL 2;
  END;
  WITH PCXHeader DO BEGIN
    ID           := 10; (* Kennung als PCX-Datei *)
    Version      := 5;  (* Versionsnummer 2.5 *)
    BitsPerPlane := 8;  (* Bei 16Farbmodi hier 1 einsetzen *)
    BitPlanes    := 1;  (* Bei 16Farbmodi hier 4 einsetzen *)
    PaletteType  := 0;  (* Farbpalette, keine Graustufen *)
    Compression  := 1;  (* 0 fr unkomprimiert *)
    x0           := 0;
    y0           := 0;
    x1           := 319;
    y1           := 199;
    xDpI         := 96; (* Auflsung Pixel/Zoll fr X und Y *)
    yDpI         := 96; (* hlt sich aber kein Schwein dran *)
    Move(RGBPalette, Palette, Sizeof(Palette)); (* nur fr 16Farbmodi *)
    Reserved1    := 0;
    BytesPerLine := Succ(x1 - x0); (* 16Farbmodi: x1 SHR 3 - x0 SHR 3 + 1 *)
    FillChar(Reserved2, SizeOf(Reserved2), 0);
    Assign(f, PCXFile);
    Rewrite(f, 1);
    BlockWrite(f, PCXHeader, Sizeof(PCXHeader));
    FOR y := y0 TO y1 DO BEGIN
      RLEComp(P,y, Succ(x1 - x0), addr(Buffer), n);
(*
  Statt Video[y, x0] den gewnschten Speicher eintragen, wo die einzelnen
  Videozeilen liegen. Man kann auch ber mehrere Zeilen komprimieren, dann
  machen aber nicht alle Anwendungsprogramme mit.
*)
      BlockWrite(f, Buffer, n);
    END;
    IF BitsPerPlane = 8 THEN BEGIN (* 256Farbpalette anhngen *)
      BlockWrite(f, BeginPal, Sizeof(BeginPal));   (* Kennung *)
      BlockWrite(f, RGBPalette, Sizeof(RGBPalette));
    END;
  END;
  close(f);
END;


{ *************************************************************************

   MORE EFFECTIVE SPRITEROUTINES

 ************************************************************************* }

procedure PutSpriteWindowEff( x,y : integer; p : TSprite );
var breite,tiefe : integer;
    ausgleich : word;
    LTrag,OTrag,RTrag,UTrag : integer;
    Rest : word;
begin
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  asm inc wx2; inc wy2; end;
  {betrge berechnen}
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  {und weg damit wieder!!!}
  asm dec wx2; dec wy2 ; end;
  {reale breite und tiefe ermitteln}
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {ok, nun die breite/ rechter&linker-bertrag manipulieren}
  Rest := breite mod 4;
  breite := breite - Rest;
{  RTrag := RTrag + Rest;}
  {neue x und y position bestimmen}
  x := x + ltrag;
  y := y + otrag;
  {und nun das Mammut Assemblerteil}
  case Rest of
    0 : {*** einfach nur DWORDs schreiben!!! ***}
    asm
      {eigentlicher spritecode}
      push ds

      mov ax, 320
      sub ax, breite
      mov ausgleich, ax

      les di,ActVPage   {dest}
      mov ax,y   {y dazu}
      mov bx,320
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx,breite
	shr cx,2

	db $66; rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

	{hier den rest anhngen}
	{HIER: Nur DWORDs!!! kein REST! }

	add di, ausgleich {grafikausgleichen 320-breite}
	add si, rtrag     {rechter bertrag}


	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
      @@exit:
    end;
    1 : {*** einfach nur DWORDs schreiben und hinten ein BYTE dran!!! ***}
    asm
      {eigentlicher spritecode}
      push ds

      mov ax, 320
      sub ax, breite
      mov ausgleich, ax

      dec Ausgleich { ein weniger fr ausgleich, da 1 Byt dran!!!}

      les di,ActVPage   {dest}
      mov ax,y   {y dazu}
      mov bx,320
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx,breite
	shr cx,2

	db $66; rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

	{hier den rest anhngen // 1 Byte }
	movsb

	add di, ausgleich {grafikausgleichen 320-breite}
	add si, rtrag     {rechter bertrag}


	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
      @@exit:
    end;
    2 : {*** einfach nur DWORDs schreiben und hinten ein WORD dran!!! ***}
    asm
      {eigentlicher spritecode}
      push ds

      mov ax, 320
      sub ax, breite
      mov ausgleich, ax

      dec Ausgleich { ein weniger fr ausgleich, da 1 WORD dran!!!}
      dec Ausgleich

      les di,ActVPage   {dest}
      mov ax,y   {y dazu}
      mov bx,320
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx,breite
	shr cx,2

	db $66; rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

	{hier den rest anhngen // 1 Byte }
	movsw

	add di, ausgleich {grafikausgleichen 320-breite}
	add si, rtrag     {rechter bertrag}


	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
      @@exit:
    end;
    3 : {*** einfach nur DWORDs schreiben und hinten ein WORD &
	     ein BTYE dran!!! ***}
    asm
      {eigentlicher spritecode}
      push ds

      mov ax, 320
      sub ax, breite
      mov ausgleich, ax

      dec Ausgleich { ein weniger fr ausgleich, da 1 WORD & 1 Byte dran!!!}
      dec Ausgleich
      dec Ausgleich

      les di,ActVPage   {dest}
      mov ax,y   {y dazu}
      mov bx,320
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx,breite
	shr cx,2

	db $66; rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

	{hier den rest anhngen // 1 Word & 1 Byte }
	movsw
	movsb

	add di, ausgleich {grafikausgleichen 320-breite}
	add si, rtrag     {rechter bertrag}


	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
      @@exit:
    end;
  end;
end;

procedure PutSpriteWindowTransEff(x,y : integer; trans : byte; p : TSprite);
var
  breite,tiefe : integer;
  ausgleich : word;
  ltrag,otrag,rtrag,utrag : integer;
  Rest : Word;
begin
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  asm inc wx2; inc wy2; end;
  {betrge berechnen}
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  {und weg damit wieder!!!}
  asm dec wx2; dec wy2; end;
  {reale breite und tiefe ermitteln}
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {ok, nun die breite/ rechter&linker-bertrag manipulieren}
  Rest := breite mod 2;
  breite := breite - Rest;
  {neue x und y position bestimmen}
  asm
    {x := x + ltrag;}
    mov ax,x
    add ax,ltrag
    mov x, ax
    {y := y + otrag;}
    mov ax,y
    add ax,otrag
    mov y, ax
  end;
  case Rest of
    0:  {*** einfach nur DWORDs lesen & BYTES schreiben!!! ***}
    asm
      push ds

      mov ax, 320
      sub ax, breite
      mov ausgleich, ax

      les di,ActVPage   {dest}
      mov ax,y   {y dazu}
      mov bx,320
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx, breite {Breite}
	shr cx,1       {nur die Hlfte der Abfragen}

	@@loop2:
	  { Read a word }
	  mov ax, [DS:SI]

	  {low-byte}
	  cmp al, trans
	  jz @@weiter1
	    mov [es:di],al
	  @@weiter1:
	  inc di
	  inc si
	  {high-byte}
	  cmp ah, trans
	  jz @@weiter2
	    mov [es:di],ah
	  @@weiter2:
	  inc di
	  inc si


	dec cx
	cmp cx,0
	jnz @@loop2

	add di, ausgleich {grafikausgleichen 320-breite}
	add si, rtrag     {rechter bertrag}

	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
    end;
    1:  {*** einfach nur WORDs lesen & BYTES schreiben
	     und am ende jeder Zeile ewentuell ein Byte anhngen !!! ***}
    asm
      push ds

      mov ax, 320
      sub ax, breite
      mov ausgleich, ax

      dec Ausgleich { *** Ein Byte weniger Ausgleich *** }

      les di,ActVPage   {dest}
      mov ax,y   {y dazu}
      mov bx,320
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx, breite {Breite}
	shr cx,1       {nur die Hlfte der Abfragen}

	cmp cx,0
	jz @@only_a_byte
	  @@loop2:
	    { Read a word }
	    mov ax, [DS:SI]

	    {low-byte}
	    cmp al, trans
	    jz @@weiter1
	      mov [es:di],al
	    @@weiter1:
	    inc di
	    inc si
	    {high-byte}
	    cmp ah, trans
	    jz @@weiter2
	      mov [es:di],ah
	    @@weiter2:
	    inc di
	    inc si


	  dec cx
	  cmp cx,0
	  jnz @@loop2
	@@only_a_byte:

	{ok, am ende der Zeile vieleicht noch ein Byte dranhngen!!!}
	mov al,[ds:si]
	cmp al,trans
	jz @@weiter3
	  mov [es:di],al
	@@weiter3:
	inc di
	inc si

	add di, ausgleich {grafikausgleichen 320-breite}
	add si, rtrag     {rechter bertrag}

	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
    end;
  end;
end;

function GetPixelfromSprite(x,y:integer; var p:TSprite):byte;
var
  b:byte;
  t : Tsprite;
begin
  if ( x < 0 ) or ( y < 0) or
     ( x > p.b-1 ) or ( y > p.t-1 ) then
       begin
	 GetPixelFromSprite := 0;
	 exit;
       end;
  t := p;
  asm
    les di, t.mem

    mov ax, t.b
    mov bx, y
    mul bx
    add ax, x

    add di, ax

    mov al, [es:di]
    mov b,  al
  end;
  GetPixelFromSprite := b;
end;

procedure PutSprite2Sprite( x,y : integer; p, destp : TSprite);
var breite,tiefe : integer;
    ausgleich : word;
    LTrag,OTrag,RTrag,UTrag : integer;
    Rest : word;
    swx1, swx2, swy1, swy2:integer;
    destbreite:word;
begin
  swx1:=0; swy1:=0; swx2:=destp.b-1; swy2:=destp.t-1;
  destbreite:=destp.b; {war sonst das 320}
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  asm inc swx2; inc swy2;
  {betrge berechnen}
{  if x < swx1 then ltrag := swx1-x else ltrag := 0;}
    mov LTrag, 0

    mov ax, x
    mov bx, swx1
    cmp ax,bx

    jge @@weiter1
      sub bx, ax
      mov LTrag, bx

    @@weiter1:

{  if y < swy1 then otrag := swy1-y else otrag := 0;}
    mov OTrag, 0

    mov ax, y
    mov bx, swy1
    cmp ax,bx

    jge @@weiter2
      sub bx, ax
      mov OTrag, bx

    @@weiter2:
{  if x+p.b > swx2 then rtrag := x+p.b-swx2 else rtrag := 0;}
    mov RTrag, 0

    mov ax, x
    add ax, p.b

    mov bx, swx2

    cmp ax,bx

    jle @@weiter3
      sub ax, bx
      mov RTrag, ax

    @@weiter3:
{  if y+p.t > swy2 then utrag := y+p.t-swy2 else utrag := 0;}
    mov UTrag, 0

    mov ax, y
    add ax, p.t

    mov bx, swy2

    cmp ax,bx

    jle @@weiter4
      sub ax, bx
      mov UTrag, ax

    @@weiter4:

  {und weg damit wieder!!!}
  dec swx2; dec swy2 ;
  {reale breite und tiefe ermitteln}
{  breite := p.b - ltrag - rtrag;}
    mov ax, p.b
    sub ax, ltrag
    sub ax, rtrag
    mov Breite, ax
{  tiefe := p.t - otrag - utrag;}
    mov ax, p.t
    sub ax, otrag
    sub ax, utrag
    mov Tiefe, ax
  end;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {ok, nun die breite/ rechter&linker-bertrag manipulieren}
  Rest := breite mod 4;
  asm
{  breite := breite - Rest;}
    mov ax, breite
    sub ax, rest
    mov breite, ax
  end;
{  RTrag := RTrag + Rest;}
  {neue x und y position bestimmen}
  asm
{  x := x + ltrag;}
    mov ax, x
    add ax, ltrag
    mov x, ax
{  y := y + otrag;}
    mov ax, y
    add ax, otrag
    mov y, ax
  end;
  {und nun das Mammut Assemblerteil}
  case Rest of
    0 : {*** einfach nur DWORDs schreiben!!! ***}
    asm
      {eigentlicher spritecode}
      push ds

      mov ax, destbreite
      sub ax, breite
      mov ausgleich, ax

      les di,destp.mem   {dest}
      mov ax,y   {y dazu}
      mov bx,destbreite
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx,breite
	shr cx,2

	db $66; rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

	{hier den rest anhngen}
	{HIER: Nur DWORDs!!! kein REST! }

	add di, ausgleich {grafikausgleichen destbreite-breite}
	add si, rtrag     {rechter bertrag}


	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
      @@exit:
    end;
    1 : {*** einfach nur DWORDs schreiben und hinten ein BYTE dran!!! ***}
    asm
      {eigentlicher spritecode}
      push ds

      mov ax, destbreite
      sub ax, breite
      mov ausgleich, ax

      dec Ausgleich { ein weniger fr ausgleich, da 1 Byt dran!!!}

      les di,destp.mem   {dest}
      mov ax,y   {y dazu}
      mov bx,destbreite
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx,breite
	shr cx,2

	db $66; rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

	{hier den rest anhngen // 1 Byte }
	movsb

	add di, ausgleich {grafikausgleichen destbreite-breite}
	add si, rtrag     {rechter bertrag}


	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
      @@exit:
    end;
    2 : {*** einfach nur DWORDs schreiben und hinten ein WORD dran!!! ***}
    asm
      {eigentlicher spritecode}
      push ds

      mov ax, destbreite
      sub ax, breite
      mov ausgleich, ax

      dec Ausgleich { ein weniger fr ausgleich, da 1 WORD dran!!!}
      dec Ausgleich

      les di,destp.mem   {dest}
      mov ax,y   {y dazu}
      mov bx,destbreite
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx,breite
	shr cx,2

	db $66; rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

	{hier den rest anhngen // 1 Byte }
	movsw

	add di, ausgleich {grafikausgleichen destbreite-breite}
	add si, rtrag     {rechter bertrag}


	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
      @@exit:
    end;
    3 : {*** einfach nur DWORDs schreiben und hinten ein WORD &
	     ein BTYE dran!!! ***}
    asm
      {eigentlicher spritecode}
      push ds

      mov ax, destbreite
      sub ax, breite
      mov ausgleich, ax

      dec Ausgleich { ein weniger fr ausgleich, da 1 WORD & 1 Byte dran!!!}
      dec Ausgleich
      dec Ausgleich

      les di,destp.mem   {dest}
      mov ax,y   {y dazu}
      mov bx,destbreite
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx,breite
	shr cx,2

	db $66; rep movsw {{ [ES:DI] := [DS:SI] // CX = ANZAHL DER MOVES!!! }

	{hier den rest anhngen // 1 Word & 1 Byte }
	movsw
	movsb

	add di, ausgleich {grafikausgleichen destbreite-breite}
	add si, rtrag     {rechter bertrag}


	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
      @@exit:
    end;
  end;
end; (* *)

procedure PutSprite2SpriteTrans(x,y : integer; trans : byte; p, destp : TSprite);
var
  breite,tiefe : integer;
  ausgleich : word;
  ltrag,otrag,rtrag,utrag : integer;
  Rest : Word;
  swx1, swx2, swy1, swy2:integer;
  destbreite:word;

begin
  swx1:=0; swy1:=0; swx2:=destp.b-1; swy2:=destp.t-1;
  destbreite:=destp.b; {war sonst das 320}

  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  asm inc swx2; inc swy2;
  {betrge berechnen}
{  if x < swx1 then ltrag := swx1-x else ltrag := 0;}
    mov LTrag, 0

    mov ax, x
    mov bx, swx1
    cmp ax,bx

    jge @@weiter1
      sub bx, ax
      mov LTrag, bx

    @@weiter1:

{  if y < swy1 then otrag := swy1-y else otrag := 0;}
    mov OTrag, 0

    mov ax, y
    mov bx, swy1
    cmp ax,bx

    jge @@weiter2
      sub bx, ax
      mov OTrag, bx

    @@weiter2:
{  if x+p.b > swx2 then rtrag := x+p.b-swx2 else rtrag := 0;}
    mov RTrag, 0

    mov ax, x
    add ax, p.b

    mov bx, swx2

    cmp ax,bx

    jle @@weiter3
      sub ax, bx
      mov RTrag, ax

    @@weiter3:
{  if y+p.t > swy2 then utrag := y+p.t-swy2 else utrag := 0;}
    mov UTrag, 0

    mov ax, y
    add ax, p.t

    mov bx, swy2

    cmp ax,bx

    jle @@weiter4
      sub ax, bx
      mov UTrag, ax

    @@weiter4:

  {und weg damit wieder!!!}
   dec swx2; dec swy2;
  {reale breite und tiefe ermitteln}
{  breite := p.b - ltrag - rtrag;}
    mov ax, p.b
    sub ax, ltrag
    sub ax, rtrag
    mov Breite, ax
{  tiefe := p.t - otrag - utrag;}
    mov ax, p.t
    sub ax, otrag
    sub ax, utrag
    mov Tiefe, ax
  end;
  {wenn kleiner oder gleich Null, dann raus}
  if (breite <= 0) or (tiefe <= 0) then exit;
  {ok, nun die breite/ rechter&linker-bertrag manipulieren}
asm
{  Rest := breite mod 2;}
    mov ax, Breite
    mov bx, ax

    shr ax,1
    shl ax,1

    sub bx, ax
    mov Rest, bx
{  breite := breite - Rest;}
    mov ax, Breite
    sub ax, Rest
    mov Breite, ax
  {neue x und y position bestimmen}
{    x := x + ltrag;}
    mov ax,x
    add ax,ltrag
    mov x, ax
{    y := y + otrag;}
    mov ax,y
    add ax,otrag
    mov y, ax
  end;
  case Rest of
    0:  {*** einfach nur DWORDs lesen & BYTES schreiben!!! ***}
    asm
      push ds

      mov ax, destbreite
      sub ax, breite
      mov ausgleich, ax

      les di,destp.mem   {dest}
      mov ax,y   {y dazu}
      mov bx,destbreite
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loop:

	add si, ltrag {linker bertrag}

	mov cx, breite {Breite}
	shr cx,1       {nur die Hlfte der Abfragen}

	@@loop2:
	  { Read a word }
	  mov ax, [DS:SI]

	  {low-byte}
	  cmp al, trans
	  jz @@weiter1
	    mov [es:di],al
	  @@weiter1:
	  inc di
	  inc si
	  {high-byte}
	  cmp ah, trans
	  jz @@weiter2
	    mov [es:di],ah
	  @@weiter2:
	  inc di
	  inc si


	dec cx
	cmp cx,0
	jnz @@loop2

	add di, ausgleich {grafikausgleichen destbreite-breite}
	add si, rtrag     {rechter bertrag}

	inc dx
	cmp dx, tiefe
	jnz @@loop

      pop ds
    end;
    1:  {*** einfach nur DWORDs lesen & BYTES schreiben
	     und am ende jeder Zeile ewentuell ein Byte anhngen !!! ***}
    asm
      push ds

      mov ax, destbreite
      sub ax, breite
      mov ausgleich, ax

      dec Ausgleich { *** Ein Byte weniger Ausgleich *** }

      les di,destp.mem   {dest}
      mov ax,y   {y dazu}
      mov bx,destbreite
      mul bx
      add ax,x   {x dazu}
      add di,ax

      lds si, p.mem { Source }
      mov ax, otrag {ausgleich}
      mov bx, p.b
      mul bx
      add si,ax

      mov dx,0
      @@loopA:

	add si, ltrag {linker bertrag}

	mov cx, breite {Breite}
	shr cx,1       {nur die Hlfte der Abfragen}

	cmp cx,0
	jz @@only_a_byte
	  @@loop2A:
	    { Read a word }
	    mov ax, [DS:SI]

	    {low-byte}
	    cmp al, trans
	    jz @@weiter1A
	      mov [es:di],al
	    @@weiter1A:
	    inc di
	    inc si
	    {high-byte}
	    cmp ah, trans
	    jz @@weiter2A
	      mov [es:di],ah
	    @@weiter2A:
	    inc di
	    inc si


	  dec cx
	  cmp cx,0
	  jnz @@loop2A
	@@only_a_byte:

	{ok, am ende der Zeile vieleicht noch ein Byte dranhngen!!!}
	mov al,[ds:si]
	cmp al,trans
	jz @@weiter3
	  mov [es:di],al
	@@weiter3:
	inc di
	inc si

	add di, ausgleich {grafikausgleichen destbreite-breite}
	add si, rtrag     {rechter bertrag}

	inc dx
	cmp dx, tiefe
	jnz @@loopA

      pop ds
    end;
  end;
end;     (*  *)

procedure ClearSprite(p:TSprite);
var l:word;
    ganz1,rest1,ganz2,rest2:word;
begin
  l:=p.b*p.t;
  rest1:=l mod 4;
  ganz1:=l div 4;
  l:=rest1;
  rest2:=l mod 2;
  ganz2:=l div 2;
  asm
    les di,p.mem
    db 66H
    xor ax,ax
    mov cx,ganz1
    db 66H
    rep stosw
    mov cx,ganz2
    rep stosw
    mov cx,rest2
    rep stosb
  end;
end;

procedure PutPixel2Sprite(p:TSprite; x,y : integer; c : byte);
var b:word;
begin
  b:=p.b;
  if (x>b-1) or (y>p.t-1) or (x<0) or (y<0) then exit;
asm
  mov ax,y
  mov bx,b
  mul bx
  add ax,x

  mov cl,c
  les di, p.mem
  add di,ax
  mov [es:di],cl
end;
end;

Procedure Line2Sprite(p:TSprite;a,b,c,d,col:longint);
  { This draws a line from a,b to c,d of color col. }
  Function sgn(a:real):integer;
  begin
    if a>0 then sgn:=+1;
    if a<0 then sgn:=-1;
    if a=0 then sgn:=0;
  end;
var u,s,v,d1x,d1y,d2x,d2y,m,n:real;
    i:integer;
BEGIN
  u:= c - a;
  v:= d - b;
  d1x:= SGN(u);
  d1y:= SGN(v);
  d2x:= SGN(u);
  d2y:= 0;
  m:= ABS(u);
  n := ABS(v);
  IF NOT (M>N) then
    BEGIN
      d2x := 0 ;
      d2y := SGN(v);
      m := ABS(v);
      n := ABS(u);
    END;

  s := INT(m / 2);
  FOR i := 0 TO round(m) DO
    BEGIN
      PutPixel2Sprite(p,a,b,col);
      s := s + n;
      IF not (s<m) THEN
	 BEGIN
	   s := s - m;
	   a:= a +round(d1x);
	   b := b + round(d1y);
	 END
       ELSE
	 BEGIN
	   a := a + round(d2x);
	   b := b + round(d2y);
	 END;
   END;
END;

var
  t : string;


begin
  t := copyright;
end.
