{
  _VIDEOHI.PAS : Shareware-version.

         -  Fast video-unit especially for games.
         -  Supports Protected Mode.
         -  Use virtual screen as many as you like ( you memory have )
         -  Set window-borders for easy drawing
         -  Over 80(!) functions included

  (c) vIRTUAL tECHNOLOGIES 1996

  Version 6.0b

  Registered version includes BigFileSupport and Spritescaling!

  Distribition via any media is explicit allowed.

  DISCLAIMER:
  We give no warranty for this code, because it was firstly coded for us,
  and not for the public.
  But after lot of people asking us for releasing the source, we decided,
  to make it as unit available.
  But however, I really don't think that there is a bug in this unit.
  We use this videosystem in our own productions for years without
  any problems.

  for more information, questions and register contact us:

    Ansgar Scherp
    scherp.ansgar@informatik.uni-oldenburg.de

    Joachim Gelhaus
    j.gelhaus@flight.gun.de

    http://www.informatik.uni-oldenburg.de/~virtech/

    Mailbox : + 49 (0) 4441 / 851887
    Hotline : + 49 (0) 4441 / 851717 (english, german)

  To create your own Sprites, Backgrounds... , we decided to included routines
  to load clipboard files and palette files as used by the shareware painting
  program Improces by John Wagner.
  LoadPCX and SavePCX routines for loading and saving a page from/to disk are
  also included.
}

{DEFINE ShareWare}

{$IFNDEF DPMI}
...no, only for protected mode
{$ENDIF}

unit _VideoHi;

interface

uses _Video13;

type
  TPage101h = array[0..5] of pointer;

const
  Mode101h : word = $101; {der Bildschirmmodus 640x480x256}

{ initialise/close Video13hSystem }
procedure InitVideo101h;
procedure CloseVideo101h;

{ set the ActivePage, on which you want to draw }
procedure ActivePage101h(var page : TPage101h);

{ set a video mode; Mode101h ($101) is for VESA-SVGA-Mode 640x480x256 }
procedure SetVideoMode101h(m:word);

{ set window-edges of ActivePage }
procedure SetWindow101h(x1,y1,x2,y2:longint);

{ display an error message }
procedure Video101hError(t:string);


{ copy a virtual screen to another virtual screen }
procedure CopyP2P101h(var Src,Dst:TPage101h);
{ copy a virtual screen to visual screen }
procedure CopyP2V101h(VAR page:TPage101h);

{ clears a virtual screen }
procedure ClearPage101h( page:TPage101h);
{ clears the visual page }
procedure ClearVisualPage101h;

{ initialies a new virtual page }
procedure InitPage101h(var page:TPage101h);
{ closes a virtual page }
procedure ClosePage101h(var page:TPage101h);

{ puts/gets a pixel directly to/from visual screen }
procedure DirectPutPixel101h(x,y : integer; c : byte);
function  DirectGetPixel101h(x,y:integer):byte;

{ puts/gets a pixel to/from current active virtual screen }
procedure PutPixel101h(x,y:integer; c:byte);
function  GetPixel101h(x,y:integer ) : byte;

{ draws a line to current active virtual screen }
procedure Line101h( x1, y1, x2, y2 : Integer; color : Byte );

{ puts sprites to current active virtual screen }
procedure PutSpriteWindow101h(x,y:integer; p: TSprite);
procedure PutSpriteWindowW101h(x,y:integer; p: TSprite);
procedure PutSpriteWindowD101h(x,y:integer; p: TSprite );
procedure PutSpriteWindowTrans101h(x,y:integer; trans:byte; p: TSprite );
procedure PutSpriteWindowWTrans101h(x,y:integer; trans:byte; p: TSprite );
procedure PutSpriteWindowHide101h(x,y:integer; hide:byte; p: TSprite );
procedure PutSpriteWindowShadow101h(x,y:integer; subtract,border:byte; p: TSprite );
procedure PutSpriteWindowEff101h(x,y:integer; p: TSprite );
procedure PutSpriteWindowTransEff101h(x,y:integer; trans: byte; p: TSprite );

{$IFNDEF ShareWare}
procedure PutSpriteScaled101h(x,y,dx,dy:integer; p: TSprite );
procedure PutSpritePerCent101h(x,y:integer; factor:real; p : tsprite);
procedure PutSpriteScaledTrans101h(x,y,dx,dy:integer; Tcol:byte; p: Tsprite );
procedure PutSpritePerCentTrans101h(x,y:integer; factor:real; Tcol:byte; p : TSprite );
{$ENDIF}

{ puts/gets a pixel to/from current active virtual screen /
  looking for window-borders;  }
procedure PutPixelWindow101h(x,y : longint; c : byte);
function  GetPixelWindow101h(x,y : longint):byte;

{ draws an filled rectangle on the current virtual screen }
procedure RectangleWindow101h(x1,y1,x2,y2,x3,y3,x4,y4:longint; c : byte);
{ draws an filled triangle on the current virtual screen }
procedure TriangleWindow101h(x1,y1,x2,y2,x3,y3:longint; c : byte);
{ draws a line on the current virtual screen }
procedure LineWindow101h( x1, y1, x2, y2 : longint; color : Byte );

{ draws a box on the screen filled with a selected color }
procedure Box101h(x1,y1,x2,y2:integer; c:byte);

{ copy parts of a virtual screen to another virtual screen }
procedure CopyBoxP2P101h(x1,y1,x2,y2:integer; src, dst : TPage101h);
procedure CopyBoxP2PW101h(x1,y1,x2,y2:integer; src, dst : TPage101h);
procedure CopyBoxP2PD101h(x1,y1,x2,y2:integer; src, dst : TPage101h);
procedure CopyBoxP2PEff101h(x1,y1,x2,y2:integer; src, dst : TPage101h);
procedure CopyBoxWindowP2PEff101h(x1,y1,x2,y2:integer; src, dst : TPage101h);

{ move parts of a virtual screen to another virtual screen }
procedure MoveBoxWindowP2PEff101h( x1,y1,x2,y2:integer; src, dst : TPage101h;
                                   x,y : integer);


{ load a 640x480 big file directly to a virtual screen }
{$IFNDEF ShareWare}
procedure BigLoadTitle101h( n : String; s : TPage101h; no : byte );
{$ENDIF}

{ gets a sprite from screen }
procedure GetSprite101h(x,y:integer; p: TSprite );


{
  No, this source is not free now!
  For register the unit or getting the source code, please contact us.
 }


implementation

uses _DPMI{$IFNDEF ShareWare}, _BigLoad{$ENDIF};

const
  Copyright = '(c) vIRTUAL tECHNOLOGIES 1993-1996 - Ansgar Scherp, Joachim Gelhaus';

{Dir wirkliche Scale-routine}
{$F+}
{$L _SCALE1.OBJ}
{$L _SCALE2.OBJ}
procedure _Scale1( X,Y,DW,DY,SW,SH:integer;Bitmap:pointer); external;
procedure _Scale1Trans( X,Y,DW,DY,SW,SH:integer; Bitmap:pointer ); external;
{$F-}

var
  FreeMemory : longint;

type
  modes   = array[0..255] of word;
  p_modes = ^modes;
  asciiz   = array[0..255] of char;
  p_asciiz = ^asciiz;

  vesainfotype =
    record
      signature    : array[0..3] of char; {VESA}
      version      : array[0..1] of byte;
      OEMName      : p_asciiz; { Hersteller }
      capabilities : array[0..3] of byte;
      vmodes       : p_modes;
      reserved     : array[0..237] of byte;
    end;

  modeinfotype =
    record
      attributes       : word;
      winA             : byte;
      winB             : byte;
      granularity      : word; { KB-increment for moving windows }
      size             : word; { in KB }
      segA             : word; { segmant of winA }
      segB             : word;
      eqv4f05          : longint;
      bytesperscanline : word; { optional, siehe at_optional_available }
      width            : word;  { Breite in Pixeln }
      height           : word; { Hhe in Pixeln }
      characterwidth   : byte; { Zeichenbreite }
      characterheight  : byte; { Zeichenhhe }
      planes           : byte; { BitPlanes }
      bitsperpixel     : byte;
      banks            : byte;
      memorymodel      : byte;
      sizeofbank       : byte; { in KB }
      res              : array[0..256-$1e] of byte; { Auffller zu 256 Bytes }
    end;

var
  Page0101h      : TPage101h;
  VisualPage101h : TPage101h;
  ActVPage101h   : TPage101h; {Auf diesen pointer beziehen sich alle Grafikroutinen}
  Regs           : TRealModeRegs;
  LowMemoryBlock : TLowMemoryBlock; { ACHTUNG: Wird global benutzt! }
  VesaInfo       : vesainfotype;
  ModeInfo       : modeinfotype;
  Granny         : byte;
  BankNr         : byte;
  WinX1,WinX2,
  WinY1,WinY2    : integer; {globale Vars! Grenzen des sichtfensters! }

const
  Windows101h : array[0..5,1..4] of integer = ((0,319,0,199),
                                               (0,319,0,199),
                                               (0,319,0,199),
                                               (0,319,0,199),
                                               (0,319,0,199),
                                               (0,319,0,199));

{ Have a look at the online manual of Turbo/Borland Pascal (Keyword: STR)
  Converts any integer type to a string }
function IntToStr( HelpInt : LongInt ): string;
var
  HelpString : string;
begin
  Str( HelpInt , HelpString );
  IntToStr := HelpString;
end;

{VESA COMPATIBLE}
procedure SetVideoMode101h(m:word);
begin
  regs.ax:=$4f02;
  Regs.bx:=m;
  if SimRealModeInt($10,Regs)=false then
  begin
    writeln(GetSimRealModeIntError);
    halt(0);
  end;
end;

function GetPage(x,y : integer):word;
var SubPage : byte;
begin
  if x <= 319 then SubPage := 0 else SubPage := 1;
  if y >= 400 then inc(SubPage,4)
     else if y >= 200 then inc(SubPage,2);
  GetPage := SubPage;
end;

function CalcPageX(x:integer;b:word):integer;
begin
{  case b of
    1,3,5 : rx:=x-320;
    0,2,4 : rx:=x;
  end;
  CalcPageX:=rx;}
  asm
    cmp b,0
    je @ende
    cmp b,2
    je @ende
    cmp b,4
    je @ende
      sub x,320 {page 1 oder 3 oder 5}
    @ende:
  end;
  CalcPageX := x;
end;

function CalcPageY(y:integer;b:word):integer;
begin
{  case b of
    0,1 : ry:=y;
    2,3 : ry:=y-200;
    4,5 : ry:=y-400;
  end;
  CalcPageY:=ry;}
  asm
    cmp b,2
    jb @ende
      sub y,200 {page 2 oder 3}
      cmp b,4
      jb @ende
      sub y, 200; {insg. also 400 //page 4 oder 5}
    @ende:
  end;
  CalcPageY := y
end;

function CheckInArea(bank:byte;x,y:longint;p: TSprite):byte;
var breite,tiefe : integer;
    ltrag,otrag,rtrag,utrag : integer;
    b:byte;
begin
  SetWindow(Windows101h[bank,1],Windows101h[bank,3],Windows101h[bank,2],Windows101h[bank,4]);
  {damit auf zeile 199 und spalte 319 auch gezeichnet wird}
  inc(wx2); inc(wy2);
  {betrge berechnen}
  if x < wx1 then ltrag := wx1-x else ltrag := 0;
  if y < wy1 then otrag := wy1-y else otrag := 0;
  if x+p.b > wx2 then rtrag := x+p.b-wx2 else rtrag := 0;
  if y+p.t > wy2 then utrag := y+p.t-wy2 else utrag := 0;
  {und weg damit wieder!!!}
  dec(wx2); dec(wy2);
  {reale breite und tiefe ermitteln}
  breite := p.b - ltrag - rtrag;
  tiefe := p.t - otrag - utrag;
  {wenn kleiner oder gleich Null, dann raus}
  {Das Sprite ist in dem Fenster ...}
  if (breite < p.b) or (tiefe < p.t) then b:=1; {teileweise zu sehen}
  if (breite = p.b) and (tiefe = p.t) then b:=2; {komplett drin}
  if (breite <= 0)   or (tiefe <= 0)  then b:=0; {nicht drin}
  setwindow(0,0,319,199);
  CheckInArea := b;
end;

{VESA COMPATIBLE}
procedure SetWindow101h(x1,y1,x2,y2:longint);
  var h : longint;
      bank:byte;
      rx1,rx2,ry1,ry2:integer;
begin
  if x1 < 0 then x1 := 0;
  if x1 > 639 then x1 := 639;
  if y1 < 0 then y1 := 0;
  if y1 > 479 then y1 := 479;
  if x1 > x2 then begin h := x2; x2 := x1; x1 := h; end;
  if y1 > y2 then begin h := y2; y2 := y1; y1 := h; end;

  WinX1 := x1; WinX2 := x2; WinY1 := y1; WinY2 := y2;

  for bank:=0 to 5 do begin
    rx1:=CalcPageX(x1,bank); ry1:=CalcPageY(y1,bank);
    rx2:=CalcPageX(x2,bank); ry2:=CalcPageY(y2,bank);
    setwindow(rx1,ry1,rx2,ry2);
    if (wx1=wx2) or (wy1=wy2) then
      begin
        wx1:=0; wx2:=0; wy1:=0; wy2:=0;
      end;
    windows101h[bank,1]:=wx1; windows101h[bank,2]:=wx2;
    windows101h[bank,3]:=wy1; windows101h[bank,4]:=wy2;
  end;
end;

{VESA COMPATIBLE}
procedure SetBank(b:byte);
begin
  regs.ax:=$4f05;
  Regs.bx:=$0000;
  Regs.dx:=b*granny;
  SimRealModeInt($10,Regs);
  regs.ax:=$4f05;
  Regs.bx:=$0001;
  Regs.dx:=b*granny;
  SimRealModeInt($10,Regs);
  banknr:=b;
end;

{VESA COMPATIBLE}
procedure GetVESAInfo;
var bes,bdi,bcx:word;
    bah,bal:byte;
    x:word;
    segment,offset:word;
begin
  AllocateLowMem( LowMemoryBlock ,300);
  ClearRealRegs(regs);
  Regs.es:=LowMemoryBlock.RealModeSeg;
  Regs.ax:=$4f00;
  if SimRealModeInt($10,Regs)=false then
    begin
      writeln(GetSimRealModeIntError);
      halt(0);
    end;
  for x:=0 to sizeof(vesainfo)-1 do mem[seg(vesainfo):ofs(vesainfo)+x]:=mem[LowMemoryBlock.ProtModeSel:x];
  FreeLowMem(LowMemoryBlock);
end;

{VESA COMPATIBLE}
procedure GetModeInfo(m:word);
var bes,bdi,bcx:word;
    bah,bal:byte;
    x:word;
    segment,offset:word;
begin
  AllocateLowMem(LowMemoryBlock,300);
  ClearRealRegs(regs);
  Regs.es:=LowMemoryBlock.RealModeSeg;
  Regs.cx:=m;
  Regs.ax:=$4f01;
  if SimRealModeInt($10,Regs)=false then
    begin
      writeln(GetSimRealModeIntError);
      halt(0);
    end;
  for x:=0 to sizeof(modeinfo)-1 do mem[seg(modeinfo):ofs(modeinfo)+x]:=mem[LowMemoryBlock.ProtModeSel:x];
  FreeLowMem(LowMemoryBlock);
  granny:=64 div modeinfo.granularity;
end;

{VESA COMPATIBLE}
procedure InitVideo101h;
var ch:char;
begin
  Page0101h[0]       := ptr(SegA000,0);
  VisualPage101h[0]  := ptr(SegA000,0);

  SetWindow101h(0,0,639,479);
  {Check if VESA is available}
  GetVESAInfo;
  if vesainfo.Signature='VESA' then writeln('VESA VBE      : found!');
  if vesainfo.Signature<>'VESA' then writeln('VESA VBE      : not found!');
  if vesainfo.Signature<>'VESA' then
    begin
      writeln('Please install VBE VESA-driver and run again.');
      halt(1);
    end;
  {VESA is available, so check mode-specific stuff}
  GetModeInfo($101);
  writeln('Granularity   : ',ModeInfo.granularity,' KBytes');
  writeln('Bytes per Scan: ',ModeInfo.bytesperscanline);
  writeln('Width         : ',ModeInfo.width);
  writeln('Height        : ',ModeInfo.height);
  writeln('SegA          : ',ModeInfo.sega);
  FreeMemory := MemAvail;
end;

{VESA COMPATIBLE}
procedure CloseVideo101h;
begin
  SetVideoMode101h(3);
  if FreeMemory <> MemAvail then begin
      writeln('MemoryManagement-error detected:');
      writeln('We have a memory-difference of totally '+
              inttostr(FreeMemory-MemAvail)+' bytes!'+#7);
     halt(2);
   end;
end;

{VESA COMPATIBLE}
procedure Video101hError(t:string);
begin
  SetVideoMode101h(03);
  writeln('Video101hSystemError at: ');
  writeln(t);
  halt(1);
end;

{VESA COMPATIBLE}
procedure ActivePage101h(var page : TPage101h);
var b:byte;
begin
  ActVPage101h:=page;
end;

{VESA COMPATIBLE}
procedure CopyP2P101h(var Src,Dst:TPage101h); {DWORD-VERSION // ab 386er}
var b:byte;
    s,d:pointer;
begin
  asm push ds end;
  for b := 0 to 5 do begin
    s:=src[b];
    d:=dst[b];
    ASM
      les di, s
      lds si, d
      mov cx, 16000
      db $66; rep movsw
    end;
    end;
  asm pop ds end;
END;

{ Warum nicht gleich als assembler, ??? }
procedure CopyLines( s1,o1,s2,o2:word; off:word; lines:byte); assembler;
asm
  push ds
    mov al,lines
    mov es,SEGA000; mov di,off
    mov si,o1; mov dx,o2
    mov ds,s1; mov bx,s2

    @loop1:
    mov cx,80
    db $66; rep movsw
    xchg si,dx
    push ds
    mov ds,bx
    pop bx

    mov cx,80
    db $66; rep movsw
    xchg si,dx
    push ds
    mov ds,bx
    pop bx

    dec al
    cmp al,0
    jnz @loop1
  pop ds
end;

{ Warum nicht gleich als assembler, ??? }
procedure CopyDWord(dstoffset,srcsegment,srcoffset,l:word); assembler;
asm
  push ds
    mov es,SEGA000
    mov di,dstoffset
    mov ds,srcsegment
    mov si,srcoffset
    mov cx,l
    shr cx,2
    db $66; rep movsw
  pop ds
end;

procedure copyP2V101h(VAR page:TPage101h);
var s0,s1,s2,s3,s4,s5:word;
begin
  s0 := seg(page[0]^);
  s1 := seg(page[1]^);
  s2 := seg(page[2]^);
  s3 := seg(page[3]^);
  s4 := seg(page[4]^);
  s5 := seg(page[5]^);

  setbank(0);
  copylines(s0,0,s1,0,0,102);            {Zeile 0-101}
  copydword(65280,s0,32640,256);         {Zeile 102}
  setbank(1);
  copydword(0,s0,32896,64);              {Zeile 102}
  copydword(64,s1,32640,320);            {Zeile 102}
  copylines(s0,32960,s1,32960,384,97);   {Zeile 103-199}
  copylines(s2,0,s3,0,62464,4);          {Zeile 200-203}
  copydword(65024,s2,1280,320);          {Zeile 204-203}
  copydword(65344,s3,1280,192);          {Zeile 204}
  setbank(2);
  copydword(0,s3,1472,128);              {Zeile 204}
  copylines(s2,1600,s3,1600,128,102);    {Zeile 205-306}
  copydword(65408,s2,34240,128);         {Zeile 307}
  setbank(3);
  copydword(0,s2,34368,192);             {Zeile 307}
  copydword(192,s3,34240,320);           {Zeile 307}
  copylines(s2,34560,s3,34560,512,92);   {Zeile 308-399}
  copylines(s4,0,s5,0,59392,9);          {Zeile 400-408}
  copydword(65152,s4,2880,320);          {Zeile 409}
  copydword(65472,s5,2880,64);           {Zeile 409}
  setbank(4);
  copydword(0,s5,2944,256);              {Zeile 409}
  copylines(s4,3200,s5,3200,256,70);     {Zeile 410-479}(**)
end;

{VESA COMPATIBLE}       {!!!!KEINE VAR-PARAMETER!!!!}
procedure ClearPage101h( page:TPage101h); {DWORD-VERSION // ab 386er}
var b:byte;
    p:pointer;
begin
  for b:=0 to 3 do begin
    p:=page[b];
    asm
      les di, p
      {les di, dword ptr page[1]}
      db $66; xor ax,ax
      mov cx,64000 / 4
      db $66; rep stosw
    end;
  end;
  for b:=4 to 5 do begin
    p:=page[b];
    asm
      les di,p
      db $66; xor ax,ax
      mov cx,25600 / 4
      db $66; rep stosw
    end;
  end;
end;

{VESA COMPATIBLE}
procedure ClearVisualPage101h; {DWORD-VERSION // ab 386er}
var b:byte;
begin
  for b:=0 to 3 do begin
    setbank(b);
    asm
      mov es,SegA000
      xor di,di
      db $66; xor ax,ax
      mov cx,65536 / 4
      db $66; rep stosw
    end;
  end;
  setbank(4);
  asm
    mov es,SegA000
    xor di,di
    db $66; xor ax,ax
    mov cx,45056 / 4
    db $66; rep stosw
  end;
end;

{VESA COMPATIBLE}
procedure InitPage101h(var page:TPage101h);
var b:byte;
    w:word;
begin
  for b:=0 to 5 do
    begin
      if page[b] <> NIL then
        Video101hError('Trying to open an already existing page!');
      InitPage(Page[b]);
    end;
  ActivePage101h(page);
end;

{VESA COMPATIBLE}
procedure ClosePage101h(var page:TPage101h);
var b:byte;
begin
  for b:=0 to 5 do begin
    if page[b] = NIL then Video101hError('Trying to close an already closed page!');
    ClosePage(Page[b]);
  end;
end;

{VESA COMPATIBLE}
procedure DirectPutPixel101h(x,y : integer; c : byte);
var off,b:word;
begin
  asm
    mov ax,640
    mov bx,&y
    mul bx    { DX enthlt die oberen 4 Bit der Multiplikation also alles ber 65535}
    add ax,&x
    jnc @noverflow
    inc dx
    @noverflow:
    mov off,ax
    mov b,dx
  end;
  if banknr<>b then setbank(b);
  mem[segA000:off]:=c;
end;

{VESA COMPATIBLE}
Function DirectGetPixel101h(x,y:integer):byte;
var off,b:word;
begin
  asm
    mov ax,640
    mov bx,&y
    mul bx    { DX enthlt die oberen 4 Bit der Multiplikation also alles ber 65535}
    add ax,&x
    jnc @noverflow
    inc dx
    @noverflow:
    mov off,ax
    mov b,dx
  end;
  if banknr<>b then setbank(b);
  DirectGetPixel101h:=mem[segA000:off];
end;

procedure PutPixel101h(x,y:integer; c:byte);
var
  page:word;
begin
  page := GetPage(x,y);
  ActVPage := ActVPage101h[page];
  PutPixel(x mod 320, y mod 200,c);
end;

function GetPixel101h(x,y:integer ) : byte;
var page:word;
begin
  page := GetPage(x,y);
  ActVPage := ActVPage101h[page];
  GetPixel101h := GetPixel(x mod 320,y mod 200);
end;

{ Bresenham line }
PROCEDURE Line101h( x1, y1, x2, y2 : Integer; color : Byte );
VAR j, steps, sx, sy, dx, dy, e : Integer;
    steep : Boolean;
BEGIN
  dx := Abs( x2 - x1 );
  sx := Sgn( x2 - x1 );
  dy := Abs( y2 - y1 );
  sy := Sgn( y2 - y1 );
  steep := ( dy > dx );
  IF steep THEN
    BEGIN
      SwapInt( x1, y1 );
      SwapInt( dx, dy );
      SwapInt( sx, sy )
    END;
  e := 2 * dy - dx;
  FOR j := 1 TO dx DO
    BEGIN
      IF steep THEN PutPixel101h( y1, x1, color )
               ELSE PutPixel101h( x1, y1, color );
      WHILE e >= 0 DO
	BEGIN
	  Inc( y1, sy );
	  Dec( e, 2 * dx )
	END;
      Inc( x1, sx );
      Inc( e, 2 * dy )
    END;
  PutPixel101h( x2, y2, color )
END;

procedure PutSpriteWindow101h(x,y:integer; p: TSprite);
var b:byte;
    page:word;
begin
  page := 0;
  repeat
    ActVPage:=ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    PutSpriteWindow(CalcPageX(x,page),CalcPageY(y,page),p);
    inc(page);
  until page > 5;
end;

procedure putSpriteWindowW101h(x,y:integer; p: TSprite);
var b:byte;
    rx1,ry1:integer;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x,page);
    ry1:=CalcPageY(y,page);
    ActVPage:=ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    PutSpriteWindowW(rx1,ry1,p);
    inc(page);
  until page > 5;
end;

procedure putSpriteWindowD101h(x,y:integer; p: TSprite );
var b:byte;
    rx1,ry1:longint;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x,page);
    ry1:=CalcPageY(y,page);
    ActVPage:=ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    PutSpriteWindowD(rx1,ry1,p);
    inc(page);
  until page > 5;
end;

procedure putSpriteWindowTrans101h(x,y:integer; trans:byte; p: TSprite );
var b:byte;
    rx1,ry1:integer;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x,page);
    ry1:=CalcPageY(y,page);
    b:=CheckInArea(page,rx1,ry1,p);
    if b > 0 then
      begin
        ActVPage:=ActVPage101h[page];
        case b of
          1 : begin
                SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
                PutSpriteWindowTrans(rx1,ry1,trans,p);
              end;
          2 : PutSpriteTrans(rx1,ry1,trans,p);
        end;
      end;
    inc(page);
  until page > 5;
end;

procedure PutSpriteWindowWTrans101h(x,y:integer; trans:byte; p: TSprite );
var b:byte;
    rx1,ry1:integer;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x,page);
    ry1:=CalcPageY(y,page);
    ActVPage:=ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    PutSpriteWindowWTrans(rx1,ry1,trans,p);
    inc(page);
  until page > 5;
end;

procedure putSpriteWindowHide101h(x,y:integer; hide:byte; p: TSprite );
var b:byte;
    rx1,ry1:longint;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x,page);
    ry1:=CalcPageY(y,page);
    b:=CheckInArea(page,rx1,ry1,p);
    if b>0 then begin
      ActVPage:=ActVPage101h[page];
      case b of
        1 : begin SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
                  PutSpriteWindowHide(rx1,ry1,hide,p);
            end;
        2 : PutSpriteHide(rx1,ry1,hide,p);
      end;
    end;
    inc(page);
  until page >5;
end;

procedure putSpriteWindowShadow101h(x,y:integer; subtract,border:byte; p: TSprite );
var b:byte;
    rx1,ry1:longint;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x,page);
    ry1:=CalcPageY(y,page);
    b:=CheckInArea(page,rx1,ry1,p);
    if b>0 then
      begin
        ActVPage:=ActVPage101h[page];
        case b of
          1 : begin
                SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
                PutSpriteWindowShadow(rx1,ry1,subtract,border,p);
              end;
          2 : PutSpriteWindowShadow(rx1,ry1,subtract,border,p);
        end;
      end;
    inc(page);
  until page > 5;
end;

procedure PutPixelWindow101h(x,y : longint; c : byte);
begin
  if (x>= WinX1) and (x<=WinX2) and (y>= WinY1) and (y<=WinY2) then
    putpixel101h(x,y,c);
end;

function GetPixelWindow101h(x,y : longint):byte;
begin
  if (x>= WinX1) and (x<=WinX2) and (y>= WinY1) and (y<=WinY2) then
    GetPixelWindow101h := GetPixel101h(x,y);
end;

procedure RectangleWindow101h(x1,y1,x2,y2,x3,y3,x4,y4:longint; c : byte);
var b:byte;
    rx1,ry1,rx2,ry2,rx3,ry3,rx4,ry4:longint;
    page:word;
begin
  if ((x1 > Winx2) and (x2 > Winx2) and (x3 > Winx2) and (x4 > Winx2)) or
     ((x1 < Winx1) and (x2 < Winx1) and (x3 < Winx1) and (x4 < Winx1)) or
     ((y1 > Winy2) and (y2 > Winy2) and (y3 > Winy2) and (y4 > Winy2)) or
     ((y1 < Winy1) and (y2 < Winy1) and (y3 < Winy1) and (y4 < Winy1)) then
     begin
       exit;
     end;

  for page:=0 to 5 do begin
    rx1:=CalcPageX(integer(x1),page);
    ry1:=CalcPageY(integer(y1),page);
    rx2:=CalcPageX(integer(x2),page);
    ry2:=CalcPageY(integer(y2),page);
    rx3:=CalcPageX(integer(x3),page);
    ry3:=CalcPageY(integer(y3),page);
    rx4:=CalcPageX(integer(x4),page);
    ry4:=CalcPageY(integer(y4),page);
    ActVPage:=ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    RectangleWindow(rx1,ry1,rx2,ry2,rx3,ry3,rx4,ry4,c);
  end;
end;

procedure TriangleWindow101h(x1,y1,x2,y2,x3,y3:longint; c : byte);
begin
  RectangleWindow101h(x1,y1,x2,y2,x3,y3,x3,y3,c);
end;

PROCEDURE LineWindow101h( x1, y1, x2, y2 : longint; color : Byte );
VAR j, steps, sx, sy, dx, dy, e : Integer;
    steep : Boolean;
BEGIN
  dx := Abs( x2 - x1 );
  sx := Sgn( x2 - x1 );
  dy := Abs( y2 - y1 );
  sy := Sgn( y2 - y1 );
  steep := ( dy > dx );
  IF steep THEN
    BEGIN
      SwapInt( x1, y1 );
      SwapInt( dx, dy );
      SwapInt( sx, sy )
    END;
  e := 2 * dy - dx;
  FOR j := 1 TO dx DO
    BEGIN
      IF steep THEN PutPixelWindow101h( y1, x1, color )
               ELSE PutPixelWindow101h( x1, y1, color );
      WHILE e >= 0 DO
	BEGIN
	  Inc( y1, sy );
	  Dec( e, 2 * dx )
	END;
      Inc( x1, sx );
      Inc( e, 2 * dy )
    END;
  PutPixelWindow101h( x2, y2, color )
END;

procedure Box101h(x1,y1,x2,y2:integer; c:byte);
var b:byte;
    rx1,ry1,rx2,ry2:integer;
    page:word;
begin
  page := 0;
  repeat
    rx1 := CalcPageX(x1,page);
    ry1 := CalcPageY(y1,page);
    rx2 := CalcPageX(x2,page);
    ry2 := CalcPageY(y2,page);
    ActVPage:=ActVPage101h[page];
    if not (( (rx1 > 319) and (rx2 > 319) ) or
       ( (ry1 > 199) and (ry2 > 199) ) or
       ( (rx1 < 0  ) and (rx2 < 0  ) ) or
       ( (ry1 < 0  ) and (ry2 < 0  ) )) then
      begin
        if rx1 < 0   then rx1 := 0;
        if rx1 > 319 then rx1 := 319;
        if ry1 < 0   then ry1 := 0;
        if ry1 > 199 then ry1 := 199;
        if rx2 < 0   then rx2 := 0;
        if rx2 > 319 then rx2 := 319;
        if ry2 < 0   then ry2 := 0;
        if ry2 > 199 then ry2 := 199;
        Box(rx1,ry1,rx2,ry2,c);
      end;
    inc(page);
  until page > 5;
end;

procedure CopyBoxP2P101h(x1,y1,x2,y2:integer; src, dst : TPage101h);
var b:byte;
    rx1,ry1,rx2,ry2:integer;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x1,page);
    ry1:=CalcPageY(y1,page);
    rx2:=CalcPageX(x2,page);
    ry2:=CalcPageY(y2,page);
    ActVPage:=src[page];
    if rx1 < 0   then rx1 := 0;
    if rx1 > 319 then rx1 := 319;
    if ry1 < 0   then ry1 := 0;
    if ry1 > 199 then ry1 := 199;
    if rx2 < 0   then rx2 := 0;
    if rx2 > 319 then rx2 := 319;
    if ry2 < 0   then ry2 := 0;
    if ry2 > 199 then ry2 := 199;
    CopyBoxP2P( rx1,ry1,rx2,ry2,src[page],dst[page]);
    inc(page);
  until page > 5;
end;

procedure CopyBoxP2PW101h(x1,y1,x2,y2:integer; src, dst : TPage101h);
var b:byte;
    rx1,ry1,rx2,ry2:integer;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x1,page);
    ry1:=CalcPageY(y1,page);
    rx2:=CalcPageX(x2,page);
    ry2:=CalcPageY(y2,page);
    ActVPage:=src[page];
    if rx1 < 0   then rx1 := 0;
    if rx1 > 319 then rx1 := 319;
    if ry1 < 0   then ry1 := 0;
    if ry1 > 199 then ry1 := 199;
    if rx2 < 0   then rx2 := 0;
    if rx2 > 319 then rx2 := 319;
    if ry2 < 0   then ry2 := 0;
    if ry2 > 199 then ry2 := 199;
    CopyBoxP2PW( rx1,ry1,rx2,ry2,src[page],dst[page]);
    inc(page);
  until page > 5;
end;

procedure CopyBoxP2PD101h(x1,y1,x2,y2:integer; src, dst : TPage101h);
var b:byte;
    rx1,ry1,rx2,ry2:integer;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x1,page);
    ry1:=CalcPageY(y1,page);
    rx2:=CalcPageX(x2,page);
    ry2:=CalcPageY(y2,page);
    ActVPage:=src[page];
    if rx1 < 0   then rx1 := 0;
    if rx1 > 319 then rx1 := 319;
    if ry1 < 0   then ry1 := 0;
    if ry1 > 199 then ry1 := 199;
    if rx2 < 0   then rx2 := 0;
    if rx2 > 319 then rx2 := 319;
    if ry2 < 0   then ry2 := 0;
    if ry2 > 199 then ry2 := 199;
    CopyBoxP2PD( rx1,ry1,rx2,ry2,src[page],dst[page]);
    inc(page);
  until page > 5;
end;

procedure CopyBoxP2PEff101h(x1,y1,x2,y2:integer; src, dst : TPage101h);
var b:byte;
    rx1,ry1,rx2,ry2:integer;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x1,page);
    ry1:=CalcPageY(y1,page);
    rx2:=CalcPageX(x2,page);
    ry2:=CalcPageY(y2,page);
    ActVPage:=src[page];
    if rx1 < 0   then rx1 := 0;
    if rx1 > 319 then rx1 := 319;
    if ry1 < 0   then ry1 := 0;
    if ry1 > 199 then ry1 := 199;
    if rx2 < 0   then rx2 := 0;
    if rx2 > 319 then rx2 := 319;
    if ry2 < 0   then ry2 := 0;
    if ry2 > 199 then ry2 := 199;
    CopyBoxP2PEff( rx1,ry1,rx2,ry2,src[page],dst[page]);
    inc(page);
  until page > 5;
end;

procedure CopyBoxWindowP2PEff101h(x1,y1,x2,y2:integer; src, dst : TPage101h);
var b:byte;
    rx1,ry1,rx2,ry2:integer;
    page:word;
begin
  page := 0;
  repeat
    rx1:=CalcPageX(x1,page);
    ry1:=CalcPageY(y1,page);
    rx2:=CalcPageX(x2,page);
    ry2:=CalcPageY(y2,page);
    ActVPage:=src[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    CopyBoxWindowP2PEff( rx1,ry1,rx2,ry2,src[page],dst[page]);
    inc(page);
  until page > 5;
end;

{ *** here we changed src and dst // normaly it was swapped *** }
procedure MoveBoxWindowP2PEff101h( x1,y1,x2,y2:integer; src, dst : TPage101h;
                          x,y : integer);
var b:byte;
    rx,ry,rx1,ry1,rx2,ry2:integer;
    srcpage,
    page:word;
begin
  srcpage := 1;
  repeat
    page := 0;
    repeat
      rx:=CalcPageX(x,page);
      ry:=CalcPageY(y,page);
      rx1:=CalcPageX(x1,srcpage);
      ry1:=CalcPageY(y1,srcpage);
      rx2:=CalcPageX(x2,srcpage);
      ry2:=CalcPageY(y2,srcpage);
      ActVPage:=src[page];
      SetWindow( Windows101h[page,1],Windows101h[page,3],
                 Windows101h[page,2],Windows101h[page,4] );
      MoveBoxWindowP2PEff( rx1,ry1,rx2,ry2,src[srcpage],dst[page],rx,ry);
      inc(page);
    until page > 5;
    inc(srcpage);
  until srcpage > 5;
end;

{procedure, die fr _VIDEO13h.pas angepat wurde}
procedure PutSpriteScaled101h(x,y,dx,dy:integer; p: TSprite );
var b:byte;
    rx,ry : integer;
    page:word;
begin
  page := 0;
  repeat
    rx:=CalcPageX(x,page);
    ry:=CalcPageY(y,page);
    ActVPage:= ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    _scale1(rx,ry,dx,dy,p.b,p.t,{Ptr(seg(p.mem^),ofs(p.mem^))}p.mem);
    inc(page);
  until page > 5;
end;

procedure PutSpritePerCent101h(x,y:integer; factor:real; p : tsprite);
var b:byte;
    rx,ry : integer;
    page:word;
begin
  page := 0;
  repeat
    rx:=CalcPageX(x,page);
    ry:=CalcPageY(y,page);
    ActVPage:= ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    _scale1(rx,ry,
          trunc(p.b*0.01*factor),
          trunc(p.t*0.01*factor),p.b,p.t,
          p.mem);
    inc(page);
  until page > 5;
end;

procedure PutSpriteScaledTrans101h(x,y,dx,dy:integer; Tcol:byte; p: Tsprite );
var b:byte;
    rx,ry : integer;
    page:word;
begin
  TransparentColor := TCol;
  page := 0;
  repeat
    rx:=CalcPageX(x,page);
    ry:=CalcPageY(y,page);
    ActVPage:= ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    _scale1trans(rx,ry,dx,dy,p.b,p.t,p.mem{Ptr(seg(p.mem^),ofs(p.mem^))});
    inc(page);
  until page > 5;
end;

procedure PutSpritePerCentTrans101h(x,y:integer; factor:real; Tcol:byte; p : TSprite );
var b:byte;
    rx,ry : integer;
    page:word;
begin
  TransparentColor := TCol;
  page := 0;
  repeat
    rx:=CalcPageX(x,page);
    ry:=CalcPageY(y,page);
    ActVPage:= ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    _scale1trans(rx,ry,
          trunc(p.b*0.01*factor),
          trunc(p.t*0.01*factor),p.b,p.t,
          p.mem);
    inc(page);
  until page > 5;
end;

{$IFNDEF ShareWare}
procedure BigLoadTitle101h( n : String; s : TPage101h; no : byte );

var
  x,y   : word;
  check : word;
  Buffer: TSprite;
  Length: word;
begin
  Buffer.mem := NIL;
  InitSprite( Buffer, 320, 1 );
  BigAssign( no , n );
  BigReset( no , 1 );
  for y := 0 to 199 do
    begin
      BigBlockRead( no, Buffer.mem^ , 320 , check);
      ActivePage( s[0] );
      PutSpriteD( 0,y, Buffer );
      BigBlockRead( no, Buffer.mem^ , 320 , check);
      ActivePage( s[1] );
      PutSpriteD( 0,y, Buffer );
    end;
  for y := 0 to 199 do
    begin
      BigBlockRead( no, Buffer.mem^ , 320 , check);
      ActivePage( s[2] );
      PutSpriteD( 0,y, Buffer );
      BigBlockRead( no, Buffer.mem^ , 320 , check);
      ActivePage( s[3] );
      PutSpriteD( 0,y, Buffer );
    end;
  for y := 0 to 79 do
    begin
      BigBlockRead( no, Buffer.mem^ , 320 , check);
      ActivePage( s[4] );
      PutSpriteD( 0,y, Buffer );
      BigBlockRead( no, Buffer.mem^ , 320 , check);
      ActivePage( s[5] );
      PutSpriteD( 0,y, Buffer );
    end;


  BigClose( no );
  CloseSprite( Buffer );
end;
{$ENDIF}

procedure PutSpriteWindowEff101h(x,y:integer; p: TSprite );
var b:byte;
    page:word;
begin
  page := 0;
  repeat
    ActVPage:=ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    PutSpriteWindowEff(CalcPageX(x,page),CalcPageY(y,page),p);
    inc(page);
  until page > 5;
end;

procedure PutSpriteWindowTransEff101h(x,y:integer; trans: byte; p: TSprite );
var b:byte;
    page:word;
begin
  page := 0;
  repeat
    ActVPage:=ActVPage101h[page];
    SetWindow(Windows101h[page,1],Windows101h[page,3],Windows101h[page,2],Windows101h[page,4]);
    PutSpriteWindowTransEff(CalcPageX(x,page),CalcPageY(y,page),trans,p);
    inc(page);
  until page > 5;
end;

procedure getSprite101h(x,y:integer; p: TSprite );
var b:byte;
    rx1,ry1:longint;
    bank:word;
begin
  for bank:=0 to 5 do begin
    rx1:=calcpagex(x,bank);
    ry1:=calcpagey(y,bank);
   { b:=in_area(bank,rx1,ry1,p);
    if b>0 then begin
      bankdifference[bank]:=true;
      ActVPage:=ActVPage101h.p[bank];
      case b of
        1 : begin SetWindow(Windows101h[bank,1],Windows101h[bank,3],Windows101h[bank,2],Windows101h[bank,4]);
                  PutSpriteWindow(rx1,ry1,p);
            end;
        2 : PutSpriteD(rx1,ry1,p);
      end;
    end;}
    ActVPage:=ActVPage101h{.p}[bank];
    SetWindow(Windows101h[bank,1],Windows101h[bank,3],Windows101h[bank,2],Windows101h[bank,4]);
    GetSpriteWindow(rx1,ry1,p);
  end;
end;

var
  t : string;
begin
  t := copyright;
end.
