/*
 * Decompiled with CFR 0.152.
 */
package writer2latex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import writer2latex.api.BatchHandler;

public class BatchHandlerImpl
implements BatchHandler {
    private int nIndent = 0;

    private void writeMessage(String sMsg) {
        for (int i = 0; i < this.nIndent; ++i) {
            System.out.print("  ");
        }
        System.out.println(sMsg);
    }

    public void startConversion() {
        System.out.println("Press Enter to cancel the conversion");
    }

    public void endConversion() {
    }

    public void startDirectory(String sName) {
        this.writeMessage("Converting directory " + sName);
        ++this.nIndent;
    }

    public void endDirectory(String sName, boolean bSuccess) {
        --this.nIndent;
        if (!bSuccess) {
            this.writeMessage("--> Conversion of the directory " + sName + " failed!");
        }
    }

    public void startFile(String sName) {
        this.writeMessage("Converting file " + sName);
        ++this.nIndent;
    }

    public void endFile(String sName, boolean bSuccess) {
        --this.nIndent;
        if (!bSuccess) {
            this.writeMessage("--> Conversion of the file " + sName + " failed!");
        }
    }

    public boolean cancel() {
        try {
            if (System.in.available() > 0) {
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                in.readLine();
                System.out.print("Do you want to cancel the conversion (y/n)? ");
                String s = in.readLine();
                if (s != null && s.toLowerCase().startsWith("y")) {
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

