/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.ListStyleConverter;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.HeadingMap;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Misc;

public class HeadingConverter
extends ConverterHelper {
    private String[] sHeadingStyles = new String[11];

    public HeadingConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        this.appendHeadingStyles(decl);
    }

    public void handleHeading(Element node, LaTeXDocumentPortion ldp, Context oc) {
        int nLevel = this.ofr.isOpenDocument() ? Misc.getPosInteger(Misc.getAttribute(node, "text:outline-level"), 1) : Misc.getPosInteger(Misc.getAttribute(node, "text:level"), 1);
        boolean bUnNumbered = "true".equals(Misc.getAttribute(node, "text:is-list-header"));
        HeadingMap hm = this.config.getHeadingMap();
        String sStyleName = node.getAttribute("text:style-name");
        if (nLevel <= hm.getMaxLevel()) {
            this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(this.ofr.getParStyle(sStyleName)));
            Context ic = (Context)oc.clone();
            ic.setInSection(true);
            ic.setNoFootnotes(true);
            BeforeAfter baHardPage = new BeforeAfter();
            BeforeAfter baHardChar = new BeforeAfter();
            this.applyHardHeadingStyle(nLevel, sStyleName, baHardPage, baHardChar, ic);
            ldp.append(baHardPage.getBefore());
            ldp.append("\\" + hm.getName(nLevel));
            if (bUnNumbered) {
                ldp.append("*");
            } else if (baHardChar.getBefore().length() > 0 || this.containsElements(node)) {
                ldp.append("[");
                this.palette.getInlineCv().traversePlainInlineText(node, ldp, ic);
                ldp.append("]");
            }
            ldp.append("{").append(baHardChar.getBefore());
            this.palette.getInlineCv().traverseInlineText(node, ldp, ic);
            ldp.append(baHardChar.getAfter()).append("}").nl();
            ldp.append(baHardPage.getAfter());
            this.palette.getFieldCv().flushReferenceMarks(ldp, oc);
            this.palette.getIndexCv().flushIndexMarks(ldp, oc);
            this.palette.getNoteCv().flushFootnotes(ldp, oc);
            this.palette.getDrawCv().flushFloatingFrames(ldp, ic);
            this.palette.getI18n().popSpecialTable();
        } else {
            this.palette.getParCv().handleParagraph(node, ldp, oc, false);
        }
    }

    private void applyHardHeadingStyle(int nLevel, String sStyleName, BeforeAfter baPage, BeforeAfter baText, Context context) {
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (style == null) {
            return;
        }
        if (this.sHeadingStyles[nLevel] == null) {
            String string = this.sHeadingStyles[nLevel] = style.isAutomatic() ? style.getParentName() : sStyleName;
        }
        if (style.isAutomatic()) {
            this.palette.getPageSc().applyPageBreak(style, false, baPage);
            this.palette.getCharSc().applyHardCharFormatting(style, baText);
        }
        context.updateFormattingFromStyle(style);
    }

    private void appendHeadingStyles(LaTeXDocumentPortion ldp) {
        int i;
        boolean bOnlyNum;
        if (this.config.formatting() <= 1) {
            return;
        }
        HeadingMap hm = this.config.getHeadingMap();
        int nMaxLevel = 0;
        for (int i2 = 1; i2 <= 5; ++i2) {
            if (this.sHeadingStyles[i2] == null) continue;
            nMaxLevel = i2;
        }
        if (nMaxLevel == 0) {
            return;
        }
        if (nMaxLevel > hm.getMaxLevel()) {
            nMaxLevel = hm.getMaxLevel();
        }
        boolean bl = bOnlyNum = this.config.formatting() == 2;
        if (bOnlyNum) {
            ldp.append("% Outline numbering").nl();
        } else {
            ldp.append("% Headings and outline numbering").nl().append("\\makeatletter").nl();
        }
        if (!bOnlyNum) {
            for (int i3 = 1; i3 <= nMaxLevel; ++i3) {
                StyleWithProperties style;
                if (this.sHeadingStyles[i3] == null || (style = this.ofr.getParStyle(this.sHeadingStyles[i3])) == null) continue;
                BeforeAfter decl = new BeforeAfter();
                BeforeAfter comm = new BeforeAfter();
                this.palette.getPageSc().applyPageBreak(style, true, decl);
                this.palette.getCharSc().applyNormalFont(decl);
                this.palette.getCharSc().applyFont(style, true, true, decl, new Context());
                this.palette.getParCv().applyAlignment(style, false, true, decl);
                this.palette.getI18n().applyLanguage(style, false, true, comm);
                this.palette.getCharSc().applyFontEffects(style, true, comm);
                String sMarginTop = style.getAbsoluteLength("fo:margin-top");
                String sMarginBottom = style.getAbsoluteLength("fo:margin-bottom");
                String sMarginLeft = style.getAbsoluteLength("fo:margin-left");
                String sTextIndent = style.getAbsoluteLength("fo:text-indent");
                String sSecName = hm.getName(i3);
                if (!comm.isEmpty()) {
                    ldp.append("\\newcommand\\cs").append(sSecName).append("[1]{").append(comm.getBefore()).append("#1").append(comm.getAfter()).append("}").nl();
                }
                ldp.append("\\renewcommand\\").append(sSecName).append("{\\@startsection{").append(sSecName).append("}{" + hm.getLevel(i3)).append("}{" + Misc.add(sMarginLeft, sTextIndent) + "}{");
                ldp.append(sMarginTop).append("}{").append(Misc.isZero(sMarginBottom) ? "0.1mm" : sMarginBottom).append("}{");
                ldp.append(decl.getBefore());
                if (!comm.isEmpty()) {
                    ldp.append("\\cs").append(sSecName);
                }
                ldp.append("}}").nl();
            }
        }
        if (!bOnlyNum) {
            ldp.append("\\renewcommand\\@seccntformat[1]{").append("\\csname @textstyle#1\\endcsname{\\csname the#1\\endcsname}").append("\\csname @distance#1\\endcsname}").nl();
        }
        int nSecnumdepth = nMaxLevel;
        ListStyle outline = this.ofr.getOutlineStyle();
        String[] sNumFormat = new String[6];
        for (i = nMaxLevel; i >= 1; --i) {
            sNumFormat[i] = ListStyleConverter.numFormat(outline.getLevelProperty(i, "style:num-format"));
            if (sNumFormat[i] != null && !"".equals(sNumFormat[i])) continue;
            nSecnumdepth = i - 1;
        }
        ldp.append("\\setcounter{secnumdepth}{" + nSecnumdepth + "}").nl();
        for (i = 1; i <= nMaxLevel; ++i) {
            if (sNumFormat[i] == null || "".equals(sNumFormat[i])) {
                if (bOnlyNum) continue;
                ldp.append("\\newcommand\\@distance").append(hm.getName(i)).append("{}").nl().append("\\newcommand\\@textstyle").append(hm.getName(i)).append("[1]{#1}").nl();
                continue;
            }
            if (!bOnlyNum) {
                String sSpaceChar = "";
                String sDistance = null;
                if (outline.isNewType(i)) {
                    String sFormat = outline.getLevelStyleProperty(i, "text:label-followed-by");
                    if ("listtab".equals(sFormat)) {
                        String sTabPos;
                        StyleWithProperties style;
                        String sMarginLeft = "0cm";
                        String sTextIndent = "0cm";
                        if (this.sHeadingStyles[i] != null && (style = this.ofr.getParStyle(this.sHeadingStyles[i])) != null) {
                            sMarginLeft = style.getAbsoluteLength("fo:margin-left");
                            sTextIndent = style.getAbsoluteLength("fo:text-indent");
                        }
                        if ((sTabPos = outline.getLevelStyleProperty(i, "text:list-tab-stop-position")) == null) {
                            sTabPos = "0cm";
                        }
                        sDistance = Misc.sub(sTabPos, Misc.add(sMarginLeft, sTextIndent));
                    } else if ("space".equals(sFormat)) {
                        sSpaceChar = "\\ ";
                    }
                } else {
                    sDistance = outline.getLevelStyleProperty(i, "text:min-label-distance");
                }
                ldp.append("\\newcommand\\@distance").append(hm.getName(i)).append("{");
                if (sDistance != null) {
                    ldp.append("\\hspace{").append(sDistance).append("}");
                }
                ldp.append("}").nl();
                String sTextAlign = outline.getLevelStyleProperty(i, "fo:text-align");
                String sAlignmentChar = "l";
                if (sTextAlign != null) {
                    if ("end".equals(sTextAlign)) {
                        sAlignmentChar = "r";
                    } else if ("right".equals(sTextAlign)) {
                        sAlignmentChar = "r";
                    } else if ("center".equals(sTextAlign)) {
                        sAlignmentChar = "c";
                    }
                }
                String sLabelWidth = null;
                if (outline.isNewType(i)) {
                    String sFormat = outline.getLevelStyleProperty(i, "text:label-followed-by");
                    if ("listtab".equals(sFormat) || sAlignmentChar == "r") {
                        sLabelWidth = "0cm";
                    }
                } else {
                    sLabelWidth = outline.getLevelStyleProperty(i, "text:min-label-width");
                }
                String sStyleName = outline.getLevelProperty(i, "text:style-name");
                String sPrefix = outline.getLevelProperty(i, "style:num-prefix");
                String sSuffix = outline.getLevelProperty(i, "style:num-suffix");
                BeforeAfter baText = new BeforeAfter();
                if (!bOnlyNum) {
                    this.palette.getCharSc().applyTextStyle(sStyleName, baText, new Context());
                }
                ldp.append("\\newcommand\\@textstyle").append(hm.getName(i)).append("[1]{");
                if (!bOnlyNum && sLabelWidth != null) {
                    ldp.append("\\protect\\makebox[").append(sLabelWidth).append("][").append(sAlignmentChar).append("]{");
                }
                ldp.append(baText.getBefore()).append(sPrefix != null ? this.palette.getI18n().convert(sPrefix, false, "en") : "").append("#1").append(sSuffix != null ? this.palette.getI18n().convert(sSuffix, false, "en") : "").append(sSpaceChar).append(baText.getAfter());
                if (!bOnlyNum && sLabelWidth != null) {
                    ldp.append("}");
                }
                ldp.append("}").nl();
            }
            int nLevels = Misc.getPosInteger(outline.getLevelProperty(i, "text:display-levels"), 1);
            ldp.append("\\renewcommand\\the").append(hm.getName(i)).append("{");
            for (int j = i - nLevels + 1; j < i; ++j) {
                ldp.append(sNumFormat[j]).append("{").append(HeadingConverter.sectionName(j)).append("}").append(".");
            }
            ldp.append(sNumFormat[i]).append("{").append(hm.getName(i)).append("}").append("}").nl();
        }
        if (!bOnlyNum) {
            ldp.append("\\makeatother").nl();
        }
    }

    public boolean containsElements(Node node) {
        if (!node.hasChildNodes()) {
            return false;
        }
        NodeList list = node.getChildNodes();
        int nLen = list.getLength();
        for (int i = 0; i < nLen; ++i) {
            Node child = list.item(i);
            if (child.getNodeType() != 1 || child.getNodeName().startsWith("text:reference-mark")) continue;
            return true;
        }
        return false;
    }

    static final String sectionName(int nLevel) {
        switch (nLevel) {
            case 1: {
                return "section";
            }
            case 2: {
                return "subsection";
            }
            case 3: {
                return "subsubsection";
            }
            case 4: {
                return "paragraph";
            }
            case 5: {
                return "subparagraph";
            }
        }
        return null;
    }
}

